/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.editor;

import java.util.ArrayList;
import org.eclipse.debug.examples.ui.pda.editor.PDAScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class PDAContentAssistProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        int index = offset - 1;
        StringBuilder prefix = new StringBuilder();
        IDocument document = viewer.getDocument();
        while (index > 0) {
            try {
                char prev = document.getChar(index);
                if (Character.isWhitespace(prev)) break;
                prefix.insert(0, prev);
                --index;
            }
            catch (BadLocationException badLocationException) {}
        }
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        String[] keywords = PDAScanner.fgKeywords;
        if (prefix.length() > 0) {
            String word = prefix.toString();
            int i = 0;
            while (i < keywords.length) {
                String keyword = keywords[i];
                if (keyword.startsWith(word) && word.length() < keyword.length()) {
                    proposals.add(new CompletionProposal(String.valueOf(keyword) + " ", index + 1, offset - (index + 1), keyword.length() + 1));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < keywords.length) {
                String keyword = keywords[i];
                proposals.add(new CompletionProposal(String.valueOf(keyword) + " ", offset, 0, keyword.length() + 1));
                ++i;
            }
        }
        if (!proposals.isEmpty()) {
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

