/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.midi.detailpanes;

import org.eclipse.debug.examples.core.midi.launcher.ClockControl;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IWorkbenchPartSite;

public class ClockSliderDetailPane
implements IDetailPane {
    private Slider fSlider;
    private ClockControl fControl;

    public Control createControl(Composite parent) {
        this.fSlider = new Slider(parent, 256);
        this.fSlider.setMinimum(0);
        this.fSlider.setMaximum(1000);
        this.fSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = ClockSliderDetailPane.this.fSlider.getSelection();
                if (ClockSliderDetailPane.this.fControl != null) {
                    ClockSliderDetailPane.this.fControl.setValue(Integer.toString(selection));
                }
            }
        });
        return this.fSlider;
    }

    public void display(IStructuredSelection selection) {
        this.fControl = null;
        if (selection == null || selection.isEmpty()) {
            this.fSlider.setEnabled(false);
        } else {
            this.fSlider.setEnabled(true);
            this.fControl = (ClockControl)selection.getFirstElement();
            int max = (int)this.fControl.getSequencer().getMicrosecondLength() / 1000000;
            long micro = this.fControl.getSequencer().getMicrosecondPosition();
            int seconds = (int)micro / 1000000;
            this.fSlider.setMaximum(max);
            this.fSlider.setSelection(seconds);
        }
    }

    public void dispose() {
    }

    public String getDescription() {
        return "Location (seconds)";
    }

    public String getID() {
        return "CLOCK_SLIDER";
    }

    public String getName() {
        return "Clock Slider (seconds)";
    }

    public void init(IWorkbenchPartSite partSite) {
    }

    public boolean setFocus() {
        this.fSlider.setFocus();
        return true;
    }
}

