/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModelContentProvider;
import org.eclipse.ant.internal.ui.model.AntModelLabelProvider;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntProjectNodeProxy;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.InternalTargetFilter;
import org.eclipse.ant.internal.ui.views.AntViewDropAdapter;
import org.eclipse.ant.internal.ui.views.AntViewMessages;
import org.eclipse.ant.internal.ui.views.actions.AddBuildFilesAction;
import org.eclipse.ant.internal.ui.views.actions.AntOpenWithMenu;
import org.eclipse.ant.internal.ui.views.actions.FilterInternalTargetsAction;
import org.eclipse.ant.internal.ui.views.actions.RefreshBuildFilesAction;
import org.eclipse.ant.internal.ui.views.actions.RemoveAllAction;
import org.eclipse.ant.internal.ui.views.actions.RemoveProjectAction;
import org.eclipse.ant.internal.ui.views.actions.RunTargetAction;
import org.eclipse.ant.internal.ui.views.actions.SearchForBuildFilesAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IUpdate;

public class AntView
extends ViewPart
implements IResourceChangeListener,
IShowInSource {
    private List<AntProjectNode> fInput = new ArrayList<AntProjectNode>();
    private boolean filterInternalTargets = false;
    private InternalTargetFilter fInternalTargetFilter = null;
    private static final String TAG_PROJECT = "project";
    private static final String KEY_ERROR = "error";
    private static final String KEY_WARNING = "warning";
    private static final String KEY_PATH = "path";
    private static final String KEY_NAME = "name";
    private static final String KEY_DEFAULT = "default";
    private static final String TAG_FILTER_INTERNAL_TARGETS = "filterInternalTargets";
    private static final String KEY_VALUE = "value";
    private TreeViewer projectViewer;
    private AntModelContentProvider contentProvider;
    private List<IUpdate> updateProjectActions;
    private AddBuildFilesAction addBuildFileAction;
    private SearchForBuildFilesAction searchForBuildFilesAction;
    private RefreshBuildFilesAction refreshBuildFilesAction;
    private RemoveProjectAction removeProjectAction;
    private RemoveAllAction removeAllAction;
    private FilterInternalTargetsAction filterInternalTargetsAction;
    private RunTargetAction runTargetAction;
    private AntOpenWithMenu openWithMenu;

    private void handleBuildFileChanged(AntProjectNode project) {
        ((AntProjectNodeProxy)project).parseBuildFile(true);
        Display.getDefault().asyncExec(() -> {
            this.projectViewer.refresh();
            this.handleSelectionChanged((IStructuredSelection)this.projectViewer.getSelection());
        });
    }

    public void createPartControl(Composite parent) {
        this.initializeActions();
        this.createProjectViewer(parent);
        this.initializeDragAndDrop();
        this.fillMainToolBar();
        if (this.getProjects().length > 0) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ant.ui.ant_view_context");
        this.updateProjectActions();
    }

    private void initializeDragAndDrop() {
        int ops = 17;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        TreeViewer viewer = this.getViewer();
        AntViewDropAdapter adapter = new AntViewDropAdapter(this);
        viewer.addDropSupport(ops, transfers, (DropTargetListener)adapter);
    }

    private void createContextMenu(Viewer viewer) {
        Control menuControl = viewer.getControl();
        MenuManager menuMgr = new MenuManager("#PopUp");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AntView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void fillContextMenu(IMenuManager menu) {
        this.addOpenWithMenu(menu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.addBuildFileAction);
        menu.add((IAction)this.removeProjectAction);
        menu.add((IAction)this.removeAllAction);
        menu.add((IAction)this.refreshBuildFilesAction);
        menu.add((IContributionItem)new Separator("additions"));
    }

    private void addOpenWithMenu(IMenuManager menu) {
        IFile buildFile;
        AntElementNode node = this.getSelectionNode();
        if (node != null && (buildFile = node.getIFile()) != null) {
            menu.add((IContributionItem)new Separator("group.open"));
            MenuManager submenu = new MenuManager(AntViewMessages.AntView_1);
            this.openWithMenu.setNode(node);
            submenu.add((IContributionItem)this.openWithMenu);
            menu.appendToGroup("group.open", (IContributionItem)submenu);
        }
    }

    private void initializeActions() {
        this.updateProjectActions = new ArrayList<IUpdate>(5);
        this.addBuildFileAction = new AddBuildFilesAction(this);
        this.removeProjectAction = new RemoveProjectAction(this);
        this.updateProjectActions.add(this.removeProjectAction);
        this.removeAllAction = new RemoveAllAction(this);
        this.updateProjectActions.add(this.removeAllAction);
        this.runTargetAction = new RunTargetAction(this);
        this.updateProjectActions.add(this.runTargetAction);
        this.searchForBuildFilesAction = new SearchForBuildFilesAction(this);
        this.refreshBuildFilesAction = new RefreshBuildFilesAction(this);
        this.updateProjectActions.add(this.refreshBuildFilesAction);
        this.openWithMenu = new AntOpenWithMenu(this.getViewSite().getPage());
        this.filterInternalTargetsAction = new FilterInternalTargetsAction(this);
    }

    private void updateProjectActions() {
        for (IUpdate update : this.updateProjectActions) {
            update.update();
        }
    }

    private void createProjectViewer(Composite parent) {
        this.projectViewer = new TreeViewer(parent, 770);
        this.contentProvider = new AntModelContentProvider();
        this.projectViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.filterInternalTargetsAction.setChecked(this.filterInternalTargets);
        this.setFilterInternalTargets(this.filterInternalTargets);
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new AntModelLabelProvider());
        this.projectViewer.setInput(this.fInput);
        this.projectViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof AntProjectNode && e2 instanceof AntProjectNode || e1 instanceof AntTargetNode && e2 instanceof AntTargetNode) {
                    return e1.toString().compareToIgnoreCase(e2.toString());
                }
                return 0;
            }
        });
        this.projectViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AntView.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        this.projectViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    AntView.this.handleProjectViewerDoubleClick();
                }
            }
        });
        this.projectViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                AntView.this.handleProjectViewerKeyPress(event);
            }
        });
        this.createContextMenu((Viewer)this.projectViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.projectViewer);
    }

    private void handleProjectViewerKeyPress(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            if (this.removeProjectAction.isEnabled()) {
                this.removeProjectAction.run();
            }
        } else if (event.keyCode == 0x100000E && event.stateMask == 0 && this.refreshBuildFilesAction.isEnabled()) {
            this.refreshBuildFilesAction.run();
        }
    }

    private void handleProjectViewerDoubleClick() {
        AntElementNode node = this.getSelectionNode();
        if (node != null) {
            this.runTargetAction.run(node);
        }
    }

    private void handleSelectionChanged(IStructuredSelection selection) {
        this.updateProjectActions();
        Iterator selectionIter = selection.iterator();
        AntElementNode selected = null;
        if (selectionIter.hasNext()) {
            selected = (AntElementNode)selectionIter.next();
        }
        String messageString = null;
        if (!selectionIter.hasNext()) {
            String errorString;
            if (selected != null && (errorString = selected.getProblemMessage()) != null) {
                this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(errorString);
                return;
            }
            this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
            messageString = this.getStatusLineText(selected);
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(messageString);
    }

    private String getStatusLineText(AntElementNode node) {
        if (node instanceof AntProjectNode) {
            AntProjectNode project = (AntProjectNode)node;
            StringBuilder message = new StringBuilder(project.getBuildFileName());
            String description = project.getDescription();
            if (description != null && description.length() > 0) {
                message.append(": ");
                message.append(description);
            }
            return message.toString();
        }
        if (node instanceof AntTargetNode) {
            String description;
            AntTargetNode target = (AntTargetNode)node;
            StringBuilder message = new StringBuilder();
            Enumeration depends = target.getTarget().getDependencies();
            if (depends.hasMoreElements()) {
                message.append(AntViewMessages.AntView_3);
                message.append((String)depends.nextElement());
                while (depends.hasMoreElements()) {
                    String dependancy = (String)depends.nextElement();
                    message.append(',').append(dependancy);
                }
                message.append('\"');
            }
            if ((description = target.getTarget().getDescription()) != null && description.length() != 0) {
                message.append(AntViewMessages.AntView_4);
                message.append(description);
                message.append('\"');
            }
            return message.toString();
        }
        return null;
    }

    public TreeViewer getViewer() {
        return this.projectViewer;
    }

    public AntProjectNode[] getProjects() {
        return this.fInput.toArray(new AntProjectNode[this.fInput.size()]);
    }

    public void addProject(AntProjectNode project) {
        this.fInput.add(project);
        this.projectViewer.refresh();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.handleSelectionChanged((IStructuredSelection)new StructuredSelection((Object)project));
    }

    private void removeProject(AntProjectNode project) {
        this.fInput.remove(project);
        this.projectViewer.refresh();
        this.setProjectViewerSelectionAfterDeletion();
    }

    private void setProjectViewerSelectionAfterDeletion() {
        Object[] children = this.getProjects();
        if (children.length > 0) {
            ViewerComparator comparator = this.projectViewer.getComparator();
            comparator.sort((Viewer)this.projectViewer, children);
            StructuredSelection selection = new StructuredSelection(children[0]);
            this.projectViewer.setSelection((ISelection)selection);
            this.handleSelectionChanged((IStructuredSelection)selection);
        }
    }

    public void removeProjects(List<AntProjectNode> projectNodes) {
        for (AntProjectNode project : projectNodes) {
            this.fInput.remove(project);
        }
        this.projectViewer.refresh();
        this.setProjectViewerSelectionAfterDeletion();
    }

    public void removeAllProjects() {
        AntProjectNode[] projects = this.getProjects();
        int i = 0;
        while (i < projects.length) {
            AntProjectNode node = projects[i];
            node.dispose();
            ++i;
        }
        this.fInput.clear();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.updateProjectActions();
        this.projectViewer.refresh();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        String persistedMemento = AntUIPlugin.getDefault().getDialogSettingsSection(((Object)((Object)this)).getClass().getName()).get("memento");
        if (persistedMemento != null) {
            try {
                memento = XMLMemento.createReadRoot((Reader)new StringReader(persistedMemento));
            }
            catch (WorkbenchException workbenchException) {}
        }
        if (memento != null) {
            this.restoreViewerInput(memento);
            IMemento child = memento.getChild(TAG_FILTER_INTERNAL_TARGETS);
            if (child != null) {
                this.filterInternalTargets = Boolean.valueOf(child.getString(KEY_VALUE));
            }
        }
    }

    private void restoreViewerInput(IMemento memento) {
        IMemento[] projects = memento.getChildren(TAG_PROJECT);
        if (projects.length < 1) {
            return;
        }
        int i = 0;
        while (i < projects.length) {
            IMemento projectMemento = projects[i];
            String pathString = projectMemento.getString(KEY_PATH);
            if (ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathString)).exists()) {
                String nameString = projectMemento.getString(KEY_NAME);
                String defaultTarget = projectMemento.getString(KEY_DEFAULT);
                String errorString = projectMemento.getString(KEY_ERROR);
                String warningString = projectMemento.getString(KEY_WARNING);
                AntProjectNodeProxy project = null;
                if (nameString == null) {
                    nameString = "";
                }
                project = new AntProjectNodeProxy(nameString, pathString);
                if (errorString != null && Boolean.valueOf(errorString).booleanValue()) {
                    project.setProblemSeverity(1);
                } else if (warningString != null && Boolean.valueOf(warningString).booleanValue()) {
                    project.setProblemSeverity(0);
                }
                if (defaultTarget != null) {
                    project.setDefaultTargetName(defaultTarget);
                }
                this.fInput.add(project);
            }
            ++i;
        }
    }

    private void saveViewerState() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"antView");
        StringWriter writer = new StringWriter();
        AntProjectNode[] projects = this.getProjects();
        if (projects.length > 0) {
            int i = 0;
            while (i < projects.length) {
                AntProjectNode project = projects[i];
                IMemento projectMemento = memento.createChild(TAG_PROJECT);
                projectMemento.putString(KEY_PATH, project.getBuildFileName());
                projectMemento.putString(KEY_NAME, project.getLabel());
                String defaultTarget = project.getDefaultTargetName();
                if (project.isErrorNode()) {
                    projectMemento.putString(KEY_ERROR, String.valueOf(true));
                } else {
                    if (project.isWarningNode()) {
                        projectMemento.putString(KEY_WARNING, String.valueOf(true));
                    }
                    if (defaultTarget != null) {
                        projectMemento.putString(KEY_DEFAULT, defaultTarget);
                    }
                    projectMemento.putString(KEY_ERROR, String.valueOf(false));
                }
                ++i;
            }
            IMemento filterTargets = memento.createChild(TAG_FILTER_INTERNAL_TARGETS);
            filterTargets.putString(KEY_VALUE, this.isFilterInternalTargets() ? String.valueOf(true) : String.valueOf(false));
        }
        try {
            memento.save((Writer)writer);
            AntUIPlugin.getDefault().getDialogSettingsSection(((Object)((Object)this)).getClass().getName()).put("memento", writer.getBuffer().toString());
        }
        catch (IOException iOException) {}
    }

    public void saveState(IMemento memento) {
        this.saveViewerState();
    }

    public void dispose() {
        this.saveViewerState();
        this.fInput.clear();
        super.dispose();
        if (this.openWithMenu != null) {
            this.openWithMenu.dispose();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            AntProjectNode[] projects = this.getProjects();
            int i = 0;
            while (i < projects.length) {
                Path buildFilePath = new Path(projects[i].getBuildFileName());
                IResourceDelta change = delta.findMember((IPath)buildFilePath);
                if (change != null) {
                    this.handleChangeDelta(change, projects[i]);
                }
                ++i;
            }
        }
    }

    private void handleChangeDelta(IResourceDelta delta, AntProjectNode project) {
        IResource resource = delta.getResource();
        if (resource.getType() != 1) {
            return;
        }
        if (delta.getKind() == 2) {
            Display.getDefault().asyncExec(() -> this.removeProject(project));
        } else if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0) {
            this.handleBuildFileChanged(project);
        }
    }

    private void fillMainToolBar() {
        IToolBarManager toolBarMgr = this.getViewSite().getActionBars().getToolBarManager();
        toolBarMgr.removeAll();
        toolBarMgr.add((IAction)this.addBuildFileAction);
        toolBarMgr.add((IAction)this.searchForBuildFilesAction);
        toolBarMgr.add((IAction)this.filterInternalTargetsAction);
        toolBarMgr.add((IAction)this.runTargetAction);
        toolBarMgr.add((IAction)this.removeProjectAction);
        toolBarMgr.add((IAction)this.removeAllAction);
        toolBarMgr.update(false);
    }

    private AntElementNode getSelectionNode() {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof AntElementNode) {
            AntElementNode node = (AntElementNode)element;
            return node;
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        IFile buildFile;
        AntElementNode node = this.getSelectionNode();
        if (node != null && (buildFile = node.getIFile()) != null) {
            StructuredSelection selection = new StructuredSelection((Object)buildFile);
            return new ShowInContext(null, (ISelection)selection);
        }
        return null;
    }

    public boolean isFilterInternalTargets() {
        return this.filterInternalTargets;
    }

    public void setFilterInternalTargets(boolean filter) {
        this.filterInternalTargets = filter;
        if (filter) {
            this.projectViewer.addFilter(this.getInternalTargetsFilter());
        } else {
            this.projectViewer.removeFilter(this.getInternalTargetsFilter());
        }
    }

    private ViewerFilter getInternalTargetsFilter() {
        if (this.fInternalTargetFilter == null) {
            this.fInternalTargetFilter = new InternalTargetFilter();
        }
        return this.fInternalTargetFilter;
    }

    public void setFocus() {
        if (this.getViewer() != null) {
            this.getViewer().getControl().setFocus();
        }
    }
}

