/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.utility.iterator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterator<E>
implements Iterator<E> {
    E[] array;
    private int maxIndex;
    int nextIndex;

    public <T extends E> ArrayIterator(T ... array) {
        this(array, 0, array.length);
    }

    public <T extends E> ArrayIterator(T[] array, int start, int length) {
        if (start < 0 || start > array.length) {
            throw new IllegalArgumentException("The start index is either a negative value or greater than the length of the array: " + start);
        }
        if (length < 0 || length > array.length - start) {
            throw new IllegalArgumentException("The length to copy goes beyond the length of the array: " + length);
        }
        this.array = array;
        this.nextIndex = start;
        this.maxIndex = start + length;
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.maxIndex;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            return this.array[this.nextIndex++];
        }
        throw new NoSuchElementException("No more elements can be retrieved.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("An ArrayIterator is read-only.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append(Arrays.toString(this.array));
        sb.append(")");
        return sb.toString();
    }
}

