/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.eclipse.persistence.dbws.DBWSException;
import org.eclipse.persistence.dbws.DBWSModelProject;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.DescriptorHelper;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsWriter;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGenerator;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGeneratorProperties;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.sessions.factories.MissingDescriptorListener;
import org.eclipse.persistence.internal.sessions.factories.ObjectPersistenceWorkbenchXMLProject;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigProject_11_1_1;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.DeleteOperation;
import org.eclipse.persistence.internal.xr.InsertOperation;
import org.eclipse.persistence.internal.xr.NamedQueryHandler;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProjectHelper;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.UpdateOperation;
import org.eclipse.persistence.internal.xr.XRDynamicClassLoader;
import org.eclipse.persistence.internal.xr.XmlBindingsModel;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.platform.DOMPlatform;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.jdbc.OracleArrayType;
import org.eclipse.persistence.platform.database.oracle.jdbc.OracleObjectType;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCursor;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DefaultNamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.ModelWithBuildSql;
import org.eclipse.persistence.tools.dbws.NamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.OperationModel;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.TableOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.WSDLGenerator;
import org.eclipse.persistence.tools.dbws.XmlBindingsGenerator;
import org.eclipse.persistence.tools.dbws.XmlEntityMappingsGenerator;
import org.eclipse.persistence.tools.dbws.jdbc.DbColumn;
import org.eclipse.persistence.tools.dbws.jdbc.DbTable;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCollectionType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCursorType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLRecordType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.PrecisionType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.ROWTYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.SizedType;
import org.eclipse.persistence.tools.oracleddl.metadata.TYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.VArrayType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.EnclosedTypeVisitor;

public abstract class BaseDBWSBuilderHelper {
    public static final String ITEM_MAPPING_NAME = "item";
    public static final String ITEMS_MAPPING_ATTRIBUTE_NAME = "items";
    public static final String ITEMS_MAPPING_FIELD_NAME = "ITEMS";
    public static final String MTOM_STR = "MTOM";
    public static final String SWAREF_STR = "SWAREF";
    public static final String NO_TABLE_MSG = "No tables were found matching the following: ";
    public static final String NO_PROC_MSG = "No procedures were found matching the following: ";
    public static final String OXM_MARSHAL_EX_MSG = "An exception occurred while attempting to marshal the OXM bindings file";
    public static final String ORM_MARSHAL_EX_MSG = "An exception occurred while attempting to marshal the ORM mappings file";
    public static final String SELECT_FROM_STR = "SELECT * FROM ";
    public static final String WHERE_STR = " WHERE ";
    public static final String AND_STR = " AND ";
    public static final String SET_STR = " SET ";
    public static final String VALUES_STR = " VALUES ";
    public static final String UPDATE_STR = "UPDATE ";
    public static final String INSERT_STR = "INSERT INTO ";
    public static final String DELETE_STR = "DELETE FROM ";
    public static final String COMMA_SPACE_STR = ", ";
    public static final String EQUALS_BINDING1_STR = " = ?1";
    public static final String EQUALS_BINDING_STR = " = ?";
    public static final String TIMESTAMP_CLASS = "oracle.sql.TIMESTAMP";
    public static final String USER_STR = "user";
    public static final String PASSWORD_STR = "password";
    public static final String SIMPLEXML_STR = "simple-xml-format";
    protected List<TableType> dbTables = new ArrayList<TableType>();
    protected List<ProcedureType> dbStoredProcedures = new ArrayList<ProcedureType>();
    protected DBWSBuilder dbwsBuilder;
    protected XMLSessionConfigProject_11_1_1 sessionConfigProject = new XMLSessionConfigProject_11_1_1();
    protected NamingConventionTransformer nct;
    protected ObjectPersistenceWorkbenchXMLProject workbenchXMLProject = new ObjectPersistenceWorkbenchXMLProject();
    protected Map<String, ClassDescriptor> createdORDescriptors = new HashMap<String, ClassDescriptor>();
    protected List<String> referencedORDescriptors = new ArrayList<String>();
    protected List<CompositeDatabaseType> complextypes = new ArrayList<CompositeDatabaseType>();
    protected Map<String, Map<String, String>> crudOps = new HashMap<String, Map<String, String>>();

    public BaseDBWSBuilderHelper(DBWSBuilder dbwsBuilder) {
        this.dbwsBuilder = dbwsBuilder;
    }

    public List<TableType> getDbTables() {
        return this.dbTables;
    }

    public List<ProcedureType> getDbStoredProcedures() {
        return this.dbStoredProcedures;
    }

    public abstract boolean hasTables();

    protected abstract List<TableType> loadTables(List<String> var1, List<String> var2, List<String> var3);

    protected abstract List<ProcedureType> loadProcedures(List<String> var1, List<String> var2, List<String> var3);

    protected abstract void addToOROXProjectsForComplexTypes(List<CompositeDatabaseType> var1, Project var2, Project var3);

    protected abstract void buildQueryForProcedureType(ProcedureType var1, Project var2, Project var3, ProcedureOperationModel var4, boolean var5);

    protected void addToOROXProjectsForBuildSql(ModelWithBuildSql modelWithBuildSql, Project orProject, Project oxProject, NamingConventionTransformer nct) {
        String schemaAlias;
        List<DbColumn> columns = BaseDBWSBuilderHelper.buildDbColumns(this.dbwsBuilder.getConnection(), modelWithBuildSql.getBuildSql());
        String tableName = schemaAlias = modelWithBuildSql.getReturnType();
        NamingConventionTransformer customNct = this.setUpCustomTransformer(tableName, nct);
        RelationalDescriptor desc = Util.buildORDescriptor(tableName, this.dbwsBuilder.getProjectName(), null, customNct);
        this.createdORDescriptors.put(desc.getJavaClassName(), (ClassDescriptor)desc);
        desc.descriptorIsAggregate();
        orProject.addDescriptor((ClassDescriptor)desc);
        XMLDescriptor xdesc = Util.buildOXDescriptor(desc.getAlias(), schemaAlias, desc.getJavaClassName(), this.dbwsBuilder.getTargetNamespace());
        oxProject.addDescriptor((ClassDescriptor)xdesc);
        ArrayList<String> columnsAlreadyProcessed = new ArrayList<String>();
        for (DbColumn dbColumn : columns) {
            String columnName = dbColumn.getFieldName();
            if (!columnsAlreadyProcessed.contains(columnName)) {
                columnsAlreadyProcessed.add(columnName);
                NamingConventionTransformer.ElementStyle style = nct.styleForElement(columnName);
                if (style == NamingConventionTransformer.ElementStyle.NONE) continue;
                this.dbwsBuilder.logMessage(Level.FINE, "Building mappings for " + columnName);
                DirectToFieldMapping orFieldMapping = this.buildORFieldMappingFromColumn(dbColumn, desc, this.dbwsBuilder.getDatabasePlatform(), nct);
                desc.addMapping((DatabaseMapping)orFieldMapping);
                XMLDirectMapping oxFieldMapping = this.buildOXFieldMappingFromColumn(dbColumn, this.dbwsBuilder.getDatabasePlatform(), nct);
                if (oxFieldMapping instanceof XMLBinaryDataMapping) {
                    xdesc.getNamespaceResolver().put("xmime", "http://www.w3.org/2005/05/xmlmime");
                }
                xdesc.addMapping((DatabaseMapping)oxFieldMapping);
                continue;
            }
            this.dbwsBuilder.logMessage(Level.SEVERE, "Duplicate ResultSet columns not supported '" + columnName + "'");
            throw new RuntimeException("Duplicate ResultSet columns not supported");
        }
    }

    public List<CompositeDatabaseType> buildTypesList(List<OperationModel> operations) {
        EnclosedTypeVisitor etVisitor = new EnclosedTypeVisitor();
        for (OperationModel opModel : operations) {
            ProcedureOperationModel procedureOperation;
            if (!opModel.isProcedureOperation() || !(procedureOperation = (ProcedureOperationModel)opModel).isPLSQLProcedureOperation() && !procedureOperation.isAdvancedJDBCProcedureOperation()) continue;
            for (ProcedureType procType : procedureOperation.getDbStoredProcedures()) {
                ArrayList<ArgumentType> args = new ArrayList<ArgumentType>();
                if (procType.isFunctionType()) {
                    args.add(((FunctionType)procType).getReturnArgument());
                }
                args.addAll(procType.getArguments());
                for (ArgumentType arg : args) {
                    if (arg.getEnclosedType().isROWTYPEType()) {
                        ROWTYPEType rType = (ROWTYPEType)arg.getEnclosedType();
                        TableType tableType = (TableType)rType.getEnclosedType();
                        PLSQLRecordType plsqlRec = new PLSQLRecordType(rType.getTypeName());
                        plsqlRec.setParentType(new PLSQLPackageType());
                        for (FieldType col : tableType.getColumns()) {
                            FieldType ft = new FieldType(col.getFieldName());
                            ft.setEnclosedType(col.getEnclosedType());
                            plsqlRec.addField((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)ft);
                        }
                        arg.setEnclosedType((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)plsqlRec);
                    }
                    if (!arg.isComposite()) continue;
                    etVisitor.visit((CompositeDatabaseType)arg);
                }
            }
        }
        List types = etVisitor.getCompositeDatabaseTypes();
        for (CompositeDatabaseType type : types) {
            this.complextypes.add(type);
        }
        return etVisitor.getCompositeDatabaseTypes();
    }

    public void buildOROXProjects(NamingConventionTransformer nct) {
        this.buildOROXProjects(nct, new ArrayList<CompositeDatabaseType>());
    }

    public void buildOROXProjects(NamingConventionTransformer nct, List<CompositeDatabaseType> types) {
        this.nct = nct;
        String projectName = this.dbwsBuilder.getProjectName();
        Project orProject = new Project();
        orProject.setName(projectName + "_dbws-or");
        Project oxProject = null;
        if (this.dbTables.isEmpty() && !this.dbwsBuilder.hasBuildSqlOperations()) {
            this.dbwsBuilder.logMessage(Level.FINEST, "No tables specified");
            oxProject = new SimpleXMLFormatProject();
        } else {
            oxProject = new Project();
        }
        oxProject.setName(projectName + "_dbws-ox");
        for (TableType dbTable : this.dbTables) {
            String tableName = dbTable.getTableName();
            RelationalDescriptor desc = Util.buildORDescriptor(tableName, this.dbwsBuilder.getProjectName(), this.dbwsBuilder.requireCRUDOperations, nct);
            orProject.addDescriptor((ClassDescriptor)desc);
            XMLDescriptor xdesc = Util.buildOXDescriptor(tableName, this.dbwsBuilder.getProjectName(), this.dbwsBuilder.getTargetNamespace(), nct);
            oxProject.addDescriptor((ClassDescriptor)xdesc);
            for (FieldType dbColumn : dbTable.getColumns()) {
                String columnName = dbColumn.getFieldName();
                NamingConventionTransformer.ElementStyle style = nct.styleForElement(columnName);
                if (style == NamingConventionTransformer.ElementStyle.NONE) continue;
                this.dbwsBuilder.logMessage(Level.FINE, "Building mappings for " + tableName + "." + columnName);
                DirectToFieldMapping orFieldMapping = this.buildORFieldMappingFromColumn(dbColumn, desc, this.dbwsBuilder.getDatabasePlatform(), nct);
                desc.addMapping((DatabaseMapping)orFieldMapping);
                XMLDirectMapping oxFieldMapping = this.buildOXFieldMappingFromColumn(dbColumn, this.dbwsBuilder.getDatabasePlatform(), nct);
                if (oxFieldMapping instanceof XMLBinaryDataMapping) {
                    xdesc.getNamespaceResolver().put("xmime", "http://www.w3.org/2005/05/xmlmime");
                }
                xdesc.addMapping((DatabaseMapping)oxFieldMapping);
                if (oxFieldMapping.getAttributeClassificationName() != CoreClassConstants.APBYTE.getName()) continue;
                orFieldMapping.setAttributeClassificationName(CoreClassConstants.APBYTE.getName());
            }
            this.setUpFindQueries(nct, tableName, desc);
        }
        this.finishUpProjects(orProject, oxProject, types);
    }

    protected void finishUpProjects(Project orProject, Project oxProject, List<CompositeDatabaseType> typeList) {
        for (OperationModel opModel : this.dbwsBuilder.operations) {
            if (!opModel.hasBuildSql()) continue;
            this.addToOROXProjectsForBuildSql((ModelWithBuildSql)opModel, orProject, oxProject, this.nct);
        }
        this.addToOROXProjectsForComplexTypes(typeList, orProject, oxProject);
        for (OperationModel opModel : this.dbwsBuilder.operations) {
            if (!opModel.isProcedureOperation()) continue;
            ProcedureOperationModel procedureOperation = (ProcedureOperationModel)opModel;
            for (ProcedureType procType : procedureOperation.getDbStoredProcedures()) {
                this.buildQueryForProcedureType(procType, orProject, oxProject, procedureOperation, Util.hasPLSQLArgs(this.getArgumentListForProcedureType(procType)));
            }
        }
        for (String refClassName : this.referencedORDescriptors) {
            ClassDescriptor cdesc = this.createdORDescriptors.get(refClassName);
            if (cdesc == null) continue;
            cdesc.descriptorIsAggregate();
        }
        DatabaseLogin databaseLogin = new DatabaseLogin();
        databaseLogin.removeProperty(USER_STR);
        databaseLogin.removeProperty(PASSWORD_STR);
        databaseLogin.setDriverClassName(null);
        databaseLogin.setConnectionString(null);
        orProject.setLogin(databaseLogin);
        XMLLogin xmlLogin = new XMLLogin();
        xmlLogin.setDatasourcePlatform((Platform)new DOMPlatform());
        xmlLogin.getProperties().remove(USER_STR);
        xmlLogin.getProperties().remove(PASSWORD_STR);
        oxProject.setLogin((Login)xmlLogin);
        this.dbwsBuilder.setOrProject(orProject);
        this.dbwsBuilder.setOxProject(oxProject);
    }

    protected DirectToFieldMapping buildORFieldMappingFromColumn(FieldType dbColumn, RelationalDescriptor desc, DatabasePlatform databasePlatform, NamingConventionTransformer nct) {
        SizedType sizedType;
        String columnName = dbColumn.getFieldName();
        org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dataType = dbColumn.getEnclosedType();
        String typeName = BaseDBWSBuilderHelper.getTypeNameForDatabaseType(dataType);
        int jdbcType = Util.getJDBCTypeFromTypeName(typeName);
        String dmdTypeName = Util.getJDBCTypeNameFromType(jdbcType);
        Class attributeClass = null;
        attributeClass = "CHAR".equalsIgnoreCase(dmdTypeName) && dbColumn.getEnclosedType().isSizedType() ? ((sizedType = (SizedType)dbColumn.getEnclosedType()).getSize() == 1L ? Character.class : String.class) : org.eclipse.persistence.internal.xr.Util.getClassFromJDBCType((String)dmdTypeName.toUpperCase(), (DatabasePlatform)databasePlatform);
        if (attributeClass.getName().contains(TIMESTAMP_CLASS)) {
            attributeClass = Timestamp.class;
        }
        DirectToFieldMapping dtfm = BaseDBWSBuilderHelper.setUpDirectToFieldMapping(desc, columnName, nct, attributeClass, jdbcType, dbColumn.pk());
        return dtfm;
    }

    protected XMLDirectMapping buildOXFieldMappingFromColumn(FieldType dbColumn, DatabasePlatform databasePlatform, NamingConventionTransformer nct) {
        SizedType sizedType;
        String columnName = dbColumn.getFieldName();
        org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dataType = dbColumn.getEnclosedType();
        String typeName = BaseDBWSBuilderHelper.getTypeNameForDatabaseType(dataType);
        int jdbcType = Util.getJDBCTypeFromTypeName(typeName);
        String dmdTypeName = Util.getJDBCTypeNameFromType(jdbcType);
        QName qName = Util.getXMLTypeFromJDBCType(jdbcType);
        Class attributeClass = "CHAR".equalsIgnoreCase(dmdTypeName) && dbColumn.getEnclosedType().isSizedType() ? ((sizedType = (SizedType)dbColumn.getEnclosedType()).getSize() == 1L ? Character.class : String.class) : org.eclipse.persistence.internal.xr.Util.getClassFromJDBCType((String)dmdTypeName.toUpperCase(), (DatabasePlatform)databasePlatform);
        if (attributeClass.getName().contains(TIMESTAMP_CLASS)) {
            attributeClass = Timestamp.class;
        } else if (attributeClass.getName().contains(Character[].class.getName())) {
            attributeClass = String.class;
        }
        XMLDirectMapping xdm = this.setUpXMLDirectMapping(columnName, qName, nct, attributeClass, jdbcType, dbColumn.pk());
        return xdm;
    }

    public void buildDbArtifacts() {
        boolean schemaNameMatch;
        ArrayList<String> schemaPatterns;
        ArrayList<String> catalogPatterns;
        ArrayList<TableOperationModel> tableOperations = new ArrayList<TableOperationModel>();
        ArrayList<ProcedureOperationModel> procedureOperations = new ArrayList<ProcedureOperationModel>();
        if (this.dbTables.isEmpty()) {
            for (OperationModel operation : this.dbwsBuilder.operations) {
                if (!operation.isTableOperation()) continue;
                TableOperationModel tom = (TableOperationModel)operation;
                tableOperations.add(tom);
                if (tom.additionalOperations == null || tom.additionalOperations.isEmpty()) continue;
                for (OperationModel operationModel : tom.additionalOperations) {
                    if (!operationModel.isProcedureOperation()) continue;
                    procedureOperations.add((ProcedureOperationModel)operationModel);
                }
            }
            if (!tableOperations.isEmpty()) {
                catalogPatterns = new ArrayList();
                schemaPatterns = new ArrayList<String>();
                ArrayList<String> tableNamePatterns = new ArrayList<String>();
                for (TableOperationModel tableOperationModel : tableOperations) {
                    catalogPatterns.add(tableOperationModel.getCatalogPattern());
                    schemaPatterns.add(tableOperationModel.getSchemaPattern());
                    tableNamePatterns.add(tableOperationModel.getTablePattern());
                }
                List<TableType> tables = this.loadTables(catalogPatterns, schemaPatterns, tableNamePatterns);
                if (tables == null || tables.isEmpty()) {
                    this.logNotFoundWarnings(NO_TABLE_MSG, schemaPatterns, catalogPatterns, tableNamePatterns);
                } else {
                    for (TableType tableType : tables) {
                        for (TableOperationModel tableOperation : tableOperations) {
                            boolean tableNameMatch = Util.sqlMatch(tableOperation.getTablePattern(), tableType.getTableName());
                            schemaNameMatch = Util.sqlMatch(tableOperation.getSchemaPattern(), tableType.getSchema());
                            if (!tableNameMatch || !schemaNameMatch) continue;
                            String originalCatalogPattern = tableOperation.getCatalogPattern();
                            if (tableType.isDbTableType() && originalCatalogPattern != null) {
                                boolean catalogNameMatch = Util.sqlMatch(originalCatalogPattern, ((DbTable)tableType).getCatalog());
                                if (!catalogNameMatch) continue;
                                tableOperation.getDbTables().add(tableType);
                                continue;
                            }
                            tableOperation.getDbTables().add(tableType);
                        }
                    }
                    this.dbTables.addAll((Collection<TableType>)tables);
                }
            }
        }
        if (this.dbStoredProcedures.isEmpty()) {
            for (OperationModel operation : this.dbwsBuilder.operations) {
                if (!operation.isProcedureOperation()) continue;
                procedureOperations.add((ProcedureOperationModel)operation);
            }
            if (!procedureOperations.isEmpty()) {
                catalogPatterns = new ArrayList<String>();
                schemaPatterns = new ArrayList();
                ArrayList<String> procedureNamePatterns = new ArrayList<String>();
                for (ProcedureOperationModel procedureOperationModel : procedureOperations) {
                    catalogPatterns.add(procedureOperationModel.getCatalogPattern());
                    schemaPatterns.add(procedureOperationModel.getSchemaPattern());
                    procedureNamePatterns.add(procedureOperationModel.getProcedurePattern());
                }
                List<ProcedureType> procedures = this.loadProcedures(catalogPatterns, schemaPatterns, procedureNamePatterns);
                if (procedures == null || procedures.isEmpty()) {
                    this.logNotFoundWarnings(NO_PROC_MSG, schemaPatterns, catalogPatterns, procedureNamePatterns);
                } else {
                    for (ProcedureType procedureType : procedures) {
                        for (ProcedureOperationModel procedureOperation : procedureOperations) {
                            boolean procedureNameMatch = Util.sqlMatch(procedureOperation.getProcedurePattern(), procedureType.getProcedureName());
                            schemaNameMatch = true;
                            boolean catalogNameMatch = true;
                            if (procedureNameMatch) {
                                String originalCatalogPattern;
                                String originalSchemaPattern = procedureOperation.getSchemaPattern();
                                if (originalSchemaPattern != null) {
                                    schemaNameMatch = Util.sqlMatch(originalSchemaPattern, procedureType.getSchema());
                                }
                                if ((originalCatalogPattern = procedureOperation.getCatalogPattern()) != null) {
                                    catalogNameMatch = Util.sqlMatch(originalCatalogPattern, procedureType.getCatalogName());
                                }
                            }
                            if (!procedureNameMatch || !schemaNameMatch || !catalogNameMatch) continue;
                            procedureOperation.getDbStoredProcedures().add(procedureType);
                        }
                    }
                    this.dbStoredProcedures.addAll(procedures);
                }
            }
        }
    }

    public void buildSchema(NamingConventionTransformer nct) {
        Project oxProject = this.dbwsBuilder.getOxProject();
        Schema schema = null;
        ArrayList<Descriptor> descriptorsToProcess = new ArrayList<Descriptor>();
        for (Descriptor desc : oxProject.getOrderedDescriptors()) {
            String alias = desc.getAlias();
            if (SIMPLEXML_STR.equals(alias)) continue;
            descriptorsToProcess.add(desc);
        }
        if (!descriptorsToProcess.isEmpty()) {
            StringWriter sw = new StringWriter();
            XMLProjectWriter.write((Project)oxProject, (Writer)sw);
            XRDynamicClassLoader specialLoader = new XRDynamicClassLoader(this.getClass().getClassLoader());
            Project oxProjectClone = XMLProjectReader.read((Reader)new StringReader(sw.toString()), (ClassLoader)specialLoader);
            ProjectHelper.fixOROXAccessors((Project)oxProjectClone, null);
            XMLLogin xmlLogin = new XMLLogin();
            DOMPlatform domPlatform = new DOMPlatform();
            domPlatform.getConversionManager().setLoader((ClassLoader)specialLoader);
            xmlLogin.setPlatform((Platform)domPlatform);
            oxProjectClone.setLogin((Login)xmlLogin);
            oxProjectClone.createDatabaseSession();
            SchemaModelGenerator schemaGenerator = new SchemaModelGenerator((ConversionManager)XMLConversionManager.getDefaultXMLManager(), true);
            SchemaModelGeneratorProperties sgProperties = new SchemaModelGeneratorProperties();
            sgProperties.addProperty(this.dbwsBuilder.getTargetNamespace(), "elementFormQualified", (Object)true);
            Map schemaMap = schemaGenerator.generateSchemas(descriptorsToProcess, sgProperties);
            Schema s = (Schema)schemaMap.get(this.dbwsBuilder.getTargetNamespace());
            if (this.dbwsBuilder.getSchema() != null && s != null) {
                Map topLevelComplexTypes = this.dbwsBuilder.getSchema().getTopLevelComplexTypes();
                for (Map.Entry me : topLevelComplexTypes.entrySet()) {
                    s.addTopLevelComplexTypes((ComplexType)me.getValue());
                }
                NamespaceResolver snr = s.getNamespaceResolver();
                NamespaceResolver nr = this.dbwsBuilder.getSchema().getNamespaceResolver();
                for (String prefix : nr.getPrefixesToNamespaces().keySet()) {
                    if (snr.resolveNamespacePrefix(prefix) != null) continue;
                    snr.put(prefix, nr.resolveNamespacePrefix(prefix));
                }
                schema = s;
                schema.setNamespaceResolver(snr);
            }
        } else {
            schema = new Schema();
            Util.addSimpleXMLFormat(schema);
            schema.setTargetNamespace(this.dbwsBuilder.getTargetNamespace());
        }
        this.dbwsBuilder.setSchema(schema);
    }

    public void buildSessionsXML(OutputStream dbwsSessionsStream) {
        if (!Util.isNullStream(dbwsSessionsStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "Building " + this.dbwsBuilder.getSessionsFileName());
            SessionConfigs ts = this.dbwsBuilder.getPackager().buildSessionsXML(dbwsSessionsStream, this.dbwsBuilder);
            XMLContext context = new XMLContext((Project)this.sessionConfigProject);
            XMLMarshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)ts, (Writer)new OutputStreamWriter(dbwsSessionsStream));
            this.dbwsBuilder.getPackager().closeSessionsStream(dbwsSessionsStream);
        }
    }

    public void buildDBWSModel(NamingConventionTransformer nct, OutputStream dbwsServiceStream) {
        Project orProject = this.dbwsBuilder.getOrProject();
        if (!Util.isNullStream(dbwsServiceStream)) {
            for (ClassDescriptor desc : orProject.getOrderedDescriptors()) {
                String crudOpName;
                Map<Object, Object> ops;
                String tablenameAlias = desc.getAlias();
                if (!this.dbwsBuilder.requireCRUDOperations.contains(tablenameAlias)) continue;
                String aliasType = tablenameAlias + "Type";
                String tableName = desc.getTableName();
                String schemaAlias = nct.generateSchemaAlias(tableName);
                if (!this.crudOps.containsKey(tableName)) {
                    ops = new HashMap();
                    this.crudOps.put(tableName, ops);
                }
                ops = this.crudOps.get(tableName);
                Object pks = null;
                int pkCount = 0;
                for (DatabaseField field : desc.getPrimaryKeyFields()) {
                    if (pkCount++ == 0) {
                        pks = "(" + field.getName() + EQUALS_BINDING1_STR;
                        continue;
                    }
                    pks = ((String)pks).concat(AND_STR + field.getName() + EQUALS_BINDING_STR + pkCount++);
                }
                if (pks != null) {
                    pks = ((String)pks).concat(")");
                }
                String findByPKName = crudOpName = "findByPrimaryKey_" + aliasType;
                QueryOperation findByPKQueryOperation = new QueryOperation();
                findByPKQueryOperation.setName(crudOpName);
                findByPKQueryOperation.setUserDefined(false);
                NamedQueryHandler nqh1 = new NamedQueryHandler();
                nqh1.setName(crudOpName);
                nqh1.setDescriptor(tablenameAlias);
                Result result = new Result();
                QName theInstanceType = new QName(this.dbwsBuilder.getTargetNamespace(), schemaAlias, "ns1");
                result.setType(theInstanceType);
                findByPKQueryOperation.setResult(result);
                findByPKQueryOperation.setQueryHandler((QueryHandler)nqh1);
                for (DatabaseField field : desc.getPrimaryKeyFields()) {
                    Parameter p = new Parameter();
                    p.setName(field.getName().toLowerCase());
                    p.setType(Util.getXMLTypeFromJDBCType(field.getSqlType()));
                    findByPKQueryOperation.getParameters().add(p);
                }
                this.dbwsBuilder.xrServiceModel.getOperations().put(findByPKQueryOperation.getName(), findByPKQueryOperation);
                crudOpName = "findAll_" + aliasType;
                QueryOperation findAllOperation = new QueryOperation();
                findAllOperation.setName(crudOpName);
                findAllOperation.setUserDefined(false);
                NamedQueryHandler nqh2 = new NamedQueryHandler();
                nqh2.setName(crudOpName);
                nqh2.setDescriptor(tablenameAlias);
                CollectionResult result2 = new CollectionResult();
                result2.setType(theInstanceType);
                findAllOperation.setResult((Result)result2);
                findAllOperation.setQueryHandler((QueryHandler)nqh2);
                this.dbwsBuilder.xrServiceModel.getOperations().put(findAllOperation.getName(), findAllOperation);
                crudOpName = "create_" + aliasType;
                InsertOperation insertOperation = new InsertOperation();
                insertOperation.setName(crudOpName);
                Parameter theInstance = new Parameter();
                theInstance.setName("theInstance");
                theInstance.setType(theInstanceType);
                insertOperation.getParameters().add(theInstance);
                this.dbwsBuilder.xrServiceModel.getOperations().put(insertOperation.getName(), insertOperation);
                StringBuilder sqlStmt = new StringBuilder(128);
                sqlStmt.append(INSERT_STR).append(tableName).append(" ").append("(");
                DescriptorHelper.buildColsFromMappings((StringBuilder)sqlStmt, (Collection)desc.getMappings(), (String)COMMA_SPACE_STR);
                sqlStmt.append(")").append(VALUES_STR).append("(");
                DescriptorHelper.buildValuesAsQMarksFromMappings((StringBuilder)sqlStmt, (Collection)desc.getMappings(), (String)COMMA_SPACE_STR);
                sqlStmt.append(")");
                ops.put(crudOpName, sqlStmt.toString());
                crudOpName = "update_" + aliasType;
                UpdateOperation updateOperation = new UpdateOperation();
                updateOperation.setName(crudOpName);
                updateOperation.getParameters().add(theInstance);
                this.dbwsBuilder.xrServiceModel.getOperations().put(updateOperation.getName(), updateOperation);
                sqlStmt = new StringBuilder(128);
                sqlStmt.append(UPDATE_STR).append(tableName).append(SET_STR);
                DescriptorHelper.buildColsAndValuesBindingsFromMappings((StringBuilder)sqlStmt, (Collection)desc.getMappings(), (Collection)desc.getPrimaryKeyFields(), (int)pkCount, (String)EQUALS_BINDING_STR, (String)COMMA_SPACE_STR);
                sqlStmt.append(WHERE_STR).append((String)pks);
                ops.put(crudOpName, sqlStmt.toString());
                crudOpName = "delete_" + aliasType;
                DeleteOperation deleteOperation = new DeleteOperation();
                deleteOperation.setName(crudOpName);
                deleteOperation.setDescriptorName(tablenameAlias);
                deleteOperation.setFindByPKQuery(findByPKName);
                for (DatabaseField field : desc.getPrimaryKeyFields()) {
                    Parameter p = new Parameter();
                    p.setName(field.getName().toLowerCase());
                    p.setType(Util.getXMLTypeFromJDBCType(field.getSqlType()));
                    deleteOperation.getParameters().add(p);
                }
                this.dbwsBuilder.xrServiceModel.getOperations().put(deleteOperation.getName(), deleteOperation);
                sqlStmt = new StringBuilder(128);
                sqlStmt.append(DELETE_STR).append(tableName).append(WHERE_STR).append((String)pks);
                ops.put(crudOpName, sqlStmt.toString());
            }
            for (OperationModel operation : this.dbwsBuilder.operations) {
                if (operation.isTableOperation()) {
                    TableOperationModel tableModel = (TableOperationModel)operation;
                    if (tableModel.additionalOperations == null || tableModel.additionalOperations.isEmpty()) continue;
                    for (OperationModel additionalOperation : tableModel.additionalOperations) {
                        if (additionalOperation.hasBuildSql()) {
                            this.addToOROXProjectsForBuildSql((ModelWithBuildSql)additionalOperation, orProject, this.dbwsBuilder.getOxProject(), nct);
                            continue;
                        }
                        additionalOperation.buildOperation(this.dbwsBuilder);
                    }
                    continue;
                }
                operation.buildOperation(this.dbwsBuilder);
            }
            DBWSModelProject modelProject = new DBWSModelProject();
            modelProject.ns.put("ns1", this.dbwsBuilder.getTargetNamespace());
            XMLContext context = new XMLContext((Project)modelProject);
            XMLMarshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)this.dbwsBuilder.xrServiceModel, dbwsServiceStream);
            this.dbwsBuilder.getPackager().closeServiceStream(dbwsServiceStream);
        }
    }

    public void writeAttachmentSchema(OutputStream swarefStream) {
        if (!Util.isNullStream(swarefStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "writing " + Util.WSI_SWAREF_XSD_FILE);
            OutputStreamWriter osw = new OutputStreamWriter(new BufferedOutputStream(swarefStream));
            try {
                osw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<xsd:schema targetNamespace=\"http://ws-i.org/profiles/basic/1.1/xsd\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"> \n  <xsd:simpleType name=\"swaRef\"> \n    <xsd:restriction base=\"xsd:anyURI\"/> \n  </xsd:simpleType> \n</xsd:schema>");
                osw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dbwsBuilder.getPackager().closeSWARefStream(swarefStream);
        }
    }

    public void buildWSDL(OutputStream wsdlStream, NamingConventionTransformer nct) throws WSDLException {
        if (!Util.isNullStream(wsdlStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "building eclipselink-dbws.wsdl");
            this.dbwsBuilder.wsdlGenerator = new WSDLGenerator(this.dbwsBuilder.xrServiceModel, nct, this.dbwsBuilder.getWsdlLocationURI(), this.dbwsBuilder.getPackager().hasAttachments(), this.dbwsBuilder.getTargetNamespace(), wsdlStream);
            this.dbwsBuilder.wsdlGenerator.generateWSDL(this.dbwsBuilder.usesSOAP12());
            this.dbwsBuilder.getPackager().closeWSDLStream(wsdlStream);
        }
    }

    public void writeWebXML(OutputStream webXmlStream) {
        if (!Util.isNullStream(webXmlStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "writing web.xml");
            this.dbwsBuilder.getPackager().writeWebXml(webXmlStream, this.dbwsBuilder);
            this.dbwsBuilder.getPackager().closeWebXmlStream(webXmlStream);
        }
    }

    public void writeDeploymentDescriptor(OutputStream deploymentDescriptorStream) {
        if (!Util.isNullStream(deploymentDescriptorStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "writing " + this.dbwsBuilder.getPackager().getDeploymentDescriptorFileName());
            this.dbwsBuilder.getPackager().writeDeploymentDescriptor(deploymentDescriptorStream);
            this.dbwsBuilder.getPackager().closeDeploymentDescriptorStream(deploymentDescriptorStream);
        }
    }

    public void generateDBWSProvider(OutputStream sourceProviderStream, OutputStream classProviderStream, OutputStream sourceProviderListenerStream, OutputStream classProviderListenerStream) {
        if (Util.isNullStream(sourceProviderStream) && Util.isNullStream(classProviderStream) && Util.isNullStream(sourceProviderListenerStream) && Util.isNullStream(classProviderListenerStream)) {
            return;
        }
        if (!Util.isNullStream(sourceProviderStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "generating DBWSProvider.java");
        }
        if (!Util.isNullStream(classProviderStream)) {
            this.dbwsBuilder.logMessage(Level.FINEST, "generating DBWSProvider.class");
        }
        this.dbwsBuilder.getPackager().writeProvider(sourceProviderStream, classProviderStream, sourceProviderListenerStream, classProviderListenerStream, this.dbwsBuilder);
        this.dbwsBuilder.getPackager().closeProviderSourceStream(sourceProviderStream);
        this.dbwsBuilder.getPackager().closeProviderClassStream(classProviderStream);
    }

    public void writeSchema(OutputStream dbwsSchemaStream) {
        if (!Util.isNullStream(dbwsSchemaStream)) {
            XMLDescriptor descriptor;
            SchemaModelProject schemaProject = new SchemaModelProject();
            if (this.dbwsBuilder.getSchema().getNamespaceResolver().resolveNamespacePrefix("ref") != null) {
                descriptor = (XMLDescriptor)schemaProject.getClassDescriptor(Schema.class);
                descriptor.getNamespaceResolver().put("ref", "http://ws-i.org/profiles/basic/1.1/xsd");
            }
            if (this.dbwsBuilder.getSchema().getNamespaceResolver().resolveNamespacePrefix("xmime") != null) {
                descriptor = (XMLDescriptor)schemaProject.getClassDescriptor(Schema.class);
                descriptor.getNamespaceResolver().put("xmime", "http://www.w3.org/2005/05/xmlmime");
            }
            XMLContext context = new XMLContext((Project)schemaProject);
            XMLMarshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)this.dbwsBuilder.getSchema(), dbwsSchemaStream);
            this.dbwsBuilder.getPackager().closeSchemaStream(dbwsSchemaStream);
        }
    }

    public void writeOROXProjects(OutputStream dbwsOrStream, OutputStream dbwsOxStream) {
        Project orProject = this.dbwsBuilder.getOrProject();
        Project oxProject = this.dbwsBuilder.getOxProject();
        boolean writeORProject = false;
        if (this.hasTables() || this.dbwsBuilder.hasBuildSqlOperations()) {
            writeORProject = true;
        }
        if (!writeORProject) {
            if (!orProject.getQueries().isEmpty()) {
                writeORProject = true;
            } else if (!orProject.getDescriptors().isEmpty()) {
                Collection descriptors = orProject.getDescriptors().values();
                for (Object desc : descriptors) {
                    if (!desc.isObjectRelationalDataTypeDescriptor()) continue;
                    writeORProject = true;
                    break;
                }
            }
        }
        if (!(!writeORProject && this.dbwsBuilder.xrServiceModel.getOperations().isEmpty() || Util.isNullStream(dbwsOrStream))) {
            XMLContext context = new XMLContext((Project)this.workbenchXMLProject);
            context.getSession((Object)orProject).getEventManager().addListener((SessionEventListener)new MissingDescriptorListener());
            XMLEntityMappings mappings = XmlEntityMappingsGenerator.generateXmlEntityMappings(orProject, this.complextypes, this.crudOps);
            if (mappings != null) {
                XMLEntityMappingsWriter.write((XMLEntityMappings)mappings, (OutputStream)dbwsOrStream);
            }
        }
        if (!Util.isNullStream(dbwsOxStream)) {
            List<XmlBindings> xmlBindingsList;
            boolean writeOXProject = false;
            if (this.hasTables() || this.dbwsBuilder.hasBuildSqlOperations()) {
                writeOXProject = true;
            }
            if (!writeOXProject) {
                if (!orProject.getQueries().isEmpty()) {
                    writeOXProject = true;
                } else if (!orProject.getDescriptors().isEmpty()) {
                    Collection descriptors = orProject.getDescriptors().values();
                    for (ClassDescriptor desc : descriptors) {
                        if (!desc.isObjectRelationalDataTypeDescriptor()) continue;
                        writeOXProject = true;
                        break;
                    }
                }
            }
            if (writeOXProject && !(xmlBindingsList = XmlBindingsGenerator.generateXmlBindings(oxProject.getOrderedDescriptors())).isEmpty()) {
                XmlBindingsModel model = new XmlBindingsModel();
                model.setBindingsList(xmlBindingsList);
                try {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlBindingsModel.class});
                    Marshaller marshaller = jc.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)true);
                    marshaller.marshal((Object)model, dbwsOxStream);
                }
                catch (JAXBException jaxbEx) {
                    throw new DBWSException(OXM_MARSHAL_EX_MSG, (Throwable)jaxbEx);
                }
            }
        }
        this.dbwsBuilder.getPackager().closeOrStream(dbwsOrStream);
        this.dbwsBuilder.getPackager().closeOxStream(dbwsOxStream);
    }

    protected static ResultSetMetaData getResultSetMetadataForSecondarySQL(Connection connection, String secondarySql) {
        ResultSet resultSet = null;
        try {
            Statement statement = connection.createStatement();
            resultSet = statement.executeQuery(secondarySql);
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure executing secondary SQL: " + secondarySql, sqlException);
        }
        try {
            return resultSet.getMetaData();
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure retrieving resultSet metadata", sqlException);
        }
    }

    protected static DirectToFieldMapping setUpDirectToFieldMapping(RelationalDescriptor desc, String columnName, NamingConventionTransformer nct, Class<?> attributeClass, int jdbcType, boolean isPk) {
        DirectToFieldMapping dtfm = new DirectToFieldMapping();
        dtfm.setAttributeClassificationName(attributeClass.getName());
        String fieldName = nct.generateElementAlias(columnName);
        dtfm.setAttributeName(fieldName);
        DatabaseField databaseField = new DatabaseField(columnName, desc.getTableName());
        databaseField.setSqlType(jdbcType);
        dtfm.setField(databaseField);
        if (nct.getOptimisticLockingField() != null && nct.getOptimisticLockingField().equalsIgnoreCase(columnName)) {
            desc.useVersionLocking(columnName, false);
        }
        if (isPk) {
            desc.addPrimaryKeyField(databaseField);
        }
        return dtfm;
    }

    protected XMLDirectMapping setUpXMLDirectMapping(String columnName, QName qName, NamingConventionTransformer nct, Class<?> attributeClass, int jdbcType, boolean isPk) {
        XMLDirectMapping xdm = null;
        boolean binaryAttach = false;
        String attachmentType = null;
        if (Constants.BASE_64_BINARY_QNAME.equals(qName)) {
            attributeClass = CoreClassConstants.APBYTE;
            block0: for (OperationModel om : this.dbwsBuilder.operations) {
                if (!om.isTableOperation()) continue;
                TableOperationModel tom = (TableOperationModel)om;
                if (tom.getBinaryAttachment()) {
                    binaryAttach = true;
                    if (MTOM_STR.equalsIgnoreCase(tom.getAttachmentType())) {
                        attachmentType = MTOM_STR;
                        break;
                    }
                    attachmentType = SWAREF_STR;
                    break;
                }
                if (tom.additionalOperations == null || tom.additionalOperations.isEmpty()) continue;
                for (OperationModel om2 : tom.additionalOperations) {
                    ProcedureOperationModel pom;
                    if (!om2.isProcedureOperation() || !(pom = (ProcedureOperationModel)om2).getBinaryAttachment()) continue;
                    binaryAttach = true;
                    if (MTOM_STR.equalsIgnoreCase(tom.getAttachmentType())) {
                        attachmentType = MTOM_STR;
                        continue block0;
                    }
                    attachmentType = SWAREF_STR;
                    continue block0;
                }
            }
            XMLBinaryDataMapping xbdm = new XMLBinaryDataMapping();
            if (binaryAttach) {
                if (attachmentType.equals(SWAREF_STR)) {
                    xbdm.setSwaRef(true);
                    qName = XMLConstants.SWA_REF_QNAME;
                }
            } else {
                xbdm.setShouldInlineBinaryData(true);
            }
            xbdm.setMimeType("application/octet-stream");
            xdm = xbdm;
        } else {
            xdm = new XMLDirectMapping();
        }
        String fieldName = nct.generateElementAlias(columnName);
        xdm.setAttributeName(fieldName);
        xdm.setAttributeClassificationName(attributeClass.getName());
        Object xPath = "";
        NamingConventionTransformer.ElementStyle style = nct.styleForElement(columnName);
        if (style == NamingConventionTransformer.ElementStyle.ATTRIBUTE) {
            xPath = (String)xPath + "@" + fieldName;
        } else if (style == NamingConventionTransformer.ElementStyle.ELEMENT) {
            xPath = (String)xPath + fieldName;
        }
        if (style == NamingConventionTransformer.ElementStyle.ELEMENT && attributeClass != CoreClassConstants.APBYTE) {
            xPath = (String)xPath + "/text()";
        }
        xdm.setXPath((String)xPath);
        XMLField xmlField = (XMLField)xdm.getField();
        xmlField.setSchemaType(qName);
        if (isPk) {
            xmlField.setRequired(true);
        } else {
            AbstractNullPolicy nullPolicy = xdm.getNullPolicy();
            nullPolicy.setNullRepresentedByEmptyNode(false);
            nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
            nullPolicy.setNullRepresentedByXsiNil(true);
            xdm.setNullPolicy(nullPolicy);
        }
        return xdm;
    }

    protected NamingConventionTransformer setUpCustomTransformer(String tableName, NamingConventionTransformer nct) {
        DefaultNamingConventionTransformer customNct = new DefaultNamingConventionTransformer(){

            @Override
            protected boolean isDefaultTransformer() {
                return false;
            }

            @Override
            public String generateSchemaAlias(String tableName) {
                return tableName;
            }
        };
        ((DefaultNamingConventionTransformer)customNct).setNextTransformer(nct);
        return customNct;
    }

    protected void setUpFindQueries(NamingConventionTransformer nct, String tableName, RelationalDescriptor desc) {
        ReadObjectQuery roq = new ReadObjectQuery();
        String generatedJavaClassName = Util.getGeneratedJavaClassName(tableName, this.dbwsBuilder.getProjectName());
        roq.setReferenceClassName(generatedJavaClassName);
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        Object pks = null;
        List primaryKeyFields = desc.getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField primaryKeyField = (DatabaseField)primaryKeyFields.get(index);
            Expression subExp1 = builder.getField(primaryKeyField);
            Expression subExp2 = builder.getParameter(primaryKeyField.getName().toLowerCase());
            Expression subExpression = subExp1.equal(subExp2);
            expression = expression == null ? subExpression : expression.and(subExpression);
            roq.addArgument(primaryKeyField.getName().toLowerCase());
            pks = index == 0 ? "(" + primaryKeyField.getName() + EQUALS_BINDING1_STR : ((String)pks).concat(AND_STR + primaryKeyField.getName() + EQUALS_BINDING_STR + index);
        }
        if (pks != null) {
            pks = ((String)pks).concat(")");
        }
        roq.setSelectionCriteria(expression);
        desc.getQueryManager().addQuery("findByPrimaryKey_" + desc.getAlias() + "Type", (DatabaseQuery)roq);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClassName(generatedJavaClassName);
        desc.getQueryManager().addQuery("findAll_" + desc.getAlias() + "Type", (DatabaseQuery)raq);
        String findByPk = SELECT_FROM_STR + tableName + WHERE_STR + (String)pks;
        roq.setSQLString(findByPk);
        String findAll = SELECT_FROM_STR + tableName;
        raq.setSQLString(findAll);
    }

    protected static List<DbColumn> buildDbColumns(Connection connection, String secondarySql) {
        ArrayList<DbColumn> columns = null;
        ResultSetMetaData rsMetaData = BaseDBWSBuilderHelper.getResultSetMetadataForSecondarySQL(connection, secondarySql);
        if (rsMetaData != null) {
            int columnCount = 0;
            try {
                columnCount = rsMetaData.getColumnCount();
            }
            catch (SQLException sqlException) {
                throw new IllegalStateException("failure retrieving columnCount", sqlException);
            }
            if (columnCount > 0) {
                columns = new ArrayList<DbColumn>(columnCount);
                try {
                    for (int i = 1; i <= columnCount; ++i) {
                        String dbColumnName = rsMetaData.getColumnLabel(i);
                        DbColumn dbColumn = new DbColumn(dbColumnName);
                        dbColumn.setJDBCType(rsMetaData.getColumnType(i));
                        dbColumn.setJDBCTypeName(rsMetaData.getColumnTypeName(i));
                        int dbPrecision = rsMetaData.getPrecision(i);
                        int dbScale = rsMetaData.getScale(i);
                        dbColumn.setEnclosedType(Util.buildTypeForJDBCType(dbColumn.getJDBCType(), dbPrecision, dbScale));
                        if (rsMetaData.isNullable(i) == 1) {
                            dbColumn.unSetNotNull();
                        } else {
                            dbColumn.setNotNull();
                        }
                        columns.add(dbColumn);
                    }
                }
                catch (SQLException sqlException) {
                    throw new IllegalStateException("failure retrieving column information", sqlException);
                }
            }
        }
        return columns;
    }

    protected static String getTypeNameForDatabaseType(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dataType) {
        NumericType numericDataType;
        String typeName = dataType.getTypeName();
        if (dataType.isNumericType() && (numericDataType = (NumericType)dataType).getScale() > 0L) {
            typeName = "DECIMAL";
        }
        return typeName;
    }

    protected DatabaseType buildDatabaseTypeFromMetadataType(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dType) {
        return this.buildDatabaseTypeFromMetadataType(dType, null);
    }

    protected DatabaseType buildDatabaseTypeFromMetadataType(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dType, String catalog) {
        DatabaseType theType;
        PLSQLType pType;
        if (dType.isPLSQLType()) {
            pType = (PLSQLType)dType;
            catalog = pType.getParentType().getPackageName();
        }
        if (dType.isPLSQLCursorType()) {
            if (dType.isArgumentType()) {
                dType = ((ArgumentType)dType).getEnclosedType();
            }
            pType = (PLSQLCursorType)dType;
            return new PLSQLCursor(pType.getParentType().getPackageName() + "." + pType.getCursorName());
        }
        if (dType.isArgumentType()) {
            dType = ((ArgumentType)dType).getEnclosedType();
        } else if (dType.isTYPEType()) {
            dType = ((TYPEType)dType).getEnclosedType();
        }
        if (dType.isComposite()) {
            String typeName = dType.getTypeName();
            String compatibleType = typeName.contains("%") ? typeName.replace("%", "_") : typeName;
            String javaTypeName = compatibleType.toLowerCase();
            if (dType.isPLSQLType()) {
                if (catalog != null && !typeName.contains("%ROWTYPE")) {
                    typeName = (catalog + ".").concat(typeName);
                    compatibleType = (catalog + "_").concat(compatibleType);
                    javaTypeName = (catalog.toLowerCase() + ".").concat(javaTypeName);
                }
                if (dType.isPLSQLRecordType()) {
                    PLSQLrecord plsqlRec = new PLSQLrecord();
                    plsqlRec.setTypeName(typeName);
                    plsqlRec.setCompatibleType(compatibleType);
                    plsqlRec.setJavaTypeName(javaTypeName);
                    for (FieldType fld : ((PLSQLRecordType)dType).getFields()) {
                        if (fld.getEnclosedType().isPrecisionType()) {
                            PrecisionType precisionType = (PrecisionType)fld.getEnclosedType();
                            plsqlRec.addField(fld.getFieldName(), this.buildDatabaseTypeFromMetadataType((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)precisionType), (int)precisionType.getPrecision(), (int)precisionType.getScale());
                            continue;
                        }
                        if (fld.getEnclosedType().isSizedType()) {
                            SizedType sizedType = (SizedType)fld.getEnclosedType();
                            plsqlRec.addField(fld.getFieldName(), this.buildDatabaseTypeFromMetadataType((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)sizedType), (int)sizedType.getSize());
                            continue;
                        }
                        plsqlRec.addField(fld.getFieldName(), this.buildDatabaseTypeFromMetadataType(fld.getEnclosedType(), catalog));
                    }
                    return plsqlRec;
                }
                PLSQLCollection plsqlCollection = new PLSQLCollection();
                plsqlCollection.setTypeName(typeName);
                plsqlCollection.setCompatibleType(compatibleType);
                plsqlCollection.setJavaTypeName(javaTypeName + "_CollectionWrapper");
                plsqlCollection.setNestedType(this.buildDatabaseTypeFromMetadataType(((PLSQLCollectionType)dType).getEnclosedType(), catalog));
                return plsqlCollection;
            }
            if (dType.isVArrayType()) {
                OracleArrayType varray = new OracleArrayType();
                varray.setTypeName(typeName);
                varray.setCompatibleType(compatibleType);
                varray.setJavaTypeName(Util.getGeneratedWrapperClassName(javaTypeName, this.dbwsBuilder.getProjectName()));
                varray.setNestedType(this.buildDatabaseTypeFromMetadataType(((VArrayType)dType).getEnclosedType(), null));
                return varray;
            }
            if (dType.isObjectType()) {
                OracleObjectType objType = new OracleObjectType();
                objType.setTypeName(typeName);
                objType.setCompatibleType(compatibleType);
                objType.setJavaTypeName(Util.getGeneratedJavaClassName(javaTypeName, this.dbwsBuilder.getProjectName()));
                objType.setJavaType(this.getWrapperClass(objType.getJavaTypeName()));
                Map fields = objType.getFields();
                ObjectType oType = (ObjectType)dType;
                for (FieldType field : oType.getFields()) {
                    fields.put(field.getFieldName(), this.buildDatabaseTypeFromMetadataType(field.getEnclosedType()));
                }
                return objType;
            }
            if (dType.isObjectTableType()) {
                OracleArrayType tableType = new OracleArrayType();
                tableType.setTypeName(typeName);
                tableType.setCompatibleType(compatibleType);
                tableType.setJavaTypeName(Util.getGeneratedWrapperClassName(javaTypeName, this.dbwsBuilder.getProjectName()));
                DatabaseType nestedType = this.buildDatabaseTypeFromMetadataType(((ObjectTableType)dType).getEnclosedType(), null);
                Class wrapper = this.getWrapperClass(nestedType);
                if (wrapper != null) {
                    ((ComplexDatabaseType)nestedType).setJavaType(wrapper);
                }
                tableType.setNestedType(nestedType);
                return tableType;
            }
            return null;
        }
        if (dType.isScalar() && (theType = OraclePLSQLTypes.getDatabaseTypeForCode((String)dType.getTypeName())) != null) {
            return theType;
        }
        return JDBCTypes.getDatabaseTypeForCode((int)Util.getJDBCTypeFromTypeName(dType.getTypeName()));
    }

    protected void handleSimpleXMLFormat(boolean isSimpleXMLFormat, Result result, ProcedureOperationModel procedureOperationModel) {
        if (isSimpleXMLFormat || result.getType() == org.eclipse.persistence.internal.xr.Util.SXF_QNAME) {
            String xmlTag;
            SimpleXMLFormat sxf = new SimpleXMLFormat();
            String simpleXMLFormatTag = procedureOperationModel.getSimpleXMLFormatTag();
            if (simpleXMLFormatTag != null && !simpleXMLFormatTag.isEmpty()) {
                sxf.setSimpleXMLFormatTag(simpleXMLFormatTag);
            }
            if ((xmlTag = procedureOperationModel.getXmlTag()) != null && !xmlTag.isEmpty()) {
                sxf.setXMLTag(xmlTag);
            }
            result.setSimpleXMLFormat(sxf);
            if (this.dbwsBuilder.getOxProject().getDescriptorForAlias(SIMPLEXML_STR) == null) {
                SimpleXMLFormatProject sxfProject = new SimpleXMLFormatProject();
                this.dbwsBuilder.getOxProject().addDescriptor(sxfProject.buildXRRowSetModelDescriptor());
            }
        }
    }

    protected void finishProcedureOperation() {
        if (Util.requiresSimpleXMLFormat(this.dbwsBuilder.getXrServiceModel()) && this.dbwsBuilder.getSchema().getTopLevelElements().get(SIMPLEXML_STR) == null) {
            Util.addSimpleXMLFormat(this.dbwsBuilder.getSchema());
        }
    }

    protected List<ArgumentType> getArgumentListForProcedureType(ProcedureType pType) {
        ArrayList<ArgumentType> args = new ArrayList<ArgumentType>();
        if (pType.isFunctionType()) {
            args.add(((FunctionType)pType).getReturnArgument());
        }
        args.addAll(pType.getArguments());
        return args;
    }

    protected Class getWrapperClass(DatabaseType databaseType) {
        if (databaseType instanceof ComplexDatabaseType) {
            return this.getWrapperClass(((ComplexDatabaseType)databaseType).getJavaTypeName());
        }
        return null;
    }

    protected Class getWrapperClass(String wrapperClassName) {
        Class wrapperClass = null;
        try {
            wrapperClass = new XRDynamicClassLoader(this.getClass().getClassLoader()).loadClass(wrapperClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return wrapperClass;
    }

    protected void logNotFoundWarnings(String message, List<String> schemaPatterns, List<String> catalogPatterns, List<String> targetPatterns) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        for (int i = 0; i < targetPatterns.size(); ++i) {
            String tgtName;
            String pkgName;
            sb.append(" ");
            sb.append("[");
            boolean prependDot = false;
            String schemaName = schemaPatterns.get(i);
            if (schemaName != null && !schemaName.isEmpty()) {
                sb.append(schemaName);
                prependDot = true;
            }
            if ((pkgName = catalogPatterns.get(i)) != null && !pkgName.isEmpty()) {
                if (prependDot) {
                    sb.append(".");
                }
                prependDot = true;
                sb.append(pkgName);
            }
            if ((tgtName = targetPatterns.get(i)) != null && !tgtName.isEmpty()) {
                if (prependDot) {
                    sb.append(".");
                }
                sb.append(tgtName);
            }
            sb.append("]");
        }
        this.dbwsBuilder.logMessage(Level.WARNING, sb.toString());
    }

    protected void logPackageNotFoundWarnings(String message, List<String> schemaPatterns, List<String> catalogPatterns) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        for (int i = 0; i < catalogPatterns.size(); ++i) {
            String pkgName;
            sb.append(" ");
            sb.append("[");
            boolean prependDot = false;
            String schemaName = schemaPatterns.get(i);
            if (schemaName != null && !schemaName.isEmpty()) {
                sb.append(schemaName);
                prependDot = true;
            }
            if ((pkgName = catalogPatterns.get(i)) != null && !pkgName.isEmpty()) {
                if (prependDot) {
                    sb.append(".");
                }
                prependDot = true;
                sb.append(pkgName);
            }
            sb.append("]");
        }
        this.dbwsBuilder.logMessage(Level.WARNING, sb.toString());
    }
}

