/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.oracleddl.metadata.CharType;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseTypeWithEnclosedType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCollectionType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLRecordType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.PrecisionType;
import org.eclipse.persistence.tools.oracleddl.metadata.ROWTYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum;
import org.eclipse.persistence.tools.oracleddl.metadata.SizedType;
import org.eclipse.persistence.tools.oracleddl.metadata.TYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarCharType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.BaseDatabaseTypeVisitor;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitor;

public class ShadowDDLGenerator {
    static final String ROWTYPE_PREFIX = "_ROWTYPE_SQL";
    protected PLSQLPackageType plsqlPackageType;
    protected Map<String, Integer> rowTYPETypeCounts;
    protected Map<CompositeDatabaseTypeWithEnclosedType, DDLWrapper> createDDLs = new HashMap<CompositeDatabaseTypeWithEnclosedType, DDLWrapper>();
    protected Map<CompositeDatabaseTypeWithEnclosedType, DDLWrapper> dropDDLs = new HashMap<CompositeDatabaseTypeWithEnclosedType, DDLWrapper>();

    public ShadowDDLGenerator(PLSQLPackageType plsqlPackageType) {
        this.plsqlPackageType = plsqlPackageType;
        CountROWTYPETypesVisitor countVisitor = new CountROWTYPETypesVisitor();
        plsqlPackageType.accept((DatabaseTypeVisitor)countVisitor);
        this.rowTYPETypeCounts = countVisitor.getRowTYPETypeCounts();
        DDLWrapperGeneratorVisitor generatorVisitor = new DDLWrapperGeneratorVisitor();
        plsqlPackageType.accept((DatabaseTypeVisitor)generatorVisitor);
    }

    public String getCreateDDLFor(CompositeDatabaseTypeWithEnclosedType dType) {
        return this.createDDLs.get((Object)dType).ddl;
    }

    public List<String> getAllCreateDDLs() {
        ArrayList<String> allDDLs = new ArrayList<String>();
        for (Map.Entry<CompositeDatabaseTypeWithEnclosedType, DDLWrapper> me : this.createDDLs.entrySet()) {
            allDDLs.add(me.getValue().ddl);
        }
        return allDDLs;
    }

    public String getDropDDLFor(CompositeDatabaseTypeWithEnclosedType dType) {
        return this.dropDDLs.get((Object)dType).ddl;
    }

    public List<String> getAllDropDDLs() {
        ArrayList<String> allDDLs = new ArrayList<String>();
        for (Map.Entry<CompositeDatabaseTypeWithEnclosedType, DDLWrapper> me : this.dropDDLs.entrySet()) {
            allDDLs.add(me.getValue().ddl);
        }
        return allDDLs;
    }

    protected String getShadowROWTYPETypeName(ROWTYPEType rowTYPEType) {
        return rowTYPEType.getTypeName().replace("%", "_");
    }

    static class DDLWrapper {
        String ddl;
        boolean finished = false;

        DDLWrapper() {
        }

        public String toString() {
            return this.ddl;
        }
    }

    class DDLWrapperGeneratorVisitor
    extends BaseDatabaseTypeVisitor {
        static final String COR_TYPE = "CREATE OR REPLACE TYPE ";
        static final String DROP_TYPE = "DROP TYPE ";
        static final String FORCE = " FORCE";
        static final String LBRACKET = "(";
        static final String RBRACKET = ")";
        static final String SPACES = "      ";
        static final String AS_OBJECT = " AS OBJECT (";
        static final String AS_TABLE_OF = " AS TABLE OF ";
        static final String END_OBJECT = "\n);";
        static final String NUMBER_STR = "NUMBER";
        static final String ROWID_STR = "VARCHAR2(256)";
        static final String NUMBER_DEFAULTSIZE = "38";
        static final String FLOAT_DEFAULTSIZE = "63";
        static final String DOUBLE_DEFAULTSIZE = "126";
        static final String LONG_DEFAULTSIZE = "32760";
        protected Stack<PLSQLRecordType> recordTypes = new Stack();
        protected Stack<ROWTYPEType> rowTYPETypes = new Stack();

        DDLWrapperGeneratorVisitor() {
        }

        public void beginVisit(PLSQLRecordType recordType) {
            if (this.recordTypes.isEmpty()) {
                this.recordTypes.push(recordType);
            } else if (!this.recordTypes.peek().equals(recordType)) {
                this.recordTypes.push(recordType);
            }
            DDLWrapper ddlWrapper = ShadowDDLGenerator.this.createDDLs.get(recordType);
            if (ddlWrapper == null) {
                ddlWrapper = new DDLWrapper();
                ddlWrapper.ddl = COR_TYPE + recordType.getParentType().getPackageName() + "_" + recordType.getTypeName().toUpperCase() + AS_OBJECT;
                ShadowDDLGenerator.this.createDDLs.put((CompositeDatabaseTypeWithEnclosedType)recordType, ddlWrapper);
            }
        }

        public void endVisit(PLSQLRecordType recordType) {
            this.recordTypes.pop();
            DDLWrapper ddlWrapper = ShadowDDLGenerator.this.createDDLs.get(recordType);
            if (ddlWrapper != null && !ddlWrapper.finished) {
                ddlWrapper.ddl = ddlWrapper.ddl + END_OBJECT;
                ddlWrapper.finished = true;
            }
            if ((ddlWrapper = ShadowDDLGenerator.this.dropDDLs.get(recordType)) == null) {
                ddlWrapper = new DDLWrapper();
                ddlWrapper.ddl = DROP_TYPE + recordType.getParentType().getPackageName() + "_" + recordType.getTypeName().toUpperCase() + " FORCE;";
                ddlWrapper.finished = true;
                ShadowDDLGenerator.this.dropDDLs.put((CompositeDatabaseTypeWithEnclosedType)recordType, ddlWrapper);
            }
        }

        public void beginVisit(FieldType fieldType) {
            PLSQLRecordType currentRecordType;
            if (!this.recordTypes.isEmpty() && (currentRecordType = this.recordTypes.peek()) != null) {
                DDLWrapper ddlWrapper = ShadowDDLGenerator.this.createDDLs.get(currentRecordType);
                if (!ddlWrapper.finished) {
                    String fieldName = fieldType.getFieldName();
                    int len = currentRecordType.getFields().size();
                    for (int i = 0; i < len; ++i) {
                        FieldType f = (FieldType)currentRecordType.getFields().get(i);
                        if (!fieldName.equals(f.getFieldName())) continue;
                        ddlWrapper.ddl = ddlWrapper.ddl + SPACES + fieldName + " ";
                        DatabaseType fieldDataType = f.getEnclosedType();
                        Object fieldShadowName = null;
                        if (fieldDataType.isPLSQLType()) {
                            fieldShadowName = ((PLSQLType)fieldDataType).getParentType().getPackageName() + "_" + fieldDataType.getTypeName().toUpperCase();
                        } else if (fieldDataType.isTYPEType()) {
                            fieldShadowName = this.getShadowTypeName(fieldDataType);
                            TYPEType tType = (TYPEType)fieldDataType;
                            if (tType.getEnclosedType().isFieldType()) {
                                FieldType fType = (FieldType)tType.getEnclosedType();
                                if (fType.getEnclosedType().isPrecisionType()) {
                                    PrecisionType pType = (PrecisionType)fType.getEnclosedType();
                                    long precision = pType.getPrecision();
                                    if (precision != pType.getDefaultPrecision()) {
                                        long scale = pType.getScale();
                                        fieldShadowName = scale != 0L ? (String)fieldShadowName + LBRACKET + precision + "," + scale + RBRACKET : (String)fieldShadowName + LBRACKET + precision + RBRACKET;
                                    }
                                } else if (fType.getEnclosedType().isSizedType()) {
                                    SizedType sType = (SizedType)fType.getEnclosedType();
                                    fieldShadowName = (String)fieldShadowName + LBRACKET + sType.getSize() + RBRACKET;
                                }
                            }
                        } else {
                            fieldShadowName = this.getShadowTypeName(fieldDataType);
                        }
                        ddlWrapper.ddl = ddlWrapper.ddl + (String)fieldShadowName;
                        if (i >= len - 1) break;
                        ddlWrapper.ddl = ddlWrapper.ddl + ",\n";
                        break;
                    }
                }
            }
        }

        public void beginVisit(PLSQLCollectionType collectionType) {
            DDLWrapper ddlWrapper = ShadowDDLGenerator.this.createDDLs.get(collectionType);
            if (ddlWrapper == null) {
                ddlWrapper = new DDLWrapper();
            }
            if (!ddlWrapper.finished) {
                Object shadowNestedTypeName = null;
                DatabaseType nestedType = collectionType.getEnclosedType();
                if (nestedType.isNumericType()) {
                    NumericType nDataType = (NumericType)nestedType;
                    shadowNestedTypeName = nDataType.isNumberSynonym() ? NUMBER_STR : "NUMERIC";
                    PrecisionType pDataType = (PrecisionType)nestedType;
                    long defaultPrecision = pDataType.getDefaultPrecision();
                    long precision = pDataType.getPrecision();
                    long scale = pDataType.getScale();
                    if (precision != defaultPrecision) {
                        shadowNestedTypeName = (String)shadowNestedTypeName + LBRACKET + precision;
                        if (scale != 0L) {
                            shadowNestedTypeName = (String)shadowNestedTypeName + ", " + scale;
                        }
                        shadowNestedTypeName = (String)shadowNestedTypeName + RBRACKET;
                    }
                } else {
                    shadowNestedTypeName = this.getShadowTypeName(nestedType);
                }
                ddlWrapper.ddl = COR_TYPE + collectionType.getParentType().getPackageName() + "_" + collectionType.getTypeName().toUpperCase() + AS_TABLE_OF + (String)shadowNestedTypeName + ";";
                ddlWrapper.finished = true;
                ShadowDDLGenerator.this.createDDLs.put((CompositeDatabaseTypeWithEnclosedType)collectionType, ddlWrapper);
            }
        }

        public void endVisit(PLSQLCollectionType collectionType) {
            DDLWrapper ddlWrapper = new DDLWrapper();
            ddlWrapper.ddl = DROP_TYPE + collectionType.getParentType().getPackageName() + "_" + collectionType.getTypeName().toUpperCase() + " FORCE;";
            ddlWrapper.finished = true;
            ShadowDDLGenerator.this.dropDDLs.put((CompositeDatabaseTypeWithEnclosedType)collectionType, ddlWrapper);
        }

        public void beginVisit(ROWTYPEType rowTYPEType) {
            if (this.rowTYPETypes.isEmpty()) {
                this.rowTYPETypes.push(rowTYPEType);
            } else if (!this.rowTYPETypes.peek().equals(rowTYPEType)) {
                this.rowTYPETypes.push(rowTYPEType);
            }
            DDLWrapper ddlWrapper = ShadowDDLGenerator.this.createDDLs.get(rowTYPEType);
            if (ddlWrapper == null) {
                ddlWrapper = new DDLWrapper();
                ddlWrapper.ddl = COR_TYPE + ShadowDDLGenerator.this.getShadowROWTYPETypeName(rowTYPEType) + AS_OBJECT;
                DatabaseType enclosedType = rowTYPEType.getEnclosedType();
                if (enclosedType.isTableType()) {
                    TableType tableType = (TableType)enclosedType;
                    ddlWrapper.ddl = ddlWrapper.ddl + "\n";
                    int len = tableType.getColumns().size();
                    for (int i = 0; i < len; ++i) {
                        FieldType f = (FieldType)tableType.getColumns().get(i);
                        ddlWrapper.ddl = ddlWrapper.ddl + SPACES + f.getFieldName() + " ";
                        DatabaseType fieldDataType = f.getEnclosedType();
                        String fieldShadowName = this.getShadowTypeName(fieldDataType);
                        ddlWrapper.ddl = ddlWrapper.ddl + fieldShadowName;
                        if (i >= len - 1) continue;
                        ddlWrapper.ddl = ddlWrapper.ddl + ",\n";
                    }
                    ShadowDDLGenerator.this.createDDLs.put((CompositeDatabaseTypeWithEnclosedType)rowTYPEType, ddlWrapper);
                }
            }
        }

        public void endVisit(ROWTYPEType rowTYPEType) {
            this.rowTYPETypes.pop();
            DDLWrapper ddlWrapper = ShadowDDLGenerator.this.createDDLs.get(rowTYPEType);
            if (ddlWrapper != null && !ddlWrapper.finished) {
                ddlWrapper.ddl = ddlWrapper.ddl + END_OBJECT;
                ddlWrapper.finished = true;
            }
            if ((ddlWrapper = ShadowDDLGenerator.this.dropDDLs.get(rowTYPEType)) == null) {
                ddlWrapper = new DDLWrapper();
                ddlWrapper.ddl = DROP_TYPE + ShadowDDLGenerator.this.getShadowROWTYPETypeName(rowTYPEType) + " FORCE;";
                ddlWrapper.finished = true;
                ShadowDDLGenerator.this.dropDDLs.put((CompositeDatabaseTypeWithEnclosedType)rowTYPEType, ddlWrapper);
            }
        }

        protected String getShadowTypeName(DatabaseType dataType) {
            Object shadowTypeName = null;
            if (dataType == ScalarDatabaseTypeEnum.INTEGER_TYPE || dataType == ScalarDatabaseTypeEnum.SMALLINT_TYPE) {
                shadowTypeName = "NUMBER(38)";
            } else if (dataType == ScalarDatabaseTypeEnum.BINARY_INTEGER_TYPE || dataType == ScalarDatabaseTypeEnum.BOOLEAN_TYPE || dataType == ScalarDatabaseTypeEnum.NATURAL_TYPE || dataType == ScalarDatabaseTypeEnum.PLS_INTEGER_TYPE || dataType == ScalarDatabaseTypeEnum.POSITIVE_TYPE || dataType == ScalarDatabaseTypeEnum.SIGN_TYPE || dataType == ScalarDatabaseTypeEnum.SIMPLE_INTEGER_TYPE) {
                shadowTypeName = "INTEGER";
            } else if (dataType == ScalarDatabaseTypeEnum.ROWID_TYPE) {
                shadowTypeName = ROWID_STR;
            } else if (dataType == ScalarDatabaseTypeEnum.SIMPLE_DOUBLE_TYPE) {
                shadowTypeName = ScalarDatabaseTypeEnum.BINARY_DOUBLE_TYPE.getTypeName();
            } else if (dataType == ScalarDatabaseTypeEnum.SIMPLE_FLOAT_TYPE) {
                shadowTypeName = ScalarDatabaseTypeEnum.BINARY_FLOAT_TYPE.getTypeName();
            } else if (dataType.isPrecisionType()) {
                PrecisionType pDataType = (PrecisionType)dataType;
                long defaultPrecision = pDataType.getDefaultPrecision();
                String defaultPrecisionStr = NUMBER_DEFAULTSIZE;
                if (dataType.isNumericType() || dataType.isDecimalType()) {
                    shadowTypeName = NUMBER_STR;
                } else {
                    shadowTypeName = "FLOAT";
                    defaultPrecisionStr = FLOAT_DEFAULTSIZE;
                    if (dataType.isFloatType() || dataType.isDoubleType()) {
                        defaultPrecisionStr = DOUBLE_DEFAULTSIZE;
                    }
                }
                if (!dataType.isNumericType() || !((NumericType)dataType).isNumberSynonym()) {
                    long precision = pDataType.getPrecision();
                    long scale = pDataType.getScale();
                    if (precision != defaultPrecision) {
                        shadowTypeName = (String)shadowTypeName + LBRACKET + Long.toString(precision);
                        if (scale != 0L) {
                            shadowTypeName = (String)shadowTypeName + ", " + scale;
                        }
                    } else {
                        shadowTypeName = (String)shadowTypeName + LBRACKET + defaultPrecisionStr;
                    }
                    shadowTypeName = (String)shadowTypeName + RBRACKET;
                }
            } else if (dataType.isVarCharType()) {
                shadowTypeName = "VARCHAR2";
                VarCharType vcharType = (VarCharType)dataType;
                long defaultSize = vcharType.getDefaultSize();
                long size = vcharType.getSize();
                String sizeStr = Long.toString(size);
                if (dataType.isLongType()) {
                    shadowTypeName = "VARCHAR2";
                    if (size == defaultSize) {
                        sizeStr = LONG_DEFAULTSIZE;
                    }
                }
                shadowTypeName = (String)shadowTypeName + LBRACKET + sizeStr + RBRACKET;
            } else if (dataType.isCharType()) {
                shadowTypeName = "CHAR";
                long size = ((CharType)dataType).getSize();
                shadowTypeName = (String)shadowTypeName + LBRACKET + size + RBRACKET;
            } else if (dataType.isSizedType()) {
                shadowTypeName = dataType.getTypeName();
                SizedType sDataType = (SizedType)dataType;
                long defaultSize = sDataType.getDefaultSize();
                String sizeStr = null;
                long size = sDataType.getSize();
                if (dataType.isLongType()) {
                    shadowTypeName = "VARCHAR2";
                    sizeStr = size == defaultSize ? LONG_DEFAULTSIZE : Long.toString(size);
                    shadowTypeName = (String)shadowTypeName + LBRACKET + sizeStr + RBRACKET;
                } else if (dataType.isLongRawType()) {
                    shadowTypeName = "RAW";
                    sizeStr = size == defaultSize ? LONG_DEFAULTSIZE : Long.toString(size);
                    shadowTypeName = (String)shadowTypeName + LBRACKET + sizeStr + RBRACKET;
                } else if (size != defaultSize) {
                    shadowTypeName = (String)shadowTypeName + LBRACKET + size + RBRACKET;
                }
            } else if (dataType.isPLSQLType()) {
                shadowTypeName = ((PLSQLType)dataType).getParentType().getPackageName() + "_" + dataType.getTypeName();
            } else {
                String typeName = dataType.getTypeName();
                int typ = Util.getJDBCTypeFromTypeName(typeName);
                shadowTypeName = Util.getJDBCTypeNameFromType(typ);
                if ("OTHER".equals(shadowTypeName)) {
                    shadowTypeName = typeName;
                }
            }
            return shadowTypeName;
        }
    }

    static class CountROWTYPETypesVisitor
    extends BaseDatabaseTypeVisitor {
        Map<String, Integer> rowTYPETypeCounts = new HashMap<String, Integer>();
        int initialRowTYPETypeCount = 0;

        CountROWTYPETypesVisitor() {
        }

        public void beginVisit(ROWTYPEType rowTYPEType) {
            Integer rowTYPETypeCount = this.rowTYPETypeCounts.get(rowTYPEType.getTypeName());
            if (rowTYPETypeCount == null) {
                this.rowTYPETypeCounts.put(rowTYPEType.getTypeName(), this.initialRowTYPETypeCount++);
            }
        }

        public Map<String, Integer> getRowTYPETypeCounts() {
            return this.rowTYPETypeCounts;
        }
    }
}

