/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.metadata.generation;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.XMLAttributes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.IdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedPLSQLStoredFunctionQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedPLSQLStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredFunctionQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.OracleArrayTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.OracleObjectTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLRecordMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.StoredProcedureParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.structures.ArrayAccessor;
import org.eclipse.persistence.internal.jpa.metadata.structures.StructMetadata;
import org.eclipse.persistence.internal.jpa.metadata.structures.StructureAccessor;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.tools.metadata.generation.Util;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseTypeWithEnclosedType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCollectionType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLRecordType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.ROWTYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.TYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.VArrayType;

public class JPAMetadataGenerator {
    protected XMLEntityMappings xmlEntityMappings;
    protected DatabasePlatform dbPlatform;
    protected String defaultPackage;
    protected boolean generateCRUDOps = false;
    protected List<String> processedTypes = null;
    protected List<String> generatedEmbeddables = null;
    protected static final String DEFAULT_PLATFORM = "org.eclipse.persistence.platform.database.oracle.Oracle11Platform";

    public JPAMetadataGenerator() {
        this(null, DEFAULT_PLATFORM);
    }

    public JPAMetadataGenerator(String defaultPackage, String platformClassName) {
        this(defaultPackage, JPAMetadataGenerator.loadDatabasePlatform(platformClassName));
    }

    public JPAMetadataGenerator(String defaultPackage, DatabasePlatform dbPlatform) {
        this(defaultPackage, dbPlatform, false);
    }

    public JPAMetadataGenerator(String defaultPackage, DatabasePlatform dbPlatform, boolean generateCRUDOps) {
        this.defaultPackage = defaultPackage.toLowerCase();
        this.dbPlatform = dbPlatform;
        this.generateCRUDOps = generateCRUDOps;
        this.xmlEntityMappings = new XMLEntityMappings();
        this.initializeXMLEntityMappingLists();
    }

    protected void initializeXMLEntityMappingLists() {
        this.xmlEntityMappings.setEntities(new ArrayList());
        this.xmlEntityMappings.setEmbeddables(new ArrayList());
        this.xmlEntityMappings.setPLSQLRecords(new ArrayList());
        this.xmlEntityMappings.setPLSQLTables(new ArrayList());
        this.xmlEntityMappings.setOracleObjectTypes(new ArrayList());
        this.xmlEntityMappings.setOracleArrayTypes(new ArrayList());
        this.xmlEntityMappings.setNamedNativeQueries(new ArrayList());
        this.xmlEntityMappings.setNamedPLSQLStoredFunctionQueries(new ArrayList());
        this.xmlEntityMappings.setNamedPLSQLStoredProcedureQueries(new ArrayList());
        this.xmlEntityMappings.setNamedStoredFunctionQueries(new ArrayList());
        this.xmlEntityMappings.setNamedStoredProcedureQueries(new ArrayList());
        this.xmlEntityMappings.setMixedConverters(new ArrayList());
        this.xmlEntityMappings.setMappedSuperclasses(new ArrayList());
        this.xmlEntityMappings.setTenantDiscriminatorColumns(new ArrayList());
        this.xmlEntityMappings.setTypeConverters(new ArrayList());
        this.xmlEntityMappings.setObjectTypeConverters(new ArrayList());
        this.xmlEntityMappings.setSerializedConverters(new ArrayList());
        this.xmlEntityMappings.setStructConverters(new ArrayList());
        this.xmlEntityMappings.setTableGenerators(new ArrayList());
        this.xmlEntityMappings.setSequenceGenerators(new ArrayList());
        this.xmlEntityMappings.setPartitioning(new ArrayList());
        this.xmlEntityMappings.setReplicationPartitioning(new ArrayList());
        this.xmlEntityMappings.setRoundRobinPartitioning(new ArrayList());
        this.xmlEntityMappings.setPinnedPartitioning(new ArrayList());
        this.xmlEntityMappings.setRangePartitioning(new ArrayList());
        this.xmlEntityMappings.setValuePartitioning(new ArrayList());
        this.xmlEntityMappings.setHashPartitioning(new ArrayList());
        this.xmlEntityMappings.setNamedQueries(new ArrayList());
        this.xmlEntityMappings.setSqlResultSetMappings(new ArrayList());
    }

    protected void initializeXMLAttributeLists(ClassAccessor accessor) {
        accessor.setAttributes(new XMLAttributes());
        accessor.getAttributes().setIds(new ArrayList());
        accessor.getAttributes().setBasics(new ArrayList());
        accessor.getAttributes().setArrays(new ArrayList());
        accessor.getAttributes().setStructures(new ArrayList());
        accessor.getAttributes().setEmbeddeds(new ArrayList());
        accessor.getAttributes().setBasicCollections(new ArrayList());
        accessor.getAttributes().setBasicMaps(new ArrayList());
        accessor.getAttributes().setElementCollections(new ArrayList());
        accessor.getAttributes().setManyToManys(new ArrayList());
        accessor.getAttributes().setManyToOnes(new ArrayList());
        accessor.getAttributes().setOneToManys(new ArrayList());
        accessor.getAttributes().setOneToOnes(new ArrayList());
        accessor.getAttributes().setTransformations(new ArrayList());
        accessor.getAttributes().setTransients(new ArrayList());
        accessor.getAttributes().setVariableOneToOnes(new ArrayList());
        accessor.getAttributes().setVersions(new ArrayList());
    }

    public XMLEntityMappings generateXmlEntityMappings(List<CompositeDatabaseType> databaseTypes) {
        ArrayList<ProcedureType> procedures = new ArrayList<ProcedureType>();
        ArrayList<TableType> tables = new ArrayList<TableType>();
        for (CompositeDatabaseType dbType : databaseTypes) {
            if (dbType.isTableType()) {
                tables.add((TableType)dbType);
                continue;
            }
            if (!dbType.isProcedureType()) continue;
            procedures.add((ProcedureType)dbType);
        }
        Util.handleOverloading(procedures);
        for (TableType table : tables) {
            EntityAccessor entity = this.processTableType(table);
            this.xmlEntityMappings.getEntities().add(entity);
        }
        for (ProcedureType procedure : procedures) {
            PLSQLPackageType pkgType = procedure.getParentType();
            if (pkgType != null) {
                if (procedure.isFunctionType()) {
                    this.xmlEntityMappings.getNamedPLSQLStoredFunctionQueries().add(this.processPLSQLFunctionType((FunctionType)procedure, pkgType));
                    continue;
                }
                this.xmlEntityMappings.getNamedPLSQLStoredProcedureQueries().add(this.processPLSQLProcedureType(procedure, pkgType));
                continue;
            }
            if (procedure.isFunctionType()) {
                this.xmlEntityMappings.getNamedStoredFunctionQueries().add(this.processFunctionType((FunctionType)procedure));
                continue;
            }
            this.xmlEntityMappings.getNamedStoredProcedureQueries().add(this.processProcedureType(procedure));
        }
        return this.xmlEntityMappings;
    }

    protected EntityAccessor processTableType(TableType tType) {
        EntityAccessor entity = new EntityAccessor();
        entity.setAccess("VIRTUAL");
        entity.setClassName(Util.getEntityName(tType.getTableName(), this.defaultPackage));
        this.initializeXMLAttributeLists((ClassAccessor)entity);
        TableMetadata table = new TableMetadata();
        table.setName(tType.getTableName());
        entity.setTable(table);
        for (FieldType fType : tType.getColumns()) {
            IdAccessor attribute;
            if (fType.pk()) {
                attribute = new IdAccessor();
                entity.getAttributes().getIds().add(attribute);
            } else {
                attribute = new BasicAccessor();
                entity.getAttributes().getBasics().add(attribute);
            }
            attribute.setName(fType.getFieldName().toLowerCase());
            attribute.setAttributeType(Util.getAttributeTypeNameForFieldType(fType, this.dbPlatform));
            ColumnMetadata column = new ColumnMetadata();
            column.setName(fType.getFieldName());
            attribute.setColumn(column);
        }
        this.generateCRUDMetadata(entity);
        return entity;
    }

    protected NamedStoredFunctionQueryMetadata processFunctionType(FunctionType fType) {
        NamedStoredFunctionQueryMetadata storedFunc = new NamedStoredFunctionQueryMetadata();
        storedFunc.setName(this.getQueryNameForProcedureType((ProcedureType)fType));
        storedFunc.setProcedureName(fType.getProcedureName());
        storedFunc.setReturnParameter(this.processArgument(fType.getReturnArgument()));
        if (fType.getArguments().size() > 0) {
            ArrayList<StoredProcedureParameterMetadata> params = new ArrayList<StoredProcedureParameterMetadata>();
            for (ArgumentType arg : fType.getArguments()) {
                params.add(this.processArgument(arg));
            }
            storedFunc.setParameters(params);
        }
        return storedFunc;
    }

    protected NamedStoredProcedureQueryMetadata processProcedureType(ProcedureType pType) {
        NamedStoredProcedureQueryMetadata storedProc = new NamedStoredProcedureQueryMetadata();
        storedProc.setName(this.getQueryNameForProcedureType(pType));
        storedProc.setProcedureName(pType.getProcedureName());
        storedProc.setReturnsResultSet(Boolean.valueOf(false));
        if (pType.getArguments().size() > 0) {
            ArrayList<StoredProcedureParameterMetadata> params = new ArrayList<StoredProcedureParameterMetadata>();
            for (ArgumentType arg : pType.getArguments()) {
                params.add(this.processArgument(arg));
            }
            storedProc.setParameters(params);
        }
        return storedProc;
    }

    protected NamedPLSQLStoredFunctionQueryMetadata processPLSQLFunctionType(FunctionType fType, PLSQLPackageType pkgType) {
        NamedPLSQLStoredFunctionQueryMetadata storedFunc = new NamedPLSQLStoredFunctionQueryMetadata();
        storedFunc.setName(this.getQueryNameForProcedureType((ProcedureType)fType));
        storedFunc.setProcedureName(pkgType.getPackageName() + "." + fType.getProcedureName());
        ArrayList<PLSQLParameterMetadata> params = new ArrayList<PLSQLParameterMetadata>();
        storedFunc.setReturnParameter(this.processPLSQLArgument(fType.getReturnArgument()));
        if (fType.getArguments().size() > 0) {
            for (ArgumentType arg : fType.getArguments()) {
                params.add(this.processPLSQLArgument(arg));
            }
        }
        storedFunc.setParameters(params);
        return storedFunc;
    }

    protected NamedPLSQLStoredProcedureQueryMetadata processPLSQLProcedureType(ProcedureType pType, PLSQLPackageType pkgType) {
        NamedPLSQLStoredProcedureQueryMetadata storedProc = new NamedPLSQLStoredProcedureQueryMetadata();
        storedProc.setName(this.getQueryNameForProcedureType(pType));
        storedProc.setProcedureName(pkgType.getPackageName() + "." + pType.getProcedureName());
        if (pType.getArguments().size() > 0) {
            ArrayList<PLSQLParameterMetadata> params = new ArrayList<PLSQLParameterMetadata>();
            for (ArgumentType arg : pType.getArguments()) {
                params.add(this.processPLSQLArgument(arg));
            }
            storedProc.setParameters(params);
        }
        return storedProc;
    }

    protected String getQueryNameForProcedureType(ProcedureType pType) {
        return pType.getOverload() == 0 ? pType.getProcedureName() : pType.getProcedureName() + "_" + pType.getOverload();
    }

    protected StoredProcedureParameterMetadata processArgument(ArgumentType arg) {
        StoredProcedureParameterMetadata param = new StoredProcedureParameterMetadata();
        param.setName(arg.getArgumentName());
        if (arg.getDirection() != ArgumentTypeDirection.RETURN) {
            param.setMode(arg.getDirection().name());
        }
        if (!arg.isComposite()) {
            param.setTypeName(Util.getClassNameFromJDBCTypeName(arg.getTypeName(), this.dbPlatform));
            param.setJdbcType(Integer.valueOf(Util.getJDBCTypeFromTypeName(arg.getTypeName())));
            param.setJdbcTypeName(Util.getJDBCTypeName(arg.getTypeName()));
        } else {
            param.setTypeName(Util.getGeneratedJavaClassName(arg.getTypeName(), this.defaultPackage));
            param.setJdbcTypeName(arg.getTypeName());
            if (arg.isObjectType()) {
                param.setJdbcType(Integer.valueOf(2002));
            } else if (arg.isObjectTableType() || arg.isVArrayType()) {
                param.setJdbcType(Integer.valueOf(2003));
            }
            this.processCompositeType(arg.getEnclosedType());
        }
        return param;
    }

    protected PLSQLParameterMetadata processPLSQLArgument(ArgumentType arg) {
        if (arg.getEnclosedType().isROWTYPEType()) {
            ROWTYPEType rType = (ROWTYPEType)arg.getEnclosedType();
            TableType tableType = (TableType)rType.getEnclosedType();
            PLSQLRecordType plsqlRec = new PLSQLRecordType(rType.getTypeName());
            plsqlRec.setParentType(new PLSQLPackageType());
            for (FieldType col : tableType.getColumns()) {
                FieldType ft = new FieldType(col.getFieldName());
                ft.setEnclosedType(col.getEnclosedType());
                plsqlRec.addField((DatabaseType)ft);
            }
            arg.setEnclosedType((DatabaseType)plsqlRec);
        }
        PLSQLParameterMetadata param = new PLSQLParameterMetadata();
        if (arg.isPLSQLCursorType()) {
            param.setDirection("OUT_CURSOR");
        }
        if (arg.getDirection() == ArgumentTypeDirection.RETURN) {
            param.setName(arg.isPLSQLCursorType() ? "CURSOR" : "RESULT");
        } else {
            if (!arg.isPLSQLCursorType()) {
                param.setDirection(arg.getDirection().name());
            }
            param.setName(arg.getArgumentName());
        }
        String dbType = arg.getTypeName();
        if (arg.isComposite()) {
            DatabaseType enclosedType = arg.getEnclosedType();
            if (enclosedType.isPLSQLType() || enclosedType.isPLSQLCursorType()) {
                dbType = Util.getQualifiedTypeName(enclosedType);
            }
            this.processCompositeType(enclosedType, dbType);
        }
        param.setDatabaseType(Util.processTypeName(dbType));
        return param;
    }

    protected OracleObjectTypeMetadata processObjectType(ObjectType oType) {
        OracleObjectTypeMetadata objectType = new OracleObjectTypeMetadata();
        objectType.setName(oType.getTypeName());
        objectType.setJavaType(Util.getGeneratedJavaClassName(oType.getTypeName(), this.defaultPackage));
        ArrayList<PLSQLParameterMetadata> fields = new ArrayList<PLSQLParameterMetadata>();
        for (FieldType ft : oType.getFields()) {
            PLSQLParameterMetadata fieldMetadata = new PLSQLParameterMetadata();
            fieldMetadata.setName(ft.getFieldName());
            fieldMetadata.setDatabaseType(Util.processTypeName(ft.getTypeName()));
            fields.add(fieldMetadata);
            if (!ft.isComposite()) continue;
            this.processCompositeType(ft.getEnclosedType());
        }
        objectType.setFields(fields);
        this.getProcessedTypes().add(objectType.getName());
        this.generateEmbeddable(objectType, oType);
        return objectType;
    }

    protected OracleArrayTypeMetadata processArrayType(DatabaseType dbType) {
        OracleArrayTypeMetadata arrayType = new OracleArrayTypeMetadata();
        arrayType.setName(dbType.getTypeName());
        arrayType.setJavaType(Util.getGeneratedJavaClassName(dbType.getTypeName(), this.defaultPackage));
        if (dbType.isVArrayType()) {
            arrayType.setNestedType(Util.processTypeName(((VArrayType)dbType).getEnclosedType().getTypeName()));
        } else {
            arrayType.setNestedType(((ObjectTableType)dbType).getEnclosedType().getTypeName());
        }
        this.getProcessedTypes().add(arrayType.getName());
        this.generateEmbeddable(arrayType, (CompositeDatabaseTypeWithEnclosedType)dbType);
        return arrayType;
    }

    protected PLSQLTableMetadata processPLSQLCollectionType(PLSQLCollectionType plsqlCollectionType) {
        String compatiableName;
        String typeName = Util.getQualifiedTypeName((DatabaseType)plsqlCollectionType);
        String targetClassName = compatiableName = Util.getQualifiedCompatibleTypeName((DatabaseType)plsqlCollectionType);
        PLSQLTableMetadata plsqlTable = new PLSQLTableMetadata();
        plsqlTable.setName(typeName);
        plsqlTable.setCompatibleType(compatiableName);
        plsqlTable.setJavaType(Util.getGeneratedJavaClassName(typeName));
        plsqlTable.setNestedTable(Boolean.valueOf(!plsqlCollectionType.isIndexed()));
        String dbType = plsqlCollectionType.getEnclosedType().getTypeName();
        if (Util.getJDBCTypeFromTypeName(dbType) != 1111) {
            if (Util.isArgPLSQLScalar(dbType)) {
                plsqlTable.setNestedType(Util.getOraclePLSQLTypeForName(dbType));
            } else {
                plsqlTable.setNestedType(Util.processTypeName(dbType));
            }
        } else {
            if (plsqlCollectionType.isComposite()) {
                DatabaseType enclosedType = plsqlCollectionType.getEnclosedType();
                if (enclosedType.isPLSQLType()) {
                    dbType = ((PLSQLType)enclosedType).getParentType().getPackageName() + "." + dbType;
                    targetClassName = Util.getGeneratedJavaClassName(dbType);
                } else {
                    targetClassName = Util.getGeneratedJavaClassName(dbType, this.defaultPackage);
                }
                this.processCompositeType(enclosedType, dbType);
            }
            plsqlTable.setNestedType(dbType);
        }
        this.getProcessedTypes().add(plsqlTable.getName());
        this.generateEmbeddable(plsqlTable, targetClassName);
        return plsqlTable;
    }

    protected PLSQLRecordMetadata processPLSQLRecordType(PLSQLRecordType plsqlRecordType) {
        String typeName = Util.getQualifiedTypeName((DatabaseType)plsqlRecordType);
        String compatibleName = Util.getQualifiedCompatibleTypeName((DatabaseType)plsqlRecordType);
        if (compatibleName.contains("%")) {
            compatibleName = compatibleName.replace("%", "_");
        }
        PLSQLRecordMetadata plsqlRecord = new PLSQLRecordMetadata();
        plsqlRecord.setName(typeName);
        plsqlRecord.setCompatibleType(compatibleName);
        if (typeName.endsWith("%ROWTYPE")) {
            plsqlRecord.setJavaType(Util.getGeneratedJavaClassName(compatibleName));
        } else {
            plsqlRecord.setJavaType(Util.getGeneratedJavaClassName(typeName));
        }
        ArrayList<PLSQLParameterMetadata> fields = new ArrayList<PLSQLParameterMetadata>();
        for (FieldType fld : plsqlRecordType.getFields()) {
            PLSQLParameterMetadata field = new PLSQLParameterMetadata();
            field.setName(fld.getFieldName());
            String dbType = Util.processTypeName(fld.getTypeName());
            if (fld.isComposite()) {
                DatabaseType enclosedType = fld.getEnclosedType();
                if (enclosedType.isPLSQLType()) {
                    dbType = ((PLSQLType)fld.getEnclosedType()).getParentType().getPackageName() + "." + dbType;
                }
                this.processCompositeType(enclosedType, dbType);
            }
            field.setDatabaseType(dbType);
            fields.add(field);
        }
        plsqlRecord.setFields(fields);
        this.getProcessedTypes().add(plsqlRecord.getName());
        this.generateEmbeddable(plsqlRecord, plsqlRecordType);
        return plsqlRecord;
    }

    protected void processCompositeType(DatabaseType compositeType) {
        this.processCompositeType(compositeType, compositeType.getTypeName());
    }

    protected void processCompositeType(DatabaseType compositeType, String typeName) {
        if (!this.alreadyProcessed(typeName)) {
            if (compositeType.isPLSQLCollectionType()) {
                this.xmlEntityMappings.getPLSQLTables().add(this.processPLSQLCollectionType((PLSQLCollectionType)compositeType));
            } else if (compositeType.isPLSQLRecordType()) {
                this.xmlEntityMappings.getPLSQLRecords().add(this.processPLSQLRecordType((PLSQLRecordType)compositeType));
            } else if (compositeType.isObjectType()) {
                this.xmlEntityMappings.getOracleObjectTypes().add(this.processObjectType((ObjectType)compositeType));
            } else if (compositeType.isObjectTableType() || compositeType.isVArrayType()) {
                this.xmlEntityMappings.getOracleArrayTypes().add(this.processArrayType(compositeType));
            }
        }
    }

    protected void generateEmbeddable(PLSQLTableMetadata tableMetadata, String targetClassName) {
        if (!this.embeddableAlreadyProcessed(tableMetadata.getJavaType())) {
            EmbeddableAccessor embeddable = this.initEmbeddable(tableMetadata.getJavaType());
            ArrayAccessor array = this.generateArrayAccessor("items", "ITEMS", tableMetadata.getCompatibleType(), targetClassName);
            embeddable.getAttributes().getArrays().add(array);
            this.xmlEntityMappings.getEmbeddables().add(embeddable);
            this.getGeneratedEmbeddables().add(tableMetadata.getJavaType());
        }
    }

    protected void generateEmbeddable(PLSQLRecordMetadata recordMetadata, PLSQLRecordType recordType) {
        if (!this.embeddableAlreadyProcessed(recordMetadata.getJavaType())) {
            EmbeddableAccessor embeddable = this.initEmbeddable(recordMetadata.getJavaType());
            StructMetadata struct = new StructMetadata();
            struct.setName(recordMetadata.getCompatibleType());
            ArrayList<String> fields = new ArrayList<String>();
            for (PLSQLParameterMetadata fld : recordMetadata.getFields()) {
                fields.add(fld.getName());
            }
            struct.setFields(fields);
            embeddable.setStruct(struct);
            this.addEmbeddableAttributes(embeddable, recordType.getFields());
            this.xmlEntityMappings.getEmbeddables().add(embeddable);
            this.getGeneratedEmbeddables().add(recordMetadata.getJavaType());
        }
    }

    protected void generateEmbeddable(OracleArrayTypeMetadata arrayTypeMetadata, CompositeDatabaseTypeWithEnclosedType dbType) {
        if (!this.embeddableAlreadyProcessed(arrayTypeMetadata.getJavaType())) {
            EmbeddableAccessor embeddable = this.initEmbeddable(arrayTypeMetadata.getJavaType());
            ArrayAccessor array = dbType.getEnclosedType().isComposite() ? this.generateArrayAccessor("items", "ITEMS", arrayTypeMetadata.getNestedType(), Util.getGeneratedJavaClassName(arrayTypeMetadata.getNestedType(), this.defaultPackage)) : this.generateArrayAccessor("items", "ITEMS", dbType.getEnclosedType().getTypeName());
            embeddable.getAttributes().getArrays().add(array);
            this.xmlEntityMappings.getEmbeddables().add(embeddable);
            this.getGeneratedEmbeddables().add(arrayTypeMetadata.getJavaType());
        }
    }

    protected void generateEmbeddable(OracleObjectTypeMetadata objectTypeMetadata, ObjectType objectType) {
        if (!this.embeddableAlreadyProcessed(objectTypeMetadata.getJavaType())) {
            EmbeddableAccessor embeddable = this.initEmbeddable(objectTypeMetadata.getJavaType());
            StructMetadata struct = new StructMetadata();
            struct.setName(objectTypeMetadata.getName());
            ArrayList<String> fields = new ArrayList<String>();
            for (PLSQLParameterMetadata fld : objectTypeMetadata.getFields()) {
                fields.add(fld.getName());
            }
            struct.setFields(fields);
            embeddable.setStruct(struct);
            this.addEmbeddableAttributes(embeddable, objectType.getFields());
            this.xmlEntityMappings.getEmbeddables().add(embeddable);
            this.getGeneratedEmbeddables().add(objectTypeMetadata.getJavaType());
        }
    }

    protected EmbeddableAccessor initEmbeddable(String embeddableClassName) {
        EmbeddableAccessor embeddable = new EmbeddableAccessor();
        embeddable.setClassName(embeddableClassName);
        embeddable.setAccess("VIRTUAL");
        this.initializeXMLAttributeLists((ClassAccessor)embeddable);
        return embeddable;
    }

    protected void addEmbeddableAttributes(EmbeddableAccessor embeddable, List<FieldType> fields) {
        for (FieldType fld : fields) {
            BasicAccessor basic;
            DatabaseType enclosedType = fld.getEnclosedType();
            if (!enclosedType.isComposite() || enclosedType.isTYPEType()) {
                String typeName = enclosedType.isTYPEType() ? ((TYPEType)enclosedType).getTypeName() : fld.getTypeName();
                basic = this.generateBasicAccessor(fld.getFieldName().toLowerCase(), fld.getFieldName(), Util.getClassNameFromJDBCTypeName(typeName, this.dbPlatform));
                embeddable.getAttributes().getBasics().add(basic);
                continue;
            }
            if (enclosedType.isPLSQLType()) {
                PLSQLType plsqlType = (PLSQLType)enclosedType;
                String typeName = Util.getQualifiedTypeName((DatabaseType)plsqlType);
                EmbeddedAccessor embedded = new EmbeddedAccessor();
                embedded.setName(fld.getFieldName().toLowerCase());
                embedded.setAttributeType(Util.getGeneratedJavaClassName(typeName));
                embeddable.getAttributes().getEmbeddeds().add(embedded);
                continue;
            }
            if (enclosedType.isVArrayType() || enclosedType.isObjectTableType()) {
                ArrayAccessor array = null;
                if (enclosedType.isVArrayType()) {
                    array = this.generateArrayAccessor(fld.getFieldName().toLowerCase(), fld.getFieldName(), enclosedType.getTypeName());
                } else {
                    ObjectTableType otType = (ObjectTableType)enclosedType;
                    array = this.generateArrayAccessor(fld.getFieldName().toLowerCase(), fld.getFieldName(), otType.getEnclosedType().getTypeName(), Util.getGeneratedJavaClassName(otType.getEnclosedType().getTypeName(), this.defaultPackage));
                }
                embeddable.getAttributes().getArrays().add(array);
                continue;
            }
            if (enclosedType.isObjectType()) {
                StructureAccessor structure = this.generateStructureAccessor(fld.getFieldName().toLowerCase(), fld.getFieldName(), Util.getGeneratedJavaClassName(enclosedType.getTypeName(), this.defaultPackage));
                embeddable.getAttributes().getStructures().add(structure);
                continue;
            }
            if (!enclosedType.isTYPEType()) continue;
            TYPEType tType = (TYPEType)enclosedType;
            basic = this.generateBasicAccessor(fld.getFieldName().toLowerCase(), fld.getFieldName(), Util.getClassNameFromJDBCTypeName(tType.getTypeName(), this.dbPlatform));
            embeddable.getAttributes().getBasics().add(basic);
        }
    }

    protected ArrayAccessor generateArrayAccessor(String arrayName, String columnName, String databaseTypeName) {
        return this.generateArrayAccessor(arrayName, columnName, databaseTypeName, databaseTypeName);
    }

    protected ArrayAccessor generateArrayAccessor(String arrayName, String columnName, String databaseTypeName, String targetClassName) {
        ArrayAccessor array = new ArrayAccessor();
        array.setName(arrayName);
        array.setAttributeType("java.util.ArrayList");
        array.setDatabaseType(databaseTypeName);
        array.setTargetClassName(targetClassName);
        ColumnMetadata column = new ColumnMetadata();
        column.setName(columnName);
        array.setColumn(column);
        return array;
    }

    protected BasicAccessor generateBasicAccessor(String basicName, String columnName, String attributeTypeName) {
        BasicAccessor basic = new BasicAccessor();
        basic.setName(basicName);
        basic.setAttributeType(attributeTypeName);
        ColumnMetadata column = new ColumnMetadata();
        column.setName(columnName);
        basic.setColumn(column);
        return basic;
    }

    protected StructureAccessor generateStructureAccessor(String structureName, String columnName, String attributeTypeName) {
        return this.generateStructureAccessor(structureName, columnName, attributeTypeName, attributeTypeName);
    }

    protected StructureAccessor generateStructureAccessor(String structureName, String columnName, String attributeTypeName, String targetClassName) {
        StructureAccessor structure = new StructureAccessor();
        structure.setName(structureName);
        structure.setAttributeType(attributeTypeName);
        structure.setTargetClassName(targetClassName);
        ColumnMetadata column = new ColumnMetadata();
        column.setName(columnName);
        structure.setColumn(column);
        return structure;
    }

    protected void generateCRUDMetadata(EntityAccessor entity) {
        if (this.generateCRUDOps) {
            if (entity.getNamedNativeQueries() == null) {
                entity.setNamedNativeQueries(new ArrayList());
            }
            String tableName = entity.getTable().getName();
            String entityType = Util.getUnqualifiedEntityName(tableName) + "Type";
            List ids = entity.getAttributes().getIds();
            List basics = entity.getAttributes().getBasics();
            ArrayList mappings = new ArrayList();
            mappings.addAll(ids);
            mappings.addAll(basics);
            String pks = null;
            int pkCount = 0;
            for (IdAccessor pk : ids) {
                if (pkCount++ == 0) {
                    pks = "(" + pk.getName().toUpperCase() + " = ?1";
                    continue;
                }
                pks = pks.concat(" AND " + pk.getName().toUpperCase() + " = ?" + pkCount++);
            }
            if (pks != null) {
                pks = pks.concat(")");
            }
            NamedNativeQueryMetadata crudQuery = new NamedNativeQueryMetadata();
            crudQuery.setName("findByPrimaryKey_" + entityType);
            crudQuery.setQuery("SELECT * FROM " + tableName + " WHERE " + pks);
            crudQuery.setResultClassName(entity.getClassName());
            entity.getNamedNativeQueries().add(crudQuery);
            crudQuery = new NamedNativeQueryMetadata();
            crudQuery.setName("findAll_" + entityType);
            crudQuery.setQuery("SELECT * FROM " + tableName);
            crudQuery.setResultClassName(entity.getClassName());
            entity.getNamedNativeQueries().add(crudQuery);
            StringBuilder sqlStmt = new StringBuilder(128);
            sqlStmt.append("INSERT INTO ").append(tableName).append(" ").append("(");
            MetadataHelper.buildColsFromMappings((StringBuilder)sqlStmt, mappings, (String)", ");
            sqlStmt.append(")").append(" VALUES ").append("(");
            MetadataHelper.buildValuesAsQMarksFromMappings((StringBuilder)sqlStmt, mappings, (String)", ");
            sqlStmt.append(")");
            crudQuery = new NamedNativeQueryMetadata();
            crudQuery.setName("create_" + entityType);
            crudQuery.setQuery(sqlStmt.toString());
            entity.getNamedNativeQueries().add(crudQuery);
            sqlStmt = new StringBuilder(128);
            sqlStmt.append("UPDATE ").append(tableName).append(" SET ");
            MetadataHelper.buildColsAndValuesBindingsFromMappings((StringBuilder)sqlStmt, (Collection)basics, (int)pkCount, (String)" = ?", (String)", ");
            sqlStmt.append(" WHERE ").append(pks);
            crudQuery = new NamedNativeQueryMetadata();
            crudQuery.setName("update_" + entityType);
            crudQuery.setQuery(sqlStmt.toString());
            entity.getNamedNativeQueries().add(crudQuery);
            crudQuery = new NamedNativeQueryMetadata();
            crudQuery.setName("delete_" + entityType);
            crudQuery.setQuery("DELETE FROM " + tableName + " WHERE " + pks);
            entity.getNamedNativeQueries().add(crudQuery);
        }
    }

    protected void setGenerateCRUDOps(boolean generateCRUDOps) {
        this.generateCRUDOps = generateCRUDOps;
    }

    protected List<String> getProcessedTypes() {
        if (this.processedTypes == null) {
            this.processedTypes = new ArrayList<String>();
        }
        return this.processedTypes;
    }

    protected List<String> getGeneratedEmbeddables() {
        if (this.generatedEmbeddables == null) {
            this.generatedEmbeddables = new ArrayList<String>();
        }
        return this.generatedEmbeddables;
    }

    protected boolean embeddableAlreadyProcessed(String embeddableName) {
        return this.generatedEmbeddables != null && this.generatedEmbeddables.size() > 0 && this.generatedEmbeddables.contains(embeddableName);
    }

    protected boolean alreadyProcessed(String typeName) {
        return this.processedTypes != null && this.processedTypes.size() > 0 && this.processedTypes.contains(typeName);
    }

    public static DatabasePlatform loadDatabasePlatform(String platformClassName) {
        DatabasePlatform dbPlatform = null;
        Class platformClass = null;
        try {
            platformClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(platformClassName)) : PrivilegedAccessHelper.getClassForName((String)platformClassName);
            dbPlatform = (DatabasePlatform)Helper.getInstanceFromClass((Class)platformClass);
        }
        catch (Exception e) {
            try {
                platformClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(DEFAULT_PLATFORM)) : PrivilegedAccessHelper.getClassForName((String)DEFAULT_PLATFORM);
                dbPlatform = (DatabasePlatform)Helper.getInstanceFromClass((Class)platformClass);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return dbPlatform;
    }
}

