/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.eclipse.persistence.internal.databaseaccess.DatabaseJsonPlatform;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.spi.JsonPlatformProvider;

public class JsonPlatformManager {
    private final Map<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>> platforms;

    public static final JsonPlatformManager getInstance() {
        return Instance.INSTANCE;
    }

    private JsonPlatformManager() {
        HashMap<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>> converters = new HashMap<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>>();
        ServiceLoader<JsonPlatformProvider> providers = ServiceLoader.load(JsonPlatformProvider.class);
        for (JsonPlatformProvider provider : providers) {
            Map<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>> providerConverters = provider.platforms();
            for (Class<? extends DatabasePlatform> type : providerConverters.keySet()) {
                if (converters.containsKey(type)) continue;
                converters.put(type, providerConverters.get(type));
            }
        }
        this.platforms = Collections.unmodifiableMap(converters);
    }

    public DatabaseJsonPlatform createPlatform(Class<? extends DatabasePlatform> type) {
        Supplier<DatabaseJsonPlatform> supplier = this.platforms.get(type);
        if (supplier != null) {
            return supplier.get();
        }
        supplier = this.platforms.get(DatabasePlatform.class);
        return supplier != null ? supplier.get() : new DatabaseJsonPlatform(){};
    }

    private static final class Instance {
        private static final JsonPlatformManager INSTANCE = new JsonPlatformManager();

        private Instance() {
        }
    }
}

