/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.QueryStringCall;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;

public class SQLCall
extends DatabaseCall
implements QueryStringCall {
    protected boolean hasCustomSQLArguments = false;
    protected transient boolean isTranslatedCustomQuery = false;

    public SQLCall() {
    }

    public SQLCall(String sqlString) {
        this();
        this.setSQLString(sqlString);
    }

    protected void afterTranslateCustomQuery(List updatedParameters, List<Integer> updatedParameterTypes) {
        int size = this.getParameters().size();
        for (int i = 0; i < size; ++i) {
            DatabaseField outField;
            Integer parameterType = (Integer)this.parameterTypes.get(i);
            Object parameter = this.parameters.get(i);
            if (parameterType == MODIFY || parameterType == OUT || parameterType == OUT_CURSOR || parameterType == IN && parameter instanceof DatabaseField) {
                DatabaseField field = this.afterTranslateCustomQueryUpdateParameter((DatabaseField)parameter, i, parameterType, updatedParameters, updatedParameterTypes);
                if (field == null) continue;
                this.parameters.set(i, field);
                continue;
            }
            if (parameterType != INOUT || (outField = this.afterTranslateCustomQueryUpdateParameter((DatabaseField)((Object[])parameter)[1], i, parameterType, updatedParameters, updatedParameterTypes)) == null) continue;
            if (((Object[])parameter)[0] instanceof DatabaseField) {
                if (((Object[])parameter)[0] != ((Object[])parameter)[1]) {
                    DatabaseField inField = outField.clone();
                    inField.setName(((DatabaseField)((Object[])parameter)[0]).getName());
                    ((Object[])parameter)[0] = inField;
                } else {
                    ((Object[])parameter)[0] = outField;
                }
            }
            ((Object[])parameter)[1] = outField;
        }
    }

    protected DatabaseField afterTranslateCustomQueryUpdateParameter(DatabaseField field, int index, Integer parameterType, List updatedParameters, List<Integer> updatedParameterTypes) {
        int size = updatedParameters.size();
        for (int j = 0; j < size; ++j) {
            DatabaseField updateField = (DatabaseField)updatedParameters.get(j);
            if (!field.equals(updateField)) continue;
            Integer updateParameterType = updatedParameterTypes.get(j);
            if (updateParameterType == null) {
                return updateField;
            }
            if (updateParameterType != OUT_CURSOR) break;
            if (parameterType == OUT) {
                this.parameterTypes.set(index, OUT_CURSOR);
                return updateField;
            }
            throw ValidationException.cannotSetCursorForParameterTypeOtherThanOut(field.getName(), this.toString());
        }
        return null;
    }

    public boolean hasCustomSQLArguments() {
        return this.hasCustomSQLArguments;
    }

    @Override
    public boolean isSQLCall() {
        return true;
    }

    @Override
    public boolean isQueryStringCall() {
        return true;
    }

    @Override
    protected void prepareInternal(AbstractSession session) {
        if (this.hasCustomSQLArguments()) {
            List updatedParameters = null;
            List<Integer> updatedParameterTypes = null;
            if (this.getParameters().size() > 0) {
                updatedParameters = this.getParameters();
                this.setParameters(NonSynchronizedVector.newInstance());
                updatedParameterTypes = this.getParameterTypes();
                this.setParameterTypes(NonSynchronizedVector.newInstance());
            }
            this.translateCustomQuery();
            if (updatedParameters != null) {
                this.afterTranslateCustomQuery(updatedParameters, updatedParameterTypes);
            }
        }
        super.prepareInternal(session);
    }

    public void setHasCustomSQLArguments(boolean hasCustomSQLArguments) {
        this.hasCustomSQLArguments = hasCustomSQLArguments;
    }

    public void setCustomSQLArgumentType(String customParameterName, Class<?> type) {
        DatabaseField field = new DatabaseField(customParameterName);
        field.setType(type);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type) {
        DatabaseField field = new DatabaseField(argumentFieldName);
        field.setSqlType(type);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName) {
        ObjectRelationalDatabaseField field = new ObjectRelationalDatabaseField(argumentFieldName);
        field.setSqlType(type);
        field.setSqlTypeName(typeName);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName, Class<?> javaType) {
        ObjectRelationalDatabaseField field = new ObjectRelationalDatabaseField(argumentFieldName);
        field.setSqlType(type);
        field.setSqlTypeName(typeName);
        field.setType(javaType);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName, DatabaseField nestedType) {
        ObjectRelationalDatabaseField field = new ObjectRelationalDatabaseField(argumentFieldName);
        field.setSqlType(type);
        field.setSqlTypeName(typeName);
        field.setNestedTypeField(nestedType);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName, Class<?> javaType, DatabaseField nestedType) {
        ObjectRelationalDatabaseField field = new ObjectRelationalDatabaseField(argumentFieldName);
        field.setSqlType(type);
        field.setSqlTypeName(typeName);
        field.setType(javaType);
        field.setNestedTypeField(nestedType);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setSQLString(String sqlString) {
        this.setSQLStringInternal(sqlString);
    }

    @Override
    public void translateCustomQuery() {
        super.translateCustomQuery();
        this.isTranslatedCustomQuery = true;
    }

    @Override
    public void translatePureSQLCustomQuery() {
        if (this.isTranslatedCustomQuery) {
            return;
        }
        super.translatePureSQLCustomQuery();
        this.isTranslatedCustomQuery = true;
    }

    public void appendTranslationParameter(Writer writer, ParameterExpression expression, DatabasePlatform platform, AbstractRecord record) throws IOException {
        try {
            platform.writeParameterMarker(writer, expression, record, this);
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().add(expression);
        this.getParameterTypes().add(TRANSLATION);
    }

    public void useCustomSQLCursorOutputAsResultSet(String customParameterName) {
        DatabaseField field = new DatabaseField(customParameterName);
        this.getParameters().add(field);
        this.getParameterTypes().add(OUT_CURSOR);
        this.setIsCursorOutputProcedure(true);
    }
}

