/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

public class PropertiesHandler {
    public static String getPropertyValue(String name, Map m) {
        return PropertiesHandler.getPropertyValue(name, m, true);
    }

    public static String getPropertyValueLogDebug(String name, Map m, AbstractSession session) {
        return PropertiesHandler.getPropertyValueLogDebug(name, m, session, true);
    }

    public static String getPropertyValue(String name, Map m, boolean useSystemAsDefault) {
        return Prop.getPropertyValueToApply(name, m, null, useSystemAsDefault);
    }

    public static String getPropertyValueLogDebug(String name, Map m, AbstractSession session, boolean useSystemAsDefault) {
        return Prop.getPropertyValueToApply(name, m, session, useSystemAsDefault);
    }

    public static String getPropertyValue(String name, String value) {
        return Prop.getPropertyValueToApply(name, value, null);
    }

    public static String getPropertyValueLogDebug(String name, String value, AbstractSession session) {
        return Prop.getPropertyValueToApply(name, value, session);
    }

    public static String getPrefixedPropertyValue(String prefix, String suffix, Map m) {
        return (String)PropertiesHandler.getPrefixValues(prefix, m).get(suffix);
    }

    public static Map getPrefixValues(String prefix, Map m) {
        return Prop.getPrefixValuesToApply(prefix, m, null, true);
    }

    public static Map getPrefixValuesLogDebug(String prefix, Map m, AbstractSession session) {
        return Prop.getPrefixValuesToApply(prefix, m, session, true);
    }

    public static String getDefaultPropertyValue(String name) {
        return Prop.getDefaultPropertyValueToApply(name, null);
    }

    public static String getDefaultPropertyValueLogDebug(String name, AbstractSession session) {
        return Prop.getDefaultPropertyValueToApply(name, session);
    }

    protected static boolean shouldUseDefault(String value) {
        return value != null && value.length() == 0;
    }

    protected static class PessimisticLockTimeoutUnitProp
    extends Prop {
        PessimisticLockTimeoutUnitProp() {
            super("eclipselink.pessimistic.lock.timeout.unit", DescriptorQueryManager.DefaultTimeoutUnit.toString());
            this.valueArray = new Object[]{TimeUnit.MILLISECONDS.toString(), TimeUnit.SECONDS.toString(), TimeUnit.MINUTES.toString()};
        }
    }

    protected static class QueryTimeoutUnitProp
    extends Prop {
        QueryTimeoutUnitProp() {
            super("eclipselink.query.timeout.unit", DescriptorQueryManager.DefaultTimeoutUnit.toString());
            this.valueArray = new Object[]{TimeUnit.MILLISECONDS.toString(), TimeUnit.SECONDS.toString(), TimeUnit.MINUTES.toString()};
        }
    }

    protected static class IdValidationProp
    extends Prop {
        IdValidationProp() {
            super("eclipselink.id-validation", IdValidation.ZERO.toString());
            this.valueArray = new Object[]{IdValidation.NULL.toString(), IdValidation.ZERO.toString(), IdValidation.NEGATIVE.toString(), IdValidation.NONE.toString()};
        }
    }

    protected static class ExclusiveConnectionModeProp
    extends Prop {
        ExclusiveConnectionModeProp() {
            super("eclipselink.jdbc.exclusive-connection.mode", "Transactional");
            this.valueArray = new Object[]{"Transactional", "Isolated", "Always"};
        }
    }

    protected static class FlushClearCacheProp
    extends Prop {
        FlushClearCacheProp() {
            super("eclipselink.flush-clear.cache", "DropInvalidate");
            this.valueArray = new Object[]{"Merge", "Drop", "DropInvalidate"};
        }
    }

    protected static class BatchWritingProp
    extends Prop {
        BatchWritingProp() {
            super("eclipselink.jdbc.batch-writing", "None");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            this.valueArray = new Object[]{"None", "JDBC", "Buffered", "Oracle-JDBC"};
        }
    }

    protected static class DescriptorCustomizerProp
    extends Prop {
        DescriptorCustomizerProp() {
            super("eclipselink.descriptor.customizer.");
        }
    }

    protected static class BooleanProp
    extends Prop {
        BooleanProp(String name, String defaultValue) {
            super(name, defaultValue);
            this.valueArray = new Object[]{"true", "false"};
        }
    }

    protected static class CacheTypeProp
    extends Prop {
        CacheTypeProp() {
            super("eclipselink.cache.type.", "SoftWeak");
            String pcg = "org.eclipse.persistence.internal.identitymaps.";
            this.valueArray = new Object[][]{{"Weak", pcg + "WeakIdentityMap"}, {"Soft", pcg + "SoftIdentityMap"}, {"SoftWeak", pcg + "SoftCacheWeakIdentityMap"}, {"HardWeak", pcg + "HardCacheWeakIdentityMap"}, {"Full", pcg + "FullIdentityMap"}, {"NONE", pcg + "NoIdentityMap"}};
        }
    }

    protected static class CacheSizeProp
    extends Prop {
        CacheSizeProp() {
            super("eclipselink.cache.size.", Integer.toString(1000));
        }
    }

    protected static class JTACntrlrProp
    extends Prop {
        JTACntrlrProp() {
            super("eclipselink.jta.controller");
        }
    }

    protected static class TargetServerProp
    extends Prop {
        TargetServerProp() {
            super("eclipselink.target-server", "None");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String pcg = "org.eclipse.persistence.platform.server.";
            this.valueArray = new Object[][]{{"None", pcg + "NoServerPlatform"}, {"OC4J", pcg + "oc4j.Oc4jPlatform"}, {"Glassfish", pcg + "glassfish.GlassfishPlatform"}, {"WebSphere", pcg + "was.WebSpherePlatform"}, {"WebSphere_6_1", pcg + "was.WebSphere_6_1_Platform"}, {"WebSphere_7", pcg + "was.WebSphere_7_Platform"}, {"WebSphere_EJBEmbeddable", pcg + "was.WebSphere_EJBEmbeddable_Platform"}, {"WebSphere_Liberty", pcg + "was.WebSphere_Liberty_Platform"}, {"WebLogic", pcg + "wls.WebLogicPlatform"}, {"WebLogic_9", pcg + "wls.WebLogic_9_Platform"}, {"WebLogic_10", pcg + "wls.WebLogic_10_Platform"}, {"WebLogic_12", pcg + "wls.WebLogic_12_Platform"}, {"JBoss", pcg + "jboss.JBossPlatform"}, {"NetWeaver_7_1", pcg + "sap.SAPNetWeaver_7_1_Platform"}};
        }
    }

    protected static class TargetDatabaseProp
    extends Prop {
        TargetDatabaseProp() {
            super("eclipselink.target-database", "Auto");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String pcg = "org.eclipse.persistence.platform.database.";
            this.valueArray = new Object[][]{{"Auto", pcg + "DatabasePlatform"}, {"Oracle", pcg + "OraclePlatform"}, {"Oracle8i", pcg + "oracle.Oracle8Platform"}, {"Oracle9i", pcg + "oracle.Oracle9Platform"}, {"Oracle10g", pcg + "oracle.Oracle10Platform"}, {"Oracle11", pcg + "oracle.Oracle11Platform"}, {"Attunity", pcg + "AttunityPlatform"}, {"Cloudscape", pcg + "CloudscapePlatform"}, {"Database", pcg + "DatabasePlatform"}, {"DB2Mainframe", pcg + "DB2MainframePlatform"}, {"DB2", pcg + "DB2Platform"}, {"DBase", pcg + "DBasePlatform"}, {"Derby", pcg + "DerbyPlatform"}, {"HANA", pcg + "HANAPlatform"}, {"HSQL", pcg + "HSQLPlatform"}, {"Informix", pcg + "InformixPlatform"}, {"JavaDB", pcg + "JavaDBPlatform"}, {"MySQL", pcg + "MySQLPlatform"}, {"MaxDB", pcg + "MaxDBPlatform"}, {"MySQL4", pcg + "MySQLPlatform"}, {"PointBase", pcg + "PointBasePlatform"}, {"PostgreSQL", pcg + "PostgreSQLPlatform"}, {"SQLAnywhere", pcg + "SQLAnywherePlatform"}, {"SQLServer", pcg + "SQLServerPlatform"}, {"Sybase", pcg + "SybasePlatform"}, {"Symfoware", pcg + "SymfowarePlatform"}, {"TimesTen", pcg + "TimesTenPlatform"}};
        }
    }

    protected static class CommitOrderProp
    extends Prop {
        CommitOrderProp() {
            super("eclipselink.persistence-context.commit-order", "None");
            this.valueArray = new Object[]{"Id", "Changes", "None"};
        }
    }

    protected static class FlushModeProp
    extends Prop {
        FlushModeProp() {
            super("eclipselink.persistence-context.flush-mode", "AUTO");
            this.valueArray = new Object[]{"AUTO", "COMMIT"};
        }
    }

    protected static class ReferenceModeProp
    extends Prop {
        ReferenceModeProp() {
            super("eclipselink.persistence-context.reference-mode", ReferenceMode.HARD.toString());
            this.valueArray = new Object[]{ReferenceMode.HARD.toString(), ReferenceMode.WEAK.toString(), ReferenceMode.FORCE_WEAK.toString()};
        }
    }

    protected static class LoggingLevelProp
    extends Prop {
        LoggingLevelProp(String name, String defaultValue) {
            super(name, defaultValue);
            this.valueArray = new Object[]{Level.OFF.getName(), Level.SEVERE.getName(), Level.OFF.getName(), Level.WARNING.getName(), Level.INFO.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName()};
        }
    }

    protected static class ConnectionPoolProp
    extends Prop {
        ConnectionPoolProp() {
            super("eclipselink.connection-pool.");
        }
    }

    protected static class LoggerTypeProp
    extends Prop {
        LoggerTypeProp() {
            super("eclipselink.logging.logger", "DefaultLogger");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String pcg = "org.eclipse.persistence.logging.";
            this.valueArray = new Object[][]{{"DefaultLogger", pcg + "DefaultSessionLog"}, {"JavaLogger", pcg + "JavaLog"}};
        }
    }

    protected static abstract class Prop {
        static HashMap mainMap = new HashMap();
        Object[] valueArray;
        HashMap valueMap;
        String name;
        String defaultValue;
        String defaultValueToApply;
        boolean valueToApplyMayBeNull;
        boolean shouldReturnOriginalValueIfValueToApplyNotFound;

        Prop(String name) {
            this.name = name;
        }

        Prop(String name, String defaultValue) {
            this(name);
            this.defaultValue = defaultValue;
        }

        static String getPropertyValueFromMap(String name, Map m, boolean useSystemAsDefault) {
            String value = (String)m.get(name);
            if (value == null && useSystemAsDefault) {
                value = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetSystemProperty(name)) : System.getProperty(name);
            }
            return value;
        }

        static Map getPrefixValuesFromMap(String name, Map m, boolean useSystemAsDefault) {
            HashMap mapOut = new HashMap();
            if (useSystemAsDefault) {
                Map.Entry[] entries;
                for (Map.Entry entry : entries = (Map.Entry[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperties().entrySet().toArray(new Map.Entry[0]);
                    }
                })) {
                    String str = (String)entry.getKey();
                    if (!str.startsWith(name)) continue;
                    String entityName = str.substring(name.length(), str.length());
                    mapOut.put(entityName, entry.getValue());
                }
            }
            for (Map.Entry entry : m.entrySet()) {
                String str = (String)entry.getKey();
                if (!str.startsWith(name)) continue;
                String entityName = str.substring(name.length(), str.length());
                mapOut.put(entityName, entry.getValue());
            }
            return mapOut;
        }

        static String getPropertyValue(String name, boolean shouldUseDefault, Map m, AbstractSession session, boolean useSystemAsDefault) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                return null;
            }
            String value = Prop.getPropertyValueFromMap(name, m, useSystemAsDefault);
            if (value == null) {
                return null;
            }
            return prop.getValueToApply(value, shouldUseDefault, session);
        }

        static String getPropertyValueToApply(String name, Map m, AbstractSession session, boolean useSystemAsDefault) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                throw new IllegalArgumentException(name);
            }
            String value = Prop.getPropertyValueFromMap(name, m, useSystemAsDefault);
            if (value == null) {
                return null;
            }
            return prop.getValueToApply(value, PropertiesHandler.shouldUseDefault(value), session);
        }

        static String getPropertyValueToApply(String name, String value, AbstractSession session) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                throw new IllegalArgumentException(name);
            }
            return prop.getValueToApply(value, PropertiesHandler.shouldUseDefault(value), session);
        }

        static Map<String, Object> getPrefixValuesToApply(String prefix, Map m, AbstractSession session, boolean useSystemAsDefault) {
            Prop prop = (Prop)mainMap.get(prefix);
            Map mapIn = Prop.getPrefixValuesFromMap(prefix, m, useSystemAsDefault);
            if (mapIn.isEmpty()) {
                return mapIn;
            }
            HashMap<String, Object> mapOut = new HashMap<String, Object>(mapIn.size());
            for (Map.Entry entry : mapIn.entrySet()) {
                String suffix = (String)entry.getKey();
                Object value = entry.getValue();
                if (prop != null && value instanceof String) {
                    value = prop.getValueToApply((String)value, PropertiesHandler.shouldUseDefault((String)value), suffix, session);
                }
                mapOut.put(suffix, value);
            }
            return mapOut;
        }

        static String getDefaultPropertyValueToApply(String name, AbstractSession session) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-default-for-unknown-property", new Object[]{name}));
            }
            prop.logDefault(session);
            return prop.defaultValueToApply;
        }

        String getValueToApply(String value, boolean shouldUseDefault, AbstractSession session) {
            return this.getValueToApply(value, shouldUseDefault, null, session);
        }

        String getValueToApply(String value, boolean shouldUseDefault, String suffix, AbstractSession session) {
            String logValue;
            String key;
            if (shouldUseDefault) {
                this.logDefault(session, suffix);
                return this.defaultValueToApply;
            }
            String valueToApply = value;
            if (this.valueMap != null && (valueToApply = (String)this.valueMap.get(key = Prop.getUpperCaseString(value))) == null) {
                boolean notFound = true;
                if (this.valueToApplyMayBeNull) {
                    boolean bl = notFound = !this.valueMap.containsKey(key);
                }
                if (notFound) {
                    if (this.shouldReturnOriginalValueIfValueToApplyNotFound) {
                        valueToApply = value;
                    } else {
                        Object propertyName = this.name;
                        if (suffix != null) {
                            propertyName = (String)propertyName + suffix;
                        }
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-illegal-property-value", new Object[]{propertyName, Prop.getPrintValue(value)}));
                    }
                }
            }
            if ((logValue = PersistenceUnitProperties.getOverriddenLogStringForProperty(this.name)) != null) {
                this.log(session, logValue, logValue, suffix);
            } else {
                this.log(session, value, valueToApply, suffix);
            }
            return valueToApply;
        }

        static String getUpperCaseString(String value) {
            if (value != null) {
                return value.toUpperCase();
            }
            return null;
        }

        static String getPrintValue(String value) {
            if (value != null) {
                return value;
            }
            return "null";
        }

        void initialize() {
            if (this.valueArray != null) {
                this.valueMap = new HashMap(this.valueArray.length);
                if (this.valueArray instanceof Object[][]) {
                    Object[][] valueArray2 = (Object[][])this.valueArray;
                    for (int i = 0; i < valueArray2.length; ++i) {
                        this.valueMap.put(Prop.getUpperCaseString((String)valueArray2[i][0]), valueArray2[i][1]);
                        if (valueArray2[i][1] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                } else {
                    for (int i = 0; i < this.valueArray.length; ++i) {
                        this.valueMap.put(Prop.getUpperCaseString((String)this.valueArray[i]), this.valueArray[i]);
                        if (this.valueArray[i] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                }
                this.defaultValueToApply = (String)this.valueMap.get(Prop.getUpperCaseString(this.defaultValue));
            } else {
                this.defaultValueToApply = this.defaultValue;
            }
        }

        void logDefault(AbstractSession session) {
            this.logDefault(session, null);
        }

        void logDefault(AbstractSession session, String suffix) {
            if (session != null && session.shouldLog(1, "properties")) {
                Object propertyName = this.name;
                if (suffix != null) {
                    propertyName = (String)propertyName + suffix;
                }
                if (this.defaultValue != this.defaultValueToApply) {
                    session.log(1, "properties", "handler_property_value_default", new Object[]{propertyName, this.defaultValue, this.defaultValueToApply});
                } else {
                    session.log(1, "properties", "property_value_default", new Object[]{propertyName, this.defaultValue});
                }
            }
        }

        void log(AbstractSession session, String value, String valueToApply, String suffix) {
            if (session != null && session.shouldLog(1, "properties")) {
                Object propertyName = this.name;
                if (suffix != null) {
                    propertyName = (String)propertyName + suffix;
                }
                if (value != valueToApply) {
                    session.log(1, "properties", "handler_property_value_specified", new Object[]{propertyName, value, valueToApply});
                } else {
                    session.log(1, "properties", "property_value_specified", new Object[]{propertyName, value});
                }
            }
        }

        static void addProp(Prop prop) {
            prop.initialize();
            mainMap.put(prop.name, prop);
        }

        static {
            Prop.addProp(new LoggerTypeProp());
            Prop.addProp(new LoggingLevelProp("eclipselink.logging.level", Level.INFO.getName()));
            Prop.addProp(new LoggingLevelProp("eclipselink.logging.level.", Level.INFO.getName()));
            Prop.addProp(new TargetDatabaseProp());
            Prop.addProp(new TargetServerProp());
            Prop.addProp(new JTACntrlrProp());
            Prop.addProp(new CacheSizeProp());
            Prop.addProp(new CacheTypeProp());
            Prop.addProp(new BooleanProp("eclipselink.cache.shared.", "false"));
            Prop.addProp(new DescriptorCustomizerProp());
            Prop.addProp(new BatchWritingProp());
            Prop.addProp(new FlushClearCacheProp());
            Prop.addProp(new ReferenceModeProp());
            Prop.addProp(new FlushModeProp());
            Prop.addProp(new BooleanProp("eclipselink.persistence-context.close-on-commit", "false"));
            Prop.addProp(new BooleanProp("eclipselink.persistence-context.persist-on-commit", "true"));
            Prop.addProp(new BooleanProp("eclipselink.persistence-context.commit-without-persist-rules", "false"));
            Prop.addProp(new BooleanProp("eclipselink.validate-existence", "false"));
            Prop.addProp(new BooleanProp("eclipselink.order-updates", "true"));
            Prop.addProp(new CommitOrderProp());
            Prop.addProp(new BooleanProp("eclipselink.transaction.join-existing", "false"));
            Prop.addProp(new BooleanProp("eclipselink.composite-unit", "false"));
            Prop.addProp(new BooleanProp("eclipselink.composite-unit.member", "false"));
            Prop.addProp(new ExclusiveConnectionModeProp());
            Prop.addProp(new BooleanProp("eclipselink.jdbc.exclusive-connection.is-lazy", "true"));
            Prop.addProp(new IdValidationProp());
            Prop.addProp(new ConnectionPoolProp());
            Prop.addProp(new BooleanProp("eclipselink.jdbc.result-set-access-optimization", Boolean.toString(ObjectLevelReadQuery.isResultSetAccessOptimizedQueryDefault)));
            Prop.addProp(new BooleanProp("eclipselink.tolerate-invalid-jpql", "false"));
            Prop.addProp(new BooleanProp("eclipselink.multitenant.tenants-share-cache", "false"));
            Prop.addProp(new BooleanProp("eclipselink.multitenant.tenants-share-emf", "true"));
            Prop.addProp(new QueryTimeoutUnitProp());
            Prop.addProp(new PessimisticLockTimeoutUnitProp());
            Prop.addProp(new BooleanProp("eclipselink.locking.timestamp.local.default", "false"));
            Prop.addProp(new BooleanProp("eclipselink.jpa.sql-call-deferral", "true"));
            Prop.addProp(new BooleanProp("eclipselink.jpa.naming_into_indexed", "false"));
        }
    }
}

