/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.Serializable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.core.helper.CoreField;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class DatabaseField
implements Cloneable,
Serializable,
CoreField {
    protected int scale;
    protected int length;
    protected int precision;
    protected boolean isUnique;
    protected boolean isNullable;
    protected boolean isUpdatable;
    protected boolean isInsertable;
    protected boolean isCreatable;
    protected boolean isPrimaryKey;
    protected String columnDefinition;
    protected String name;
    protected String qualifiedName;
    protected DatabaseTable table;
    public transient Class type;
    public String typeName;
    public int sqlType = Integer.MIN_VALUE;
    public int index = -1;
    protected boolean useDelimiters = false;
    protected String nameForComparisons;
    protected boolean useUpperCaseForComparisons = false;
    public static final int NULL_SQL_TYPE = Integer.MIN_VALUE;
    protected boolean isTranslated = false;
    public boolean keepInRow;

    public DatabaseField() {
        this("", new DatabaseTable());
    }

    public DatabaseField(String qualifiedName) {
        this(qualifiedName, null, null);
    }

    public DatabaseField(String qualifiedName, String startDelimiter, String endDelimiter) {
        int index = qualifiedName.lastIndexOf(46);
        if (index == -1) {
            this.setName(qualifiedName, startDelimiter, endDelimiter);
            this.table = new DatabaseTable();
        } else {
            this.setName(qualifiedName.substring(index + 1, qualifiedName.length()), startDelimiter, endDelimiter);
            this.table = new DatabaseTable(qualifiedName.substring(0, index), startDelimiter, endDelimiter);
        }
        this.initDDLFields();
    }

    public DatabaseField(String fieldName, String tableName) {
        this(fieldName, new DatabaseTable(tableName));
    }

    public DatabaseField(String fieldName, DatabaseTable databaseTable) {
        this(fieldName, databaseTable, null, null);
    }

    public DatabaseField(String fieldName, DatabaseTable databaseTable, String startDelimiter, String endDelimiter) {
        this.setName(fieldName, startDelimiter, endDelimiter);
        this.table = databaseTable;
        this.initDDLFields();
    }

    public void initDDLFields() {
        this.scale = 0;
        this.length = 0;
        this.precision = 0;
        this.isUnique = false;
        this.isNullable = true;
        this.isUpdatable = true;
        this.isInsertable = true;
        this.isCreatable = true;
        this.isPrimaryKey = false;
        this.columnDefinition = "";
    }

    public DatabaseField clone() {
        try {
            return (DatabaseField)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.getMessage());
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.type == null && this.typeName != null) {
            this.type = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.typeName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.typeName, ex));
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DatabaseField)) {
            return false;
        }
        return this.equals((DatabaseField)object);
    }

    public boolean equals(DatabaseField field) {
        if (this == field) {
            return true;
        }
        if (field != null) {
            if (this.getQualifiedName().equals(field.getQualifiedName())) {
                return true;
            }
            if (DatabasePlatform.shouldIgnoreCaseOnFieldComparisons()) {
                if (this.name.equalsIgnoreCase(field.name)) {
                    if (!this.hasTableName() || !field.hasTableName()) {
                        return true;
                    }
                    return this.table.equals(field.table);
                }
            } else {
                String fieldNameToCompare;
                String ourNameToCompare;
                if (field.shouldUseDelimiters() || this.shouldUseDelimiters()) {
                    ourNameToCompare = this.name;
                    fieldNameToCompare = field.name;
                } else {
                    ourNameToCompare = this.getNameForComparisons();
                    fieldNameToCompare = field.getNameForComparisons();
                }
                if (this.name.equals(field.name) || ourNameToCompare.equals(fieldNameToCompare)) {
                    if (!this.hasTableName() || !field.hasTableName()) {
                        return true;
                    }
                    return this.table.equals(field.table);
                }
            }
        }
        return false;
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNameDelimited(DatasourcePlatform platform) {
        if (this.useDelimiters) {
            return platform.getStartDelimiter() + this.name + platform.getEndDelimiter();
        }
        return this.name;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.hasTableName() ? this.table.getQualifiedName() + "." + this.getName() : this.getName();
        }
        return this.qualifiedName;
    }

    public String getQualifiedNameDelimited(DatasourcePlatform platform) {
        if (this.hasTableName()) {
            return this.table.getQualifiedNameDelimited(platform) + "." + this.getNameDelimited(platform);
        }
        return this.getNameDelimited(platform);
    }

    public int getScale() {
        return this.scale;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public void setTableName(String tableName) {
        this.setTable(new DatabaseTable(tableName));
    }

    @Override
    public Class getType() {
        if (this.type == null && this.typeName != null) {
            this.convertClassNamesToClasses(this.getClass().getClassLoader());
        }
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int hashCode() {
        return this.getNameForComparisons().hashCode();
    }

    public boolean hasTableName() {
        if (this.table == null) {
            return false;
        }
        if (this.table.getName() == null) {
            return false;
        }
        return !this.table.getName().equals("");
    }

    public boolean isObjectRelationalDatabaseField() {
        return false;
    }

    public boolean isInsertable() {
        return this.isInsertable;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isTranslated() {
        return this.isTranslated;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isReadOnly() {
        return !this.isUpdatable && !this.isInsertable;
    }

    public boolean keepInRow() {
        return this.keepInRow;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public void resetQualifiedName(String qualifiedName) {
        this.setIndex(-1);
        int index = qualifiedName.lastIndexOf(46);
        if (index == -1) {
            this.setName(qualifiedName);
            this.getTable().setName("");
            this.getTable().setTableQualifier("");
        } else {
            this.setName(qualifiedName.substring(index + 1, qualifiedName.length()));
            this.getTable().setPossiblyQualifiedName(qualifiedName.substring(0, index));
        }
    }

    public void setColumnDefinition(String columnDefinition) {
        this.columnDefinition = columnDefinition;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setInsertable(boolean isInsertable) {
        this.isInsertable = isInsertable;
    }

    public void setKeepInRow(boolean keepInRow) {
        this.keepInRow = keepInRow;
    }

    public void setIsTranslated(boolean isTranslated) {
        this.isTranslated = isTranslated;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setName(String name) {
        this.setName(name, null, null);
    }

    public void setName(String name, DatasourcePlatform platform) {
        this.setName(name, platform.getStartDelimiter(), platform.getEndDelimiter());
    }

    public void setName(String name, String startDelimiter, String endDelimiter) {
        if (startDelimiter != null && endDelimiter != null && !startDelimiter.equals("") && !endDelimiter.equals("") && name.startsWith(startDelimiter) && name.endsWith(endDelimiter)) {
            this.name = name.substring(startDelimiter.length(), name.length() - endDelimiter.length());
            this.useDelimiters = true;
        } else {
            this.name = name;
        }
        this.nameForComparisons = null;
        this.qualifiedName = null;
    }

    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setPrimaryKey(boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    public void setTable(DatabaseTable table) {
        this.table = table;
        this.qualifiedName = null;
    }

    @Override
    public void setType(Class type) {
        this.type = type;
        if (this.type != null && this.typeName == null) {
            this.typeName = this.type.getName();
        }
    }

    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public void setUpdatable(boolean isUpdatable) {
        this.isUpdatable = isUpdatable;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public void setUseDelimiters(boolean useDelimiters) {
        this.useDelimiters = useDelimiters;
    }

    public boolean shouldUseDelimiters() {
        return this.useDelimiters;
    }

    public void useUpperCaseForComparisons(boolean useUpperCaseForComparisons) {
        if (this.useUpperCaseForComparisons != useUpperCaseForComparisons) {
            this.useUpperCaseForComparisons = useUpperCaseForComparisons;
            this.setNameForComparisons(null);
        }
    }

    public boolean getUseUpperCaseForComparisons() {
        return this.useUpperCaseForComparisons;
    }

    public void setNameForComparisons(String name) {
        this.nameForComparisons = name;
    }

    public boolean isCreatable() {
        return this.isCreatable;
    }

    public void setCreatable(boolean isCreatable) {
        this.isCreatable = isCreatable;
    }

    public String getNameForComparisons() {
        if (this.nameForComparisons == null) {
            this.nameForComparisons = !this.useUpperCaseForComparisons || this.name == null ? this.name : this.name.toUpperCase();
        }
        return this.nameForComparisons;
    }
}

