/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.EmptyRecord;
import org.eclipse.persistence.platform.database.oracle.Oracle11Platform;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Session;

public class Oracle12Platform
extends Oracle11Platform {
    private final Map<String, String> identitySequences;

    public Oracle12Platform() {
        this.supportsIdentity = true;
        this.identitySequences = new ConcurrentHashMap<String, String>();
    }

    @Override
    public boolean isOracle12() {
        return true;
    }

    @Override
    public void initIdentitySequences(Session session, String defaultIdentityGenerator) {
        if (this.sequences != null && this.sequences.containsKey(defaultIdentityGenerator)) {
            for (ClassDescriptor descriptor : session.getDescriptors().values()) {
                String tableName;
                String seqName;
                Sequence sequence = descriptor.getSequence();
                if (sequence == null || !defaultIdentityGenerator.equals(sequence.getName()) || (seqName = this.getIdentitySequence(tableName = descriptor.getTableName(), session)) == null) continue;
                NativeSequence newSequence = new NativeSequence(seqName, 1, true);
                newSequence.setShouldAcquireValueAfterInsert(true);
                newSequence.onConnect(this);
                descriptor.setSequence(newSequence);
                descriptor.setSequenceNumberName(seqName);
                this.identitySequences.put(tableName, seqName);
                this.addSequence(newSequence);
                if (!session.getSessionLog().shouldLog(3)) continue;
                session.getSessionLog().log(3, "platform_ora_init_id_seq", new Object[]{defaultIdentityGenerator, seqName, tableName});
            }
        }
    }

    @Override
    public void removeIdentitySequences(Session session, String defaultIdentityGenerator, Set<String> tableNames) {
        if (this.sequences != null && this.sequences.containsKey(defaultIdentityGenerator)) {
            Sequence defaultSeq = this.getSequence(defaultIdentityGenerator);
            for (ClassDescriptor descriptor : session.getDescriptors().values()) {
                String tableName = descriptor.getTableName();
                if (tableName == null || !this.identitySequences.containsKey(tableName)) continue;
                String seqName = this.identitySequences.remove(tableName);
                this.removeSequence(seqName);
                descriptor.setSequence(defaultSeq);
                descriptor.setSequenceNumberName(defaultIdentityGenerator);
                if (!session.getSessionLog().shouldLog(3)) continue;
                session.getSessionLog().log(3, "platform_ora_remove_id_seq", new Object[]{seqName, defaultIdentityGenerator, tableName});
            }
        }
    }

    private String getIdentitySequence(String tableName, Session session) {
        String sql = "SELECT SEQUENCE_NAME FROM USER_TAB_IDENTITY_COLS WHERE TABLE_NAME='" + tableName.toUpperCase() + "'";
        return (String)new ValueReadQuery(sql).execute((AbstractSession)session, EmptyRecord.getEmptyRecord());
    }

    @Override
    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" GENERATED AS IDENTITY");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public Struct createStruct(String structTypeName, Object[] attributes, AbstractRecord row, Vector orderedFields, AbstractSession session, Connection connection) throws SQLException {
        for (int index = 0; index < orderedFields.size(); ++index) {
            DatabaseField field = (DatabaseField)orderedFields.elementAt(index);
            if (row.getField(field) != null && row.getField(field).getTypeName() != null) {
                if (ClassConstants.BLOB.getTypeName().equals(row.getField(field).getTypeName())) {
                    Blob blob = connection.createBlob();
                    blob.setBytes(1L, (byte[])row.get(field));
                    attributes[index] = blob;
                    continue;
                }
                if (!ClassConstants.CLOB.getTypeName().equals(row.getField(field).getTypeName())) continue;
                Clob clob = connection.createClob();
                clob.setString(1L, (String)attributes[index]);
                attributes[index] = clob;
                continue;
            }
            attributes[index] = row.get(field);
        }
        return this.createStruct(structTypeName, attributes, connection);
    }

    @Override
    public Struct createStruct(String structTypeName, Object[] attributes, Connection connection) throws SQLException {
        return connection.createStruct(structTypeName, attributes);
    }
}

