/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util.metadatasources;

import jakarta.xml.bind.JAXBElement;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.eis.mappings.EISCompositeCollectionMapping;
import org.eclipse.persistence.eis.mappings.EISCompositeDirectCollectionMapping;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeAccessor;
import org.eclipse.persistence.internal.jpa.rs.weaving.RestAdapterClassWriter;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.metadata.MetadataSource;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.ObjectFactory;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessMethods;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethods;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;

public class DynamicXMLMetadataSource
implements MetadataSource {
    private XmlBindings xmlBindings;

    public DynamicXMLMetadataSource(AbstractSession session, String packageName) {
        ObjectFactory objectFactory = new ObjectFactory();
        this.xmlBindings = new XmlBindings();
        this.xmlBindings.setPackageName(packageName);
        XmlBindings.JavaTypes javaTypes = new XmlBindings.JavaTypes();
        this.xmlBindings.setJavaTypes(javaTypes);
        for (ClassDescriptor ormDescriptor : session.getProject().getOrderedDescriptors()) {
            String descriptorPackageName = "";
            if (ormDescriptor.getJavaClassName().lastIndexOf(46) > 0) {
                descriptorPackageName = ormDescriptor.getJavaClassName().substring(0, ormDescriptor.getJavaClassName().lastIndexOf(46));
            }
            if (!descriptorPackageName.equals(packageName)) continue;
            javaTypes.getJavaType().add(this.createJAXBType(ormDescriptor, objectFactory));
        }
    }

    private JavaType createJAXBType(ClassDescriptor classDescriptor, ObjectFactory objectFactory) {
        JavaType javaType = new JavaType();
        String alias = classDescriptor.getAlias();
        if (alias == null || alias.isEmpty()) {
            alias = classDescriptor.getJavaClass().getSimpleName();
        }
        javaType.setName(alias);
        javaType.setJavaAttributes(new JavaType.JavaAttributes());
        boolean isDynamic = DynamicEntity.class.isAssignableFrom(classDescriptor.getJavaClass());
        for (DatabaseMapping ormMapping : classDescriptor.getMappings()) {
            JAXBElement<XmlElement> element = this.createJAXBProperty(ormMapping, objectFactory, javaType, isDynamic);
            if (element == null) continue;
            javaType.getJavaAttributes().getJavaAttribute().add(element);
        }
        if (classDescriptor.isAggregateDescriptor()) {
            return javaType;
        }
        String name = RestAdapterClassWriter.constructClassNameForReferenceAdapter(classDescriptor.getJavaClassName());
        XmlJavaTypeAdapter adapter = new XmlJavaTypeAdapter();
        adapter.setValue(name);
        adapter.setValueType(classDescriptor.getJavaClassName());
        adapter.setType(classDescriptor.getJavaClassName());
        javaType.setXmlJavaTypeAdapter(adapter);
        return javaType;
    }

    private JAXBElement<XmlElement> createJAXBProperty(DatabaseMapping mapping, ObjectFactory objectFactory, JavaType owningType, boolean isDynamic) {
        if (!mapping.getAttributeAccessor().isVirtualAttributeAccessor() && !isDynamic) {
            return null;
        }
        XmlElement xmlElement = new XmlElement();
        xmlElement.setJavaAttribute(mapping.getAttributeName());
        if (mapping.isObjectReferenceMapping()) {
            xmlElement.setType(((ObjectReferenceMapping)mapping).getReferenceClassName());
        } else if (mapping.isCollectionMapping()) {
            if (mapping.isEISMapping()) {
                if (mapping instanceof EISCompositeDirectCollectionMapping) {
                    xmlElement.setContainerType(mapping.getContainerPolicy().getContainerClassName());
                } else if (mapping instanceof EISCompositeCollectionMapping) {
                    xmlElement.setContainerType(mapping.getContainerPolicy().getContainerClassName());
                    xmlElement.setType(((EISCompositeCollectionMapping)mapping).getReferenceClassName());
                }
            } else {
                xmlElement.setType(((CollectionMapping)mapping).getReferenceClassName());
                xmlElement.setContainerType(mapping.getContainerPolicy().getContainerClassName());
            }
        } else {
            xmlElement.setType(mapping.getAttributeClassification().getName());
        }
        if (mapping.getAttributeAccessor().isVirtualAttributeAccessor()) {
            VirtualAttributeAccessor jpaAccessor = (VirtualAttributeAccessor)mapping.getAttributeAccessor();
            if (owningType.getXmlVirtualAccessMethods() == null) {
                XmlVirtualAccessMethods virtualAccessMethods = new XmlVirtualAccessMethods();
                virtualAccessMethods.setGetMethod(jpaAccessor.getGetMethodName());
                virtualAccessMethods.setSetMethod(jpaAccessor.getSetMethodName());
                owningType.setXmlVirtualAccessMethods(virtualAccessMethods);
            } else if (!owningType.getXmlVirtualAccessMethods().getGetMethod().equals(jpaAccessor.getGetMethodName())) {
                XmlAccessMethods accessMethods = new XmlAccessMethods();
                accessMethods.setGetMethod(jpaAccessor.getGetMethodName());
                accessMethods.setSetMethod(jpaAccessor.getSetMethodName());
                xmlElement.setXmlAccessMethods(accessMethods);
            }
        }
        return objectFactory.createXmlElement(xmlElement);
    }

    @Override
    public XmlBindings getXmlBindings(Map<String, ?> properties, ClassLoader classLoader) {
        return this.xmlBindings;
    }
}

