/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.ConcurrencyUtil;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.type.CacheKeyToThreadRelationships;
import org.eclipse.persistence.internal.helper.type.ConcurrencyManagerState;
import org.eclipse.persistence.internal.helper.type.DeadLockComponent;
import org.eclipse.persistence.internal.helper.type.IsBuildObjectCompleteOutcome;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class ExplainDeadLockUtil {
    public static final ExplainDeadLockUtil SINGLETON = new ExplainDeadLockUtil();
    private static final DeadLockComponent DEAD_LOCK_NOT_FOUND = null;

    private ExplainDeadLockUtil() {
    }

    public List<DeadLockComponent> explainPossibleDeadLockStartRecursion(ConcurrencyManagerState concurrencyManagerState) {
        Thread currentCandidateThreadPartOfTheDeadLock;
        int maxNumberOfDifferentThreadsThatWillJustifyADeadLock = 5;
        int recursionMaxDepth = 6;
        boolean initialRecursionDepth = true;
        HashSet<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain = new HashSet<Thread>();
        HashSet<Thread> allCandidateThreadsToExpand = new HashSet<Thread>();
        allCandidateThreadsToExpand.addAll(concurrencyManagerState.getUnifiedMapOfThreadsStuckTryingToAcquireWriteLock().keySet());
        allCandidateThreadsToExpand.addAll(concurrencyManagerState.getSetThreadWaitingToReleaseDeferredLocksClone());
        allCandidateThreadsToExpand.addAll(concurrencyManagerState.getMapThreadToWaitOnAcquireReadLockClone().keySet());
        DeadLockComponent deadLockOutcome = null;
        Iterator iterator = allCandidateThreadsToExpand.iterator();
        while (iterator.hasNext() && (deadLockOutcome = this.recursiveExplainPossibleDeadLockStep01(concurrencyManagerState, 6, 1, currentCandidateThreadPartOfTheDeadLock = (Thread)iterator.next(), Collections.emptyList(), threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain)) == null) {
        }
        if (deadLockOutcome != null) {
            return this.createListExplainingDeadLock(deadLockOutcome);
        }
        return Collections.emptyList();
    }

    protected List<DeadLockComponent> createListExplainingDeadLock(DeadLockComponent deadLockExplanation) {
        DeadLockComponent previousElement = null;
        HashMap<Thread, DeadLockComponent> helperMap = new HashMap<Thread, DeadLockComponent>();
        ArrayList<DeadLockComponent> deadLockAsSimpleList = new ArrayList<DeadLockComponent>();
        for (DeadLockComponent currentElementToIterate = deadLockExplanation; currentElementToIterate != null; currentElementToIterate = currentElementToIterate.getNextThreadPartOfDeadLock()) {
            boolean foundDtoRepresentingRepeatingThreadInADeadLock = currentElementToIterate.isFirstRepeatingThreadThatExplainsDeadLock();
            if (foundDtoRepresentingRepeatingThreadInADeadLock) {
                Thread repatedThreadInDeadLock = currentElementToIterate.getThreadNotAbleToAccessResource();
                DeadLockComponent equivalentDtoHavingAllProperMetadata = (DeadLockComponent)helperMap.get(repatedThreadInDeadLock);
                equivalentDtoHavingAllProperMetadata.setFirstRepeatingThreadThatExplainsDeadLock(true);
                if (previousElement != null) {
                    previousElement.setNextThreadPartOfDeadLock(currentElementToIterate);
                }
                deadLockAsSimpleList.add(equivalentDtoHavingAllProperMetadata);
            } else {
                deadLockAsSimpleList.add(currentElementToIterate);
                helperMap.put(currentElementToIterate.getThreadNotAbleToAccessResource(), currentElementToIterate);
            }
            previousElement = currentElementToIterate;
        }
        return deadLockAsSimpleList;
    }

    protected DeadLockComponent recursiveExplainPossibleDeadLockStep01(ConcurrencyManagerState concurrencyManagerStateDto, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain) {
        if (threadPartOfCurrentDeadLockExpansion.contains(currentCandidateThreadPartOfTheDeadLock)) {
            return new DeadLockComponent(currentCandidateThreadPartOfTheDeadLock);
        }
        if (threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain.contains(currentCandidateThreadPartOfTheDeadLock)) {
            return DEAD_LOCK_NOT_FOUND;
        }
        if (currentRecursionDepth == 1) {
            threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain.add(currentCandidateThreadPartOfTheDeadLock);
        }
        if (currentRecursionDepth >= recursionMaxDepth) {
            return DEAD_LOCK_NOT_FOUND;
        }
        return this.recursiveExplainPossibleDeadLockStep02(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain);
    }

    protected DeadLockComponent recursiveExplainPossibleDeadLockStep02(ConcurrencyManagerState concurrencyManagerStateDto, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain) {
        DeadLockComponent currentResult;
        boolean isCurrentThreadWaitingForDeferredLocksToBeResolved;
        DeadLockComponent currentResult2;
        Set<ConcurrencyManager> writeLocksCurrentThreadWantsToGetButFailsToGet = concurrencyManagerStateDto.getUnifiedMapOfThreadsStuckTryingToAcquireWriteLock().get(currentCandidateThreadPartOfTheDeadLock);
        if (writeLocksCurrentThreadWantsToGetButFailsToGet != null && !writeLocksCurrentThreadWantsToGetButFailsToGet.isEmpty()) {
            for (ConcurrencyManager cacheKeyCurrentThreadWantsForWritingButCannotGet : writeLocksCurrentThreadWantsToGetButFailsToGet) {
                currentResult2 = this.recursiveExplainPossibleDeadLockStep03ExpandBasedOnCacheKeyWantedForWriting(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, cacheKeyCurrentThreadWantsForWritingButCannotGet);
                if (currentResult2 == null) continue;
                return currentResult2;
            }
        }
        if ((isCurrentThreadWaitingForDeferredLocksToBeResolved = concurrencyManagerStateDto.getSetThreadWaitingToReleaseDeferredLocksClone().contains(currentCandidateThreadPartOfTheDeadLock)) && (currentResult = this.recursiveExplainPossibleDeadLockStep04ExpandBasedOnThreadStuckOnReleaseDeferredLocks(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain)) != null) {
            return currentResult;
        }
        ConcurrencyManager cacheKeyCurrentThreadWantsForReadingButCannotGet = concurrencyManagerStateDto.getMapThreadToWaitOnAcquireReadLockClone().get(currentCandidateThreadPartOfTheDeadLock);
        if (cacheKeyCurrentThreadWantsForReadingButCannotGet != null && (currentResult2 = this.recursiveExplainPossibleDeadLockStep05ExpandBasedOnCacheKeyWantedForReading(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, cacheKeyCurrentThreadWantsForReadingButCannotGet)) != null) {
            return currentResult2;
        }
        return DEAD_LOCK_NOT_FOUND;
    }

    protected boolean currentThreadIsKnownToBeWaitingForAnyResource(ConcurrencyManagerState concurrencyManagerStateDto, Thread currentCandidateThreadPartOfTheDeadLock) {
        ConcurrencyManager cacheKeyCurrentThreadWantsForReadingButCannotGet;
        boolean isCurrentThreadWaitingForDeferredLocksToBeResolved;
        boolean currentThreadExpansionEnteredAnyOfTheScenarios = false;
        Set<ConcurrencyManager> writeLocksCurrentThreadWantsToGetButFailsToGet = concurrencyManagerStateDto.getUnifiedMapOfThreadsStuckTryingToAcquireWriteLock().get(currentCandidateThreadPartOfTheDeadLock);
        if (writeLocksCurrentThreadWantsToGetButFailsToGet != null && !writeLocksCurrentThreadWantsToGetButFailsToGet.isEmpty()) {
            currentThreadExpansionEnteredAnyOfTheScenarios = true;
        }
        if (isCurrentThreadWaitingForDeferredLocksToBeResolved = concurrencyManagerStateDto.getSetThreadWaitingToReleaseDeferredLocksClone().contains(currentCandidateThreadPartOfTheDeadLock)) {
            currentThreadExpansionEnteredAnyOfTheScenarios = true;
        }
        if ((cacheKeyCurrentThreadWantsForReadingButCannotGet = concurrencyManagerStateDto.getMapThreadToWaitOnAcquireReadLockClone().get(currentCandidateThreadPartOfTheDeadLock)) != null) {
            currentThreadExpansionEnteredAnyOfTheScenarios = true;
        }
        return currentThreadExpansionEnteredAnyOfTheScenarios;
    }

    protected DeadLockComponent recursiveExplainPossibleDeadLockStep03ExpandBasedOnCacheKeyWantedForWriting(ConcurrencyManagerState concurrencyManagerStateDto, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, ConcurrencyManager cacheKeyCurrentThreadWantsForWritingButCannotGet) {
        DeadLockComponent expansionResult = this.recursiveExplainPossibleDeadLockStep03Scenario01CurrentWriterVsOtherWritersWriter(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, cacheKeyCurrentThreadWantsForWritingButCannotGet);
        if (expansionResult != null) {
            return expansionResult;
        }
        expansionResult = this.recursiveExplainPossibleDeadLockStep03Scenario02CurrentWriterVsOtherReader(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, cacheKeyCurrentThreadWantsForWritingButCannotGet);
        if (expansionResult != null) {
            return expansionResult;
        }
        expansionResult = this.recursiveExplainPossibleDeadLockStep03Scenario03CurrentWriterVsCacheKeyActiveThread(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, cacheKeyCurrentThreadWantsForWritingButCannotGet);
        if (expansionResult != null) {
            return expansionResult;
        }
        return DEAD_LOCK_NOT_FOUND;
    }

    protected DeadLockComponent recursiveExplainPossibleDeadLockStep03Scenario01CurrentWriterVsOtherWritersWriter(ConcurrencyManagerState concurrencyManagerStateDto, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, ConcurrencyManager cacheKeyCurrentThreadWantsForWritingButCannotGet) {
        boolean currentThreadWantsToAcquireForWriting = true;
        return this.recursiveExpansionCurrentThreadBeingBlockedByActiveWriters(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, cacheKeyCurrentThreadWantsForWritingButCannotGet, currentThreadWantsToAcquireForWriting);
    }

    protected DeadLockComponent recursiveExplainPossibleDeadLockStep05Scenario01CurrentReaderVsOtherWriters(ConcurrencyManagerState concurrencyManagerStateDto, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, ConcurrencyManager cacheKeyCurrentThreadWantsForWritingButCannotGet) {
        boolean currentThreadWantsToAcquireForWriting = true;
        return this.recursiveExpansionCurrentThreadBeingBlockedByActiveWriters(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, cacheKeyCurrentThreadWantsForWritingButCannotGet, currentThreadWantsToAcquireForWriting);
    }

    protected DeadLockComponent recursiveExpansionCurrentThreadBeingBlockedByActiveWriters(ConcurrencyManagerState concurrencyManagerState, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, ConcurrencyManager cacheKeyThreadWantsToAcquireButCannotGet, boolean currentThreadWantsToAcquireForWriting) {
        CacheKeyToThreadRelationships cacheKeyToThreadRelationships = concurrencyManagerState.getMapOfCacheKeyToDtosExplainingThreadExpectationsOnCacheKey().get(cacheKeyThreadWantsToAcquireButCannotGet);
        List<Thread> nexThreadPartOfCurrentDeadLockExpansion = new ArrayList<Thread>(threadPartOfCurrentDeadLockExpansion);
        nexThreadPartOfCurrentDeadLockExpansion.add(currentCandidateThreadPartOfTheDeadLock);
        nexThreadPartOfCurrentDeadLockExpansion = Collections.unmodifiableList(nexThreadPartOfCurrentDeadLockExpansion);
        int nextRecursionDepth = currentRecursionDepth + 1;
        List<Thread> threadsThatHaveCurrentCacheKeyAsAnActiveLock = cacheKeyToThreadRelationships.getThreadsThatAcquiredActiveLock();
        for (Thread nextCandidateThreadPartOfTheDeadLock : threadsThatHaveCurrentCacheKeyAsAnActiveLock) {
            DeadLockComponent expansionResult;
            boolean isDifferentThread = !nextCandidateThreadPartOfTheDeadLock.equals(currentCandidateThreadPartOfTheDeadLock);
            if (!isDifferentThread || (expansionResult = this.recursiveExplainPossibleDeadLockStep01(concurrencyManagerState, recursionMaxDepth, nextRecursionDepth, nextCandidateThreadPartOfTheDeadLock, nexThreadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain)) == null) continue;
            if (currentThreadWantsToAcquireForWriting) {
                return this.deadLockFoundCreateConcurrencyManagerStateWriterThreadCouldNotAcquireWriteLock(expansionResult, currentCandidateThreadPartOfTheDeadLock, cacheKeyThreadWantsToAcquireButCannotGet);
            }
            return this.deadLockFoundCreateConcurrencyManagerStateReaderThreadCouldNotAcquireWriteLock(expansionResult, currentCandidateThreadPartOfTheDeadLock, cacheKeyThreadWantsToAcquireButCannotGet);
        }
        return DEAD_LOCK_NOT_FOUND;
    }

    protected DeadLockComponent recursiveExplainPossibleDeadLockStep03Scenario02CurrentWriterVsOtherReader(ConcurrencyManagerState concurrencyManagerState, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, ConcurrencyManager cacheKeyCurrentThreadWantsForWritingButCannotGet) {
        CacheKeyToThreadRelationships cacheKeyToThreadRelationships = concurrencyManagerState.getMapOfCacheKeyToDtosExplainingThreadExpectationsOnCacheKey().get(cacheKeyCurrentThreadWantsForWritingButCannotGet);
        List<Thread> nexThreadPartOfCurrentDeadLockExpansion = new ArrayList<Thread>(threadPartOfCurrentDeadLockExpansion);
        nexThreadPartOfCurrentDeadLockExpansion.add(currentCandidateThreadPartOfTheDeadLock);
        nexThreadPartOfCurrentDeadLockExpansion = Collections.unmodifiableList(nexThreadPartOfCurrentDeadLockExpansion);
        int nextRecursionDepth = currentRecursionDepth + 1;
        List<Thread> threadsThatHaveCurrentCacheKeyAsAReadLockLock = cacheKeyToThreadRelationships.getThreadsThatAcquiredReadLock();
        for (Thread nextCandidateThreadPartOfTheDeadLock : threadsThatHaveCurrentCacheKeyAsAReadLockLock) {
            DeadLockComponent expansionResult;
            boolean isDifferentThread = !nextCandidateThreadPartOfTheDeadLock.equals(currentCandidateThreadPartOfTheDeadLock);
            if (!isDifferentThread || (expansionResult = this.recursiveExplainPossibleDeadLockStep01(concurrencyManagerState, recursionMaxDepth, nextRecursionDepth, nextCandidateThreadPartOfTheDeadLock, nexThreadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain)) == null) continue;
            return this.deadLockFoundCreateConcurrencyManagerStateWriterThreadCouldNotAcquireWriteLock(expansionResult, currentCandidateThreadPartOfTheDeadLock, cacheKeyCurrentThreadWantsForWritingButCannotGet);
        }
        return DEAD_LOCK_NOT_FOUND;
    }

    protected DeadLockComponent recursiveExplainPossibleDeadLockStep03Scenario03CurrentWriterVsCacheKeyActiveThread(ConcurrencyManagerState concurrencyManagerStateDto, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, ConcurrencyManager cacheKeyCurrentThreadWantsForWritingButCannotGet) {
        boolean currentThreadWantsToAcquireForWriting = true;
        return this.recursiveExpansionCurrentThreadBeingBlockedByActiveThreadOnCacheKey(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, cacheKeyCurrentThreadWantsForWritingButCannotGet, currentThreadWantsToAcquireForWriting);
    }

    protected DeadLockComponent recursiveExplainPossibleDeadLockStep05Scenario02CurrentReaderVsCacheKeyActiveThread(ConcurrencyManagerState concurrencyManagerStateDto, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, ConcurrencyManager cacheKeyCurrentThreadWantsForWritingButCannotGet) {
        boolean currentThreadWantsToAcquireForWriting = false;
        return this.recursiveExpansionCurrentThreadBeingBlockedByActiveThreadOnCacheKey(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, cacheKeyCurrentThreadWantsForWritingButCannotGet, currentThreadWantsToAcquireForWriting);
    }

    protected DeadLockComponent recursiveExpansionCurrentThreadBeingBlockedByActiveThreadOnCacheKey(ConcurrencyManagerState concurrencyManagerState, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, ConcurrencyManager cacheKeyThreadWantsToAcquireButCannotGet, boolean currentThreadWantsToAcquireForWriting) {
        boolean cacheKeyHasActiveThreadWeDidNotAnalyze;
        CacheKeyToThreadRelationships cacheKeyToThreadRelationships = concurrencyManagerState.getMapOfCacheKeyToDtosExplainingThreadExpectationsOnCacheKey().get(cacheKeyThreadWantsToAcquireButCannotGet);
        List<Thread> nexThreadPartOfCurrentDeadLockExpansion = new ArrayList<Thread>(threadPartOfCurrentDeadLockExpansion);
        nexThreadPartOfCurrentDeadLockExpansion.add(currentCandidateThreadPartOfTheDeadLock);
        nexThreadPartOfCurrentDeadLockExpansion = Collections.unmodifiableList(nexThreadPartOfCurrentDeadLockExpansion);
        int nextRecursionDepth = currentRecursionDepth + 1;
        List<Thread> threadsThatHaveCurrentCacheKeyAsAnActiveLock = cacheKeyToThreadRelationships.getThreadsThatAcquiredActiveLock();
        List<Thread> threadsThatHaveCurrentCacheKeyAsAReadLockLock = cacheKeyToThreadRelationships.getThreadsThatAcquiredReadLock();
        Thread activeThreadOnCacheKey = cacheKeyThreadWantsToAcquireButCannotGet.getActiveThread();
        boolean bl = cacheKeyHasActiveThreadWeDidNotAnalyze = activeThreadOnCacheKey != null && !activeThreadOnCacheKey.equals(currentCandidateThreadPartOfTheDeadLock) && !threadsThatHaveCurrentCacheKeyAsAnActiveLock.contains(activeThreadOnCacheKey) && !threadsThatHaveCurrentCacheKeyAsAReadLockLock.contains(activeThreadOnCacheKey);
        if (cacheKeyHasActiveThreadWeDidNotAnalyze) {
            Thread nextCandidateThreadPartOfTheDeadLock = activeThreadOnCacheKey;
            boolean sanityCheckToDoKnowOfAnyResourcesNeededByNextThreadToExpand = this.currentThreadIsKnownToBeWaitingForAnyResource(concurrencyManagerState, nextCandidateThreadPartOfTheDeadLock);
            if (!sanityCheckToDoKnowOfAnyResourcesNeededByNextThreadToExpand) {
                AbstractSessionLog.getLog().log(6, "cache", "explain_dead_lock_util_current_thread_blocked_active_thread_warning", new Object[]{nextCandidateThreadPartOfTheDeadLock.getName(), currentCandidateThreadPartOfTheDeadLock.getName(), ConcurrencyUtil.SINGLETON.createToStringExplainingOwnedCacheKey(cacheKeyThreadWantsToAcquireButCannotGet)});
                return DEAD_LOCK_NOT_FOUND;
            }
            DeadLockComponent expansionResult = this.recursiveExplainPossibleDeadLockStep01(concurrencyManagerState, recursionMaxDepth, nextRecursionDepth, nextCandidateThreadPartOfTheDeadLock, nexThreadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain);
            if (expansionResult != null) {
                if (currentThreadWantsToAcquireForWriting) {
                    return this.deadLockFoundCreateConcurrencyManagerStateWriterThreadCouldNotAcquireWriteLock(expansionResult, currentCandidateThreadPartOfTheDeadLock, cacheKeyThreadWantsToAcquireButCannotGet);
                }
                return this.deadLockFoundCreateConcurrencyManagerStateReaderThreadCouldNotAcquireWriteLock(expansionResult, currentCandidateThreadPartOfTheDeadLock, cacheKeyThreadWantsToAcquireButCannotGet);
            }
        }
        return DEAD_LOCK_NOT_FOUND;
    }

    protected DeadLockComponent recursiveExplainPossibleDeadLockStep04ExpandBasedOnThreadStuckOnReleaseDeferredLocks(ConcurrencyManagerState concurrencyManagerStateDto, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain) {
        IsBuildObjectCompleteOutcome result = ExplainDeadLockUtil.isBuildObjectOnThreadComplete(concurrencyManagerStateDto, currentCandidateThreadPartOfTheDeadLock, new IdentityHashMap());
        if (result == null) {
            AbstractSessionLog.getLog().log(6, "cache", "explain_dead_lock_util_thread_stuck_deferred_locks", new Object[]{currentCandidateThreadPartOfTheDeadLock.getName()});
            return DEAD_LOCK_NOT_FOUND;
        }
        List<Thread> nexThreadPartOfCurrentDeadLockExpansion = new ArrayList<Thread>(threadPartOfCurrentDeadLockExpansion);
        nexThreadPartOfCurrentDeadLockExpansion.add(currentCandidateThreadPartOfTheDeadLock);
        nexThreadPartOfCurrentDeadLockExpansion = Collections.unmodifiableList(nexThreadPartOfCurrentDeadLockExpansion);
        int nextRecursionDepth = currentRecursionDepth + 1;
        Thread nextCandidateThreadPartOfTheDeadLock = result.getThreadBlockingTheDeferringThreadFromFinishing();
        ConcurrencyManager cacheKeyBlockingIsBuildObjectComplete = result.getCacheKeyOwnedByBlockingThread();
        DeadLockComponent expansionResult = this.recursiveExplainPossibleDeadLockStep01(concurrencyManagerStateDto, recursionMaxDepth, nextRecursionDepth, nextCandidateThreadPartOfTheDeadLock, nexThreadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain);
        if (expansionResult != null) {
            return this.deadLockFoundCreateConcurrencyManagerStateDeferredThreadCouldNotAcquireWriteLock(expansionResult, currentCandidateThreadPartOfTheDeadLock, cacheKeyBlockingIsBuildObjectComplete);
        }
        return DEAD_LOCK_NOT_FOUND;
    }

    protected DeadLockComponent recursiveExplainPossibleDeadLockStep05ExpandBasedOnCacheKeyWantedForReading(ConcurrencyManagerState concurrencyManagerStateDto, int recursionMaxDepth, int currentRecursionDepth, Thread currentCandidateThreadPartOfTheDeadLock, List<Thread> threadPartOfCurrentDeadLockExpansion, Set<Thread> threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, ConcurrencyManager cacheKeyCurrentThreadWantsForReadingButCannotGet) {
        DeadLockComponent expansionResult = this.recursiveExplainPossibleDeadLockStep05Scenario01CurrentReaderVsOtherWriters(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, cacheKeyCurrentThreadWantsForReadingButCannotGet);
        if (expansionResult != null) {
            return expansionResult;
        }
        expansionResult = this.recursiveExplainPossibleDeadLockStep05Scenario02CurrentReaderVsCacheKeyActiveThread(concurrencyManagerStateDto, recursionMaxDepth, currentRecursionDepth, currentCandidateThreadPartOfTheDeadLock, threadPartOfCurrentDeadLockExpansion, threadsAlreadyExpandedInThePastThatWeDoNotWantToExpandAgain, cacheKeyCurrentThreadWantsForReadingButCannotGet);
        if (expansionResult != null) {
            return expansionResult;
        }
        return DEAD_LOCK_NOT_FOUND;
    }

    public static IsBuildObjectCompleteOutcome isBuildObjectOnThreadComplete(ConcurrencyManagerState concurrencyManagerStateDto, Thread thread, Map recursiveSet) {
        if (recursiveSet.containsKey(thread)) {
            return IsBuildObjectCompleteOutcome.BUILD_OBJECT_IS_COMPLETE_TRUE;
        }
        recursiveSet.put(thread, thread);
        DeferredLockManager lockManager = concurrencyManagerStateDto.getDeferredLockManagerMapClone().get(thread);
        if (lockManager == null) {
            return IsBuildObjectCompleteOutcome.BUILD_OBJECT_IS_COMPLETE_TRUE;
        }
        Vector deferredLocks = lockManager.getDeferredLocks();
        Enumeration deferredLocksEnum = deferredLocks.elements();
        while (deferredLocksEnum.hasMoreElements()) {
            ConcurrencyManager deferedLock = (ConcurrencyManager)deferredLocksEnum.nextElement();
            Thread activeThread = null;
            if (!deferedLock.isAcquired() || (activeThread = deferedLock.getActiveThread()) == null) continue;
            DeferredLockManager currentLockManager = concurrencyManagerStateDto.getDeferredLockManagerMapClone().get(thread);
            if (currentLockManager == null) {
                return new IsBuildObjectCompleteOutcome(activeThread, deferedLock);
            }
            if (currentLockManager.isThreadComplete()) {
                IsBuildObjectCompleteOutcome recursiveOutcome;
                activeThread = deferedLock.getActiveThread();
                if (activeThread == null || (recursiveOutcome = ExplainDeadLockUtil.isBuildObjectOnThreadComplete(concurrencyManagerStateDto, activeThread, recursiveSet)) == null) continue;
                return new IsBuildObjectCompleteOutcome(activeThread, deferedLock);
            }
            return new IsBuildObjectCompleteOutcome(activeThread, deferedLock);
        }
        return IsBuildObjectCompleteOutcome.BUILD_OBJECT_IS_COMPLETE_TRUE;
    }

    protected DeadLockComponent deadLockFoundCreateConcurrencyManagerStateWriterThreadCouldNotAcquireWriteLock(DeadLockComponent nextThreadPartOfDeadLock, Thread threadNotAbleToAccessResource, ConcurrencyManager cacheKeyThreadWantsToAcquireButCannotGet) {
        boolean stuckOnReleaseDeferredLock = false;
        boolean stuckThreadAcquiringLockForWriting = true;
        boolean stuckThreadAcquiringLockForReading = false;
        boolean deadLockPotentiallyCausedByCacheKeyWithCorruptedActiveThread = false;
        boolean deadLockPotentiallyCausedByCacheKeyWithCorruptedNumberOfReaders = false;
        return new DeadLockComponent(threadNotAbleToAccessResource, stuckOnReleaseDeferredLock, stuckThreadAcquiringLockForWriting, stuckThreadAcquiringLockForReading, cacheKeyThreadWantsToAcquireButCannotGet, deadLockPotentiallyCausedByCacheKeyWithCorruptedActiveThread, deadLockPotentiallyCausedByCacheKeyWithCorruptedNumberOfReaders, nextThreadPartOfDeadLock);
    }

    protected DeadLockComponent deadLockFoundCreateConcurrencyManagerStateReaderThreadCouldNotAcquireWriteLock(DeadLockComponent nextThreadPartOfDeadLock, Thread threadNotAbleToAccessResource, ConcurrencyManager cacheKeyThreadWantsToAcquireButCannotGet) {
        boolean stuckOnReleaseDeferredLock = false;
        boolean stuckThreadAcquiringLockForWriting = false;
        boolean stuckThreadAcquiringLockForReading = true;
        boolean deadLockPotentiallyCausedByCacheKeyWithCorruptedActiveThread = false;
        boolean deadLockPotentiallyCausedByCacheKeyWithCorruptedNumberOfReaders = false;
        return new DeadLockComponent(threadNotAbleToAccessResource, stuckOnReleaseDeferredLock, stuckThreadAcquiringLockForWriting, stuckThreadAcquiringLockForReading, cacheKeyThreadWantsToAcquireButCannotGet, deadLockPotentiallyCausedByCacheKeyWithCorruptedActiveThread, deadLockPotentiallyCausedByCacheKeyWithCorruptedNumberOfReaders, nextThreadPartOfDeadLock);
    }

    protected DeadLockComponent deadLockFoundCreateConcurrencyManagerStateDeferredThreadCouldNotAcquireWriteLock(DeadLockComponent nextThreadPartOfDeadLock, Thread threadNotAbleToAccessResource, ConcurrencyManager cacheKeyBlockingIsBuildObjectComplete) {
        boolean stuckOnReleaseDeferredLock = true;
        boolean stuckThreadAcquiringLockForWriting = false;
        boolean stuckThreadAcquiringLockForReading = false;
        boolean deadLockPotentiallyCausedByCacheKeyWithCorruptedActiveThread = false;
        boolean deadLockPotentiallyCausedByCacheKeyWithCorruptedNumberOfReaders = false;
        return new DeadLockComponent(threadNotAbleToAccessResource, stuckOnReleaseDeferredLock, stuckThreadAcquiringLockForWriting, stuckThreadAcquiringLockForReading, cacheKeyBlockingIsBuildObjectComplete, deadLockPotentiallyCausedByCacheKeyWithCorruptedActiveThread, deadLockPotentiallyCausedByCacheKeyWithCorruptedNumberOfReaders, nextThreadPartOfDeadLock);
    }
}

