/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBHelperContext;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBValueStore;

public class JAXBList
implements List {
    private JAXBValueStore jaxbValueStore;
    private SDOProperty property;
    private CoreContainerPolicy containerPolicy;
    private AbstractSession session;

    public JAXBList(JAXBValueStore aJAXBValueStore, SDOProperty aProperty) {
        this.jaxbValueStore = aJAXBValueStore;
        this.property = aProperty;
        JAXBContext jaxbContext = (JAXBContext)this.jaxbValueStore.getJAXBHelperContext().getJAXBContext();
        this.session = jaxbContext.getXMLContext().getSession(aJAXBValueStore.getEntity().getClass());
        Mapping mapping = aJAXBValueStore.getJAXBMappingForProperty(this.property);
        this.containerPolicy = mapping.getContainerPolicy();
    }

    void setValueStore(JAXBValueStore aJAXBValueStore) {
        this.jaxbValueStore = aJAXBValueStore;
    }

    public void add(int index, Object element) {
        Object container = this.getContainer();
        if (container instanceof List) {
            List list = (List)container;
            if (!this.property.getType().isDataType()) {
                JAXBHelperContext jaxbHelperContext = this.jaxbValueStore.getJAXBHelperContext();
                Object unwrappedElement = jaxbHelperContext.unwrap((DataObject)element);
                jaxbHelperContext.putWrapperDataObject(unwrappedElement, (SDODataObject)element);
                list.add(index, unwrappedElement);
            } else {
                list.add(index, element);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean add(Object e) {
        if (!this.property.getType().isDataType()) {
            e = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)e);
        }
        return this.containerPolicy.addInto(e, this.getContainer(), this.session);
    }

    @Override
    public boolean addAll(Collection c) {
        boolean modified = false;
        for (Object o : c) {
            modified = this.add(o) || modified;
        }
        return modified;
    }

    public boolean addAll(int index, Collection c) {
        Object container = this.getContainer();
        if (container instanceof List) {
            List list = (List)container;
            if (!this.property.getType().isDataType()) {
                c = this.jaxbValueStore.getJAXBHelperContext().unwrap((Collection<DataObject>)c);
            }
            return list.addAll(index, c);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.containerPolicy.clear(this.getContainer());
    }

    @Override
    public boolean contains(Object o) {
        if (!this.property.getType().isDataType()) {
            o = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)o);
        }
        return this.containerPolicy.contains(o, this.getContainer(), this.session);
    }

    @Override
    public boolean containsAll(Collection collection) {
        for (Object o : collection) {
            if (!this.property.getType().isDataType()) {
                o = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)o);
            }
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getList().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.containerPolicy.isEmpty(this.getContainer());
    }

    @Override
    public Iterator iterator() {
        return this.getList().iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getList().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.getList().listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.getList().listIterator(index);
    }

    public Object remove(int index) {
        Object container = this.getContainer();
        if (container instanceof List) {
            List list = (List)container;
            return list.remove(index);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        if (!this.property.getType().isDataType()) {
            o = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)o);
        }
        return this.containerPolicy.removeFrom(o, this.getContainer(), this.session);
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean modified = false;
        for (Object o : c) {
            modified = this.remove(o) || modified;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.containerPolicy.sizeFor(this.getContainer());
    }

    public List subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.getList().toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.getList().toArray(a);
    }

    private Object getContainer() {
        Mapping mapping = this.jaxbValueStore.getJAXBMappingForProperty(this.property);
        Object container = mapping.getAttributeValueFromObject(this.jaxbValueStore.getEntity());
        if (null == container) {
            container = this.containerPolicy.containerInstance();
            mapping.setAttributeValueInObject(this.jaxbValueStore.getEntity(), container);
        }
        return container;
    }

    private List getList() {
        List list = this.containerPolicy.isListPolicy() ? (List)this.getContainer() : this.containerPolicy.vectorFor(this.getContainer(), this.session);
        if (this.property.getType().isDataType()) {
            return list;
        }
        if (this.property.isContainment()) {
            return this.jaxbValueStore.getJAXBHelperContext().wrap(list, (Property)this.property, (DataObject)this.jaxbValueStore.getDataObject());
        }
        return this.jaxbValueStore.getJAXBHelperContext().wrap(list);
    }
}

