/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sdo.SDOConstants;

public class DataObjectInputStream
extends ObjectInputStream {
    private HelperContext aHelperContext;

    public DataObjectInputStream() throws IOException {
        this.aHelperContext = HelperProvider.getDefaultContext();
    }

    public DataObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.aHelperContext = HelperProvider.getDefaultContext();
    }

    public DataObjectInputStream(InputStream in, HelperContext aContext) throws IOException {
        super(in);
        this.aHelperContext = aContext;
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (!SDOConstants.ALLOWED_DESERIALIZATION_CLASS_NAMES.contains(desc.getName())) {
            AbstractSessionLog.getLog().log(7, "sdo_error_deserialization", new Object[]{desc.getName()});
            throw new InvalidClassException(LoggingLocalization.buildMessage("sdo_error_deserialization", new Object[]{desc.getName()}));
        }
        return super.resolveClass(desc);
    }
}

