/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.helper.CoreConversionManager;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLMarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class JsonRecord<T extends Level>
extends MarshalRecord<XMLMarshaller> {
    protected T position;
    protected CharacterEscapeHandler characterEscapeHandler;
    protected String attributePrefix;
    protected boolean isRootArray;
    protected static final String NULL = "null";
    protected boolean isLastEventStart;

    @Override
    public void setMarshaller(XMLMarshaller marshaller) {
        super.setMarshaller(marshaller);
        this.attributePrefix = marshaller.getAttributePrefix();
        if (marshaller.getValueWrapper() != null) {
            this.textWrapperFragment = new XPathFragment();
            this.textWrapperFragment.setLocalName(marshaller.getValueWrapper());
        }
        this.characterEscapeHandler = marshaller.getCharacterEscapeHandler();
    }

    @Override
    public void forceValueWrapper() {
        this.setComplex(this.position, true);
        this.isLastEventStart = false;
    }

    @Override
    public void startDocument(String encoding, String version) {
        if (this.isRootArray) {
            if (this.position == null) {
                this.startCollection();
            }
            ((Level)this.position).setEmptyCollection(false);
            this.position = this.createNewLevel(false, this.position, false);
            this.isLastEventStart = true;
        } else {
            this.startRootObject();
        }
    }

    protected T createNewLevel(boolean collection, T parentLevel, boolean nestedArray) {
        return (T)new Level(collection, (Level)this.position, nestedArray);
    }

    protected void startRootObject() {
        this.position = this.createNewLevel(false, null, false);
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        String keyName1 = this.getKeyName(xPathFragment);
        if (this.position != null && ((Level)this.position).isCollection && xPathFragment.getXMLField() != null && xPathFragment.getXMLField().isNestedArray() && ((XMLMarshaller)this.marshaller).getJsonTypeConfiguration().isJsonDisableNestedArrayName()) {
            ((Level)this.position).addSkip();
            ((Level)this.position).setKeyName(keyName1);
            if (!((Level)this.position).isEmptyCollectionGenerated()) {
                this.startEmptyCollection();
                ((Level)this.position).setEmptyCollectionGenerated(true);
            }
            return;
        }
        if (this.position != null) {
            String keyName;
            T newLevel = xPathFragment.getXMLField() != null && xPathFragment.getXMLField().isNestedArray() && ((XMLMarshaller)this.marshaller).getJsonTypeConfiguration().isJsonDisableNestedArrayName() ? this.createNewLevel(false, this.position, true) : this.createNewLevel(false, this.position, false);
            if (this.isLastEventStart) {
                this.setComplex(this.position, true);
            }
            if ((keyName = this.getKeyName(xPathFragment)) != null && !keyName.equals("")) {
                if (((Level)this.position).isCollection && ((Level)this.position).isEmptyCollection()) {
                    ((Level)this.position).setKeyName(keyName);
                    this.startEmptyCollection();
                } else {
                    ((Level)newLevel).setKeyName(keyName);
                }
            }
            if (!((Level)newLevel).isNestedArray() || !((Level)newLevel).isComplex()) {
                this.position = newLevel;
            }
            this.isLastEventStart = true;
        }
    }

    protected void startEmptyCollection() {
    }

    @Override
    public boolean emptyCollection(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, boolean openGrouping) {
        if (((XMLMarshaller)this.marshaller).isMarshalEmptyCollections()) {
            super.emptyCollection(xPathFragment, namespaceResolver, true);
            if (xPathFragment != null) {
                if (xPathFragment.isSelfFragment() || xPathFragment.nameIsText()) {
                    String keyName = ((Level)this.position).getKeyName();
                    this.setComplex(this.position, false);
                    this.writeEmptyCollection(((Level)this.position).parentLevel, keyName);
                } else {
                    String keyName;
                    if (this.isLastEventStart) {
                        this.setComplex(this.position, true);
                    }
                    if ((keyName = this.getKeyName(xPathFragment)) != null) {
                        this.writeEmptyCollection(this.position, keyName);
                    }
                }
                this.isLastEventStart = false;
            }
            return true;
        }
        return super.emptyCollection(xPathFragment, namespaceResolver, openGrouping);
    }

    protected abstract void writeEmptyCollection(T var1, String var2);

    @Override
    public void endDocument() {
        if (this.position != null) {
            this.finishLevel();
        }
    }

    protected void finishLevel() {
        boolean notSkip;
        boolean bl = notSkip = ((Level)this.position).parentLevel == null || ((Level)this.position).parentLevel.notSkip();
        if (notSkip) {
            this.position = ((Level)this.position).parentLevel;
        }
    }

    @Override
    public void startCollection() {
        if (this.position == null) {
            this.isRootArray = true;
            this.position = this.createNewLevel(true, null, false);
            this.startRootLevelCollection();
        } else {
            if (this.isLastEventStart) {
                this.setComplex(this.position, true);
            }
            this.position = this.createNewLevel(true, this.position, ((Level)this.position).isNestedArray());
        }
        this.isLastEventStart = false;
    }

    protected void setComplex(T level, boolean complex) {
        ((Level)level).setComplex(complex);
    }

    protected abstract void startRootLevelCollection();

    protected String getKeyName(XPathFragment xPathFragment) {
        String keyName = xPathFragment.getLocalName();
        if (this.isNamespaceAware() && xPathFragment.getNamespaceURI() != null) {
            String prefix = null;
            if (this.getNamespaceResolver() != null) {
                prefix = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(xPathFragment.getNamespaceURI());
            } else if (this.namespaceResolver != null) {
                prefix = this.namespaceResolver.resolveNamespaceURI(xPathFragment.getNamespaceURI());
            }
            if (prefix != null && !prefix.equals("")) {
                keyName = String.valueOf(prefix) + this.getNamespaceSeparator() + keyName;
            }
        }
        if (xPathFragment.isAttribute() && this.attributePrefix != null) {
            keyName = String.valueOf(this.attributePrefix) + keyName;
        }
        return keyName;
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, Object value, QName schemaType) {
        if (xPathFragment.getNamespaceURI() != null && xPathFragment.getNamespaceURI() == "http://www.w3.org/2000/xmlns/") {
            return;
        }
        xPathFragment.setAttribute(true);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.characters(schemaType, value, null, false, true);
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void marshalWithoutRootElement(ObjectBuilder treeObjectBuilder, Object object, Descriptor descriptor, Root root, boolean isXMLRoot) {
        if (treeObjectBuilder != null) {
            this.addXsiTypeAndClassIndicatorIfRequired(descriptor, null, descriptor.getDefaultRootElementField(), root, object, isXMLRoot, true);
            treeObjectBuilder.marshalAttributes(this, object, this.session);
        }
    }

    @Override
    public char getNamespaceSeparator() {
        return ((XMLMarshaller)this.marshaller).getNamespaceSeparator();
    }

    @Override
    public XPathFragment getTextWrapperFragment() {
        return this.textWrapperFragment;
    }

    @Override
    public boolean isWrapperAsCollectionName() {
        return ((XMLMarshaller)this.marshaller).isWrapperAsCollectionName();
    }

    @Override
    public void element(XPathFragment frag) {
        this.isLastEventStart = false;
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        this.attribute(xPathFragment, namespaceResolver, (Object)value, (QName)null);
    }

    @Override
    public void attribute(String namespaceURI, String localName, String qName, String value) {
        XPathFragment xPathFragment = new XPathFragment();
        xPathFragment.setNamespaceURI(namespaceURI);
        xPathFragment.setAttribute(true);
        xPathFragment.setLocalName(localName);
        this.openStartElement(xPathFragment, this.namespaceResolver);
        this.characters(null, value, null, false, true);
        this.endElement(xPathFragment, this.namespaceResolver);
    }

    @Override
    public void closeStartElement() {
    }

    @Override
    public void characters(String value) {
        this.writeValue(value, null, false);
    }

    @Override
    public void characters(QName schemaType, Object value, String mimeType, boolean isCDATA) {
        this.characters(schemaType, value, mimeType, isCDATA, false);
    }

    public void characters(QName schemaType, Object value, String mimeType, boolean isCDATA, boolean isAttribute) {
        if (mimeType != null) {
            value = value instanceof List ? XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesListForBinaryValues((List)value, this.marshaller, mimeType) : (Object)XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(value, this.marshaller, mimeType).getData();
        }
        if (schemaType != null && Constants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value);
            this.writeValue(convertedValue, null, isAttribute);
        } else if (value.getClass() == String.class) {
            if (schemaType != null && this.isNumericOrBooleanType(schemaType)) {
                ConversionManager conversionManager = this.getConversionManager();
                Class<?> theClass = conversionManager.javaType(schemaType);
                Object convertedValue = conversionManager.convertObject(value, theClass, schemaType);
                this.writeValue(convertedValue, schemaType, isAttribute);
            } else if (isCDATA) {
                this.cdata((String)value);
            } else {
                this.writeValue(value, null, isAttribute);
            }
        } else {
            Class<?> theClass = ((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).javaType(schemaType);
            if (schemaType == null || theClass == null) {
                if (value.getClass() == CoreClassConstants.BOOLEAN || CoreClassConstants.NUMBER.isAssignableFrom(value.getClass())) {
                    this.writeValue(value, schemaType, isAttribute);
                } else {
                    String convertedValue = (String)((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.STRING, schemaType);
                    this.writeValue(convertedValue, schemaType, isAttribute);
                }
            } else if (schemaType != null && !this.isNumericOrBooleanType(schemaType)) {
                String convertedValue = (String)((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.STRING, schemaType);
                this.writeValue(convertedValue, schemaType, isAttribute);
            } else if (isCDATA) {
                String convertedValue = (String)((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.STRING, schemaType);
                this.cdata(convertedValue);
            } else {
                this.writeValue(value, schemaType, isAttribute);
            }
        }
    }

    private boolean isNumericOrBooleanType(QName schemaType) {
        if (schemaType == null) {
            return false;
        }
        return schemaType.equals(Constants.BOOLEAN_QNAME) || schemaType.equals(Constants.INTEGER_QNAME) || schemaType.equals(Constants.INT_QNAME) || schemaType.equals(Constants.BYTE_QNAME) || schemaType.equals(Constants.DECIMAL_QNAME) || schemaType.equals(Constants.FLOAT_QNAME) || schemaType.equals(Constants.DOUBLE_QNAME) || schemaType.equals(Constants.SHORT_QNAME) || schemaType.equals(Constants.LONG_QNAME) || schemaType.equals(Constants.NEGATIVE_INTEGER_QNAME) || schemaType.equals(Constants.NON_NEGATIVE_INTEGER_QNAME) || schemaType.equals(Constants.NON_POSITIVE_INTEGER_QNAME) || schemaType.equals(Constants.POSITIVE_INTEGER_QNAME) || schemaType.equals(Constants.UNSIGNED_BYTE_QNAME) || schemaType.equals(Constants.UNSIGNED_INT_QNAME) || schemaType.equals(Constants.UNSIGNED_LONG_QNAME) || schemaType.equals(Constants.UNSIGNED_SHORT_QNAME);
    }

    public void writeValue(Object value, QName schemaType, boolean isAttribute) {
        if (this.characterEscapeHandler != null && value instanceof String) {
            try {
                StringWriter stringWriter = new StringWriter();
                this.characterEscapeHandler.escape(((String)value).toCharArray(), 0, ((String)value).length(), isAttribute, stringWriter);
                value = stringWriter.toString();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
        boolean textWrapperOpened = false;
        if (!this.isLastEventStart) {
            this.openStartElement(this.textWrapperFragment, this.namespaceResolver);
            textWrapperOpened = true;
        }
        Object currentLevel = this.position;
        String keyName = ((Level)this.position).getKeyName();
        if (!((Level)this.position).isComplex) {
            currentLevel = ((Level)this.position).parentLevel;
        }
        this.addValue(currentLevel, keyName, value, schemaType);
        this.isLastEventStart = false;
        if (textWrapperOpened) {
            this.endElement(this.textWrapperFragment, this.namespaceResolver);
        }
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (this.position != null) {
            if (this.isLastEventStart) {
                this.setComplex(this.position, true);
            }
            if (((Level)this.position).isComplex) {
                this.finishLevel();
            } else {
                this.position = ((Level)this.position).parentLevel;
            }
            this.isLastEventStart = false;
        }
    }

    private void addValue(T currentLevel, String keyName, Object value, QName schemaType) {
        if (((Level)currentLevel).isCollection()) {
            this.addValueToArray(currentLevel, value, schemaType);
            ((Level)currentLevel).setEmptyCollection(false);
        } else {
            this.addValueToObject(currentLevel, keyName, value, schemaType);
        }
    }

    protected abstract void addValueToObject(T var1, String var2, Object var3, QName var4);

    protected abstract void addValueToArray(T var1, Object var2, QName var3);

    @Override
    public void cdata(String value) {
        this.characters(value);
    }

    @Override
    public void node(Node node, NamespaceResolver resolver, String uri, String name) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                    ((NamespaceResolver)this.getNamespaceResolver()).put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.writeValue(node.getNodeValue(), null, false);
        } else {
            try {
                JsonRecordContentHandler wrcHandler = new JsonRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(this.namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node, uri, name);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    @Override
    protected String getStringForQName(QName qName) {
        if (qName == null) {
            return null;
        }
        Object xmlConversionManager = ((CoreAbstractSession)this.getSession()).getDatasourcePlatform().getConversionManager();
        return (String)((CoreConversionManager)xmlConversionManager).convertObject(qName, String.class);
    }

    @Override
    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void namespaceDeclaration(String prefix, String namespaceURI) {
    }

    @Override
    public void defaultNamespaceDeclaration(String defaultNamespace) {
    }

    @Override
    public void nilComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.characters(NULL);
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void nilSimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.characters(NULL);
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void emptySimple(NamespaceResolver namespaceResolver) {
        this.nilSimple(namespaceResolver);
    }

    @Override
    public void emptyAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.characters(NULL);
        this.endElement(xPathFragment, namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void emptyComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.endElement(xPathFragment, namespaceResolver);
    }

    protected class JsonRecordContentHandler
    implements ExtendedContentHandler,
    LexicalHandler {
        JsonRecordContentHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            XPathFragment xPathFragment = new XPathFragment(localName);
            xPathFragment.setNamespaceURI(namespaceURI);
            JsonRecord.this.openStartElement(xPathFragment, JsonRecord.this.namespaceResolver);
            this.handleAttributes(atts);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            XPathFragment xPathFragment = new XPathFragment(localName);
            xPathFragment.setNamespaceURI(namespaceURI);
            JsonRecord.this.endElement(xPathFragment, JsonRecord.this.namespaceResolver);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String characters = new String(ch, start, length);
            this.characters(characters);
        }

        @Override
        public void characters(CharSequence characters) throws SAXException {
            JsonRecord.this.characters(characters.toString());
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        protected void handleAttributes(Attributes atts) {
            int i = 0;
            int attsLength = atts.getLength();
            while (i < attsLength) {
                String qName = atts.getQName(i);
                if (qName == null || !qName.startsWith("xmlns:") && !qName.equals("xmlns")) {
                    JsonRecord.this.attribute(atts.getURI(i), atts.getLocalName(i), qName, atts.getValue(i));
                }
                ++i;
            }
        }

        protected void writeComment(char[] chars, int start, int length) {
        }

        protected void writeCharacters(char[] chars, int start, int length) {
            try {
                this.characters(chars, start, length);
            }
            catch (SAXException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void setNil(boolean isNil) {
        }
    }

    protected static class Level {
        protected boolean isCollection;
        protected boolean emptyCollection;
        protected boolean emptyCollectionGenerated;
        protected String keyName;
        protected boolean isComplex;
        protected boolean nestedArray;
        protected Level parentLevel;
        private int skipCount;

        public Level(boolean isCollection, Level parentLevel, boolean nestedArray) {
            this.setCollection(isCollection);
            this.emptyCollection = true;
            this.parentLevel = parentLevel;
            this.nestedArray = nestedArray;
            this.skipCount = 0;
        }

        protected void addSkip() {
            ++this.skipCount;
        }

        protected boolean notSkip() {
            if (this.skipCount > 0) {
                --this.skipCount;
                return false;
            }
            return true;
        }

        protected int getSkipCount() {
            return this.skipCount;
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public void setCollection(boolean isCollection) {
            this.isCollection = isCollection;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public boolean isEmptyCollection() {
            return this.emptyCollection;
        }

        public void setEmptyCollection(boolean emptyCollection) {
            this.emptyCollection = emptyCollection;
        }

        public boolean isEmptyCollectionGenerated() {
            return this.emptyCollectionGenerated;
        }

        public void setEmptyCollectionGenerated(boolean emptyCollectionGenerated) {
            this.emptyCollectionGenerated = emptyCollectionGenerated;
        }

        public boolean isComplex() {
            return this.isComplex;
        }

        public void setComplex(boolean isComplex) {
            this.isComplex = isComplex;
        }

        public boolean isNestedArray() {
            return this.nestedArray;
        }

        public void setNestedArray(boolean nestedArray) {
            this.nestedArray = nestedArray;
        }
    }
}

