/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.Tree;

public abstract class BaseTree
implements Tree {
    protected List<Object> children;

    public BaseTree() {
    }

    public BaseTree(Tree tree) {
    }

    @Override
    public Tree getChild(int n) {
        if (this.children == null || n >= this.children.size()) {
            return null;
        }
        return (Tree)this.children.get(n);
    }

    public List<? extends Object> getChildren() {
        return this.children;
    }

    public Tree getFirstChildWithType(int n) {
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            Tree tree = (Tree)this.children.get(i);
            if (tree.getType() != n) continue;
            return tree;
        }
        return null;
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public void addChild(Tree tree) {
        if (tree == null) {
            return;
        }
        BaseTree baseTree = (BaseTree)tree;
        if (baseTree.isNil()) {
            if (this.children != null && this.children == baseTree.children) {
                throw new RuntimeException("attempt to add child list to itself");
            }
            if (baseTree.children != null) {
                if (this.children != null) {
                    int n = baseTree.children.size();
                    for (int i = 0; i < n; ++i) {
                        Tree tree2 = (Tree)baseTree.children.get(i);
                        this.children.add(tree2);
                        tree2.setParent(this);
                        tree2.setChildIndex(this.children.size() - 1);
                    }
                } else {
                    this.children = baseTree.children;
                    this.freshenParentAndChildIndexes();
                }
            }
        } else {
            if (this.children == null) {
                this.children = this.createChildrenList();
            }
            this.children.add(tree);
            baseTree.setParent(this);
            baseTree.setChildIndex(this.children.size() - 1);
        }
    }

    public void addChildren(List<? extends Tree> list) {
        for (int i = 0; i < list.size(); ++i) {
            Tree tree = list.get(i);
            this.addChild(tree);
        }
    }

    @Override
    public void setChild(int n, Tree tree) {
        if (tree == null) {
            return;
        }
        if (tree.isNil()) {
            throw new IllegalArgumentException("Can't set single child to a list");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.set(n, tree);
        tree.setParent(this);
        tree.setChildIndex(n);
    }

    public void insertChild(int n, Object object) {
        if (n < 0 || n > this.getChildCount()) {
            throw new IndexOutOfBoundsException(n + " out or range");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.add(n, object);
        this.freshenParentAndChildIndexes(n);
    }

    @Override
    public Object deleteChild(int n) {
        if (this.children == null) {
            return null;
        }
        Tree tree = (Tree)this.children.remove(n);
        this.freshenParentAndChildIndexes(n);
        return tree;
    }

    @Override
    public void replaceChildren(int n, int n2, Object object) {
        List<Object> list;
        if (this.children == null) {
            throw new IllegalArgumentException("indexes invalid; no children in list");
        }
        int n3 = n2 - n + 1;
        BaseTree baseTree = (BaseTree)object;
        if (baseTree.isNil()) {
            list = baseTree.children;
        } else {
            list = new ArrayList<Object>(1);
            list.add(baseTree);
        }
        int n4 = list.size();
        int n5 = list.size();
        int n6 = n3 - n4;
        if (n6 == 0) {
            int n7 = 0;
            for (int i = n; i <= n2; ++i) {
                BaseTree baseTree2 = (BaseTree)list.get(n7);
                this.children.set(i, baseTree2);
                baseTree2.setParent(this);
                baseTree2.setChildIndex(i);
                ++n7;
            }
        } else if (n6 > 0) {
            int n8;
            for (n8 = 0; n8 < n5; ++n8) {
                this.children.set(n + n8, list.get(n8));
            }
            for (int i = n8 = n + n5; i <= n2; ++i) {
                this.children.remove(n8);
            }
            this.freshenParentAndChildIndexes(n);
        } else {
            int n9;
            for (n9 = 0; n9 < n3; ++n9) {
                this.children.set(n + n9, list.get(n9));
            }
            n9 = n4 - n3;
            for (int i = n3; i < n4; ++i) {
                this.children.add(n + i, list.get(i));
            }
            this.freshenParentAndChildIndexes(n);
        }
    }

    protected List<Object> createChildrenList() {
        return new ArrayList<Object>();
    }

    @Override
    public boolean isNil() {
        return false;
    }

    @Override
    public void freshenParentAndChildIndexes() {
        this.freshenParentAndChildIndexes(0);
    }

    public void freshenParentAndChildIndexes(int n) {
        int n2 = this.getChildCount();
        for (int i = n; i < n2; ++i) {
            Tree tree = this.getChild(i);
            tree.setChildIndex(i);
            tree.setParent(this);
        }
    }

    public void freshenParentAndChildIndexesDeeply() {
        this.freshenParentAndChildIndexesDeeply(0);
    }

    public void freshenParentAndChildIndexesDeeply(int n) {
        int n2 = this.getChildCount();
        for (int i = n; i < n2; ++i) {
            BaseTree baseTree = (BaseTree)this.getChild(i);
            baseTree.setChildIndex(i);
            baseTree.setParent(this);
            baseTree.freshenParentAndChildIndexesDeeply();
        }
    }

    public void sanityCheckParentAndChildIndexes() {
        this.sanityCheckParentAndChildIndexes(null, -1);
    }

    public void sanityCheckParentAndChildIndexes(Tree tree, int n) {
        if (tree != this.getParent()) {
            throw new IllegalStateException("parents don't match; expected " + tree + " found " + this.getParent());
        }
        if (n != this.getChildIndex()) {
            throw new IllegalStateException("child indexes don't match; expected " + n + " found " + this.getChildIndex());
        }
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            CommonTree commonTree = (CommonTree)this.getChild(i);
            commonTree.sanityCheckParentAndChildIndexes(this, i);
        }
    }

    @Override
    public int getChildIndex() {
        return 0;
    }

    @Override
    public void setChildIndex(int n) {
    }

    @Override
    public Tree getParent() {
        return null;
    }

    @Override
    public void setParent(Tree tree) {
    }

    @Override
    public boolean hasAncestor(int n) {
        return this.getAncestor(n) != null;
    }

    @Override
    public Tree getAncestor(int n) {
        Tree tree = this;
        for (tree = tree.getParent(); tree != null; tree = tree.getParent()) {
            if (tree.getType() != n) continue;
            return tree;
        }
        return null;
    }

    public List<? extends Tree> getAncestors() {
        if (this.getParent() == null) {
            return null;
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        Tree tree = this;
        for (tree = tree.getParent(); tree != null; tree = tree.getParent()) {
            arrayList.add(0, tree);
        }
        return arrayList;
    }

    @Override
    public String toStringTree() {
        if (this.children == null || this.children.isEmpty()) {
            return this.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isNil()) {
            stringBuilder.append("(");
            stringBuilder.append(this.toString());
            stringBuilder.append(' ');
        }
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            Tree tree = (Tree)this.children.get(i);
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(tree.toStringTree());
        }
        if (!this.isNil()) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public int getLine() {
        return 0;
    }

    @Override
    public int getCharPositionInLine() {
        return 0;
    }

    @Override
    public abstract String toString();
}

