/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.XMLHelper;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.metadata.xml.ORMContentHandler;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsMappingProject;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLEntityMappingsReader {
    public static final String ORM_1_0_XSD = "org/eclipse/persistence/jpa/orm_1_0.xsd";
    public static final String ORM_1_0_NAMESPACE = "http://java.sun.com/xml/ns/persistence/orm";
    public static final String ORM_2_0_XSD = "org/eclipse/persistence/jpa/orm_2_0.xsd";
    public static final String ORM_2_0_NAMESPACE = "http://java.sun.com/xml/ns/persistence/orm";
    public static final String ORM_2_1_XSD = "org/eclipse/persistence/jpa/orm_2_1.xsd";
    public static final String ORM_2_1_NAMESPACE = "http://xmlns.jcp.org/xml/ns/persistence/orm";
    public static final String ORM_2_2_XSD = "org/eclipse/persistence/jpa/orm_2_2.xsd";
    public static final String ORM_2_2_NAMESPACE = "http://xmlns.jcp.org/xml/ns/persistence/orm";
    public static final String ECLIPSELINK_ORM_XSD = "org/eclipse/persistence/jpa/eclipselink_orm_2_5.xsd";
    public static final String ECLIPSELINK_ORM_NAMESPACE = "http://www.eclipse.org/eclipselink/xsds/persistence/orm";
    private static XMLContext m_orm1_0Project;
    private static XMLContext m_orm2_0Project;
    private static XMLContext m_orm2_1Project;
    private static XMLContext m_orm2_2Project;
    private static XMLContext m_eclipseLinkOrmProject;
    private static Schema m_orm1_0Schema;
    private static Schema m_orm2_0Schema;
    private static Schema m_orm2_1Schema;
    private static Schema m_orm2_2Schema;
    private static Schema m_eclipseLinkOrmSchema;

    private static Object[] determineXMLContextAndSchema(String file, Reader input, boolean validateSchema) throws Exception {
        Object[] context = new Object[2];
        if (input == null) {
            context[0] = XMLEntityMappingsReader.getEclipseLinkOrmProject();
            if (validateSchema) {
                context[1] = XMLEntityMappingsReader.getEclipseLinkOrmSchema();
            }
        } else {
            SAXParserFactory factory = XMLHelper.createParserFactory(false);
            SAXParser parser = factory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            ORMContentHandler contentHandler = new ORMContentHandler();
            xmlReader.setContentHandler(contentHandler);
            InputSource inputSource = new InputSource(input);
            xmlReader.parse(inputSource);
            if (contentHandler.isEclipseLink()) {
                context[0] = XMLEntityMappingsReader.getEclipseLinkOrmProject();
                if (validateSchema) {
                    context[1] = XMLEntityMappingsReader.getEclipseLinkOrmSchema();
                }
            } else if (contentHandler.getVersion() == null || contentHandler.getVersion().indexOf(50) == -1) {
                context[0] = XMLEntityMappingsReader.getOrm1_0Project();
                if (validateSchema) {
                    context[1] = XMLEntityMappingsReader.getOrm1_0Schema();
                }
            } else if (contentHandler.getVersion().indexOf("2.0") != -1) {
                context[0] = XMLEntityMappingsReader.getOrm2_0Project();
                if (validateSchema) {
                    context[1] = XMLEntityMappingsReader.getOrm2_0Schema();
                }
            } else if (contentHandler.getVersion().indexOf("2.1") != -1) {
                context[0] = XMLEntityMappingsReader.getOrm2_1Project();
                if (validateSchema) {
                    context[1] = XMLEntityMappingsReader.getOrm2_1Schema();
                }
            } else {
                context[0] = XMLEntityMappingsReader.getOrm2_2Project();
                if (validateSchema) {
                    context[1] = XMLEntityMappingsReader.getOrm2_2Schema();
                }
            }
        }
        return context;
    }

    public static XMLContext getEclipseLinkOrmProject() {
        if (m_eclipseLinkOrmProject == null) {
            m_eclipseLinkOrmProject = new XMLContext(new XMLEntityMappingsMappingProject(ECLIPSELINK_ORM_NAMESPACE, ECLIPSELINK_ORM_XSD));
        }
        return m_eclipseLinkOrmProject;
    }

    public static Schema getEclipseLinkOrmSchema() throws IOException, SAXException {
        if (m_eclipseLinkOrmSchema == null) {
            m_eclipseLinkOrmSchema = XMLEntityMappingsReader.loadLocalSchema(ECLIPSELINK_ORM_XSD);
        }
        return m_eclipseLinkOrmSchema;
    }

    private static InputStreamReader getInputStreamReader(URL url) throws IOException {
        URLConnection cnx1 = url.openConnection();
        cnx1.setUseCaches(false);
        return new InputStreamReader(cnx1.getInputStream(), "UTF-8");
    }

    public static XMLContext getOrm1_0Project() {
        if (m_orm1_0Project == null) {
            m_orm1_0Project = new XMLContext(new XMLEntityMappingsMappingProject("http://java.sun.com/xml/ns/persistence/orm", ORM_1_0_XSD));
        }
        return m_orm1_0Project;
    }

    public static Schema getOrm1_0Schema() throws IOException, SAXException {
        if (m_orm1_0Schema == null) {
            m_orm1_0Schema = XMLEntityMappingsReader.loadLocalSchema(ORM_1_0_XSD);
        }
        return m_orm1_0Schema;
    }

    public static XMLContext getOrm2_0Project() {
        if (m_orm2_0Project == null) {
            m_orm2_0Project = new XMLContext(new XMLEntityMappingsMappingProject("http://java.sun.com/xml/ns/persistence/orm", ORM_2_0_XSD));
        }
        return m_orm2_0Project;
    }

    public static Schema getOrm2_0Schema() throws IOException, SAXException {
        if (m_orm2_0Schema == null) {
            m_orm2_0Schema = XMLEntityMappingsReader.loadLocalSchema(ORM_2_0_XSD);
        }
        return m_orm2_0Schema;
    }

    public static XMLContext getOrm2_1Project() {
        if (m_orm2_1Project == null) {
            m_orm2_1Project = new XMLContext(new XMLEntityMappingsMappingProject("http://xmlns.jcp.org/xml/ns/persistence/orm", ORM_2_1_XSD));
        }
        return m_orm2_1Project;
    }

    public static Schema getOrm2_1Schema() throws IOException, SAXException {
        if (m_orm2_1Schema == null) {
            m_orm2_1Schema = XMLEntityMappingsReader.loadLocalSchema(ORM_2_1_XSD);
        }
        return m_orm2_1Schema;
    }

    public static XMLContext getOrm2_2Project() {
        if (m_orm2_2Project == null) {
            m_orm2_2Project = new XMLContext(new XMLEntityMappingsMappingProject("http://xmlns.jcp.org/xml/ns/persistence/orm", ORM_2_2_XSD));
        }
        return m_orm2_2Project;
    }

    public static Schema getOrm2_2Schema() throws IOException, SAXException {
        if (m_orm2_2Schema == null) {
            m_orm2_2Schema = XMLEntityMappingsReader.loadLocalSchema(ORM_2_2_XSD);
        }
        return m_orm2_2Schema;
    }

    public static void clear() {
        m_orm1_0Project = null;
        m_orm2_0Project = null;
        m_orm2_1Project = null;
        m_orm2_2Project = null;
        m_eclipseLinkOrmProject = null;
        m_orm1_0Schema = null;
        m_orm2_0Schema = null;
        m_orm2_1Schema = null;
        m_orm2_2Schema = null;
        m_eclipseLinkOrmSchema = null;
    }

    private static boolean isORMSchemaValidationPerformed(Map properties) {
        String value = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.orm.validate.schema", properties, "false");
        return value != null && value.equalsIgnoreCase("true");
    }

    protected static Schema loadLocalSchema(String schemaName) throws IOException, SAXException {
        URL url = XMLEntityMappingsReader.class.getClassLoader().getResource(schemaName);
        try (InputStream schemaStream = url.openStream();){
            Schema schema;
            StreamSource source = new StreamSource(url.openStream());
            SchemaFactory schemaFactory = XMLHelper.createSchemaFactory("http://www.w3.org/2001/XMLSchema", false);
            Schema schema2 = schema = schemaFactory.newSchema(source);
            return schema2;
        }
    }

    public static XMLEntityMappings read(String sourceName, Reader reader, ClassLoader classLoader, Map properties) {
        return XMLEntityMappingsReader.read(sourceName, null, reader, classLoader, properties);
    }

    protected static XMLEntityMappings read(String mappingFile, Reader reader1, Reader reader2, ClassLoader classLoader, Map properties) {
        XMLEntityMappings xmlEntityMappings;
        boolean validateORMSchema = XMLEntityMappingsReader.isORMSchemaValidationPerformed(properties);
        try {
            Object[] context = XMLEntityMappingsReader.determineXMLContextAndSchema(mappingFile, reader1, validateORMSchema);
            XMLUnmarshaller unmarshaller = ((XMLContext)context[0]).createUnmarshaller();
            if (validateORMSchema) {
                XMLEntityMappingsReader.useLocalSchemaForUnmarshaller(unmarshaller, (Schema)context[1]);
            }
            xmlEntityMappings = (XMLEntityMappings)unmarshaller.unmarshal(reader2);
        }
        catch (Exception exception) {
            throw ValidationException.errorParsingMappingFile(mappingFile, exception);
        }
        if (xmlEntityMappings != null) {
            xmlEntityMappings.setMappingFile(mappingFile);
        }
        return xmlEntityMappings;
    }

    public static XMLEntityMappings read(URL url, ClassLoader classLoader, Properties properties) throws IOException {
        InputStreamReader reader1 = null;
        InputStreamReader reader2 = null;
        try {
            reader1 = XMLEntityMappingsReader.getInputStreamReader(url);
            reader2 = XMLEntityMappingsReader.getInputStreamReader(url);
            XMLEntityMappings xMLEntityMappings = XMLEntityMappingsReader.read(url.toString(), reader1, reader2, classLoader, properties);
            return xMLEntityMappings;
        }
        catch (UnsupportedEncodingException exception) {
            throw ValidationException.fatalErrorOccurred(exception);
        }
        finally {
            try {
                if (reader1 != null) {
                    reader1.close();
                }
                if (reader2 != null) {
                    reader2.close();
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    private static void useLocalSchemaForUnmarshaller(XMLUnmarshaller unmarshaller, Schema schema) {
        try {
            unmarshaller.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    if (exception.getException() instanceof EclipseLinkException) {
                        throw (EclipseLinkException)exception.getCause();
                    }
                }
            });
            unmarshaller.setSchema(schema);
        }
        catch (UnsupportedOperationException ex) {
            unmarshaller.setValidationMode(3);
        }
    }
}

