/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util.metadatasources;

import java.util.Collection;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.weaving.RestCollectionAdapterClassWriter;
import org.eclipse.persistence.internal.jpa.weaving.RestReferenceAdapterV2ClassWriter;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.metadata.MetadataSource;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.ObjectFactory;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class DynamicXmlV2MetadataSource
implements MetadataSource {
    private XmlBindings xmlBindings;

    public DynamicXmlV2MetadataSource(AbstractSession session, String packageName) {
        ObjectFactory objectFactory = new ObjectFactory();
        this.xmlBindings = new XmlBindings();
        this.xmlBindings.setPackageName(packageName);
        XmlBindings.JavaTypes javaTypes = new XmlBindings.JavaTypes();
        this.xmlBindings.setJavaTypes(javaTypes);
        for (ClassDescriptor ormDescriptor : session.getProject().getOrderedDescriptors()) {
            String descriptorPackageName = "";
            int index = ormDescriptor.getJavaClassName().lastIndexOf(46);
            if (index > 0) {
                descriptorPackageName = ormDescriptor.getJavaClassName().substring(0, index);
            }
            if (!descriptorPackageName.equals(packageName)) continue;
            javaTypes.getJavaType().add(this.createJAXBType(ormDescriptor, objectFactory));
        }
    }

    private JavaType createJAXBType(ClassDescriptor classDescriptor, ObjectFactory objectFactory) {
        JavaType javaType = new JavaType();
        String alias = classDescriptor.getAlias();
        if (alias == null || alias.isEmpty()) {
            alias = classDescriptor.getJavaClass().getSimpleName();
        }
        javaType.setName(alias);
        JavaType.JavaAttributes javaAttributes = new JavaType.JavaAttributes();
        for (DatabaseMapping ormMapping : classDescriptor.getMappings()) {
            JAXBElement<XmlElement> element = null;
            if (ormMapping instanceof DirectCollectionMapping) continue;
            if (ormMapping.isCollectionMapping()) {
                element = this.createCollectionProperty(ormMapping, objectFactory);
            } else if (ForeignReferenceMapping.class.isAssignableFrom(ormMapping.getClass())) {
                element = this.createProperty((ForeignReferenceMapping)ormMapping, objectFactory);
            }
            if (element == null) continue;
            javaAttributes.getJavaAttribute().add(element);
        }
        if (!javaAttributes.getJavaAttribute().isEmpty()) {
            javaType.setJavaAttributes(javaAttributes);
        }
        return javaType;
    }

    private JAXBElement<XmlElement> createCollectionProperty(DatabaseMapping mapping, ObjectFactory objectFactory) {
        XmlElement xmlElement = new XmlElement();
        xmlElement.setJavaAttribute(mapping.getAttributeName());
        xmlElement.setType(((CollectionMapping)mapping).getReferenceClassName());
        XmlJavaTypeAdapter adapter = new XmlJavaTypeAdapter();
        String adapterName = RestCollectionAdapterClassWriter.getClassName(((CollectionMapping)mapping).getReferenceClassName());
        adapter.setValue(adapterName);
        adapter.setType(Collection.class.getName());
        xmlElement.setXmlJavaTypeAdapter(adapter);
        return objectFactory.createXmlElement(xmlElement);
    }

    private JAXBElement<XmlElement> createProperty(ForeignReferenceMapping mapping, ObjectFactory objectFactory) {
        String referenceClassName = mapping.getReferenceClassName();
        XmlElement xmlElement = new XmlElement();
        xmlElement.setJavaAttribute(mapping.getAttributeName());
        xmlElement.setType(referenceClassName);
        String adapterName = RestReferenceAdapterV2ClassWriter.getClassName(referenceClassName);
        XmlJavaTypeAdapter adapter = new XmlJavaTypeAdapter();
        adapter.setValue(adapterName);
        adapter.setType(referenceClassName);
        xmlElement.setXmlJavaTypeAdapter(adapter);
        return objectFactory.createXmlElement(xmlElement);
    }

    @Override
    public XmlBindings getXmlBindings(Map<String, ?> properties, ClassLoader classLoader) {
        return this.xmlBindings;
    }
}

