/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.xml;

import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.TypePath;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXAnnotationAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXCodeAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXFieldAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXModuleAdapter;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXClassAdapter
extends ClassVisitor {
    SAXAdapter sa;
    private final boolean singleDocument;
    private static final int ACCESS_CLASS = 262144;
    private static final int ACCESS_FIELD = 524288;
    private static final int ACCESS_INNER = 0x100000;

    public SAXClassAdapter(ContentHandler contentHandler, boolean bl) {
        super(393216);
        this.sa = new SAXAdapter(contentHandler);
        this.singleDocument = bl;
        if (!bl) {
            this.sa.addDocumentStart();
        }
    }

    @Override
    public void visitSource(String string, String string2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (string != null) {
            attributesImpl.addAttribute("", "file", "file", "", SAXClassAdapter.encode(string));
        }
        if (string2 != null) {
            attributesImpl.addAttribute("", "debug", "debug", "", SAXClassAdapter.encode(string2));
        }
        this.sa.addElement("source", attributesImpl);
    }

    @Override
    public ModuleVisitor visitModule() {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.sa.addStart("module", attributesImpl);
        return new SAXModuleAdapter(this.sa);
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "owner", "owner", "", string);
        if (string2 != null) {
            attributesImpl.addAttribute("", "name", "name", "", string2);
        }
        if (string3 != null) {
            attributesImpl.addAttribute("", "desc", "desc", "", string3);
        }
        this.sa.addElement("outerclass", attributesImpl);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        return new SAXAnnotationAdapter(this.sa, "annotation", bl ? 1 : -1, null, string);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        return new SAXAnnotationAdapter(this.sa, "typeAnnotation", bl ? 1 : -1, null, string, n, typePath);
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        SAXClassAdapter.appendAccess(n2 | 0x40000, stringBuilder);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "access", "access", "", stringBuilder.toString());
        if (string != null) {
            attributesImpl.addAttribute("", "name", "name", "", string);
        }
        if (string2 != null) {
            attributesImpl.addAttribute("", "signature", "signature", "", SAXClassAdapter.encode(string2));
        }
        if (string3 != null) {
            attributesImpl.addAttribute("", "parent", "parent", "", string3);
        }
        attributesImpl.addAttribute("", "major", "major", "", Integer.toString(n & 0xFFFF));
        attributesImpl.addAttribute("", "minor", "minor", "", Integer.toString(n >>> 16));
        this.sa.addStart("class", attributesImpl);
        this.sa.addStart("interfaces", new AttributesImpl());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                AttributesImpl attributesImpl2 = new AttributesImpl();
                attributesImpl2.addAttribute("", "name", "name", "", stringArray[i]);
                this.sa.addElement("interface", attributesImpl2);
            }
        }
        this.sa.addEnd("interfaces");
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        SAXClassAdapter.appendAccess(n | 0x80000, stringBuilder);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "access", "access", "", stringBuilder.toString());
        attributesImpl.addAttribute("", "name", "name", "", string);
        attributesImpl.addAttribute("", "desc", "desc", "", string2);
        if (string3 != null) {
            attributesImpl.addAttribute("", "signature", "signature", "", SAXClassAdapter.encode(string3));
        }
        if (object != null) {
            attributesImpl.addAttribute("", "value", "value", "", SAXClassAdapter.encode(object.toString()));
        }
        return new SAXFieldAdapter(this.sa, attributesImpl);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        SAXClassAdapter.appendAccess(n, stringBuilder);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "access", "access", "", stringBuilder.toString());
        attributesImpl.addAttribute("", "name", "name", "", string);
        attributesImpl.addAttribute("", "desc", "desc", "", string2);
        if (string3 != null) {
            attributesImpl.addAttribute("", "signature", "signature", "", string3);
        }
        this.sa.addStart("method", attributesImpl);
        this.sa.addStart("exceptions", new AttributesImpl());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                AttributesImpl attributesImpl2 = new AttributesImpl();
                attributesImpl2.addAttribute("", "name", "name", "", stringArray[i]);
                this.sa.addElement("exception", attributesImpl2);
            }
        }
        this.sa.addEnd("exceptions");
        return new SAXCodeAdapter(this.sa, n);
    }

    @Override
    public final void visitInnerClass(String string, String string2, String string3, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        SAXClassAdapter.appendAccess(n | 0x100000, stringBuilder);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "access", "access", "", stringBuilder.toString());
        if (string != null) {
            attributesImpl.addAttribute("", "name", "name", "", string);
        }
        if (string2 != null) {
            attributesImpl.addAttribute("", "outerName", "outerName", "", string2);
        }
        if (string3 != null) {
            attributesImpl.addAttribute("", "innerName", "innerName", "", string3);
        }
        this.sa.addElement("innerclass", attributesImpl);
    }

    @Override
    public final void visitEnd() {
        this.sa.addEnd("class");
        if (!this.singleDocument) {
            this.sa.addDocumentEnd();
        }
    }

    static final String encode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                stringBuilder.append("\\u");
                if (c < '\u0010') {
                    stringBuilder.append("000");
                } else if (c < '\u0100') {
                    stringBuilder.append("00");
                } else if (c < '\u1000') {
                    stringBuilder.append('0');
                }
                stringBuilder.append(Integer.toString(c, 16));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static void appendAccess(int n, StringBuilder stringBuilder) {
        if ((n & 1) != 0) {
            stringBuilder.append("public ");
        }
        if ((n & 2) != 0) {
            stringBuilder.append("private ");
        }
        if ((n & 4) != 0) {
            stringBuilder.append("protected ");
        }
        if ((n & 0x10) != 0) {
            stringBuilder.append("final ");
        }
        if ((n & 8) != 0) {
            stringBuilder.append("static ");
        }
        if ((n & 0x20) != 0) {
            if ((n & 0x40000) == 0) {
                stringBuilder.append("synchronized ");
            } else {
                stringBuilder.append("super ");
            }
        }
        if ((n & 0x40) != 0) {
            if ((n & 0x80000) == 0) {
                stringBuilder.append("bridge ");
            } else {
                stringBuilder.append("volatile ");
            }
        }
        if ((n & 0x80) != 0) {
            if ((n & 0x80000) == 0) {
                stringBuilder.append("varargs ");
            } else {
                stringBuilder.append("transient ");
            }
        }
        if ((n & 0x100) != 0) {
            stringBuilder.append("native ");
        }
        if ((n & 0x800) != 0) {
            stringBuilder.append("strict ");
        }
        if ((n & 0x200) != 0) {
            stringBuilder.append("interface ");
        }
        if ((n & 0x400) != 0) {
            stringBuilder.append("abstract ");
        }
        if ((n & 0x1000) != 0) {
            stringBuilder.append("synthetic ");
        }
        if ((n & 0x2000) != 0) {
            stringBuilder.append("annotation ");
        }
        if ((n & 0x4000) != 0) {
            stringBuilder.append("enum ");
        }
        if ((n & 0x20000) != 0) {
            stringBuilder.append("deprecated ");
        }
        if ((n & 0x8000) != 0) {
            if ((n & 0x40000) == 0) {
                stringBuilder.append("module ");
            } else {
                stringBuilder.append("mandated ");
            }
        }
    }
}

