/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.logging;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;

public class StdErrLogger {
    private static final SessionLog LOGGER = AbstractSessionLog.getLog();
    private static final String PROPERTY_NAME_PREFIX = "eclipselink.log";
    private static final String PROPERTY_NAME_SUFFIX = "stderr";
    private static final char PROPERTY_NAME_SEPARATOR = '.';
    private static final String CATEGORY_SEPARATOR = ": ";
    private static final String STACK_TRACE_PREFIX = " - ";
    private static final Map<String, Boolean> logEnabledCategory = StdErrLogger.initLogEnabledCategory();
    private static final boolean logEnabled = logEnabledCategory != null;

    private static Map<String, Boolean> initLogEnabledCategory() {
        int PropertyExtensionsLength = PROPERTY_NAME_PREFIX.length() + PROPERTY_NAME_SUFFIX.length() + 2;
        HashMap<String, Boolean> logEnabledMap = new HashMap<String, Boolean>(SessionLog.loggerCatagories.length);
        boolean globalTrigger = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? Boolean.valueOf(AccessController.doPrivileged(new PrivilegedGetSystemProperty("eclipselink.log.stderr"))).booleanValue() : Boolean.valueOf(System.getProperty("eclipselink.log.stderr")).booleanValue();
        boolean enable = globalTrigger;
        String[] stringArray = SessionLog.loggerCatagories;
        int n = SessionLog.loggerCatagories.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            if (globalTrigger) {
                logEnabledMap.put(category, Boolean.TRUE);
            } else {
                StringBuilder propertyKey = new StringBuilder(PropertyExtensionsLength + category.length());
                propertyKey.append(PROPERTY_NAME_PREFIX);
                propertyKey.append('.');
                propertyKey.append(category);
                propertyKey.append('.');
                propertyKey.append(PROPERTY_NAME_SUFFIX);
                boolean trigger = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? Boolean.valueOf(AccessController.doPrivileged(new PrivilegedGetSystemProperty(propertyKey.toString()))).booleanValue() : Boolean.valueOf(System.getProperty(propertyKey.toString())).booleanValue();
                logEnabledMap.put(category, trigger);
                enable = enable || trigger;
            }
            ++n2;
        }
        if (!enable) {
            logEnabledMap.clear();
        }
        return enable ? logEnabledMap : null;
    }

    private static final boolean shouldLogToStdErr(String category) {
        Boolean enabled = logEnabledCategory.get(category);
        return enabled != null ? enabled : false;
    }

    private static void logStdErr(String category, String messageKey, Object ... arguments) {
        int categoryLength;
        String message = arguments == null || arguments.length == 0 ? LoggingLocalization.buildMessage(messageKey) : LoggingLocalization.buildMessage(messageKey, arguments);
        int messageLength = message != null ? message.length() : 0;
        int n = categoryLength = category != null ? category.length() + CATEGORY_SEPARATOR.length() : 0;
        if (categoryLength > 0 || messageLength > 0) {
            StringBuilder sb = new StringBuilder(categoryLength + messageLength);
            if (categoryLength > 0) {
                sb.append(category);
                sb.append(CATEGORY_SEPARATOR);
            }
            if (messageLength > 0) {
                sb.append(message);
            }
            System.err.println(sb.toString());
        }
    }

    private static void logThrowableStdErr(String category, Throwable throwable) {
        int categoryLength = category != null ? category.length() + CATEGORY_SEPARATOR.length() : 0;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            String message = ste.toString();
            StringBuilder sb = new StringBuilder(categoryLength + STACK_TRACE_PREFIX.length() + message.length());
            if (categoryLength > 0) {
                sb.append(category);
                sb.append(CATEGORY_SEPARATOR);
            }
            sb.append(STACK_TRACE_PREFIX);
            sb.append(message);
            System.err.println(sb.toString());
            ++n2;
        }
    }

    public static final boolean shouldLog(int level, String category) {
        return logEnabled && StdErrLogger.shouldLogToStdErr(category) || LOGGER.shouldLog(level, category);
    }

    public static final void log(int level, String category, String messageKey) {
        LOGGER.log(level, category, messageKey, null);
        if (logEnabled && StdErrLogger.shouldLogToStdErr(category)) {
            StdErrLogger.logStdErr(category, messageKey, new Object[0]);
        }
    }

    public static final void log(int level, String category, String messageKey, Object ... arguments) {
        LOGGER.log(level, category, messageKey, arguments);
        if (logEnabled && StdErrLogger.shouldLogToStdErr(category)) {
            StdErrLogger.logStdErr(category, messageKey, arguments);
        }
    }

    public static final void logThrowable(int level, String category, Throwable throwable) {
        LOGGER.logThrowable(level, category, throwable);
        if (logEnabled && StdErrLogger.shouldLogToStdErr(category)) {
            StdErrLogger.logThrowableStdErr(category, throwable);
        }
    }
}

