/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.BinaryOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class DivideNode
extends BinaryOperatorNode
implements AliasableNode {
    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.addAttribute("divide", this.generateExpression(context), (Class)this.getType());
        }
    }

    @Override
    public void validate(ParseTreeContext context) {
        super.validate(context);
        if (this.left != null && this.right != null) {
            TypeHelper typeHelper = context.getTypeHelper();
            this.setType(typeHelper.extendedBinaryNumericPromotion(this.left.getType(), this.right.getType()));
        }
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        whereClause = ExpressionMath.divide(whereClause, this.getRight().generateExpression(context));
        return whereClause;
    }

    @Override
    public boolean isDivideNode() {
        return true;
    }

    @Override
    public boolean isAliasableNode() {
        return true;
    }
}

