/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyForeignKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class SecondaryTableMetadata
extends TableMetadata {
    private PrimaryKeyForeignKeyMetadata m_primaryKeyForeignKey;
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();

    public SecondaryTableMetadata() {
        super("<secondary-table>");
    }

    public SecondaryTableMetadata(MetadataAnnotation secondaryTable, MetadataAccessor accessor) {
        super(secondaryTable, accessor);
        if (secondaryTable != null) {
            Object[] objectArray = secondaryTable.getAttributeArray("pkJoinColumns");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object pkJoinColumn = objectArray[n2];
                PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn = new PrimaryKeyJoinColumnMetadata((MetadataAnnotation)pkJoinColumn, accessor);
                this.m_primaryKeyJoinColumns.add(primaryKeyJoinColumn);
                ++n2;
            }
            if (secondaryTable.hasAttribute("foreignKey")) {
                this.m_primaryKeyForeignKey = new PrimaryKeyForeignKeyMetadata(secondaryTable.getAttributeAnnotation("foreignKey"), accessor);
            }
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof SecondaryTableMetadata) {
            SecondaryTableMetadata secondaryTable = (SecondaryTableMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_primaryKeyForeignKey, secondaryTable.getPrimaryKeyForeignKey())) {
                return false;
            }
            return this.valuesMatch(this.m_primaryKeyJoinColumns, secondaryTable.getPrimaryKeyJoinColumns());
        }
        return false;
    }

    @Override
    public String getCatalogContext() {
        return "metadata_default_secondary_table_catalog";
    }

    @Override
    public String getNameContext() {
        return "metadata_default_secondary_table_name";
    }

    public PrimaryKeyForeignKeyMetadata getPrimaryKeyForeignKey() {
        return this.m_primaryKeyForeignKey;
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    @Override
    public String getSchemaContext() {
        return "metadata_default_secondary_table_schema";
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_primaryKeyForeignKey, accessibleObject);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, accessibleObject);
    }

    @Override
    public void processForeignKey() {
        if (this.m_primaryKeyForeignKey != null) {
            this.m_primaryKeyForeignKey.process(this.getDatabaseTable());
        }
    }

    public void setPrimaryKeyForeignKey(PrimaryKeyForeignKeyMetadata primaryKeyForeignKey) {
        this.m_primaryKeyForeignKey = primaryKeyForeignKey;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }
}

