/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.optimizer;

import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.TypePath;
import org.eclipse.persistence.internal.libraries.asm.optimizer.AnnotationConstantsCollector;
import org.eclipse.persistence.internal.libraries.asm.optimizer.ConstantPool;
import org.eclipse.persistence.internal.libraries.asm.optimizer.FieldConstantsCollector;
import org.eclipse.persistence.internal.libraries.asm.optimizer.MethodConstantsCollector;
import org.eclipse.persistence.internal.libraries.asm.optimizer.ModuleConstantsCollector;

public class ClassConstantsCollector
extends ClassVisitor {
    private final ConstantPool cp;

    public ClassConstantsCollector(ClassVisitor classVisitor, ConstantPool constantPool) {
        super(393216, classVisitor);
        this.cp = constantPool;
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        if ((n2 & 0x20000) != 0) {
            this.cp.newUTF8("Deprecated");
        }
        if ((n2 & 0x1000) != 0) {
            this.cp.newUTF8("Synthetic");
        }
        this.cp.newClass(string);
        if (string2 != null) {
            this.cp.newUTF8("Signature");
            this.cp.newUTF8(string2);
        }
        if (string3 != null) {
            this.cp.newClass(string3);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.cp.newClass(stringArray[i]);
            }
        }
        this.cv.visit(n, n2, string, string2, string3, stringArray);
    }

    @Override
    public void visitSource(String string, String string2) {
        if (string != null) {
            this.cp.newUTF8("SourceFile");
            this.cp.newUTF8(string);
        }
        if (string2 != null) {
            this.cp.newUTF8("SourceDebugExtension");
        }
        this.cv.visitSource(string, string2);
    }

    @Override
    public ModuleVisitor visitModule() {
        this.cp.newUTF8("Module");
        return new ModuleConstantsCollector(this.cv.visitModule(), this.cp);
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.cp.newUTF8("EnclosingMethod");
        this.cp.newClass(string);
        if (string2 != null && string3 != null) {
            this.cp.newNameType(string2, string3);
        }
        this.cv.visitOuterClass(string, string2, string3);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.cp.newUTF8(string);
        if (bl) {
            this.cp.newUTF8("RuntimeVisibleAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleAnnotations");
        }
        return new AnnotationConstantsCollector(this.cv.visitAnnotation(string, bl), this.cp);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.cp.newUTF8(string);
        if (bl) {
            this.cp.newUTF8("RuntimeVisibleTypeAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleTypeAnnotations");
        }
        return new AnnotationConstantsCollector(this.cv.visitAnnotation(string, bl), this.cp);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.cv.visitAttribute(attribute);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.cp.newUTF8("InnerClasses");
        if (string != null) {
            this.cp.newClass(string);
        }
        if (string2 != null) {
            this.cp.newClass(string2);
        }
        if (string3 != null) {
            this.cp.newUTF8(string3);
        }
        this.cv.visitInnerClass(string, string2, string3, n);
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        if ((n & 0x1000) != 0) {
            this.cp.newUTF8("Synthetic");
        }
        if ((n & 0x20000) != 0) {
            this.cp.newUTF8("Deprecated");
        }
        this.cp.newUTF8(string);
        this.cp.newUTF8(string2);
        if (string3 != null) {
            this.cp.newUTF8("Signature");
            this.cp.newUTF8(string3);
        }
        if (object != null) {
            this.cp.newConst(object);
        }
        return new FieldConstantsCollector(this.cv.visitField(n, string, string2, string3, object), this.cp);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if ((n & 0x1000) != 0) {
            this.cp.newUTF8("Synthetic");
        }
        if ((n & 0x20000) != 0) {
            this.cp.newUTF8("Deprecated");
        }
        this.cp.newUTF8(string);
        this.cp.newUTF8(string2);
        if (string3 != null) {
            this.cp.newUTF8("Signature");
            this.cp.newUTF8(string3);
        }
        if (stringArray != null) {
            this.cp.newUTF8("Exceptions");
            for (int i = 0; i < stringArray.length; ++i) {
                this.cp.newClass(stringArray[i]);
            }
        }
        return new MethodConstantsCollector(this.cv.visitMethod(n, string, string2, string3, stringArray), this.cp);
    }
}

