/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features.fieldsfiltering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ws.rs.core.UriInfo;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.mappings.DatabaseMapping;

public final class FieldsFilteringValidator {
    public static final String FIELDS_PARAM_NAME = "fields";
    public static final String EXCL_FIELDS_PARAM_NAME = "excludeFields";
    private final Object entity;
    private final PersistenceContext context;
    private final Map<String, Object> queryParameters;
    private List<String> fields;

    public FieldsFilteringValidator(PersistenceContext context, UriInfo uri, Object entity) {
        this.queryParameters = AbstractResource.getQueryParameters(uri);
        this.entity = entity;
        this.context = context;
    }

    public boolean isFeatureApplicable() throws JPARSException {
        if (!this.queryParameters.containsKey(FIELDS_PARAM_NAME) && !this.queryParameters.containsKey(EXCL_FIELDS_PARAM_NAME)) {
            return false;
        }
        if (this.queryParameters.containsKey(FIELDS_PARAM_NAME) && this.queryParameters.containsKey(EXCL_FIELDS_PARAM_NAME)) {
            throw JPARSException.fieldsFilteringBothParametersPresent();
        }
        if (this.queryParameters.containsKey(FIELDS_PARAM_NAME)) {
            this.fields = Arrays.asList(((String)this.queryParameters.get(FIELDS_PARAM_NAME)).split("\\s*,\\s*"));
        } else {
            List<String> excludeFields = Arrays.asList(((String)this.queryParameters.get(EXCL_FIELDS_PARAM_NAME)).split("\\s*,\\s*"));
            Vector<DatabaseMapping> mappings = this.context.getServerSession().getProject().getDescriptors().get(this.entity.getClass()).getMappings();
            this.fields = new ArrayList<String>();
            for (DatabaseMapping mapping : mappings) {
                if (excludeFields.contains(mapping.getAttributeName())) continue;
                this.fields.add(mapping.getAttributeName());
            }
        }
        return true;
    }

    public List<String> getFields() {
        return this.fields;
    }
}

