/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.exceptions;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.QueryTimeoutException;
import javax.persistence.RollbackException;
import javax.persistence.TransactionRequiredException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jpa.rs.DataStorage;
import org.eclipse.persistence.jpa.rs.exceptions.ErrorResponse;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.ServiceVersion;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;

public abstract class AbstractExceptionMapper {
    @Context
    private HttpHeaders headers;
    @Context
    UriInfo uriInfo;
    private static final Map<String, Response.Status> HTTP_STATUS_CODE_MAPPING = Collections.unmodifiableMap(new HashMap<String, Response.Status>(){
        {
            this.put(ClassNotFoundException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(ConversionException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(DatabaseException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR);
            this.put(EntityExistsException.class.getName(), Response.Status.CONFLICT);
            this.put(EntityNotFoundException.class.getName(), Response.Status.NOT_FOUND);
            this.put(IOException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(IllegalAccessException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(IllegalArgumentException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(IllegalStateException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(InvocationTargetException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR);
            this.put(JAXBException.class.getName(), Response.Status.NOT_FOUND);
            this.put(MalformedURLException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(NamingException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(NoResultException.class.getName(), Response.Status.NOT_FOUND);
            this.put(NoSuchMethodException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(NonUniqueResultException.class.getName(), Response.Status.NOT_FOUND);
            this.put(NumberFormatException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(OptimisticLockException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR);
            this.put(PersistenceException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR);
            this.put(PessimisticLockException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR);
            this.put(QueryTimeoutException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(RollbackException.class.getName(), Response.Status.BAD_REQUEST);
            this.put(TransactionRequiredException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    });
    private static final String PROBLEM_TYPE = "http://www.eclipse.org/eclipselink/documentation/";

    protected Response buildResponse(JPARSException exception) {
        URI requestURI;
        String path = null;
        exception.setHttpStatusCode(AbstractExceptionMapper.getHttpStatusCode(exception.getCause()));
        if (this.uriInfo != null && (requestURI = this.uriInfo.getRequestUri()) != null) {
            path = requestURI.getPath();
        }
        if (path != null && path.contains(ServiceVersion.VERSION_2_0.getCode())) {
            ErrorResponse errorResponse = new ErrorResponse(PROBLEM_TYPE, exception.getMessage(), String.valueOf(exception.getErrorCode()));
            errorResponse.setRequestId((String)DataStorage.get("requestId"));
            errorResponse.setHttpStatus(exception.getHttpStatusCode().getStatusCode());
            String error = this.marshallErrorResponse(errorResponse, StreamingOutputMarshaller.getResponseMediaType(this.headers).toString());
            if (error != null) {
                return Response.status((Response.Status)exception.getHttpStatusCode()).entity((Object)error).type(StreamingOutputMarshaller.getResponseMediaType(this.headers)).build();
            }
        }
        return Response.status((Response.Status)exception.getHttpStatusCode()).type(StreamingOutputMarshaller.getResponseMediaType(this.headers)).build();
    }

    private static Response.Status getHttpStatusCode(Throwable throwable) {
        if (throwable != null) {
            Throwable cause;
            Response.Status httpStatusCode = HTTP_STATUS_CODE_MAPPING.get(throwable.getClass().getName());
            if (throwable instanceof RollbackException && throwable != null && (cause = throwable.getCause()) != null && cause instanceof DatabaseException) {
                httpStatusCode = Response.Status.CONFLICT;
            }
            if (httpStatusCode != null) {
                return httpStatusCode;
            }
        }
        return Response.Status.BAD_REQUEST;
    }

    private String marshallErrorResponse(ErrorResponse errorResponse, String mediaType) {
        try {
            JAXBContext context = (JAXBContext)JAXBContextFactory.createContext(new Class[]{ErrorResponse.class}, null);
            JAXBMarshaller marshaller = context.createMarshaller();
            marshaller.setProperty("eclipselink.media-type", mediaType);
            marshaller.setProperty("eclipselink.json.include-root", Boolean.FALSE);
            marshaller.setProperty("eclipselink.json.reduce-any-arrays", true);
            StringWriter writer = new StringWriter();
            marshaller.marshal(errorResponse, writer);
            return writer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

