/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactory;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.ServiceVersion;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;

public class PersistenceFactoryBase
implements PersistenceContextFactory {
    protected Map<String, Set<PersistenceContext>> dynamicPersistenceContexts = new HashMap<String, Set<PersistenceContext>>();

    public PersistenceContext bootstrapPersistenceContext(String name, EntityManagerFactory emf, URI baseURI, String version, boolean replace) {
        return new PersistenceContext(name, (EntityManagerFactoryImpl)emf, baseURI, ServiceVersion.fromCode(version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            for (String key : this.dynamicPersistenceContexts.keySet()) {
                Set<PersistenceContext> contextSet = this.dynamicPersistenceContexts.get(key);
                if (contextSet == null) continue;
                for (PersistenceContext context : contextSet) {
                    context.stop();
                }
            }
            this.dynamicPersistenceContexts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePersistenceContext(String name) {
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            Set<PersistenceContext> contextSet = this.dynamicPersistenceContexts.get(name);
            if (contextSet != null) {
                for (PersistenceContext context : contextSet) {
                    context.stop();
                }
            }
            this.dynamicPersistenceContexts.remove(name);
        }
    }

    protected static Map<String, Object> createProperties(DynamicClassLoader dcl, Map<String, ?> originalProperties) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("eclipselink.classloader", dcl);
        properties.put("eclipselink.weaving", "static");
        for (Map.Entry<String, ?> entry : originalProperties.entrySet()) {
            if (!entry.getKey().startsWith("javax") && !entry.getKey().startsWith("eclipselink.log") && !entry.getKey().startsWith("eclipselink.target-server")) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistenceContext get(String persistenceUnitName, URI defaultURI, String version, Map<String, Object> initializationProperties) {
        PersistenceContext persistenceContext;
        block11: {
            persistenceContext = this.getDynamicPersistenceContext(persistenceUnitName, version);
            if (persistenceContext == null) {
                try {
                    EntityManagerFactoryImpl factory;
                    ClassLoader sessionLoader;
                    DynamicClassLoader dcl = new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put("eclipselink.classloader", dcl);
                    if (initializationProperties != null) {
                        properties.putAll(initializationProperties);
                    }
                    if (!DynamicClassLoader.class.isAssignableFrom((sessionLoader = (factory = (EntityManagerFactoryImpl)Persistence.createEntityManagerFactory((String)persistenceUnitName, properties)).getServerSession().getLoader()).getClass())) {
                        properties = new HashMap();
                        dcl = new DynamicClassLoader(sessionLoader);
                        properties.put("eclipselink.classloader", dcl);
                        if (initializationProperties != null) {
                            properties.putAll(initializationProperties);
                        }
                        factory.refreshMetadata(properties);
                    }
                    if (factory == null) break block11;
                    persistenceContext = this.bootstrapPersistenceContext(persistenceUnitName, factory, defaultURI, version, true);
                    Set<PersistenceContext> persistenceContextSet = this.getDynamicPersistenceContextSet(persistenceUnitName);
                    if (persistenceContext == null) break block11;
                    if (persistenceContextSet == null) {
                        persistenceContextSet = new HashSet<PersistenceContext>();
                    }
                    persistenceContextSet.add(persistenceContext);
                    PersistenceFactoryBase persistenceFactoryBase = this;
                    synchronized (persistenceFactoryBase) {
                        this.dynamicPersistenceContexts.put(persistenceUnitName, persistenceContextSet);
                    }
                }
                catch (Exception e) {
                    JPARSLogger.exception("exception_creating_persistence_context", new Object[]{persistenceUnitName, e.toString()}, e);
                }
            }
        }
        if (persistenceContext != null && !persistenceContext.isWeavingEnabled()) {
            JPARSLogger.error("weaving_required_for_relationships", new Object[0]);
            throw JPARSException.invalidConfiguration();
        }
        return persistenceContext;
    }

    @Override
    public Set<String> getPersistenceContextNames() {
        HashSet<String> contextNames = new HashSet<String>();
        try {
            Set<Archive> archives = PersistenceUnitProcessor.findPersistenceArchives();
            for (Archive archive : archives) {
                List<SEPersistenceUnitInfo> infos = PersistenceUnitProcessor.processPersistenceArchive(archive, Thread.currentThread().getContextClassLoader());
                for (SEPersistenceUnitInfo info : infos) {
                    if (info.getPersistenceUnitName().equals("jpa-rs") || EntityManagerSetupImpl.mustBeCompositeMember(info)) continue;
                    contextNames.add(info.getPersistenceUnitName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        contextNames.addAll(this.dynamicPersistenceContexts.keySet());
        return contextNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceContext getDynamicPersistenceContext(String name, String version) {
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            Set<PersistenceContext> persistenceContextSet = this.dynamicPersistenceContexts.get(name);
            if (persistenceContextSet != null) {
                for (PersistenceContext persistenceContext : persistenceContextSet) {
                    if (name != null && version != null) {
                        if (!name.equals(persistenceContext.getName()) || !version.equals(persistenceContext.getVersion())) continue;
                        return persistenceContext;
                    }
                    if (version != null || persistenceContext.getVersion() != null || name == null || !name.equals(persistenceContext.getName())) continue;
                    return persistenceContext;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<PersistenceContext> getDynamicPersistenceContextSet(String name) {
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            return this.dynamicPersistenceContexts.get(name);
        }
    }
}

