/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.cdi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.cdi.EntityListenerInjectionManager;

public class EntityListenerInjectionManagerImpl
implements EntityListenerInjectionManager {
    protected BeanManager beanManager = null;
    protected CreationalContext<Object> creationalContext = null;
    protected Map<Object, InjectionTarget<Object>> injectionTargets = null;

    public EntityListenerInjectionManagerImpl(Object beanManager) throws NamingException {
        if (beanManager != null) {
            this.beanManager = (BeanManager)beanManager;
        } else {
            InitialContext context = new InitialContext();
            beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
        }
        this.injectionTargets = new HashMap<Object, InjectionTarget<Object>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createEntityListenerAndInjectDependancies(Class entityListenerClass) throws NamingException {
        AnnotatedType aType = this.beanManager.createAnnotatedType(entityListenerClass);
        InjectionTarget injectionTarget = this.beanManager.createInjectionTarget(aType);
        Object entityListener = injectionTarget.produce(this.beanManager.createCreationalContext(null));
        Map<Object, InjectionTarget<Object>> map = this.injectionTargets;
        synchronized (map) {
            this.injectionTargets.put(entityListener, (InjectionTarget<Object>)injectionTarget);
        }
        this.creationalContext = this.beanManager.createCreationalContext(null);
        injectionTarget.inject(entityListener, this.creationalContext);
        injectionTarget.postConstruct(entityListener);
        return entityListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp(AbstractSession session) {
        HashSet<Object> keys = new HashSet<Object>();
        Map<Object, InjectionTarget<Object>> map = this.injectionTargets;
        synchronized (map) {
            keys.addAll(this.injectionTargets.keySet());
            for (Object e : keys) {
                try {
                    InjectionTarget<Object> target = this.injectionTargets.get(e);
                    target.preDestroy(e);
                    target.dispose(e);
                    this.injectionTargets.remove(e);
                }
                catch (Exception e2) {
                    session.logThrowable(1, "jpa", e2);
                }
            }
        }
        if (this.creationalContext != null) {
            this.creationalContext.release();
        }
    }
}

