/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.annotations.ReturnUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeAccessor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ForeignKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ClassInstanceMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConvertMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.LobMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.SerializedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.MapKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;

public abstract class MappingAccessor
extends MetadataAccessor {
    private static final String CONVERT_NONE = "none";
    private static final String CONVERT_SERIALIZED = "serialized";
    private static final String CONVERT_CLASS_INSTANCE = "class-instance";
    protected static final String KEY_DOT_NOTATION = "key.";
    protected static final String VALUE_DOT_NOTATION = "value.";
    private static final String DEFAULT_MAP_KEY_COLUMN_SUFFIX = "_KEY";
    private ClassAccessor m_classAccessor;
    private DatabaseMapping m_mapping;
    private DatabaseMapping m_overrideMapping;
    private Map<String, PropertyMetadata> m_properties = new HashMap<String, PropertyMetadata>();
    private String m_attributeType;
    protected ColumnMetadata m_field;

    protected MappingAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor.getDescriptor(), classAccessor.getProject());
        this.m_classAccessor = classAccessor;
        this.initAccess();
        if (this.isAnnotationPresent("org.eclipse.persistence.nosql.annotations.Field")) {
            this.m_field = new ColumnMetadata(this.getAnnotation("org.eclipse.persistence.nosql.annotations.Field"), this);
        }
        if (this.isAnnotationPresent("javax.persistence.Converts")) {
            Object[] objectArray = this.getAnnotation("javax.persistence.Converts").getAttributeArray("value");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object convert = objectArray[n2];
                this.addConvertMetadata(new ConvertMetadata((MetadataAnnotation)convert, this));
                ++n2;
            }
        }
        if (this.isAnnotationPresent("javax.persistence.Convert")) {
            this.addConvertMetadata(new ConvertMetadata(this.getAnnotation("javax.persistence.Convert"), this));
        }
    }

    protected MappingAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected void addConvert(ConvertMetadata convert) {
        throw ValidationException.invalidMappingForConvert(this.getJavaClassName(), this.getAttributeName());
    }

    protected void addConvertMetadata(ConvertMetadata convert) {
        if (convert.isForMapKey()) {
            this.addMapKeyConvert(convert);
        } else {
            this.addConvert(convert);
        }
    }

    protected void addFieldNameTranslation(EmbeddableMapping embeddableMapping, String overrideName, DatabaseField overrideField, MappingAccessor aggregatesAccessor) {
        DatabaseMapping aggregatesMapping = aggregatesAccessor.getMapping();
        DatabaseField aggregatesMappingField = aggregatesMapping.getField();
        if (aggregatesAccessor.isId()) {
            this.updatePrimaryKeyField(aggregatesAccessor, overrideField);
        }
        if (overrideName.indexOf(".") > -1) {
            embeddableMapping.addNestedFieldTranslation(overrideName, overrideField, aggregatesMappingField.getName());
        } else {
            embeddableMapping.addFieldTranslation(overrideField, aggregatesMappingField.getName());
        }
    }

    protected void addMapKeyConvert(ConvertMetadata convert) {
        throw ValidationException.invalidMappingForMapKeyConvert(this.getJavaClassName(), this.getAttributeName());
    }

    public boolean derivesId() {
        return false;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof MappingAccessor) {
            MappingAccessor mappingAccessor = (MappingAccessor)objectToCompare;
            if (!this.valuesMatch(this.getClassAccessor(), mappingAccessor.getClassAccessor())) {
                return false;
            }
            if (!this.valuesMatch(this.m_field, mappingAccessor.getField())) {
                return false;
            }
            return this.valuesMatch(this.getAttributeType(), mappingAccessor.getAttributeType());
        }
        return false;
    }

    @Override
    protected MetadataAnnotation getAnnotation(String annotation) {
        return this.getAccessibleObject().getAnnotation(annotation, this.getClassAccessor());
    }

    protected Map<String, AssociationOverrideMetadata> getAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides) {
        String name;
        HashMap<String, AssociationOverrideMetadata> associationOverridesMap = new HashMap<String, AssociationOverrideMetadata>();
        for (AssociationOverrideMetadata associationOverride : associationOverrides) {
            name = associationOverride.getName();
            String dotNotationName = String.valueOf(this.getAttributeName()) + "." + name;
            if (this.getClassAccessor().isMappedSuperclass() && this.getDescriptor().hasAssociationOverrideFor(dotNotationName)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logConfigMessage("metadata_warning_ignore_association_override", name, this.getAttributeName(), this.getClassAccessor().getJavaClassName(), this.getJavaClassName());
                associationOverridesMap.put(name, this.getDescriptor().getAssociationOverrideFor(dotNotationName));
                continue;
            }
            associationOverridesMap.put(name, associationOverride);
        }
        if (this.getClassAccessor().isMappedSuperclass()) {
            for (AssociationOverrideMetadata associationOverride : this.getDescriptor().getAssociationOverrides()) {
                String attributeName = name = associationOverride.getName();
                String overrideName = name;
                int indexOfFirstDot = name.indexOf(".");
                if (indexOfFirstDot > -1) {
                    attributeName = name.substring(0, indexOfFirstDot);
                    overrideName = name.substring(indexOfFirstDot + 1);
                }
                if (!attributeName.equals(this.getAttributeName()) || associationOverridesMap.containsKey(attributeName)) continue;
                associationOverridesMap.put(overrideName, associationOverride);
            }
        }
        return associationOverridesMap;
    }

    @Override
    public String getAttributeName() {
        if (this.hasAccessMethods()) {
            return this.getName();
        }
        return this.getAccessibleObject().getAttributeName();
    }

    protected AttributeOverrideMetadata getAttributeOverride(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_key_column")) {
            return this.getDescriptor().getAttributeOverrideFor(KEY_DOT_NOTATION + this.getAttributeName());
        }
        if (loggingCtx.equals("metadata_default_value_column") && this.getDescriptor().hasAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName())) {
            return this.getDescriptor().getAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName());
        }
        return this.getDescriptor().getAttributeOverrideFor(this.getAttributeName());
    }

    protected Map<String, AttributeOverrideMetadata> getAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        String name;
        HashMap<String, AttributeOverrideMetadata> attributeOverridesMap = new HashMap<String, AttributeOverrideMetadata>();
        for (AttributeOverrideMetadata attributeOverride : attributeOverrides) {
            name = attributeOverride.getName();
            String dotNotationName = String.valueOf(this.getAttributeName()) + "." + name;
            if (this.getClassAccessor().isMappedSuperclass() && this.getDescriptor().hasAttributeOverrideFor(dotNotationName)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logConfigMessage("metadata_warning_ignore_attribute_override", name, this.getAttributeName(), this.getClassAccessor().getJavaClassName(), this.getJavaClassName());
                attributeOverridesMap.put(name, this.getDescriptor().getAttributeOverrideFor(dotNotationName));
                continue;
            }
            attributeOverridesMap.put(name, attributeOverride);
        }
        if (this.getClassAccessor().isMappedSuperclass()) {
            for (AttributeOverrideMetadata attributeOverride : this.getDescriptor().getAttributeOverrides()) {
                String attributeName = name = attributeOverride.getName();
                String overrideName = name;
                int indexOfFirstDot = name.indexOf(".");
                if (indexOfFirstDot > -1) {
                    attributeName = name.substring(0, indexOfFirstDot);
                    overrideName = name.substring(indexOfFirstDot + 1);
                }
                if (!attributeName.equals(this.getAttributeName()) || attributeOverridesMap.containsKey(attributeName)) continue;
                attributeOverridesMap.put(overrideName, attributeOverride);
            }
        }
        return attributeOverridesMap;
    }

    public String getAttributeType() {
        return this.m_attributeType;
    }

    public ClassAccessor getClassAccessor() {
        return this.m_classAccessor;
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        return this.m_field == null ? new ColumnMetadata(this) : this.m_field;
    }

    protected List<ConvertMetadata> getConverts(List<ConvertMetadata> potentialConverts) {
        if (this.getDescriptor().hasConverts(this.getAttributeName())) {
            return this.getDescriptor().getConverts(this.getAttributeName());
        }
        return potentialConverts;
    }

    protected DatabaseField getDatabaseField(DatabaseTable defaultTable, String loggingCtx) {
        ColumnMetadata column = this.hasAttributeOverride(loggingCtx) ? this.getAttributeOverride(loggingCtx).getColumn() : this.getColumn(loggingCtx);
        DatabaseField field = column.getDatabaseField();
        if (!field.hasTableName()) {
            field.setTable(defaultTable);
        }
        if (this.getProject().useDelimitedIdentifier()) {
            field.getTable().setUseDelimiters(true);
        }
        String defaultName = this.getDefaultAttributeName();
        if (loggingCtx.equals("metadata_default_key_column")) {
            defaultName = String.valueOf(defaultName) + DEFAULT_MAP_KEY_COLUMN_SUFFIX;
        }
        this.setFieldName(field, defaultName, loggingCtx);
        this.getDescriptor().addField(field);
        return field;
    }

    protected String getDefaultFetchType() {
        return "EAGER";
    }

    protected DatabaseTable getDefaultTableForEntityMapKey() {
        return this.getReferenceDescriptor().getPrimaryTable();
    }

    public EnumeratedMetadata getEnumerated(boolean isForMapKey) {
        return null;
    }

    public ColumnMetadata getField() {
        return this.m_field;
    }

    protected ForeignKeyMetadata getForeignKey(ForeignKeyMetadata potentialForeignKey, MetadataDescriptor descriptor) {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            ForeignKeyMetadata foreignKey = this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getForeignKey();
            if (foreignKey != null) {
                foreignKey.setProject(descriptor.getProject());
            }
            return foreignKey;
        }
        return potentialForeignKey;
    }

    public String getGetMethodName() {
        return this.hasAccessMethods() ? this.getAccessMethods().getGetMethodName() : this.getAccessibleObjectName();
    }

    protected List<JoinColumnMetadata> getJoinColumns(List<JoinColumnMetadata> potentialJoinColumns, MetadataDescriptor descriptor) {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            return this.getJoinColumnsAndValidate(this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinColumns(), descriptor);
        }
        return this.getJoinColumnsAndValidate(potentialJoinColumns, descriptor);
    }

    protected List<JoinColumnMetadata> getJoinColumnsAndValidate(List<JoinColumnMetadata> joinColumns, MetadataDescriptor referenceDescriptor) {
        if (joinColumns.isEmpty()) {
            if (referenceDescriptor.hasCompositePrimaryKey()) {
                for (DatabaseField primaryKeyField : referenceDescriptor.getPrimaryKeyFields()) {
                    if (primaryKeyField.isPrimaryKey()) continue;
                    JoinColumnMetadata joinColumn = new JoinColumnMetadata();
                    joinColumn.setReferencedColumnName(primaryKeyField.getName());
                    joinColumn.setName(primaryKeyField.getName());
                    joinColumn.setProject(referenceDescriptor.getProject());
                    joinColumns.add(joinColumn);
                }
            } else {
                JoinColumnMetadata jcm = new JoinColumnMetadata();
                jcm.setProject(referenceDescriptor.getProject());
                joinColumns.add(jcm);
            }
        } else {
            for (JoinColumnMetadata joinColumn : joinColumns) {
                String referencedColumnName = joinColumn.getReferencedColumnName();
                if (referencedColumnName == null || this.isVariableOneToOne()) continue;
                DatabaseField referencedField = new DatabaseField();
                this.setFieldName(referencedField, referencedColumnName);
                joinColumn.setReferencedColumnName(referenceDescriptor.getPrimaryKeyJoinColumnAssociation(referencedField).getName());
            }
        }
        if (referenceDescriptor.hasSingleTableMultitenant() && joinColumns.size() != referenceDescriptor.getPrimaryKeyFields().size()) {
            Map<String, List<DatabaseField>> referenceTenantFields = referenceDescriptor.getSingleTableMultitenantFields();
            Map<String, List<DatabaseField>> tenantFields = this.getDescriptor().hasSingleTableMultitenant() ? this.getDescriptor().getSingleTableMultitenantFields() : null;
            for (String contextProperty : referenceTenantFields.keySet()) {
                List<DatabaseField> referenceFields = referenceTenantFields.get(contextProperty);
                for (DatabaseField referenceField : referenceFields) {
                    if (!referenceField.isPrimaryKey()) continue;
                    JoinColumnMetadata jcm = new JoinColumnMetadata();
                    jcm.setInsertable(false);
                    jcm.setUpdatable(false);
                    if (tenantFields != null && tenantFields.containsKey(contextProperty)) {
                        jcm.setName(tenantFields.get(contextProperty).get(0).getName());
                    } else {
                        jcm.setName(referenceField.getName());
                    }
                    jcm.setReferencedColumnName(referenceField.getName());
                    jcm.setProject(referenceDescriptor.getProject());
                    joinColumns.add(jcm);
                }
            }
        }
        if (referenceDescriptor.hasCompositePrimaryKey()) {
            if (joinColumns.size() != referenceDescriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
            for (JoinColumnMetadata joinColumn : joinColumns) {
                if (!joinColumn.isPrimaryKeyFieldNotSpecified() && !joinColumn.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
        }
        return joinColumns;
    }

    public LobMetadata getLob(boolean isForMapKey) {
        return null;
    }

    public DatabaseMapping getMapping() {
        return this.m_overrideMapping == null ? this.m_mapping : this.m_overrideMapping;
    }

    public MetadataDescriptor getOwningDescriptor() {
        return this.getClassAccessor().getOwningDescriptor();
    }

    public List<MetadataDescriptor> getOwningDescriptors() {
        return this.getClassAccessor().getOwningDescriptors();
    }

    public MapKeyMetadata getMapKey() {
        return null;
    }

    protected List<ConvertMetadata> getMapKeyConverts(List<ConvertMetadata> potentialMapKeyConverts) {
        if (this.getDescriptor().hasMapKeyConverts(this.getAttributeName())) {
            return this.getDescriptor().getMapKeyConverts(this.getAttributeName());
        }
        return potentialMapKeyConverts;
    }

    public MetadataClass getMapKeyReferenceClass() {
        MetadataClass mapKeyClass;
        if (this.isMappedKeyMapAccessor() && (mapKeyClass = ((MappedKeyMapAccessor)((Object)this)).getMapKeyClass()) != null && !mapKeyClass.isVoid()) {
            return mapKeyClass;
        }
        if (this.isMapAccessor()) {
            MetadataClass referenceClass = this.getAccessibleObject().getMapKeyClass(this.getDescriptor());
            if (referenceClass == null) {
                throw ValidationException.unableToDetermineMapKeyClass(this.getAttributeName(), this.getJavaClass());
            }
            if (this.getDescriptor().isMappedSuperclass()) {
                try {
                    MetadataHelper.getClassForName(referenceClass.getName(), this.getMetadataFactory().getLoader());
                }
                catch (ValidationException validationException) {
                    return this.getMetadataClass(Void.class);
                }
            }
            return referenceClass;
        }
        return this.getMetadataClass(Void.TYPE);
    }

    public String getMapKeyReferenceClassName() {
        return this.getMapKeyReferenceClass().getName();
    }

    public MetadataClass getMapKeyReferenceClassWithGenerics() {
        return this.getMapKeyReferenceClass();
    }

    public MetadataClass getRawClass() {
        if (this.hasAttributeType()) {
            return this.getMetadataClass(this.getAttributeType());
        }
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public MetadataClass getRawClassWithGenerics() {
        if (this.hasAttributeType()) {
            return this.getMetadataClass(this.getAttributeType());
        }
        return this.getAccessibleObject().getRawClassWithGenerics(this.getDescriptor());
    }

    public Collection<MappingAccessor> getReferenceAccessors() {
        return this.getReferenceDescriptor().getMappingAccessors();
    }

    public MetadataClass getReferenceClass() {
        return this.getRawClass();
    }

    public MetadataClass getReferenceClassWithGenerics() {
        return this.getRawClassWithGenerics();
    }

    public MetadataClass getReferenceClassFromGeneric() {
        return this.getAccessibleObject().getReferenceClassFromGeneric(this.getDescriptor());
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    protected DatabaseTable getReferenceDatabaseTable() {
        return this.getReferenceDescriptor().getPrimaryKeyTable();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        ClassAccessor accessor = this.getProject().getAccessor(this.getReferenceClassName());
        if (accessor == null) {
            throw ValidationException.classNotListedInPersistenceUnit(this.getReferenceClassName());
        }
        return accessor.getDescriptor();
    }

    public String getSetMethodName() {
        return this.hasAccessMethods() ? this.getAccessMethods().getSetMethodName() : ((MetadataMethod)this.getAccessibleObject()).getSetMethodName();
    }

    public TemporalMetadata getTemporal(boolean isForMapKey) {
        return null;
    }

    protected boolean hasAttributeOverride(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_key_column")) {
            return this.getDescriptor().hasAttributeOverrideFor(KEY_DOT_NOTATION + this.getAttributeName());
        }
        if (loggingCtx.equals("metadata_default_value_column") && this.getDescriptor().hasAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName())) {
            return true;
        }
        return this.getDescriptor().hasAttributeOverrideFor(this.getAttributeName());
    }

    public boolean hasAttributeType() {
        return this.m_attributeType != null;
    }

    protected boolean hasEnumerated(boolean isForMapKey) {
        return false;
    }

    protected boolean hasLob(boolean isForMapKey) {
        return false;
    }

    public boolean hasMapKey() {
        return false;
    }

    protected boolean hasReturnInsert() {
        return this.isAnnotationPresent(ReturnInsert.class);
    }

    protected boolean hasReturnUpdate() {
        return this.isAnnotationPresent(ReturnUpdate.class);
    }

    public boolean hasTemporal(boolean isForMapKey) {
        return false;
    }

    public void initXMLMappingAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
        this.setEntityMappings(classAccessor.getEntityMappings());
        this.initXMLAccessor(classAccessor.getDescriptor(), classAccessor.getProject());
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_field, accessibleObject);
    }

    @Override
    public boolean isAnnotationPresent(String annotation) {
        return this.getAccessibleObject().isAnnotationPresent(annotation, this.getClassAccessor());
    }

    public boolean isBasic() {
        return false;
    }

    public boolean isBasicCollection() {
        return false;
    }

    public boolean isBasicMap() {
        return false;
    }

    public boolean isDerivedIdClass() {
        return false;
    }

    public boolean isDirectCollection() {
        return false;
    }

    public boolean isDirectEmbeddableCollection() {
        return false;
    }

    public boolean isCollectionAccessor() {
        return false;
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isEmbeddedId() {
        return false;
    }

    protected boolean isEnumerated(MetadataClass referenceClass, boolean isForMapKey) {
        return this.hasEnumerated(isForMapKey) || EnumeratedMetadata.isValidEnumeratedType(referenceClass);
    }

    public boolean isId() {
        return false;
    }

    protected boolean isLob(MetadataClass referenceClass, boolean isForMapKey) {
        return this.hasLob(isForMapKey);
    }

    public boolean isManyToMany() {
        return false;
    }

    public boolean isManyToOne() {
        return false;
    }

    public boolean isMapAccessor() {
        return this.getAccessibleObject().isSupportedMapClass(this.getRawClass());
    }

    public boolean isMappedKeyMapAccessor() {
        return MappedKeyMapAccessor.class.isAssignableFrom(this.getClass()) && this.isMapAccessor() && !this.hasMapKey();
    }

    public boolean isMultitenantId() {
        return false;
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isOneToOne() {
        return false;
    }

    protected boolean isPrimitiveWrapperClass(MetadataClass cls) {
        return cls.extendsClass(Number.class) || cls.equals(Boolean.class) || cls.equals(Character.class) || cls.equals(String.class) || cls.extendsClass(BigInteger.class) || cls.extendsClass(BigDecimal.class) || cls.extendsClass(Date.class) || cls.extendsClass(Calendar.class);
    }

    @Override
    public boolean isProcessed() {
        return this.m_mapping != null;
    }

    public boolean isRelationship() {
        return this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne() || this.isVariableOneToOne();
    }

    public boolean isSerialized(MetadataClass referenceClass, boolean isForMapKey) {
        return this.isValidSerializedType(referenceClass);
    }

    protected boolean isTemporal(MetadataClass referenceClass, boolean isForMapKey) {
        return this.hasTemporal(isForMapKey) || TemporalMetadata.isValidTemporalType(referenceClass);
    }

    public boolean isTransient() {
        return false;
    }

    protected boolean isValidSerializedType(MetadataClass cls) {
        if (cls.isPrimitive()) {
            return false;
        }
        if (this.isPrimitiveWrapperClass(cls)) {
            return false;
        }
        if (LobMetadata.isValidLobType(cls)) {
            return false;
        }
        return !TemporalMetadata.isValidTemporalType(cls);
    }

    public boolean isVariableOneToOne() {
        return false;
    }

    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        throw ValidationException.invalidEmbeddableAttributeForAssociationOverride(this.getJavaClass(), this.getAttributeName(), associationOverride.getName(), associationOverride.getLocation());
    }

    protected void processAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides, EmbeddableMapping embeddableMapping, MetadataDescriptor embeddableDescriptor) {
        Map<String, AssociationOverrideMetadata> mergedAssociationOverrides = this.getAssociationOverrides(associationOverrides);
        for (String attributeName : mergedAssociationOverrides.keySet()) {
            AssociationOverrideMetadata associationOverride = mergedAssociationOverrides.get(attributeName);
            MappingAccessor mappingAccessor = embeddableDescriptor.getMappingAccessor(attributeName);
            if (mappingAccessor == null) {
                throw ValidationException.embeddableAssociationOverrideNotFound(embeddableDescriptor.getJavaClass(), attributeName, this.getJavaClass(), this.getAttributeName());
            }
            mappingAccessor.processAssociationOverride(associationOverride, embeddableMapping, this.getOwningDescriptor());
        }
    }

    protected void processAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides, AggregateObjectMapping aggregateObjectMapping, MetadataDescriptor embeddableDescriptor) {
        Map<String, AttributeOverrideMetadata> mergedAttributeOverrides = this.getAttributeOverrides(attributeOverrides);
        for (String attributeName : mergedAttributeOverrides.keySet()) {
            AttributeOverrideMetadata attributeOverride = mergedAttributeOverrides.get(attributeName);
            MappingAccessor mappingAccessor = embeddableDescriptor.getMappingAccessor(attributeName);
            if (mappingAccessor == null) {
                throw ValidationException.embeddableAttributeOverrideNotFound(embeddableDescriptor.getJavaClass(), attributeName, this.getJavaClass(), this.getAttributeName());
            }
            if (!mappingAccessor.isBasic()) {
                throw ValidationException.invalidEmbeddableAttributeForAttributeOverride(embeddableDescriptor.getJavaClass(), attributeName, this.getJavaClass(), this.getAttributeName());
            }
            this.addFieldNameTranslation(aggregateObjectMapping, attributeName, attributeOverride.getColumn().getDatabaseField(), mappingAccessor);
        }
    }

    protected void processBatchFetch(String batchFetch, ForeignReferenceMapping mapping) {
        if (batchFetch != null) {
            mapping.setBatchFetchType(BatchFetchType.valueOf(batchFetch));
        }
    }

    protected void processContainerPolicyAndIndirection(ContainerMapping mapping) {
        if (this.isMappedKeyMapAccessor()) {
            this.processMapKeyClass(mapping, (MappedKeyMapAccessor)((Object)this));
        } else if (this.isMapAccessor()) {
            MapKeyMetadata mapKey = this.getMapKey();
            if (mapKey == null) {
                this.setIndirectionPolicy(mapping, new MapKeyMetadata().process(mapping, this), this.usesIndirection());
            } else {
                this.setIndirectionPolicy(mapping, mapKey.process(mapping, this), this.usesIndirection());
            }
        } else {
            this.setIndirectionPolicy(mapping, null, this.usesIndirection());
        }
    }

    protected void processConvert(DatabaseMapping mapping, String converterName, MetadataClass referenceClass, boolean isForMapKey, boolean hasConverts) {
        if (converterName.equals(CONVERT_SERIALIZED)) {
            this.processSerialized(mapping, referenceClass, isForMapKey);
        } else if (converterName.equals(CONVERT_CLASS_INSTANCE)) {
            new ClassInstanceMetadata().process(mapping, this, referenceClass, isForMapKey);
        } else {
            AbstractConverterMetadata converter = this.getProject().getConverter(converterName);
            if (converter == null) {
                throw ValidationException.converterNotFound(this.getJavaClass(), converterName, this.getAnnotatedElement());
            }
            converter.process(mapping, this, referenceClass, isForMapKey);
        }
        if (this.hasEnumerated(isForMapKey)) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_enumerated", this.getJavaClass(), this.getAnnotatedElement());
        }
        if (this.hasLob(isForMapKey)) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_lob", this.getJavaClass(), this.getAnnotatedElement());
        }
        if (this.hasTemporal(isForMapKey)) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_temporal", this.getJavaClass(), this.getAnnotatedElement());
        }
        if (this.isValidSerializedType(referenceClass)) {
            this.getLogger().logConfigMessage("metadata_warning_ignore_serialized", this.getJavaClass(), (Object)this.getAnnotatedElement());
        }
        if (hasConverts) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_converts", this.getJavaClass(), this.getAnnotatedElement());
        }
        if (this.getProject().hasAutoApplyConverter(referenceClass)) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_auto_apply_converter", this.getJavaClass(), this.getAnnotatedElement());
        }
    }

    protected void processConverts(List<ConvertMetadata> converts, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (converts != null) {
            for (ConvertMetadata convert : converts) {
                convert.process(mapping, referenceClass, this.getClassAccessor(), isForMapKey);
            }
        }
    }

    protected AbstractDirectMapping processDirectMapKeyClass(MappedKeyMapAccessor mappedKeyMapAccessor) {
        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        DatabaseField mapKeyField = this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_key_column");
        keyMapping.setField(mapKeyField);
        keyMapping.setIsReadOnly(mapKeyField.isReadOnly());
        keyMapping.setAttributeClassificationName(mappedKeyMapAccessor.getMapKeyClass().getName());
        keyMapping.setDescriptor(this.getDescriptor().getClassDescriptor());
        this.processMappingKeyConverter(keyMapping, mappedKeyMapAccessor.getMapKeyConvert(), mappedKeyMapAccessor.getMapKeyConverts(), mappedKeyMapAccessor.getMapKeyClass(), mappedKeyMapAccessor.getMapKeyClassWithGenerics());
        return keyMapping;
    }

    protected AggregateObjectMapping processEmbeddableMapKeyClass(MappedKeyMapAccessor mappedKeyMapAccessor) {
        AggregateObjectMapping keyMapping = new AggregateObjectMapping();
        MetadataClass mapKeyClass = mappedKeyMapAccessor.getMapKeyClass();
        keyMapping.setReferenceClassName(mapKeyClass.getName());
        EmbeddableAccessor mapKeyAccessor = this.getProject().getEmbeddableAccessor(mapKeyClass);
        mapKeyAccessor.getDescriptor().setIsEmbeddable();
        this.processAttributeOverrides(mappedKeyMapAccessor.getMapKeyAttributeOverrides(), keyMapping, mapKeyAccessor.getDescriptor());
        this.processAssociationOverrides(mappedKeyMapAccessor.getMapKeyAssociationOverrides(), keyMapping, mapKeyAccessor.getDescriptor());
        this.processConverts(this.getMapKeyConverts(mappedKeyMapAccessor.getMapKeyConverts()), keyMapping, mappedKeyMapAccessor.getMapKeyClass(), true);
        keyMapping.setDescriptor(this.getDescriptor().getClassDescriptor());
        return keyMapping;
    }

    protected OneToOneMapping processEntityMapKeyClass(MappedKeyMapAccessor mappedKeyMapAccessor) {
        String mapKeyClassName = mappedKeyMapAccessor.getMapKeyClass().getName();
        OneToOneMapping keyMapping = new OneToOneMapping();
        keyMapping.setReferenceClassName(mapKeyClassName);
        keyMapping.dontUseIndirection();
        keyMapping.setDescriptor(this.getDescriptor().getClassDescriptor());
        EntityAccessor mapKeyAccessor = this.getProject().getEntityAccessor(mapKeyClassName);
        MetadataDescriptor mapKeyClassDescriptor = mapKeyAccessor.getDescriptor();
        String defaultFKFieldName = String.valueOf(this.getAttributeName()) + DEFAULT_MAP_KEY_COLUMN_SUFFIX;
        List<JoinColumnMetadata> joinColumns = this.getJoinColumns(mappedKeyMapAccessor.getMapKeyJoinColumns(), mapKeyClassDescriptor);
        ForeignKeyMetadata foreignKey = this.getForeignKey(mappedKeyMapAccessor.getMapKeyForeignKey(), mapKeyClassDescriptor);
        this.processForeignKeyRelationship(keyMapping, joinColumns, foreignKey, mapKeyClassDescriptor, defaultFKFieldName, this.getDefaultTableForEntityMapKey());
        return keyMapping;
    }

    protected void processEnumerated(EnumeratedMetadata enumerated, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (enumerated == null) {
            enumerated = new EnumeratedMetadata(this);
        }
        enumerated.process(mapping, this, referenceClass, isForMapKey);
    }

    protected void processJoinFetch(String joinFetch, ForeignReferenceMapping mapping) {
        if (joinFetch == null) {
            mapping.setJoinFetch(0);
        } else if (joinFetch.equals(JoinFetchType.INNER.name())) {
            mapping.setJoinFetch(1);
        } else {
            mapping.setJoinFetch(2);
        }
    }

    protected void processLob(LobMetadata lob, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        lob.process(mapping, this, referenceClass, isForMapKey);
    }

    protected void processMapKeyClass(ContainerMapping mapping, MappedKeyMapAccessor mappedKeyMapAccessor) {
        Class<Hashtable> containerClass;
        MetadataClass mapKeyClass = mappedKeyMapAccessor.getMapKeyClass();
        DatabaseMapping keyMapping = this.getProject().hasEntity(mapKeyClass) ? this.processEntityMapKeyClass(mappedKeyMapAccessor) : (this.getProject().hasEmbeddable(mapKeyClass) ? this.processEmbeddableMapKeyClass(mappedKeyMapAccessor) : this.processDirectMapKeyClass(mappedKeyMapAccessor));
        if (mapping instanceof ForeignReferenceMapping) {
            if (this.usesIndirection()) {
                containerClass = ClassConstants.IndirectMap_Class;
                ((ForeignReferenceMapping)((Object)mapping)).setIndirectionPolicy(new TransparentIndirectionPolicy());
            } else {
                containerClass = Hashtable.class;
                ((ForeignReferenceMapping)((Object)mapping)).dontUseIndirection();
            }
        } else {
            containerClass = Hashtable.class;
        }
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(containerClass);
        policy.setKeyMapping((MapKeyMapping)((Object)keyMapping));
        policy.setValueMapping((MapComponentMapping)((Object)mapping));
        mapping.setContainerPolicy(policy);
    }

    protected void processMappingConverter(DatabaseMapping mapping, String convertValue, List<ConvertMetadata> converts, MetadataClass referenceClass, MetadataClass referenceClassWithGenerics, boolean isForMapKey) {
        boolean hasConverts;
        boolean bl = hasConverts = converts != null && !converts.isEmpty();
        if (convertValue != null && !convertValue.equals(CONVERT_NONE)) {
            this.processConvert(mapping, convertValue, referenceClass, isForMapKey, hasConverts);
        } else if (hasConverts) {
            this.processConverts(converts, mapping, referenceClass, isForMapKey);
        } else if (this.getProject().hasAutoApplyConverter(referenceClassWithGenerics)) {
            this.getProject().getAutoApplyConverter(referenceClassWithGenerics).process(mapping, isForMapKey, null);
        } else if (this.isEnumerated(referenceClass, isForMapKey)) {
            this.processEnumerated(this.getEnumerated(isForMapKey), mapping, referenceClass, isForMapKey);
        } else if (this.isLob(referenceClass, isForMapKey)) {
            this.processLob(this.getLob(isForMapKey), mapping, referenceClass, isForMapKey);
        } else if (this.isTemporal(referenceClass, isForMapKey)) {
            this.processTemporal(this.getTemporal(isForMapKey), mapping, referenceClass, isForMapKey);
        } else if (this.isSerialized(referenceClass, isForMapKey)) {
            this.processSerialized(mapping, referenceClass, isForMapKey);
        }
    }

    protected void processMappingKeyConverter(DatabaseMapping mapping, String convertValue, List<ConvertMetadata> converts, MetadataClass referenceClass, MetadataClass referenceClassWithGenerics) {
        this.processMappingConverter(mapping, convertValue, this.getMapKeyConverts(converts), referenceClass, referenceClassWithGenerics, true);
    }

    protected void processMappingValueConverter(DatabaseMapping mapping, String convertValue, List<ConvertMetadata> converts, MetadataClass referenceClass, MetadataClass referenceClassWithGenerics) {
        this.processMappingConverter(mapping, convertValue, this.getConverts(converts), referenceClass, referenceClassWithGenerics, false);
    }

    protected void processForeignKeyRelationship(ForeignReferenceMapping mapping, List<JoinColumnMetadata> joinColumns, ForeignKeyMetadata foreignKey, MetadataDescriptor referenceDescriptor, String defaultFKFieldName, DatabaseTable defaultFKTable) {
        boolean allReadOnly = true;
        HashMap<DatabaseField, DatabaseField> fields = new HashMap<DatabaseField, DatabaseField>();
        for (JoinColumnMetadata joinColumn : joinColumns) {
            DatabaseField pkField = this.getReferencedField(joinColumn.getReferencedColumnName(), referenceDescriptor, "metadata_default_pk_column");
            DatabaseField fkField = joinColumn.getForeignKeyField(pkField);
            this.setFieldName(fkField, defaultFKFieldName, "metadata_default_fk_column");
            if (!fkField.hasTableName()) {
                fkField.setTable(defaultFKTable);
            }
            fields.put(fkField, pkField);
            boolean bl = allReadOnly = allReadOnly && fkField.isReadOnly();
        }
        DatabaseTable foreignKeyTable = null;
        for (DatabaseField fkField : fields.keySet()) {
            DatabaseField pkField = (DatabaseField)fields.get(fkField);
            if (allReadOnly || !fkField.isReadOnly()) {
                mapping.addForeignKeyField(fkField, pkField);
            } else {
                mapping.addTargetForeignKeyField(pkField, fkField);
            }
            if (foreignKeyTable != null) continue;
            foreignKeyTable = fkField.getTable();
        }
        mapping.setIsReadOnly(allReadOnly);
        if (foreignKey != null) {
            foreignKey.process(foreignKeyTable);
        }
    }

    protected void processProperties(DatabaseMapping mapping) {
        if (this.loadedFromXML()) {
            for (PropertyMetadata property : this.getProperties()) {
                this.processProperty(mapping, property);
            }
        } else {
            Object property;
            MetadataAnnotation properties = this.getAnnotation(Properties.class);
            if (properties != null) {
                Object[] objectArray = properties.getAttributeArray("value");
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    property = objectArray[n2];
                    this.processProperty(mapping, new PropertyMetadata((MetadataAnnotation)property, this));
                    ++n2;
                }
            }
            if ((property = this.getAnnotation(Property.class)) != null) {
                this.processProperty(mapping, new PropertyMetadata((MetadataAnnotation)property, this));
            }
        }
    }

    protected void processProperty(DatabaseMapping mapping, PropertyMetadata property) {
        if (property.shouldOverride(this.m_properties.get(property.getName()))) {
            this.m_properties.put(property.getName(), property);
            mapping.addUnconvertedProperty(property.getName(), property.getValue(), this.getJavaClassName(property.getValueType()));
        }
    }

    protected void processReturnInsert() {
        if (this.hasReturnInsert()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_insert", this.getAnnotatedElement());
        }
    }

    protected void processReturnInsertAndUpdate() {
        this.processReturnInsert();
        this.processReturnUpdate();
    }

    protected void processReturnUpdate() {
        if (this.hasReturnUpdate()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_update", this.getAnnotatedElement());
        }
    }

    protected void processSerialized(DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        new SerializedMetadata(this).process(mapping, this, referenceClass, isForMapKey);
    }

    protected void processSerialized(DatabaseMapping mapping, MetadataClass referenceClass, MetadataClass classification, boolean isForMapKey) {
        new SerializedMetadata(this).process(mapping, this, referenceClass, classification, isForMapKey);
    }

    protected void processTemporal(TemporalMetadata temporal, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (temporal == null) {
            throw ValidationException.noTemporalTypeSpecified(this.getAttributeName(), this.getJavaClass());
        }
        temporal.process(mapping, this, referenceClass, isForMapKey);
    }

    protected void setAccessorMethods(DatabaseMapping mapping) {
        if (this.usesPropertyAccess() || this.usesVirtualAccess()) {
            if (this.usesVirtualAccess()) {
                mapping.setAttributeAccessor(new VirtualAttributeAccessor());
            }
            mapping.setGetMethodName(this.getGetMethodName());
            mapping.setSetMethodName(this.getSetMethodName());
        }
    }

    public void setAttributeType(String attributeType) {
        this.m_attributeType = attributeType;
    }

    public void setClassAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
    }

    public void setField(ColumnMetadata column) {
        this.m_field = column;
    }

    protected void setIndirectionPolicy(ContainerMapping mapping, String mapKey, boolean usesIndirection) {
        MetadataClass rawClass = this.getRawClass();
        if (usesIndirection && mapping instanceof ForeignReferenceMapping) {
            CollectionMapping collectionMapping = (CollectionMapping)mapping;
            if (rawClass.equals(Map.class)) {
                if (collectionMapping.isDirectMapMapping()) {
                    ((DirectMapMapping)mapping).useTransparentMap();
                } else {
                    collectionMapping.useTransparentMap(mapKey);
                }
            } else if (rawClass.equals(List.class)) {
                collectionMapping.useTransparentList();
            } else if (rawClass.equals(Collection.class)) {
                collectionMapping.useTransparentCollection();
            } else if (rawClass.equals(Set.class)) {
                collectionMapping.useTransparentSet();
            } else {
                this.getLogger().logWarningMessage("non_jpa_allowed_type_used_for_collection_using_lazy_access", this.getJavaClass(), this.getAnnotatedElement(), rawClass);
            }
        } else {
            if (mapping instanceof CollectionMapping) {
                ((CollectionMapping)mapping).dontUseIndirection();
            }
            if (rawClass.equals(Map.class)) {
                if (mapping instanceof DirectMapMapping) {
                    ((DirectMapMapping)mapping).useMapClass(Hashtable.class);
                } else {
                    mapping.useMapClass(Hashtable.class, mapKey);
                }
            } else if (rawClass.equals(Set.class)) {
                mapping.useCollectionClass(HashSet.class);
            } else if (rawClass.equals(List.class)) {
                mapping.useCollectionClass(Vector.class);
            } else if (rawClass.equals(Collection.class)) {
                mapping.setContainerPolicy(new CollectionContainerPolicy(Vector.class));
            } else if (mapKey == null || mapKey.equals("")) {
                if (rawClass.isList()) {
                    mapping.useListClassName(rawClass.getName());
                } else {
                    mapping.useCollectionClassName(rawClass.getName());
                }
            } else {
                mapping.useMapClassName(rawClass.getName(), mapKey);
            }
        }
    }

    protected void setMapping(DatabaseMapping mapping) {
        if (!this.isMultitenantId()) {
            this.processProperties(mapping);
        }
        this.getDescriptor().getClassDescriptor().addMapping(mapping);
        this.m_mapping = mapping;
    }

    protected void setOverrideMapping(DatabaseMapping mapping) {
        this.m_overrideMapping = mapping;
    }

    public String toString() {
        return this.getAnnotatedElementName();
    }

    protected void updatePrimaryKeyField(MappingAccessor idAccessor, DatabaseField overrideField) {
        this.getOwningDescriptor().removePrimaryKeyField(idAccessor.getMapping().getField());
        this.getOwningDescriptor().addPrimaryKeyField(overrideField, idAccessor);
    }

    protected boolean usesIndirection() {
        return false;
    }

    public boolean usesPropertyAccess() {
        if (this.hasAccess()) {
            return this.getAccess().equals("PROPERTY");
        }
        return this.hasAccessMethods() ? !this.usesVirtualAccess() : this.m_classAccessor.usesPropertyAccess();
    }

    public boolean usesVirtualAccess() {
        if (this.hasAccess()) {
            return this.getAccess().equals("VIRTUAL");
        }
        return this.m_classAccessor.usesVirtualAccess();
    }

    public boolean usesFieldAccess() {
        if (this.hasAccess()) {
            return this.getAccess().equals("FIELD");
        }
        return this.m_classAccessor.usesFieldAccess();
    }
}

