/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.json.schema;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.jaxb.json.schema.model.JsonSchema;
import org.eclipse.persistence.internal.jaxb.json.schema.model.JsonType;
import org.eclipse.persistence.internal.jaxb.json.schema.model.Property;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.CollectionReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.DirectCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.DirectMapping;
import org.eclipse.persistence.internal.oxm.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.XMLConverterMapping;
import org.eclipse.persistence.internal.oxm.record.namespaces.MapNamespacePrefixMapper;
import org.eclipse.persistence.jaxb.JAXBEnumTypeConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.sessions.Project;

public class JsonSchemaGenerator {
    Project project;
    JsonSchema schema;
    Map contextProperties;
    String attributePrefix;
    Class rootClass;
    boolean namespaceAware;
    NamespaceResolver resolver;
    String NAMESPACE_SEPARATOR = ".";
    NamespacePrefixMapper prefixMapper = null;
    Property[] xopIncludeProp = null;
    XMLContext xmlContext;
    private static String DEFINITION_PATH = "#/definitions";
    private static HashMap<Class, JsonType> javaTypeToJsonType;

    public JsonSchemaGenerator(XMLContext context, Map properties) {
        this.xmlContext = context;
        this.contextProperties = properties;
        if (properties != null) {
            String namespaceSeparator;
            this.attributePrefix = (String)properties.get("eclipselink.json.attribute-prefix");
            Object prefixMapperValue = properties.get("eclipselink.namespace-prefix-mapper");
            if (prefixMapperValue != null) {
                this.prefixMapper = prefixMapperValue instanceof Map ? new MapNamespacePrefixMapper((Map)prefixMapperValue) : (NamespacePrefixMapper)prefixMapperValue;
            }
            if (this.prefixMapper != null && (namespaceSeparator = (String)properties.get("eclipselink.json.namespace-separator")) != null) {
                this.NAMESPACE_SEPARATOR = namespaceSeparator;
            }
        }
    }

    public JsonSchema generateSchema(Class rootClass) {
        JsonType type;
        XMLField field;
        this.rootClass = rootClass;
        this.schema = new JsonSchema();
        this.schema.setTitle(rootClass.getName());
        JsonType rootType = this.getJsonTypeForJavaType(rootClass);
        if (rootType != JsonType.OBJECT) {
            this.schema.setType(rootType);
            return this.schema;
        }
        Map<String, Property> properties = null;
        if (rootClass.isArray() || this.isCollection(rootClass)) {
            this.schema.setType(JsonType.ARRAY);
            this.schema.setItems(new Property());
            Class itemType = Object.class;
            if (rootClass.isArray()) {
                itemType = rootClass.getComponentType();
            } else {
                Type pType = rootClass.getGenericSuperclass();
                if (pType instanceof ParameterizedType) {
                    itemType = (Class)((ParameterizedType)pType).getActualTypeArguments()[0];
                }
            }
            rootType = this.getJsonTypeForJavaType(itemType);
            this.schema.getItems().setType(rootType);
            if (rootType != JsonType.OBJECT) {
                return this.schema;
            }
            rootClass = itemType;
            properties = this.schema.getItems().getProperties();
        } else {
            this.schema.setType(JsonType.OBJECT);
            properties = this.schema.getProperties();
        }
        this.project = this.xmlContext.getSession(rootClass).getProject();
        XMLDescriptor descriptor = (XMLDescriptor)this.project.getDescriptor(rootClass);
        Property rootProperty = null;
        if (this.contextProperties != null && Boolean.TRUE.equals(this.contextProperties.get("eclipselink.json.include-root")) && (field = descriptor.getDefaultRootElementField()) != null) {
            rootProperty = new Property();
            rootProperty.setType(JsonType.OBJECT);
            rootProperty.setName(field.getXPathFragment().getLocalName());
            properties.put(rootProperty.getName(), rootProperty);
            properties = rootProperty.getProperties();
        }
        if ((type = this.populateProperties(properties, descriptor)) != null) {
            if (rootProperty != null) {
                rootProperty.setType(type);
            } else {
                this.schema.setType(type);
            }
        }
        return this.schema;
    }

    private JsonType populateProperties(Map<String, Property> properties, XMLDescriptor descriptor) {
        Vector<DatabaseMapping> mappings = descriptor.getMappings();
        if (mappings.size() == 1) {
            XPathFragment frag;
            XMLConverterMapping directMapping;
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(0);
            if (mapping instanceof DirectMapping) {
                directMapping = (DirectMapping)((Object)mapping);
                frag = ((XMLField)directMapping.getField()).getXPathFragment();
                if (frag.nameIsText()) {
                    return this.getJsonTypeForJavaType(directMapping.getAttributeClassification());
                }
            } else if (mapping instanceof DirectCollectionMapping && (frag = ((XMLField)(directMapping = (DirectCollectionMapping)((Object)mapping)).getField()).getXPathFragment()).nameIsText()) {
                return this.getJsonTypeForJavaType(directMapping.getAttributeElementClass());
            }
        }
        for (DatabaseMapping next : mappings) {
            Property prop;
            XMLConverterMapping coMapping;
            if (next instanceof ChoiceObjectMapping) {
                coMapping = (ChoiceObjectMapping)((Object)next);
                for (Object nestedMapping : coMapping.getChoiceElementMappingsByClass().values()) {
                    prop = this.generateProperty((XMLMapping)nestedMapping, descriptor, properties);
                    if (properties.containsKey(prop.getName())) continue;
                    properties.put(prop.getName(), prop);
                }
                continue;
            }
            if (next instanceof ChoiceCollectionMapping) {
                coMapping = (ChoiceCollectionMapping)((Object)next);
                for (Object nestedMapping : coMapping.getChoiceElementMappingsByClass().values()) {
                    prop = this.generateProperty((XMLMapping)nestedMapping, descriptor, properties);
                    if (properties.containsKey(prop.getName())) continue;
                    properties.put(prop.getName(), prop);
                }
                continue;
            }
            Property prop2 = this.generateProperty((XMLMapping)((Object)next), descriptor, properties);
            if (prop2 == null || properties.containsKey(prop2.getName())) continue;
            properties.put(prop2.getName(), prop2);
        }
        return null;
    }

    private Property generateProperty(XMLMapping next, XMLDescriptor descriptor, Map<String, Property> properties) {
        Property prop = null;
        if (next.isCollectionMapping()) {
            if (next instanceof CollectionReferenceMapping) {
                CollectionReferenceMapping mapping = (CollectionReferenceMapping)((Object)next);
                Set sourceFields = mapping.getSourceToTargetKeyFieldAssociations().keySet();
                XMLDescriptor reference = (XMLDescriptor)mapping.getReferenceDescriptor();
                for (XMLField nextField : sourceFields) {
                    XPathFragment frag = nextField.getXPathFragment();
                    String propertyName = this.getNameForFragment(frag);
                    XMLField targetField = (XMLField)mapping.getSourceToTargetKeyFieldAssociations().get(nextField);
                    Class type = this.getTypeForTargetField(targetField, reference);
                    prop = properties.get(propertyName);
                    if (prop == null) {
                        prop = new Property();
                        prop.setName(propertyName);
                    }
                    Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                    nestedProperty.setType(JsonType.ARRAY);
                    nestedProperty.setItem(new Property());
                    nestedProperty.getItem().setType(this.getJsonTypeForJavaType(type));
                    if (properties.containsKey(prop.getName())) continue;
                    properties.put(prop.getName(), prop);
                }
                return null;
            }
            if (next.isAbstractCompositeCollectionMapping()) {
                CompositeCollectionMapping mapping = (CompositeCollectionMapping)((Object)next);
                XMLField field = (XMLField)mapping.getField();
                XPathFragment frag = field.getXPathFragment();
                String propName = this.getNameForFragment(frag);
                prop = properties.get(propName);
                if (prop == null) {
                    prop = new Property();
                    prop.setName(propName);
                }
                Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                nestedProperty.setType(JsonType.ARRAY);
                nestedProperty.setItem(new Property());
                nestedProperty.getItem().setRef(this.getReferenceForDescriptor((XMLDescriptor)mapping.getReferenceDescriptor()));
            } else {
                if (next.isAbstractCompositeDirectCollectionMapping()) {
                    DirectCollectionMapping mapping = (DirectCollectionMapping)((Object)next);
                    XMLField field = (XMLField)mapping.getField();
                    XPathFragment frag = field.getXPathFragment();
                    ArrayList<String> enumeration = null;
                    if (mapping.getValueConverter() instanceof JAXBEnumTypeConverter) {
                        JAXBEnumTypeConverter conv = (JAXBEnumTypeConverter)mapping.getValueConverter();
                        enumeration = new ArrayList<String>();
                        for (Object nextValue : conv.getAttributeToFieldValues().values()) {
                            enumeration.add(nextValue.toString());
                        }
                    }
                    String propertyName = this.getNameForFragment(frag);
                    if (frag.nameIsText()) {
                        propertyName = (String)this.contextProperties.get("eclipselink.json.value-wrapper");
                    }
                    if (frag.isAttribute() && this.attributePrefix != null) {
                        propertyName = String.valueOf(this.attributePrefix) + propertyName;
                    }
                    if ((prop = properties.get(propertyName)) == null) {
                        prop = new Property();
                        prop.setName(propertyName);
                    }
                    Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                    nestedProperty.setType(JsonType.ARRAY);
                    nestedProperty.setItem(new Property());
                    if (enumeration != null) {
                        nestedProperty.getItem().setEnumeration(enumeration);
                    }
                    nestedProperty.getItem().setType(this.getJsonTypeForJavaType(mapping.getAttributeElementClass()));
                    return prop;
                }
                if (next instanceof BinaryDataCollectionMapping) {
                    BinaryDataCollectionMapping mapping = (BinaryDataCollectionMapping)((Object)next);
                    XMLField field = (XMLField)mapping.getField();
                    XPathFragment frag = field.getXPathFragment();
                    String propertyName = this.getNameForFragment(frag);
                    if (frag.nameIsText()) {
                        propertyName = (String)this.contextProperties.get("eclipselink.json.value-wrapper");
                    }
                    if (frag.isAttribute() && this.attributePrefix != null) {
                        propertyName = String.valueOf(this.attributePrefix) + propertyName;
                    }
                    if ((prop = properties.get(propertyName)) == null) {
                        prop = new Property();
                        prop.setName(propertyName);
                    }
                    Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                    nestedProperty.setType(JsonType.ARRAY);
                    nestedProperty.setItem(new Property());
                    if (mapping.shouldInlineBinaryData()) {
                        nestedProperty.getItem().setType(JsonType.STRING);
                    } else {
                        nestedProperty.getItem().setAnyOf(this.getXopIncludeProperties());
                    }
                    return prop;
                }
            }
        } else {
            if (next.isAbstractDirectMapping()) {
                DirectMapping directMapping = (DirectMapping)((Object)next);
                XMLField field = (XMLField)directMapping.getField();
                XPathFragment frag = field.getXPathFragment();
                ArrayList<String> enumeration = null;
                if (directMapping.getConverter() instanceof JAXBEnumTypeConverter) {
                    JAXBEnumTypeConverter conv = (JAXBEnumTypeConverter)directMapping.getConverter();
                    enumeration = new ArrayList<String>();
                    for (Object nextValue : conv.getAttributeToFieldValues().values()) {
                        enumeration.add(nextValue.toString());
                    }
                }
                String propertyName = this.getNameForFragment(frag);
                if (frag.nameIsText()) {
                    String valueWrapper;
                    propertyName = "value";
                    if (this.contextProperties != null && (valueWrapper = (String)this.contextProperties.get("eclipselink.json.value-wrapper")) != null) {
                        propertyName = valueWrapper;
                    }
                }
                if (frag.isAttribute() && this.attributePrefix != null) {
                    propertyName = String.valueOf(this.attributePrefix) + propertyName;
                }
                if ((prop = properties.get(propertyName)) == null) {
                    prop = new Property();
                    prop.setName(propertyName);
                }
                Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                if (enumeration != null) {
                    nestedProperty.setEnumeration(enumeration);
                }
                if (directMapping instanceof BinaryDataMapping) {
                    BinaryDataMapping binaryMapping = (BinaryDataMapping)((Object)directMapping);
                    if (binaryMapping.shouldInlineBinaryData() || binaryMapping.isSwaRef()) {
                        nestedProperty.setType(JsonType.STRING);
                    } else {
                        if (this.xopIncludeProp == null) {
                            this.initXopIncludeProp();
                        }
                        nestedProperty.setAnyOf(this.xopIncludeProp);
                    }
                } else {
                    nestedProperty.setType(this.getJsonTypeForJavaType(directMapping.getAttributeClassification()));
                }
                return prop;
            }
            if (next instanceof ObjectReferenceMapping) {
                ObjectReferenceMapping mapping = (ObjectReferenceMapping)((Object)next);
                Set sourceFields = mapping.getSourceToTargetKeyFieldAssociations().keySet();
                XMLDescriptor reference = (XMLDescriptor)mapping.getReferenceDescriptor();
                for (XMLField nextField : sourceFields) {
                    XPathFragment frag = nextField.getXPathFragment();
                    String propName = this.getNameForFragment(frag);
                    XMLField targetField = (XMLField)mapping.getSourceToTargetKeyFieldAssociations().get(nextField);
                    Class type = this.getTypeForTargetField(targetField, reference);
                    prop = properties.get(propName);
                    if (prop == null) {
                        prop = new Property();
                        prop.setName(propName);
                    }
                    Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                    nestedProperty.setType(this.getJsonTypeForJavaType(type));
                    if (properties.containsKey(prop.getName())) continue;
                    properties.put(prop.getName(), prop);
                }
                return null;
            }
            if (next.isAbstractCompositeObjectMapping()) {
                CompositeObjectMapping mapping = (CompositeObjectMapping)((Object)next);
                XMLDescriptor nextDescriptor = (XMLDescriptor)mapping.getReferenceDescriptor();
                XMLField field = (XMLField)mapping.getField();
                XPathFragment firstFragment = field.getXPathFragment();
                String propName = this.getNameForFragment(firstFragment);
                prop = properties.get(propName);
                if (prop == null) {
                    prop = new Property();
                    prop.setName(propName);
                }
                prop.setName(propName);
                Property nestedProperty = this.getNestedPropertyForFragment(firstFragment, prop);
                nestedProperty.setRef(this.getReferenceForDescriptor(nextDescriptor));
            } else if (next instanceof BinaryDataMapping) {
                BinaryDataMapping binaryMapping = (BinaryDataMapping)((Object)next);
                XMLField field = (XMLField)binaryMapping.getField();
                XPathFragment frag = field.getXPathFragment();
                String propertyName = this.getNameForFragment(frag);
                if (frag.nameIsText()) {
                    String valueWrapper;
                    propertyName = "value";
                    if (this.contextProperties != null && (valueWrapper = (String)this.contextProperties.get("eclipselink.json.value-wrapper")) != null) {
                        propertyName = valueWrapper;
                    }
                }
                if (frag.isAttribute() && this.attributePrefix != null) {
                    propertyName = String.valueOf(this.attributePrefix) + propertyName;
                }
                if ((prop = properties.get(propertyName)) == null) {
                    prop = new Property();
                    prop.setName(propertyName);
                }
                Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                if (binaryMapping.shouldInlineBinaryData() || binaryMapping.isSwaRef()) {
                    nestedProperty.setType(JsonType.STRING);
                } else {
                    if (this.xopIncludeProp == null) {
                        this.initXopIncludeProp();
                    }
                    nestedProperty.setAnyOf(this.xopIncludeProp);
                }
                return prop;
            }
        }
        return prop;
    }

    private String getNameForFragment(XPathFragment frag) {
        String prefix;
        String namespaceUri;
        String name = frag.getLocalName();
        if (this.prefixMapper != null && (namespaceUri = frag.getNamespaceURI()) != null && namespaceUri.length() != 0 && (prefix = this.prefixMapper.getPreferredPrefix(namespaceUri, null, true)) != null) {
            name = String.valueOf(prefix) + this.NAMESPACE_SEPARATOR + name;
        }
        return name;
    }

    private void initXopIncludeProp() {
        this.xopIncludeProp = new Property[2];
        Property p = new Property();
        p.setType(JsonType.STRING);
        this.xopIncludeProp[0] = p;
        this.xopIncludeProp[1] = p = new Property();
        p.setType(JsonType.OBJECT);
        Property includeProperty = new Property();
        includeProperty.setName("Include");
        includeProperty.setType(JsonType.OBJECT);
        p.getProperties().put(includeProperty.getName(), includeProperty);
        Property hrefProp = new Property();
        String propName = "href";
        if (this.attributePrefix != null) {
            propName = String.valueOf(this.attributePrefix) + propName;
        }
        hrefProp.setName(propName);
        hrefProp.setType(JsonType.STRING);
        includeProperty.getProperties().put(propName, hrefProp);
    }

    private String getReferenceForDescriptor(XMLDescriptor referenceDescriptor) {
        if (referenceDescriptor == null) {
            return null;
        }
        String className = referenceDescriptor.getJavaClass().getSimpleName();
        String referenceName = String.valueOf(DEFINITION_PATH) + "/" + className;
        if (referenceDescriptor.getJavaClass() == this.rootClass) {
            return "#";
        }
        if (!this.schema.getDefinitions().containsKey(className)) {
            Property definition = new Property();
            definition.setName(className);
            definition.setType(JsonType.OBJECT);
            this.schema.getDefinitions().put(definition.getName(), definition);
            JsonType jType = this.populateProperties(definition.getProperties(), referenceDescriptor);
            if (jType != null) {
                definition.setType(jType);
                definition.setProperties(null);
            }
        }
        return referenceName;
    }

    private Class getTypeForTargetField(XMLField targetField, XMLDescriptor reference) {
        for (DatabaseMapping next : reference.getMappings()) {
            DirectMapping directMapping;
            if (!next.isDirectToFieldMapping() || !(directMapping = (DirectMapping)((Object)next)).getField().equals(targetField)) continue;
            return directMapping.getAttributeClassification();
        }
        return null;
    }

    private JsonType getJsonTypeForJavaType(Class attributeClassification) {
        HashMap<Class, JsonType> types = JsonSchemaGenerator.getJavaTypeToJsonType();
        JsonType jsonType = types.get(attributeClassification);
        if (jsonType == null) {
            return JsonType.OBJECT;
        }
        return jsonType;
    }

    private static HashMap<Class, JsonType> getJavaTypeToJsonType() {
        if (javaTypeToJsonType == null) {
            JsonSchemaGenerator.initJavaTypeToJsonType();
        }
        return javaTypeToJsonType;
    }

    private static void initJavaTypeToJsonType() {
        javaTypeToJsonType = new HashMap();
        javaTypeToJsonType.put(CoreClassConstants.APBYTE, JsonType.ARRAY);
        javaTypeToJsonType.put(CoreClassConstants.BIGDECIMAL, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.BIGINTEGER, JsonType.INTEGER);
        javaTypeToJsonType.put(CoreClassConstants.PBOOLEAN, JsonType.BOOLEAN);
        javaTypeToJsonType.put(CoreClassConstants.PBYTE, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.CALENDAR, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.PDOUBLE, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.PFLOAT, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.PINT, JsonType.INTEGER);
        javaTypeToJsonType.put(CoreClassConstants.PLONG, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.PSHORT, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.STRING, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.CHAR, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.ABYTE, JsonType.ARRAY);
        javaTypeToJsonType.put(CoreClassConstants.BOOLEAN, JsonType.BOOLEAN);
        javaTypeToJsonType.put(CoreClassConstants.BYTE, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.CLASS, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.GREGORIAN_CALENDAR, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.DOUBLE, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.FLOAT, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.INTEGER, JsonType.INTEGER);
        javaTypeToJsonType.put(CoreClassConstants.LONG, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.OBJECT, JsonType.OBJECT);
        javaTypeToJsonType.put(CoreClassConstants.SHORT, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.UTILDATE, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.SQLDATE, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.TIME, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.TIMESTAMP, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.DURATION, JsonType.STRING);
    }

    private Property getNestedPropertyForFragment(XPathFragment frag, Property prop) {
        if (frag.getNextFragment() == null || frag.getNextFragment().nameIsText()) {
            return prop;
        }
        Map<String, Property> currentProperties = prop.getProperties();
        prop.setProperties(currentProperties);
        prop.setType(JsonType.OBJECT);
        frag = frag.getNextFragment();
        String propertyName = this.getNameForFragment(frag);
        if (frag.isAttribute() && this.attributePrefix != null) {
            propertyName = String.valueOf(this.attributePrefix) + "propertyName";
        }
        while (frag != null && !frag.nameIsText()) {
            Property nestedProperty = prop.getProperty(propertyName);
            if (nestedProperty == null) {
                nestedProperty = new Property();
                nestedProperty.setName(propertyName);
            }
            currentProperties.put(nestedProperty.getName(), nestedProperty);
            if (frag.getNextFragment() == null || frag.getNextFragment().nameIsText()) {
                return nestedProperty;
            }
            nestedProperty.setType(JsonType.OBJECT);
            currentProperties = nestedProperty.getProperties();
            frag = frag.getNextFragment();
        }
        return null;
    }

    private Property[] getXopIncludeProperties() {
        if (this.xopIncludeProp == null) {
            this.initXopIncludeProp();
        }
        return this.xopIncludeProp;
    }

    private boolean isCollection(Class type) {
        return CoreClassConstants.Collection_Class.isAssignableFrom(type) || CoreClassConstants.List_Class.isAssignableFrom(type) || CoreClassConstants.Set_Class.isAssignableFrom(type);
    }
}

