/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;

class ComputeClassWriter
extends ClassWriter {
    private ClassLoader l = null;

    public ComputeClassWriter(ClassLoader loader, int flags) {
        super(flags);
        this.l = loader;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        ClassReader info2;
        ClassReader info1;
        block8: {
            block7: {
                info1 = this.typeInfo(type1);
                info2 = this.typeInfo(type2);
                if ((info1.getAccess() & 0x200) == 0) break block7;
                if (this.typeImplements(type2, info2, type1)) {
                    return type1;
                }
                return "java/lang/Object";
            }
            if ((info2.getAccess() & 0x200) == 0) break block8;
            if (this.typeImplements(type1, info1, type2)) {
                return type2;
            }
            return "java/lang/Object";
        }
        try {
            String result;
            block9: {
                StringBuilder b1 = this.typeAncestors(type1, info1);
                StringBuilder b2 = this.typeAncestors(type2, info2);
                result = "java/lang/Object";
                int end1 = b1.length();
                int end2 = b2.length();
                while (true) {
                    String p2;
                    int start1 = b1.lastIndexOf(";", end1 - 1);
                    int start2 = b2.lastIndexOf(";", end2 - 1);
                    if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block9;
                    String p1 = b1.substring(start1 + 1, end1);
                    if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                    result = p1;
                    end1 = start1;
                    end2 = start2;
                }
                return result;
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private StringBuilder typeAncestors(String type, ClassReader info) throws IOException {
        StringBuilder b = new StringBuilder();
        while (!"java/lang/Object".equals(type)) {
            b.append(';').append(type);
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return b;
    }

    private boolean typeImplements(String type, ClassReader info, String itf) throws IOException {
        while (!"java/lang/Object".equals(type)) {
            String[] itfs = info.getInterfaces();
            int i = 0;
            while (i < itfs.length) {
                if (itfs[i].equals(itf)) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < itfs.length) {
                if (this.typeImplements(itfs[i], this.typeInfo(itfs[i]), itf)) {
                    return true;
                }
                ++i;
            }
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return false;
    }

    private ClassReader typeInfo(String type) throws IOException {
        InputStream is = this.l.getResourceAsStream(String.valueOf(type) + ".class");
        try {
            ClassReader classReader = new ClassReader(is);
            return classReader;
        }
        finally {
            is.close();
        }
    }
}

