/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.dynamic;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContext;
import org.eclipse.persistence.jaxb.dynamic.metadata.Metadata;
import org.eclipse.persistence.jaxb.dynamic.metadata.OXMMetadata;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicJAXBContextFactory {
    public static final String XML_SCHEMA_KEY = "xml-schema";
    public static final String ENTITY_RESOLVER_KEY = "entity-resolver";
    public static final String EXTERNAL_BINDINGS_KEY = "external-bindings";
    public static final String SCHEMAMETADATA_CLASS_NAME = "org.eclipse.persistence.jaxb.dynamic.metadata.SchemaMetadata";

    public static DynamicJAXBContext createContext(String contextPath, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        Object schema = null;
        EntityResolver resolver = null;
        Object bindings = null;
        if (properties != null) {
            schema = properties.get(XML_SCHEMA_KEY);
            resolver = (EntityResolver)properties.get(ENTITY_RESOLVER_KEY);
            bindings = properties.get("eclipselink-oxm-xml");
        }
        if (schema != null) {
            if (schema instanceof Node) {
                return DynamicJAXBContextFactory.createContextFromXSD((Node)schema, resolver, classLoader, properties);
            }
            if (schema instanceof InputStream) {
                return DynamicJAXBContextFactory.createContextFromXSD((InputStream)schema, resolver, classLoader, properties);
            }
            if (schema instanceof Source) {
                return DynamicJAXBContextFactory.createContextFromXSD((Source)schema, resolver, classLoader, properties);
            }
        }
        if (bindings != null) {
            return DynamicJAXBContextFactory.createContextFromOXM(classLoader, properties);
        }
        if (contextPath != null) {
            DynamicJAXBContext dContext = new DynamicJAXBContext(classLoader);
            dContext.initializeFromSessionsXML(contextPath, classLoader);
            return dContext;
        }
        throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.nullSessionName());
    }

    public static DynamicJAXBContext createContext(Class<?>[] classes, Map<String, Object> properties) throws JAXBException {
        throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.cannotCreateDynamicContextFromClasses());
    }

    public static DynamicJAXBContext createContextFromXSD(Node schemaDOM, EntityResolver resolver, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        if (schemaDOM == null) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.nullNode());
        }
        try {
            DynamicJAXBContext dContext = new DynamicJAXBContext(classLoader);
            Class schemaMetadataClass = PrivilegedAccessHelper.getClassForName(SCHEMAMETADATA_CLASS_NAME);
            Class[] constructorClassArgs = new Class[]{DynamicClassLoader.class, Map.class, Node.class, EntityResolver.class};
            Constructor constructor = PrivilegedAccessHelper.getConstructorFor(schemaMetadataClass, constructorClassArgs, true);
            Object[] contructorObjectArgs = new Object[]{dContext.getDynamicClassLoader(), properties, schemaDOM, resolver};
            Metadata schemaMetadata = (Metadata)PrivilegedAccessHelper.invokeConstructor(constructor, contructorObjectArgs);
            dContext.initializeFromMetadata(schemaMetadata, dContext.getDynamicClassLoader(), properties);
            return dContext;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof JAXBException) {
                throw (JAXBException)cause;
            }
            throw new JAXBException((Throwable)e);
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JAXBException(e);
        }
    }

    public static DynamicJAXBContext createContextFromXSD(InputStream schemaStream, EntityResolver resolver, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        if (schemaStream == null) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.nullInputStream());
        }
        try {
            StreamSource schemaSource = new StreamSource(schemaStream);
            DynamicJAXBContext dContext = new DynamicJAXBContext(classLoader);
            Class schemaMetadataClass = PrivilegedAccessHelper.getClassForName(SCHEMAMETADATA_CLASS_NAME);
            Class[] constructorClassArgs = new Class[]{DynamicClassLoader.class, Map.class, Source.class, EntityResolver.class};
            Constructor constructor = PrivilegedAccessHelper.getConstructorFor(schemaMetadataClass, constructorClassArgs, true);
            Object[] contructorObjectArgs = new Object[]{dContext.getDynamicClassLoader(), properties, schemaSource, resolver};
            Metadata schemaMetadata = (Metadata)PrivilegedAccessHelper.invokeConstructor(constructor, contructorObjectArgs);
            dContext.initializeFromMetadata(schemaMetadata, dContext.getDynamicClassLoader(), properties);
            return dContext;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof JAXBException) {
                throw (JAXBException)cause;
            }
            throw new JAXBException((Throwable)e);
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)e);
        }
    }

    public static DynamicJAXBContext createContextFromXSD(Source schemaSource, EntityResolver resolver, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        if (schemaSource == null) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.nullSource());
        }
        try {
            DynamicJAXBContext dContext = new DynamicJAXBContext(classLoader);
            Class schemaMetadataClass = PrivilegedAccessHelper.getClassForName(SCHEMAMETADATA_CLASS_NAME);
            Class[] constructorClassArgs = new Class[]{DynamicClassLoader.class, Map.class, Source.class, EntityResolver.class};
            Constructor constructor = PrivilegedAccessHelper.getConstructorFor(schemaMetadataClass, constructorClassArgs, true);
            Object[] contructorObjectArgs = new Object[]{dContext.getDynamicClassLoader(), properties, schemaSource, resolver};
            Metadata schemaMetadata = (Metadata)PrivilegedAccessHelper.invokeConstructor(constructor, contructorObjectArgs);
            dContext.initializeFromMetadata(schemaMetadata, dContext.getDynamicClassLoader(), properties);
            return dContext;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof JAXBException) {
                throw (JAXBException)cause;
            }
            throw new JAXBException((Throwable)e);
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)e);
        }
    }

    public static DynamicJAXBContext createContextFromOXM(ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        if (properties == null || properties.get("eclipselink-oxm-xml") == null) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.oxmKeyNotFound());
        }
        DynamicJAXBContext dContext = new DynamicJAXBContext(classLoader);
        OXMMetadata oxmMetadata = new OXMMetadata(dContext.getDynamicClassLoader(), properties);
        dContext.initializeFromMetadata(oxmMetadata, dContext.getDynamicClassLoader(), properties);
        return dContext;
    }
}

