/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings.nullpolicy;

import java.lang.reflect.Method;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.NillableNodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.OptionalNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.Session;

public class IsSetNullPolicy
extends AbstractNullPolicy {
    private static final Class[] PARAMETER_TYPES = new Class[0];
    private static final Object[] PARAMETERS = new Object[0];
    private String isSetMethodName;
    private Class[] isSetParameterTypes = PARAMETER_TYPES;
    private Object[] isSetParameters = PARAMETERS;
    private Method isSetMethod;

    public IsSetNullPolicy() {
        this.isSetPerformedForAbsentNode = false;
    }

    public IsSetNullPolicy(String anIsSetMethodName) {
        this();
        this.setIsSetMethodName(anIsSetMethodName);
    }

    public IsSetNullPolicy(String anIsSetMethodName, boolean bIsNullRepresentedByEmptyNode, boolean bIsNullRepresentedByXsiNil, XMLNullRepresentationType aMarshalNullRepresentation) {
        this(anIsSetMethodName);
        this.setNullRepresentedByEmptyNode(bIsNullRepresentedByEmptyNode);
        this.setNullRepresentedByXsiNil(bIsNullRepresentedByXsiNil);
        this.setMarshalNullRepresentation(aMarshalNullRepresentation);
    }

    public boolean directMarshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Session session, NamespaceResolver namespaceResolver) {
        if (!this.isSet(object)) {
            return false;
        }
        return super.directMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
    }

    public void directMarshal(DatabaseField field, XMLRecord record, Object object) {
        if (!this.isSet(object)) {
            return;
        }
        super.directMarshal(field, record, object);
    }

    public boolean compositeObjectMarshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Session session, NamespaceResolver namespaceResolver) {
        if (!this.isSet(object)) {
            return false;
        }
        return super.compositeObjectMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
    }

    public boolean compositeObjectMarshal(XMLRecord record, Object object, XMLField field, AbstractSession session) {
        if (!this.isSet(object)) {
            return false;
        }
        return super.compositeObjectMarshal(record, object, field, session);
    }

    public void xPathNode(XPathNode xPathNode, NullCapableValue nullCapableValue) {
        if (!this.isNullRepresentedByXsiNil() && this.marshalNullRepresentation != XMLNullRepresentationType.XSI_NIL && xPathNode.getXPathFragment().isAttribute()) {
            return;
        }
        XPathNode parentNode = xPathNode.getParent();
        if (this.isNullRepresentedByXsiNil() || this.marshalNullRepresentation == XMLNullRepresentationType.XSI_NIL) {
            XPathFragment xPathFragment = new XPathFragment();
            xPathFragment.setXPath("@nil");
            xPathFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            NillableNodeValue aNodeValue = new NillableNodeValue(nullCapableValue);
            parentNode.addChild(xPathFragment, aNodeValue, null);
        } else {
            OptionalNodeValue aNodeValue = new OptionalNodeValue(nullCapableValue);
            parentNode.setNodeValue(aNodeValue);
        }
    }

    private boolean isSet(Object object) {
        try {
            Boolean isSet = (Boolean)PrivilegedAccessHelper.invokeMethod(this.getIsSetMethod(object.getClass()), object, this.isSetParameters);
            return isSet;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getIsSetMethodName() {
        return this.isSetMethodName;
    }

    public void setIsSetMethodName(String anIsSetMethodName) {
        this.isSetMethodName = anIsSetMethodName;
    }

    public Class[] getIsSetParameterTypes() {
        return this.isSetParameterTypes;
    }

    public void setIsSetParameterTypes(Class[] parameterTypes) {
        this.isSetParameterTypes = parameterTypes;
    }

    public Object[] getIsSetParameters() {
        return this.isSetParameters;
    }

    public void setIsSetParameters(Object[] parameters) {
        this.isSetParameters = parameters;
    }

    private Method getIsSetMethod(Class aClass) throws NoSuchMethodException {
        if (null == this.isSetMethod) {
            this.isSetMethod = PrivilegedAccessHelper.getPublicMethod(aClass, this.getIsSetMethodName(), this.getIsSetParameterTypes(), false);
        }
        return this.isSetMethod;
    }
}

