/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.MarshalRecord;

public abstract class MappingNodeValue
extends NodeValue {
    public abstract DatabaseMapping getMapping();

    public boolean isMappingNodeValue() {
        return true;
    }

    protected String getValueToWrite(QName schemaType, Object value, XMLConversionManager xmlConversionManager, MarshalRecord marshalRecord) {
        if (schemaType != null && XMLConstants.QNAME_QNAME.equals(schemaType)) {
            return this.getStringForQName((QName)value, marshalRecord);
        }
        return (String)xmlConversionManager.convertObject(value, ClassConstants.STRING, schemaType);
    }

    protected String getStringForQName(QName qName, MarshalRecord marshalRecord) {
        if (null == qName) {
            return null;
        }
        String namespaceURI = qName.getNamespaceURI();
        if (null == namespaceURI || 0 == namespaceURI.length()) {
            if (marshalRecord.getNamespaceResolver() != null && marshalRecord.getNamespaceResolver().getDefaultNamespaceURI() != null) {
                marshalRecord.defaultNamespaceDeclaration(namespaceURI);
            }
            return qName.getLocalPart();
        }
        NamespaceResolver namespaceResolver = marshalRecord.getNamespaceResolver();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(namespaceURI);
        }
        if (namespaceURI.equals(namespaceResolver.getDefaultNamespaceURI())) {
            return qName.getLocalPart();
        }
        String prefix = namespaceResolver.resolveNamespaceURI(namespaceURI);
        if (null == prefix) {
            prefix = namespaceResolver.generatePrefix();
            marshalRecord.namespaceDeclaration(prefix, namespaceURI);
        }
        return prefix + ':' + qName.getLocalPart();
    }

    protected void updateNamespaces(QName qname, MarshalRecord marshalRecord, XMLField xmlField) {
        if (qname != null) {
            String prefix;
            if (xmlField != null) {
                if (xmlField.isTypedTextField()) {
                    if (xmlField.getSchemaType() == null ? qname.equals(XMLConstants.STRING_QNAME) : xmlField.isSchemaType(qname)) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if ((prefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(qname.getNamespaceURI())) == null || prefix.length() == 0) {
                prefix = "http://www.w3.org/2001/XMLSchema".equals(qname.getNamespaceURI()) ? marshalRecord.getNamespaceResolver().generatePrefix("xsd") : marshalRecord.getNamespaceResolver().generatePrefix();
                marshalRecord.namespaceDeclaration(prefix, qname.getNamespaceURI());
            }
            String typeValue = prefix + ':' + qname.getLocalPart();
            this.addTypeAttribute(marshalRecord, typeValue);
        }
    }

    protected void addTypeAttribute(MarshalRecord marshalRecord, String typeValue) {
        String xsiPrefix = null;
        if (marshalRecord.getNamespaceResolver() != null) {
            xsiPrefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = "xsi";
            marshalRecord.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (xsiPrefix == null) {
            xsiPrefix = marshalRecord.getNamespaceResolver().generatePrefix("xsi");
            marshalRecord.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        marshalRecord.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix, typeValue);
    }
}

