/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.annotations.Direction;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;

public class StoredProcedureParameterMetadata
extends ORMetadata {
    private MetadataClass m_type;
    private String m_direction;
    private Boolean m_optional;
    private Integer m_jdbcType;
    private String m_jdbcTypeName;
    private String m_name;
    private String m_queryParameter;
    private String m_typeName;

    public StoredProcedureParameterMetadata() {
        super("<stored-procedure-parameter>");
    }

    public StoredProcedureParameterMetadata(MetadataAnnotation storedProcedureParameter, MetadataAccessor accessor) {
        super(storedProcedureParameter, accessor);
        this.m_direction = (String)storedProcedureParameter.getAttribute("direction");
        this.m_name = (String)storedProcedureParameter.getAttribute("name");
        this.m_queryParameter = (String)storedProcedureParameter.getAttribute("queryParameter");
        this.m_type = this.getMetadataClass((String)storedProcedureParameter.getAttributeClass("type"));
        this.m_jdbcType = (Integer)storedProcedureParameter.getAttribute("jdbcType");
        this.m_jdbcTypeName = (String)storedProcedureParameter.getAttribute("jdbcTypeName");
        this.m_optional = (Boolean)storedProcedureParameter.getAttribute("optional");
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof StoredProcedureParameterMetadata) {
            StoredProcedureParameterMetadata parameter = (StoredProcedureParameterMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_type, parameter.getType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_direction, parameter.getDirection())) {
                return false;
            }
            if (!this.valuesMatch(this.m_jdbcType, parameter.getJdbcType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_jdbcTypeName, parameter.getJdbcTypeName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_name, parameter.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_optional, parameter.getOptional())) {
                return false;
            }
            return this.valuesMatch(this.m_queryParameter, parameter.getQueryParameter());
        }
        return false;
    }

    public String getDirection() {
        return this.m_direction;
    }

    public Integer getJdbcType() {
        return this.m_jdbcType;
    }

    public String getJdbcTypeName() {
        return this.m_jdbcTypeName;
    }

    public String getName() {
        return this.m_name;
    }

    public String getQueryParameter() {
        return this.m_queryParameter;
    }

    public MetadataClass getType() {
        return this.m_type;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    protected boolean hasJdbcType() {
        return this.m_jdbcType != null && this.m_jdbcType.equals(-1);
    }

    protected boolean hasJdbcTypeName() {
        return this.m_jdbcTypeName != null && !this.m_jdbcTypeName.equals("");
    }

    protected boolean hasType() {
        return !this.m_type.isVoid();
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_type = this.initXMLClassName(this.m_typeName);
    }

    public void process(StoredProcedureCall call, MetadataProject project, boolean callByIndex, boolean functionReturn) {
        String procedureParameterName = this.m_name;
        if (this.m_name == null || this.m_name.equals("")) {
            procedureParameterName = this.m_queryParameter;
        }
        if (this.m_optional != null && this.m_optional.booleanValue()) {
            call.addOptionalArgument(this.m_queryParameter);
        }
        if (functionReturn) {
            if (this.hasType()) {
                ((StoredFunctionCall)call).setResult(procedureParameterName, this.getJavaClass(this.m_type));
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                ((StoredFunctionCall)call).setResult(procedureParameterName, this.m_jdbcType, this.m_jdbcTypeName);
            } else if (this.hasJdbcType()) {
                ((StoredFunctionCall)call).setResult(procedureParameterName, this.m_jdbcType);
            } else {
                ((StoredFunctionCall)call).setResult(procedureParameterName);
            }
        } else if (this.m_direction == null || this.m_direction.equals(Direction.IN.name())) {
            if (this.hasType()) {
                if (!callByIndex) {
                    call.addNamedArgument(procedureParameterName, this.m_queryParameter, this.getJavaClass(this.m_type));
                } else {
                    call.addUnamedArgument(this.m_queryParameter, this.getJavaClass(this.m_type));
                }
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                if (!callByIndex) {
                    call.addNamedArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
                } else {
                    call.addUnamedArgument(this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
                }
            } else if (this.hasJdbcType()) {
                if (!callByIndex) {
                    call.addNamedArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType);
                } else {
                    call.addUnamedArgument(this.m_queryParameter, this.m_jdbcType);
                }
            } else if (!callByIndex) {
                call.addNamedArgument(procedureParameterName, this.m_queryParameter);
            } else {
                call.addUnamedArgument(this.m_queryParameter);
            }
        } else if (this.m_direction.equals(Direction.OUT.name())) {
            if (this.hasType()) {
                if (!callByIndex) {
                    call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter, this.getJavaClass(this.m_type));
                } else {
                    call.addUnamedOutputArgument(this.m_queryParameter, this.getJavaClass(this.m_type));
                }
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                if (!callByIndex) {
                    call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
                } else {
                    call.addUnamedOutputArgument(this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
                }
            } else if (this.hasJdbcType()) {
                if (callByIndex) {
                    call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType);
                } else {
                    call.addUnamedOutputArgument(this.m_queryParameter, this.m_jdbcType);
                }
            } else if (!callByIndex) {
                call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter);
            } else {
                call.addUnamedOutputArgument(this.m_queryParameter);
            }
            this.setDatabaseFieldSettings((DatabaseField)call.getParameters().get(call.getParameters().size() - 1), project);
        } else if (this.m_direction.equals(Direction.IN_OUT.name())) {
            if (this.hasType()) {
                if (!callByIndex) {
                    call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter, this.m_queryParameter, this.getJavaClass(this.m_type));
                } else {
                    call.addUnamedInOutputArgument(this.m_queryParameter, this.m_queryParameter, this.getJavaClass(this.m_type));
                }
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                if (!callByIndex) {
                    call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter, this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
                } else {
                    call.addUnamedInOutputArgument(this.m_queryParameter, this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
                }
            } else if (this.hasJdbcType()) {
                if (!callByIndex) {
                    call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter, this.m_queryParameter, this.m_jdbcType);
                } else {
                    call.addUnamedInOutputArgument(this.m_queryParameter, this.m_queryParameter, this.m_jdbcType);
                }
            } else if (!callByIndex) {
                call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter);
            } else {
                call.addUnamedInOutputArgument(this.m_queryParameter);
            }
            Object[] array = (Object[])call.getParameters().get(call.getParameters().size() - 1);
            if (array[0] == array[1]) {
                array[1] = ((DatabaseField)array[1]).clone();
            }
            this.setDatabaseFieldSettings((DatabaseField)array[1], project);
        } else if (this.m_direction.equals(Direction.OUT_CURSOR.name())) {
            boolean multipleCursors = false;
            if (call.getParameterTypes().contains(StoredProcedureCall.OUT_CURSOR)) {
                multipleCursors = true;
            }
            if (!callByIndex) {
                call.useNamedCursorOutputAsResultSet(this.m_queryParameter);
            } else {
                call.useUnnamedCursorOutputAsResultSet();
            }
            if (multipleCursors) {
                call.setIsCursorOutputProcedure(false);
            }
        }
    }

    protected void setDatabaseFieldSettings(DatabaseField field, MetadataProject project) {
        if (project.useDelimitedIdentifier()) {
            field.setUseDelimiters(true);
        } else if (project.getShouldForceFieldNamesToUpperCase() && !field.shouldUseDelimiters()) {
            field.useUpperCaseForComparisons(true);
        }
    }

    public void setDirection(String direction) {
        this.m_direction = direction;
    }

    public void setJdbcType(Integer jdbcType) {
        this.m_jdbcType = jdbcType;
    }

    public void setJdbcTypeName(String jdbcTypeName) {
        this.m_jdbcTypeName = jdbcTypeName;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setQueryParameter(String queryParameter) {
        this.m_queryParameter = queryParameter;
    }

    public void setType(MetadataClass type) {
        this.m_type = type;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    public void setOptional(Boolean optional) {
        this.m_optional = optional;
    }
}

