/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ConnectionPool {
    protected boolean isConnected;
    protected int maxNumberOfConnections;
    protected int minNumberOfConnections;
    protected Vector connectionsAvailable;
    protected Vector connectionsUsed;
    protected Login login;
    protected String name;
    protected ServerSession owner;
    protected boolean checkConnections;

    public ConnectionPool() {
        this.maxNumberOfConnections = 50;
        this.minNumberOfConnections = 3;
        this.checkConnections = false;
        this.resetConnections();
    }

    public ConnectionPool(String name, Login login, int minNumberOfConnections, int maxNumberOfConnections, ServerSession owner) {
        this.login = login;
        this.owner = owner;
        this.name = name;
        this.maxNumberOfConnections = maxNumberOfConnections;
        this.minNumberOfConnections = minNumberOfConnections;
        this.checkConnections = false;
        this.resetConnections();
    }

    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        while (this.connectionsAvailable.isEmpty()) {
            if (this.connectionsUsed.size() + this.connectionsAvailable.size() < this.maxNumberOfConnections) {
                Accessor connection = this.buildConnection();
                this.connectionsUsed.add(connection);
                return connection;
            }
            try {
                this.wait();
            }
            catch (InterruptedException exception) {
                throw ConcurrencyException.waitFailureOnClientSession(exception);
            }
        }
        Accessor connection = (Accessor)this.connectionsAvailable.get(0);
        this.connectionsAvailable.remove(connection);
        if (this.checkConnections) {
            for (int connectionSize = this.connectionsAvailable.size(); connectionSize >= 0; --connectionSize) {
                if (this.getOwner().getLogin().isConnectionHealthValidatedOnError() && this.getOwner().getServerPlatform().wasFailureCommunicationBased(null, connection, this.getOwner())) {
                    try {
                        connection.closeConnection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.connectionsAvailable.isEmpty()) {
                        this.checkConnections = false;
                        return this.acquireConnection();
                    }
                    connection = (Accessor)this.connectionsAvailable.get(0);
                    this.connectionsAvailable.remove(connection);
                    continue;
                }
                this.checkConnections = false;
                break;
            }
        }
        this.connectionsUsed.add(connection);
        if (this.getOwner().isInProfile()) {
            this.getOwner().updateProfile(this.getName(), new Integer(this.getConnectionsUsed().size()));
        }
        return connection;
    }

    protected Accessor buildConnection() {
        Login localLogin = (Login)this.getLogin().clone();
        Accessor connection = localLogin.buildAccessor();
        connection.connect(localLogin, this.getOwner());
        return connection;
    }

    public Vector getConnectionsAvailable() {
        return this.connectionsAvailable;
    }

    protected Vector getConnectionsUsed() {
        return this.connectionsUsed;
    }

    public Login getLogin() {
        return this.login;
    }

    public int getMaxNumberOfConnections() {
        return this.maxNumberOfConnections;
    }

    public int getMinNumberOfConnections() {
        return this.minNumberOfConnections;
    }

    public String getName() {
        return this.name;
    }

    protected ServerSession getOwner() {
        return this.owner;
    }

    public int getTotalNumberOfConnections() {
        return this.getConnectionsUsed().size() + this.getConnectionsAvailable().size();
    }

    public boolean hasConnectionAvailable() {
        return !this.getConnectionsAvailable().isEmpty();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isThereConflictBetweenLoginAndType() {
        return this.getLogin().shouldUseExternalConnectionPooling();
    }

    public synchronized void releaseConnection(Accessor connection) throws DatabaseException {
        if (connection instanceof DatasourceAccessor) {
            ((DatasourceAccessor)connection).resetStatmentsCount();
        }
        this.connectionsUsed.remove(connection);
        if (!connection.isValid()) {
            this.checkConnections = true;
            try {
                connection.disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        } else if (this.connectionsUsed.size() + this.connectionsAvailable.size() < this.minNumberOfConnections) {
            this.connectionsAvailable.add(connection);
        } else {
            connection.disconnect(this.getOwner());
        }
        if (this.getOwner().isInProfile()) {
            this.getOwner().updateProfile(this.getName(), new Integer(this.getConnectionsUsed().size()));
        }
        this.notify();
    }

    public void resetConnections() {
        this.connectionsUsed = new Vector();
        this.connectionsAvailable = new Vector();
    }

    protected void setConnectionsAvailable(Vector connectionsAvailable) {
        this.connectionsAvailable = connectionsAvailable;
    }

    protected void setConnectionsUsed(Vector connectionsUsed) {
        this.connectionsUsed = connectionsUsed;
    }

    public void setIsConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public void setMaxNumberOfConnections(int maxNumberOfConnections) {
        this.maxNumberOfConnections = maxNumberOfConnections;
    }

    public void setMinNumberOfConnections(int minNumberOfConnections) {
        this.minNumberOfConnections = minNumberOfConnections;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void setOwner(ServerSession owner) {
        this.owner = owner;
    }

    public synchronized void shutDown() {
        this.setIsConnected(false);
        Enumeration avaiableEnum = this.getConnectionsAvailable().elements();
        while (avaiableEnum.hasMoreElements()) {
            try {
                ((Accessor)avaiableEnum.nextElement()).disconnect(this.getOwner());
            }
            catch (DatabaseException exception) {}
        }
        Enumeration usedEnum = this.getConnectionsUsed().elements();
        while (usedEnum.hasMoreElements()) {
            try {
                ((Accessor)usedEnum.nextElement()).disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        }
        this.resetConnections();
    }

    public synchronized void startUp() {
        for (int index = this.getMinNumberOfConnections(); index > 0; --index) {
            this.getConnectionsAvailable().addElement(this.buildConnection());
        }
        this.setIsConnected(true);
    }

    public String toString() {
        Object[] args = new Object[]{new Integer(this.getMinNumberOfConnections()), new Integer(this.getMaxNumberOfConnections())};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("min_max", args);
    }
}

