/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.MissingDescriptorListener;
import org.eclipse.persistence.sessions.factories.ObjectPersistenceWorkbenchXMLProject;

public class XMLProjectWriter {
    public static void write(Project project, String fileName) {
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            XMLProjectWriter.write(project, writer);
            ((Writer)writer).close();
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public static void write(Project project, Writer writer) {
        XMLContext context = new XMLContext(new ObjectPersistenceWorkbenchXMLProject());
        context.getSession(project).getEventManager().addListener(new MissingDescriptorListener());
        XMLMarshaller marshaller = context.createMarshaller();
        marshaller.marshal((Object)project, writer);
        try {
            writer.flush();
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public static void write(String fileName, Project project) {
        XMLProjectWriter.write(project, fileName);
    }

    public static void write(String fileName, Project project, Writer writer) {
        if (writer != null) {
            XMLProjectWriter.write(project, writer);
        } else {
            XMLProjectWriter.write(project, fileName);
        }
    }
}

