/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.HelperContext;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.unmapped.UnmappedContentHandler;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.SDOXMLDocument;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SDOUnmappedContentHandler
implements UnmappedContentHandler {
    private UnmarshalRecord parentRecord;
    private SDOXMLDocument xmlDocument;
    private QName currentSchemaType;
    private StrBuffer currentBuffer;
    private Stack currentDataObjects = new Stack();
    private Stack currentProperties = new Stack();
    private boolean rootProcessed;
    private boolean isInCharacterBlock = false;
    private HelperContext aHelperContext;
    private int lastEvent = -1;
    private static final int START_ELEMENT = 0;
    private static final int END_ELEMENT = 1;
    private Map uriToPrefixMap;
    protected Map namespaceMap;
    private static final String NO_NAMESPACE = null;
    private int depth = 0;

    public SDOUnmappedContentHandler() {
        this.currentBuffer = new StrBuffer();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (null == this.namespaceMap) {
            this.namespaceMap = new HashMap();
        }
        this.namespaceMap.put(prefix, uri);
        if (this.uriToPrefixMap == null) {
            this.uriToPrefixMap = new HashMap();
        }
        this.uriToPrefixMap.put(uri, prefix);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (null == this.namespaceMap) {
            return;
        }
        if (this.uriToPrefixMap != null) {
            String uri = (String)this.namespaceMap.get(prefix);
            this.uriToPrefixMap.remove(uri);
        }
        this.namespaceMap.remove(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.isInCharacterBlock) {
            this.currentBuffer.reset();
        }
        if (!this.rootProcessed) {
            this.processRoot(namespaceURI, localName, qName, atts);
        } else {
            this.processNonRoot(namespaceURI, localName, qName, atts);
        }
        this.lastEvent = 0;
    }

    private QName getTypeAttributeQName(Attributes atts) {
        int attributeSize = atts.getLength();
        for (int i = 0; i < attributeSize; ++i) {
            String stringValue = atts.getValue(i);
            String uri = atts.getURI(i);
            String attrName = atts.getLocalName(i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(uri) || !"type".equals(attrName)) continue;
            int colonIndex = stringValue.indexOf(58);
            String localPrefix = stringValue.substring(0, colonIndex);
            String localURI = (String)this.getNamespaceMap().get(localPrefix);
            if (localURI != null) {
                QName theQName;
                String localName = stringValue.substring(colonIndex + 1, stringValue.length());
                this.currentSchemaType = theQName = new QName(localURI, localName);
                return theQName;
            }
            throw XMLMarshalException.namespaceNotFound(localPrefix);
        }
        return null;
    }

    private void processAttributes(Attributes atts, DataObject dataObject, boolean isRoot) {
        int attributeSize = atts.getLength();
        for (int i = 0; i < attributeSize; ++i) {
            Object convertedValue;
            String stringValue = atts.getValue(i);
            String uri = atts.getURI(i);
            String attrName = atts.getLocalName(i);
            if (atts.getQName(i) != null && atts.getQName(i).startsWith("xmlns:")) continue;
            if (isRoot && "schemaLocation".equals(attrName)) {
                this.getXmlDocument().setSchemaLocation(stringValue);
                continue;
            }
            if (isRoot && "noNamespaceSchemaLocation".equals(attrName)) {
                this.getXmlDocument().setNoNamespaceSchemaLocation(stringValue);
                continue;
            }
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(uri) && "type".equals(attrName)) continue;
            if ("ref".equals(attrName) && "commonj.sdo".equals(uri)) {
                ((SDODataObject)dataObject)._setSdoRef(stringValue);
                continue;
            }
            HelperContext aHelperContext = ((SDOType)dataObject.getType()).getHelperContext();
            Property prop = aHelperContext.getXSDHelper().getGlobalProperty(uri, attrName, false);
            if (prop != null) {
                convertedValue = ((SDODataHelper)aHelperContext.getDataHelper()).convertFromStringValue(stringValue, prop.getType());
                dataObject.set(prop, convertedValue);
                continue;
            }
            convertedValue = ((SDODataHelper)aHelperContext.getDataHelper()).convertFromStringValue(stringValue, SDOConstants.SDO_STRING);
            prop = this.defineNewSDOProperty(uri, attrName, false, SDOConstants.SDO_STRING);
            dataObject.set(prop, convertedValue);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.currentDataObjects.size() == 0 && this.currentProperties.size() == 0) {
            return;
        }
        if (this.currentDataObjects.size() == 1 && this.currentProperties.size() == 0) {
            this.parentRecord.getUnmarshaller().getUnmarshalListener().afterUnmarshal(this.currentDataObjects.peek(), null);
            this.currentDataObjects.pop();
            --this.depth;
            return;
        }
        this.setElementPropertyValue();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.isInCharacterBlock) {
            this.currentBuffer.reset();
            this.isInCharacterBlock = true;
        }
        this.currentBuffer.append(ch, start, length);
    }

    private void setElementPropertyValue() {
        Property currentProperty = (Property)this.currentProperties.pop();
        boolean simple = true;
        if (this.lastEvent == 1) {
            simple = false;
        } else {
            if (this.depth > this.currentDataObjects.size()) {
                simple = true;
            } else {
                DataObject nextDO = (DataObject)this.currentDataObjects.peek();
                if (nextDO.getInstanceProperties().size() > 0) {
                    simple = false;
                } else {
                    this.currentDataObjects.pop();
                }
            }
            --this.depth;
        }
        this.lastEvent = 1;
        if (simple && (!this.isInCharacterBlock || this.currentBuffer.length() == 0)) {
            return;
        }
        Object currentDataObject = (DataObject)this.currentDataObjects.peek();
        if (currentProperty != null) {
            Object value = null;
            if (simple) {
                value = this.currentBuffer.toString();
                ((SDOProperty)currentProperty).setType(SDOConstants.SDO_STRING);
                ((SDOProperty)currentProperty).setContainment(false);
            } else {
                value = currentDataObject;
                this.currentDataObjects.pop();
                --this.depth;
                currentDataObject = this.currentDataObjects.isEmpty() ? null : (DataObject)this.currentDataObjects.peek();
            }
            HelperContext aHelperContext = ((SDOType)currentDataObject.getType()).getHelperContext();
            if (this.currentSchemaType != null) {
                SDOType sdoType = ((SDOTypeHelper)aHelperContext.getTypeHelper()).getSDOTypeFromXSDType(this.currentSchemaType);
                if (sdoType != null) {
                    ((SDOProperty)currentProperty).setType(sdoType);
                }
                if (currentProperty.getType() != null && simple) {
                    value = ((SDODataHelper)aHelperContext.getDataHelper()).convertFromStringValue((String)value, currentProperty.getType(), this.currentSchemaType);
                }
                this.currentSchemaType = null;
            } else if (currentProperty.getType() != null && currentProperty.getType().isDataType()) {
                value = ((SDODataHelper)aHelperContext.getDataHelper()).convertFromStringValue((String)value, currentProperty.getType());
            }
            if (currentDataObject != null) {
                if (!simple) {
                    this.parentRecord.getUnmarshaller().getUnmarshalListener().afterUnmarshal(value, currentDataObject);
                }
                if (currentProperty.isMany()) {
                    currentDataObject.getList(currentProperty).add(value);
                } else {
                    currentDataObject.set(currentProperty, value);
                }
            }
            this.currentBuffer.reset();
        }
    }

    private void processNonRoot(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        DataObject owner = (DataObject)this.currentDataObjects.peek();
        if (owner != null && !owner.getType().isOpen()) {
            return;
        }
        Property globalProperty = this.aHelperContext.getXSDHelper().getGlobalProperty(namespaceURI, localName, true);
        if (globalProperty != null) {
            this.currentProperties.push(globalProperty);
            SDOType theType = (SDOType)globalProperty.getType();
            if (globalProperty.getType().isDataType()) {
                ++this.depth;
            } else {
                XMLDescriptor xmlDescriptor = theType.getXmlDescriptor();
                this.giveToOXToProcess(namespaceURI, localName, qName, atts, xmlDescriptor);
            }
        } else {
            String typeName = localName;
            String typeUri = namespaceURI;
            QName typeAttribute = this.getTypeAttributeQName(atts);
            SDOType newType = null;
            if (typeAttribute != null) {
                typeName = typeAttribute.getLocalPart();
                typeUri = typeAttribute.getNamespaceURI();
                newType = this.aHelperContext.getTypeHelper().getType(typeUri, typeName);
            }
            if (newType == null) {
                newType = SDOConstants.SDO_OPEN_SEQUENCED;
                SDOProperty property = this.defineNewSDOProperty(namespaceURI, localName, true, newType);
                DataObject newDO = this.aHelperContext.getDataFactory().create((Type)newType);
                this.processAttributes(atts, newDO, false);
                this.currentDataObjects.push(newDO);
                ++this.depth;
                this.parentRecord.setCurrentObject(newDO);
                this.currentProperties.push(property);
            } else {
                XMLDescriptor xmlDescriptor = newType.getXmlDescriptor();
                this.giveToOXToProcess(namespaceURI, localName, qName, atts, xmlDescriptor);
                SDOProperty property = this.defineNewSDOProperty(namespaceURI, localName, true, newType);
                this.currentProperties.push(property);
                return;
            }
        }
    }

    private void processRoot(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        DataFactory dataFactory = this.aHelperContext.getDataFactory();
        SDOTypeHelper typeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
        this.getXmlDocument().setRootElementName(localName);
        this.getXmlDocument().setRootElementURI(namespaceURI);
        Property rootElementProperty = this.aHelperContext.getXSDHelper().getGlobalProperty(namespaceURI, localName, true);
        Type rootObjectType = null;
        if (rootElementProperty != null) {
            rootObjectType = rootElementProperty.getType();
        } else {
            QName typeQName = this.getTypeAttributeQName(atts);
            if (typeQName != null) {
                String typeName = typeQName.getLocalPart();
                String typeUri = null;
                String prefix = typeQName.getPrefix();
                typeUri = prefix == null || prefix.equals("") ? null : (String)this.getNamespaceMap().get(prefix);
                rootObjectType = typeHelper.getType(typeUri, typeName);
            }
        }
        DataObject rootObject = null;
        if (rootObjectType != null) {
            this.giveToOXToProcess(namespaceURI, localName, qName, atts, ((SDOType)rootObjectType).getXmlDescriptor());
            return;
        }
        SDOType rootType = SDOConstants.SDO_OPEN_SEQUENCED;
        rootObject = dataFactory.create((Type)rootType);
        this.currentDataObjects.push(rootObject);
        ++this.depth;
        this.processAttributes(atts, rootObject, true);
        this.getXmlDocument().setRootObject(rootObject);
        this.rootProcessed = true;
        this.parentRecord.setCurrentObject(this.getXmlDocument());
    }

    private SDOProperty defineNewSDOProperty(String uri, String localName, boolean isElement, Type type) {
        SDOProperty lookedUp;
        DataObject currentDataObject = (DataObject)this.currentDataObjects.peek();
        if (uri != null && uri.equals("")) {
            uri = NO_NAMESPACE;
        }
        if ((lookedUp = (SDOProperty)currentDataObject.getInstanceProperty(localName)) != null && this.equalStrings(lookedUp.getUri(), uri)) {
            if (isElement && this.aHelperContext.getXSDHelper().isElement((Property)lookedUp)) {
                return lookedUp;
            }
            if (!isElement && this.aHelperContext.getXSDHelper().isAttribute((Property)lookedUp)) {
                return lookedUp;
            }
        }
        SDOProperty property = new SDOProperty(this.aHelperContext);
        property.setName(localName);
        property.setMany(isElement);
        property.setContainment(!type.isDataType());
        property.setType(type);
        property.setUri(uri);
        property.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, isElement);
        return property;
    }

    private void giveToOXToProcess(String namespaceURI, String localName, String qName, Attributes atts, XMLDescriptor xmlDescriptor) throws SAXException {
        UnmarshalRecord unmarshalRecord;
        AbstractSession session = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().getReadSession(xmlDescriptor);
        if (xmlDescriptor.hasInheritance()) {
            QName leafElementType;
            unmarshalRecord = new UnmarshalRecord((TreeObjectBuilder)xmlDescriptor.getObjectBuilder());
            unmarshalRecord.setNamespaceMap(this.namespaceMap);
            unmarshalRecord.setUriToPrefixMap(this.uriToPrefixMap);
            unmarshalRecord.setAttributes(atts);
            Class classValue = xmlDescriptor.getInheritancePolicy().classFromRow(unmarshalRecord, session);
            if (classValue == null && (leafElementType = xmlDescriptor.getDefaultRootElementType()) != null) {
                Object indicator = xmlDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(leafElementType);
                if (indicator == null) {
                    throw DescriptorException.missingClassForIndicatorFieldValue(leafElementType, xmlDescriptor.getInheritancePolicy().getDescriptor());
                }
                classValue = (Class)indicator;
            }
            if (classValue != null) {
                xmlDescriptor = (XMLDescriptor)session.getDescriptor(classValue);
            } else if (Modifier.isAbstract(xmlDescriptor.getJavaClass().getModifiers())) {
                throw DescriptorException.missingClassIndicatorField(unmarshalRecord, xmlDescriptor.getInheritancePolicy().getDescriptor());
            }
        }
        unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord();
        unmarshalRecord.setParentRecord(this.parentRecord);
        unmarshalRecord.setSession(session);
        unmarshalRecord.setUnmarshaller(this.parentRecord.getUnmarshaller());
        unmarshalRecord.setXMLReader(this.parentRecord.getXMLReader());
        unmarshalRecord.startDocument();
        unmarshalRecord.setNamespaceMap(this.namespaceMap);
        unmarshalRecord.setUriToPrefixMap(this.uriToPrefixMap);
        unmarshalRecord.startElement(namespaceURI, localName, qName, atts);
        this.parentRecord.getXMLReader().setContentHandler(unmarshalRecord);
        try {
            unmarshalRecord.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
        }
        catch (SAXNotRecognizedException ex) {
        }
        catch (SAXNotSupportedException ex) {
            // empty catch block
        }
        this.currentDataObjects.push(unmarshalRecord.getCurrentObject());
        ++this.depth;
    }

    private SDOXMLDocument getXmlDocument() {
        if (this.xmlDocument == null) {
            this.xmlDocument = new SDOXMLDocument();
        }
        return this.xmlDocument;
    }

    public void setUnmarshalRecord(UnmarshalRecord unmarshalRecord) {
        this.parentRecord = unmarshalRecord;
        this.aHelperContext = (HelperContext)unmarshalRecord.getUnmarshaller().getProperty("sdoHelperContext");
        if (this.parentRecord.getParentRecord() == null) {
            this.rootProcessed = false;
        } else {
            this.rootProcessed = true;
            if (this.parentRecord.getParentRecord().getCurrentObject() instanceof DataObject) {
                this.currentDataObjects.push(this.parentRecord.getParentRecord().getCurrentObject());
                ++this.depth;
            }
        }
        this.namespaceMap = this.parentRecord.getNamespaceMap();
        this.uriToPrefixMap = this.parentRecord.getUriToPrefixMap();
    }

    public Map getNamespaceMap() {
        if (this.namespaceMap == null) {
            this.namespaceMap = new HashMap();
        }
        return this.namespaceMap;
    }

    private boolean equalStrings(String string1, String string2) {
        if (string1 == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string1.equals(string2);
    }
}

