/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.JNDIConnector;

public class OracleJDBC10_1_0_2ProxyConnector
extends JNDIConnector {
    public OracleJDBC10_1_0_2ProxyConnector() {
    }

    public OracleJDBC10_1_0_2ProxyConnector(Context context, String name) throws ValidationException {
        super(context, name);
    }

    public OracleJDBC10_1_0_2ProxyConnector(String name) {
        super(name);
    }

    public OracleJDBC10_1_0_2ProxyConnector(DataSource dataSource) {
        super(dataSource);
    }

    public Connection connect(Properties properties) throws DatabaseException, ValidationException {
        Connection conn = super.connect(properties);
        String proxytype = properties.getProperty("proxytype");
        if (proxytype != null && proxytype.length() > 0) {
            int proxytype_int;
            try {
                proxytype_int = Integer.valueOf(proxytype);
            }
            catch (ClassCastException classCastException) {
                throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresIntProxytype();
            }
            try {
                ((OracleConnection)conn).openProxySession(proxytype_int, properties);
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException(exception);
            }
            catch (ClassCastException classCastException) {
                throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresOracleConnection();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresOracleConnectionVersion();
            }
        }
        return conn;
    }
}

