/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.jdbc;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.jdbc.JDBCType;
import org.eclipse.persistence.platform.database.oracle.PLSQLargument;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JDBCTypes implements JDBCType
{
    ARRAY_TYPE(2003, "ARRAY"),
    BIGINT_TYPE(-5, "BIGINT"),
    BINARY_TYPE(-2, "BINARY"),
    BIT_TYPE(-7, "BIT"),
    BLOB_TYPE(2004, "BLOB"),
    BOOLEAN_TYPE(16, "BOOLEAN"),
    CHAR_TYPE(1, "CHAR"),
    CLOB_TYPE(2005, "CLOB"),
    DATALINK_TYPE(70, "DATALINK"),
    DATE_TYPE(91, "DATE"),
    DECIMAL_TYPE(3, "DECIMAL"),
    DISTINCT_TYPE(2001, "DISTINCT"),
    DOUBLE_TYPE(8, "DOUBLE"),
    FLOAT_TYPE(6, "FLOAT"),
    INTEGER_TYPE(4, "INTEGER"),
    JAVA_OBJECT_TYPE(2000, "JAVA_OBJECT"),
    LONGVARBINARY_TYPE(-4, "LONGVARBINARY"),
    LONGVARCHAR_TYPE(-1, "LONGVARCHAR"),
    NULL_TYPE(0, "NULL"),
    NUMERIC_TYPE(2, "NUMERIC"){

        protected void buildInitialDeclare(StringBuilder sb, PLSQLargument arg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, arg, this);
            if (arg.precision != Integer.MIN_VALUE) {
                sb.append("(");
                sb.append(arg.precision);
                if (arg.scale != Integer.MIN_VALUE) {
                    sb.append(",");
                    sb.append(arg.scale);
                }
                sb.append(")");
            }
        }

        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            this.buildInitialDeclare(sb, inArg);
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";\n");
        }

        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            this.buildInitialDeclare(sb, outArg);
            sb.append(";\n");
        }
    }
    ,
    OTHER_TYPE(1111, "OTHER"),
    REAL_TYPE(7, "REAL"),
    REF_TYPE(2006, "REF"),
    SMALLINT_TYPE(5, "SMALLINT"),
    STRUCT_TYPE(2002, "STRUCT"),
    TIME_TYPE(92, "TIME"),
    TIMESTAMP_TYPE(93, "TIMESTAMP"),
    TINYINT_TYPE(-6, "TINYINT"),
    VARBINARY_TYPE(-3, "VARBINARY"),
    VARCHAR_TYPE(12, "VARCHAR"){

        protected void buildInitialDeclare(StringBuilder sb, PLSQLargument arg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, arg, this);
            if (arg.length != Integer.MIN_VALUE) {
                sb.append("(");
                sb.append(arg.length);
                sb.append(")");
            }
        }

        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            this.buildInitialDeclare(sb, inArg);
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";\n");
        }

        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            this.buildInitialDeclare(sb, outArg);
            sb.append(";\n");
        }
    };

    private final int typeCode;
    private final String typeName;

    private JDBCTypes(int typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    @Override
    public boolean isComplexDatabaseType() {
        return false;
    }

    @Override
    public boolean isJDBCType() {
        return true;
    }

    @Override
    public int getSqlCode() {
        return this.typeCode;
    }

    @Override
    public int getConversionCode() {
        return this.getSqlCode();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public int computeInIndex(PLSQLargument inArg, int newIndex, ListIterator<PLSQLargument> i) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeInIndex(inArg, newIndex);
    }

    @Override
    public int computeOutIndex(PLSQLargument outArg, int newIndex, ListIterator<PLSQLargument> i) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeOutIndex(outArg, newIndex);
    }

    @Override
    public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, inArg, this);
        sb.append(" := :");
        sb.append(inArg.inIndex);
        sb.append(";\n");
    }

    @Override
    public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, outArg, this);
        sb.append(";\n");
    }

    @Override
    public void buildBeginBlock(StringBuilder sb, PLSQLargument arg) {
    }

    @Override
    public void buildOutAssignment(StringBuilder sb, PLSQLargument outArg) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutAssignment(sb, outArg);
    }

    @Override
    public void translate(PLSQLargument arg, AbstractRecord translationRow, AbstractRecord copyOfTranslationRow, Vector copyOfTranslationFields, Vector translationRowFields, Vector translationRowValues) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.translate(arg, translationRow, copyOfTranslationRow, copyOfTranslationFields, translationRowFields, translationRowValues);
    }

    @Override
    public void buildOutputRow(PLSQLargument outArg, AbstractRecord outputRow, DatabaseRecord newOutputRow, Vector outputRowFields, Vector outputRowValues) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutputRow(outArg, outputRow, newOutputRow, outputRowFields, outputRowValues);
    }

    @Override
    public void logParameter(StringBuilder sb, Integer direction, PLSQLargument arg, AbstractRecord translationRow, DatabasePlatform platform) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.logParameter(sb, direction, arg, translationRow, platform);
    }

    public static DatabaseType getDatabaseTypeForCode(int typeCode) {
        JDBCTypes databaseType = null;
        switch (typeCode) {
            case 2003: {
                databaseType = ARRAY_TYPE;
                break;
            }
            case -5: {
                databaseType = BIGINT_TYPE;
                break;
            }
            case -2: {
                databaseType = BINARY_TYPE;
                break;
            }
            case -7: {
                databaseType = BIT_TYPE;
                break;
            }
            case 2004: {
                databaseType = BLOB_TYPE;
                break;
            }
            case 16: {
                databaseType = BOOLEAN_TYPE;
                break;
            }
            case 1: {
                databaseType = CHAR_TYPE;
                break;
            }
            case 2005: {
                databaseType = CLOB_TYPE;
                break;
            }
            case 70: {
                databaseType = DATALINK_TYPE;
                break;
            }
            case 91: {
                databaseType = DATE_TYPE;
                break;
            }
            case 3: {
                databaseType = DECIMAL_TYPE;
                break;
            }
            case 2001: {
                databaseType = DISTINCT_TYPE;
                break;
            }
            case 8: {
                databaseType = DOUBLE_TYPE;
                break;
            }
            case 6: {
                databaseType = FLOAT_TYPE;
                break;
            }
            case 4: {
                databaseType = INTEGER_TYPE;
                break;
            }
            case 2000: {
                databaseType = JAVA_OBJECT_TYPE;
                break;
            }
            case -4: {
                databaseType = LONGVARBINARY_TYPE;
                break;
            }
            case -1: {
                databaseType = LONGVARCHAR_TYPE;
                break;
            }
            case 0: {
                databaseType = NULL_TYPE;
                break;
            }
            case 2: {
                databaseType = NUMERIC_TYPE;
                break;
            }
            case 1111: {
                databaseType = OTHER_TYPE;
                break;
            }
            case 7: {
                databaseType = REAL_TYPE;
                break;
            }
            case 2006: {
                databaseType = REF_TYPE;
                break;
            }
            case 5: {
                databaseType = SMALLINT_TYPE;
                break;
            }
            case 2002: {
                databaseType = STRUCT_TYPE;
                break;
            }
            case 92: {
                databaseType = TIME_TYPE;
                break;
            }
            case 93: {
                databaseType = TIMESTAMP_TYPE;
                break;
            }
            case -6: {
                databaseType = TINYINT_TYPE;
                break;
            }
            case -3: {
                databaseType = VARBINARY_TYPE;
                break;
            }
            case 12: {
                databaseType = VARCHAR_TYPE;
            }
        }
        return databaseType;
    }
}

