/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.ReferenceResolver;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnionField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLObjectReferenceMapping
extends AggregateMapping
implements XMLMapping {
    protected HashMap sourceToTargetKeyFieldAssociations = new HashMap();
    protected Vector sourceToTargetKeys = new Vector();

    public void addSourceToTargetKeyFieldAssociation(String srcXPath, String tgtXPath) {
        XMLField srcFld = new XMLField(srcXPath);
        this.sourceToTargetKeys.add(srcFld);
        this.sourceToTargetKeyFieldAssociations.put(srcFld, new XMLField(tgtXPath));
    }

    public Object buildFieldValue(Object targetObject, XMLField xmlFld, AbstractSession session) {
        if (targetObject == null || this.getReferenceClass() == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getReferenceDescriptor();
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Vector pks = objectBuilder.extractPrimaryKeyFromObject(targetObject, session);
        int idx = descriptor.getPrimaryKeyFields().indexOf(this.getSourceToTargetKeyFieldAssociations().get(xmlFld));
        if (idx == -1) {
            return null;
        }
        return pks.get(idx);
    }

    public void buildReference(UnmarshalRecord record, XMLField xmlField, Object object, AbstractSession session) {
        ReferenceResolver resolver = ReferenceResolver.getInstance(session);
        if (resolver == null) {
            return;
        }
        Object srcObject = record.getCurrentObject();
        ClassDescriptor clsDescriptor = session.getClassDescriptor(this.getReferenceClass());
        Vector<String> pkFieldNames = clsDescriptor.getPrimaryKeyFieldNames();
        Reference reference = resolver.getReference(this, srcObject);
        if (reference == null) {
            Vector pks = new Vector();
            pks.setSize(pkFieldNames.size());
            reference = new Reference((XMLMapping)this, srcObject, this.getReferenceClass(), pks);
            resolver.addReference(reference);
            record.reference(reference);
        }
        XMLField tgtFld = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(xmlField);
        int idx = pkFieldNames.indexOf(tgtFld.getXPath());
        Vector primaryKeys = reference.getPrimaryKeys();
        Object value = XMLConversionManager.getDefaultXMLManager().convertObject(object, clsDescriptor.getTypedField(tgtFld).getType());
        if (value != null) {
            primaryKeys.setElementAt(value, idx);
        }
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object objectReferenced = this.getRealAttributeValueFromObject(object, uow);
        if (objectReferenced == null) {
            return;
        }
        if (!visitedObjects.containsKey(objectReferenced)) {
            visitedObjects.put(objectReferenced, objectReferenced);
            ObjectBuilder builder = this.getReferenceDescriptor(objectReferenced.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadePerformRemove(objectReferenced, uow, visitedObjects);
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object objectReferenced = this.getRealAttributeValueFromObject(object, uow);
        if (objectReferenced == null) {
            return;
        }
        if (!visitedObjects.containsKey(objectReferenced)) {
            visitedObjects.put(objectReferenced, objectReferenced);
            ObjectBuilder builder = this.getReferenceDescriptor(objectReferenced.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadeRegisterNewForCreate(objectReferenced, uow, visitedObjects);
        }
    }

    public Vector getFields() {
        return this.sourceToTargetKeys;
    }

    protected QName getSchemaType(XMLField xmlField, Object value) {
        QName schemaType = null;
        if (xmlField.isTypedTextField()) {
            schemaType = xmlField.getXMLType(value.getClass());
        } else {
            if (xmlField.isUnionField()) {
                return this.getSingleValueToWriteForUnion((XMLUnionField)xmlField, value);
            }
            if (xmlField.getSchemaType() != null) {
                schemaType = xmlField.getSchemaType();
            }
        }
        return schemaType;
    }

    protected QName getSingleValueToWriteForUnion(XMLUnionField xmlField, Object value) {
        ArrayList schemaTypes = xmlField.getSchemaTypes();
        QName schemaType = null;
        for (int i = 0; i < schemaTypes.size(); ++i) {
            QName nextQName = (QName)xmlField.getSchemaTypes().get(i);
            try {
                if (nextQName == null) continue;
                Class javaClass = xmlField.getJavaClass(nextQName);
                value = XMLConversionManager.getDefaultXMLManager().convertObject(value, javaClass, nextQName);
                schemaType = nextQName;
                break;
            }
            catch (ConversionException ce) {
                if (i != schemaTypes.size() - 1) continue;
                schemaType = nextQName;
            }
        }
        return schemaType;
    }

    public HashMap getSourceToTargetKeyFieldAssociations() {
        return this.sourceToTargetKeyFieldAssociations;
    }

    protected String getValueToWrite(QName schemaType, Object value) {
        return (String)XMLConversionManager.getDefaultXMLManager().convertObject(value, ClassConstants.STRING, schemaType);
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.getReferenceClass() == null) {
            this.setReferenceClass(ConversionManager.getDefaultManager().convertClassNameToClass(this.getReferenceClassName()));
        }
        super.initialize(session);
        ReferenceResolver resolver = new ReferenceResolver();
        if (!session.getEventManager().getListeners().contains(resolver)) {
            session.getEventManager().addListener(resolver);
        }
        XMLDescriptor descriptor = (XMLDescriptor)this.getDescriptor();
        XMLDescriptor targetDescriptor = (XMLDescriptor)this.getReferenceDescriptor();
        for (int index = 0; index < this.sourceToTargetKeys.size(); ++index) {
            XMLField sourceField = (XMLField)this.sourceToTargetKeys.get(index);
            sourceField = (XMLField)descriptor.buildField(sourceField);
            this.sourceToTargetKeys.set(index, sourceField);
            XMLField targetField = (XMLField)this.sourceToTargetKeyFieldAssociations.get(sourceField);
            targetField = (XMLField)targetDescriptor.buildField(targetField);
            this.sourceToTargetKeyFieldAssociations.put(sourceField, targetField);
        }
    }

    public boolean isXMLMapping() {
        return true;
    }

    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        ClassDescriptor descriptor = sourceQuery.getSession().getClassDescriptor(this.getReferenceClass());
        Vector<String> pkFieldNames = descriptor.getPrimaryKeyFieldNames();
        Vector<Object> primaryKeys = new Vector<Object>();
        primaryKeys.setSize(pkFieldNames.size());
        for (XMLField keyFld : this.sourceToTargetKeys) {
            Object value;
            XMLField tgtFld = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(keyFld);
            int idx = pkFieldNames.indexOf(tgtFld.getXPath());
            if (idx == -1 || (value = XMLConversionManager.getDefaultXMLManager().convertObject(databaseRow.get(keyFld), descriptor.getTypedField(tgtFld).getType())) == null) continue;
            primaryKeys.setElementAt(value, idx);
        }
        ReferenceResolver resolver = ReferenceResolver.getInstance(sourceQuery.getSession());
        if (resolver != null) {
            resolver.addReference(new Reference((XMLMapping)this, targetObject, this.referenceClass, primaryKeys));
        }
        return null;
    }

    public void setField(DatabaseField field) {
    }

    public void setSourceToTargetKeyFieldAssociations(HashMap sourceToTargetKeyFieldAssociations) {
        this.sourceToTargetKeyFieldAssociations = sourceToTargetKeyFieldAssociations;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) {
        Object targetObject = this.getAttributeValueFromObject(object);
        this.writeSingleValue(targetObject, object, (XMLRecord)row, session);
    }

    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
        for (XMLField xmlField : this.getFields()) {
            Object fieldValue = this.buildFieldValue(value, xmlField, session);
            if (fieldValue == null) continue;
            QName schemaType = this.getSchemaType(xmlField, fieldValue);
            String stringValue = this.getValueToWrite(schemaType, fieldValue);
            row.put(xmlField, (Object)stringValue);
        }
    }
}

