/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.DateFormatThreadLocal;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.sessions.Session;

public abstract class AbstractSessionLog
implements SessionLog,
Cloneable {
    protected int level;
    protected static SessionLog defaultLog;
    protected Session session;
    protected static String SEVERE_PREFIX;
    protected static String WARNING_PREFIX;
    protected static String INFO_PREFIX;
    protected static String CONFIG_PREFIX;
    protected static String FINE_PREFIX;
    protected static String FINER_PREFIX;
    protected static String FINEST_PREFIX;
    protected static String TOPLINK_PREFIX;
    protected static final String CONNECTION_STRING = "Connection";
    protected static final String THREAD_STRING = "Thread";
    protected Writer writer = new PrintWriter(System.out);
    protected static String DATE_FORMAT_STR;
    protected DateFormatThreadLocal dateFormat;
    protected Boolean shouldLogExceptionStackTrace;
    protected Boolean shouldPrintDate;
    protected Boolean shouldPrintThread;
    protected Boolean shouldPrintSession;
    protected Boolean shouldPrintConnection;

    public static int getDefaultLoggingLevel() {
        String logLevel = System.getProperty("eclipselink.logging.level");
        return AbstractSessionLog.translateStringToLoggingLevel(logLevel);
    }

    public AbstractSessionLog() {
        this.level = AbstractSessionLog.getDefaultLoggingLevel();
        this.dateFormat = new DateFormatThreadLocal(DATE_FORMAT_STR, null);
    }

    public int getLevel() {
        return this.getLevel(null);
    }

    public String getLevelString() {
        int level = this.getLevel();
        switch (level) {
            case 8: {
                return "OFF";
            }
            case 7: {
                return "SEVERE";
            }
            case 6: {
                return "WARNING";
            }
            case 5: {
                return "INFO";
            }
            case 4: {
                return "CONFIG";
            }
            case 3: {
                return "FINE";
            }
            case 2: {
                return "FINER";
            }
            case 1: {
                return "FINEST";
            }
            case 0: {
                return "ALL";
            }
        }
        return "INFO";
    }

    public int getLevel(String category) {
        return this.level;
    }

    public void setLevel(int level) {
        this.setLevel(level, null);
    }

    public void setLevel(int level, String category) {
        this.level = level;
    }

    public boolean shouldLog(int level) {
        return this.shouldLog(level, null);
    }

    public boolean shouldLog(int level, String category) {
        return this.level <= level && !this.isOff();
    }

    public static SessionLog getLog() {
        if (defaultLog == null) {
            defaultLog = new DefaultSessionLog();
        }
        return defaultLog;
    }

    public static void setLog(SessionLog sessionLog) {
        defaultLog = sessionLog;
        defaultLog.setSession(null);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void log(int level, String message) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, null, false);
    }

    public void log(int level, String message, Object param) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, new Object[]{param});
    }

    public void log(int level, String message, Object param1, Object param2) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, new Object[]{param1, param2});
    }

    public void log(int level, String message, Object param1, Object param2, Object param3) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, new Object[]{param1, param2, param3});
    }

    public void log(int level, String message, Object[] params) {
        this.log(level, message, params, true);
    }

    public void log(int level, String message, Object[] params, boolean shouldTranslate) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(new SessionLogEntry(level, null, message, params, null, shouldTranslate));
    }

    public abstract void log(SessionLogEntry var1);

    public boolean shouldPrintSession() {
        return this.shouldPrintSession == null || this.shouldPrintSession != false;
    }

    public void setShouldPrintSession(boolean shouldPrintSession) {
        this.shouldPrintSession = shouldPrintSession ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintConnection() {
        return this.shouldPrintConnection == null || this.shouldPrintConnection != false;
    }

    public void setShouldPrintConnection(boolean shouldPrintConnection) {
        this.shouldPrintConnection = shouldPrintConnection ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldLogExceptionStackTrace() {
        if (this.shouldLogExceptionStackTrace == null) {
            return this.getLevel() <= 2;
        }
        return this.shouldLogExceptionStackTrace;
    }

    public void setShouldLogExceptionStackTrace(boolean shouldLogExceptionStackTrace) {
        this.shouldLogExceptionStackTrace = shouldLogExceptionStackTrace ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintDate() {
        return this.shouldPrintDate == null || this.shouldPrintDate != false;
    }

    public void setShouldPrintDate(boolean shouldPrintDate) {
        this.shouldPrintDate = shouldPrintDate ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintThread() {
        if (this.shouldPrintThread == null) {
            return this.getLevel() <= 3;
        }
        return this.shouldPrintThread;
    }

    public void setShouldPrintThread(boolean shouldPrintThread) {
        this.shouldPrintThread = shouldPrintThread ? Boolean.TRUE : Boolean.FALSE;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setWriter(OutputStream outputstream) {
        this.writer = new OutputStreamWriter(outputstream);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat.get();
    }

    protected String getDateString(Date date) {
        return this.getDateFormat().format(date);
    }

    protected String getSupplementDetailString(SessionLogEntry entry) {
        StringWriter writer = new StringWriter();
        if (this.shouldPrintDate()) {
            writer.write(this.getDateString(entry.getDate()));
            writer.write("--");
        }
        if (this.shouldPrintSession() && entry.getSession() != null) {
            writer.write(this.getSessionString(entry.getSession()));
            writer.write("--");
        }
        if (this.shouldPrintConnection() && entry.getConnection() != null) {
            writer.write(this.getConnectionString(entry.getConnection()));
            writer.write("--");
        }
        if (this.shouldPrintThread()) {
            writer.write(this.getThreadString(entry.getThread()));
            writer.write("--");
        }
        return writer.toString();
    }

    protected String getSessionString(Session session) {
        if (session != null) {
            return ((AbstractSession)session).getLogSessionString();
        }
        return "";
    }

    protected String getConnectionString(Accessor connection) {
        if (connection.getDatasourceConnection() == null) {
            return "Connection(" + String.valueOf(System.identityHashCode(connection)) + ")";
        }
        return "Connection(" + String.valueOf(System.identityHashCode(connection.getDatasourceConnection())) + ")";
    }

    protected String getThreadString(Thread thread) {
        return "Thread(" + String.valueOf(thread) + ")";
    }

    protected void printPrefixString(int level) {
        try {
            switch (level) {
                case 7: {
                    if (SEVERE_PREFIX == null) {
                        SEVERE_PREFIX = LoggingLocalization.buildMessage("toplink_severe");
                    }
                    this.getWriter().write(SEVERE_PREFIX);
                    break;
                }
                case 6: {
                    if (WARNING_PREFIX == null) {
                        WARNING_PREFIX = LoggingLocalization.buildMessage("toplink_warning");
                    }
                    this.getWriter().write(WARNING_PREFIX);
                    break;
                }
                case 5: {
                    if (INFO_PREFIX == null) {
                        INFO_PREFIX = LoggingLocalization.buildMessage("toplink_info");
                    }
                    this.getWriter().write(INFO_PREFIX);
                    break;
                }
                case 4: {
                    if (CONFIG_PREFIX == null) {
                        CONFIG_PREFIX = LoggingLocalization.buildMessage("toplink_config");
                    }
                    this.getWriter().write(CONFIG_PREFIX);
                    break;
                }
                case 3: {
                    if (FINE_PREFIX == null) {
                        FINE_PREFIX = LoggingLocalization.buildMessage("toplink_fine");
                    }
                    this.getWriter().write(FINE_PREFIX);
                    break;
                }
                case 2: {
                    if (FINER_PREFIX == null) {
                        FINER_PREFIX = LoggingLocalization.buildMessage("toplink_finer");
                    }
                    this.getWriter().write(FINER_PREFIX);
                    break;
                }
                case 1: {
                    if (FINEST_PREFIX == null) {
                        FINEST_PREFIX = LoggingLocalization.buildMessage("toplink_finest");
                    }
                    this.getWriter().write(FINEST_PREFIX);
                    break;
                }
                default: {
                    if (TOPLINK_PREFIX == null) {
                        TOPLINK_PREFIX = LoggingLocalization.buildMessage("toplink");
                    }
                    this.getWriter().write(TOPLINK_PREFIX);
                    break;
                }
            }
        }
        catch (IOException exception) {
            throw ValidationException.logIOError(exception);
        }
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat.set(dateFormat);
    }

    protected String formatMessage(SessionLogEntry entry) {
        String message = entry.getMessage();
        if (entry.shouldTranslate()) {
            message = entry.getLevel() > 3 ? LoggingLocalization.buildMessage(message, entry.getParameters()) : TraceLocalization.buildMessage(message, entry.getParameters());
        } else if (entry.getParameters() != null && entry.getParameters().length > 0 && message.indexOf("{0") >= 0) {
            message = MessageFormat.format(message, entry.getParameters());
        }
        return message;
    }

    public static int translateStringToLoggingLevel(String loggingLevel) {
        if (loggingLevel == null) {
            return 5;
        }
        String level = loggingLevel.toUpperCase();
        if (level.equals("OFF")) {
            return 8;
        }
        if (level.equals("SEVERE")) {
            return 7;
        }
        if (level.equals("WARNING")) {
            return 6;
        }
        if (level.equals("INFO")) {
            return 5;
        }
        if (level.equals("CONFIG")) {
            return 4;
        }
        if (level.equals("FINE")) {
            return 3;
        }
        if (level.equals("FINER")) {
            return 2;
        }
        if (level.equals("FINEST")) {
            return 1;
        }
        if (level.equals("ALL")) {
            return 0;
        }
        return 5;
    }

    public void throwing(Throwable throwable) {
        if (this.shouldLog(2)) {
            SessionLogEntry entry = new SessionLogEntry(null, throwable);
            entry.setLevel(2);
            this.log(entry);
        }
    }

    public void severe(String message) {
        this.log(7, message, null);
    }

    public void warning(String message) {
        this.log(6, message, null);
    }

    public void info(String message) {
        this.log(5, message, null);
    }

    public void config(String message) {
        this.log(4, message, null);
    }

    public void fine(String message) {
        this.log(3, message, null);
    }

    public void finer(String message) {
        this.log(2, message, null);
    }

    public void finest(String message) {
        this.log(1, message, null);
    }

    public void logThrowable(int level, Throwable throwable) {
        if (this.shouldLog(level)) {
            this.log(new SessionLogEntry(null, level, null, throwable));
        }
    }

    public boolean isOff() {
        return this.level == 8;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String translateLoggingLevelToString(int loggingLevel) {
        if (loggingLevel == 8) {
            return "OFF";
        }
        if (loggingLevel == 7) {
            return "SEVERE";
        }
        if (loggingLevel == 6) {
            return "WARNING";
        }
        if (loggingLevel == 5) {
            return "INFO";
        }
        if (loggingLevel == 4) {
            return "CONFIG";
        }
        if (loggingLevel == 3) {
            return "FINE";
        }
        if (loggingLevel == 2) {
            return "FINER";
        }
        if (loggingLevel == 1) {
            return "FINEST";
        }
        if (loggingLevel == 0) {
            return "ALL";
        }
        return "INFO";
    }

    static {
        SEVERE_PREFIX = null;
        WARNING_PREFIX = null;
        INFO_PREFIX = null;
        CONFIG_PREFIX = null;
        FINE_PREFIX = null;
        FINER_PREFIX = null;
        FINEST_PREFIX = null;
        TOPLINK_PREFIX = null;
        DATE_FORMAT_STR = "yyyy.MM.dd hh:mm:ss.SSS";
    }
}

