/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

public class OrderedCollectionChangeRecord
extends ChangeRecord
implements org.eclipse.persistence.sessions.changesets.OrderedCollectionChangeRecord {
    protected Hashtable addObjectList;
    protected Vector addIndexes;
    protected int startIndexOfRemove;

    public OrderedCollectionChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
        this.startIndexOfRemove = Integer.MAX_VALUE;
    }

    public void addAdditionChange(Hashtable additions, Vector indexes, UnitOfWorkChangeSet changes, AbstractSession session) {
        Enumeration enumtr = additions.keys();
        while (enumtr.hasMoreElements()) {
            Object index = enumtr.nextElement();
            Object object = additions.get(index);
            ObjectChangeSet changeSet = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changes, session);
            additions.put(index, changeSet);
        }
        this.addObjectList = additions;
        this.addIndexes = indexes;
    }

    public Vector getAddIndexes() {
        if (this.addIndexes == null) {
            this.addIndexes = new Vector(1);
        }
        return this.addIndexes;
    }

    public Hashtable getAddObjectList() {
        if (this.addObjectList == null) {
            this.addObjectList = new Hashtable(1);
        }
        return this.addObjectList;
    }

    public int getStartRemoveIndex() {
        return this.startIndexOfRemove;
    }

    public void mergeRecord(ChangeRecord mergeFromRecord, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
    }

    public void prepareForSynchronization(AbstractSession session) {
        Enumeration changes = this.getAddObjectList().elements();
        while (changes.hasMoreElements()) {
            ObjectChangeSet changedObject = (ObjectChangeSet)changes.nextElement();
            if (changedObject.getSynchronizationType() != 0) continue;
            ClassDescriptor descriptor = session.getDescriptor(changedObject.getClassType(session));
            int syncType = descriptor.getCacheSynchronizationType();
            changedObject.setSynchronizationType(syncType);
            changedObject.prepareChangeRecordsForSynchronization(session);
        }
    }

    public void setStartRemoveIndex(int startRemoveIndex) {
        this.startIndexOfRemove = startRemoveIndex;
    }

    public void updateReferences(UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
    }
}

