/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.WriteLockManager;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.InMemoryQueryIndirectionPolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;

public class IdentityMapAccessor
implements org.eclipse.persistence.sessions.IdentityMapAccessor,
Serializable {
    protected IdentityMapManager identityMapManager = null;
    protected AbstractSession session = null;

    public IdentityMapAccessor(AbstractSession session, IdentityMapManager identityMapManager) {
        this.session = session;
        this.identityMapManager = identityMapManager;
    }

    public CacheKey acquireDeferredLock(Vector primarKey, Class javaClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().acquireDeferredLock(primarKey, javaClass, descriptor);
    }

    public CacheKey acquireLock(Vector primarKey, Class javaClass, ClassDescriptor descriptor) {
        return this.acquireLock(primarKey, javaClass, false, descriptor);
    }

    public CacheKey acquireLock(Vector primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().acquireLock(primaryKey, domainClass, forMerge, descriptor);
    }

    public CacheKey acquireLockNoWait(Vector primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().acquireLockNoWait(primaryKey, domainClass, forMerge, descriptor);
    }

    public CacheKey acquireReadLockOnCacheKey(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().acquireReadLockOnCacheKey(primaryKey, domainClass, descriptor);
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().acquireReadLockOnCacheKeyNoWait(primaryKey, domainClass, descriptor);
    }

    public boolean acquireWriteLock() {
        return this.getIdentityMapManager().acquireWriteLock();
    }

    public void clearQueryCache() {
        this.getIdentityMapManager().clearQueryCache();
    }

    public void clearQueryCache(ReadQuery query) {
        this.getIdentityMapManager().clearQueryCache(query);
    }

    public void clearQueryCache(String sessionQueryName) {
        this.getIdentityMapManager().clearQueryCache((ReadQuery)this.session.getQuery(sessionQueryName));
    }

    public void clearQueryCache(String descriptorQueryName, Class queryClass) {
        this.getIdentityMapManager().clearQueryCache((ReadQuery)this.session.getDescriptor(queryClass).getQueryManager().getQuery(descriptorQueryName));
    }

    public boolean containsKey(Vector key, Class theClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().containsKey(key, theClass, descriptor);
    }

    public boolean containsObjectInIdentityMap(Object object) {
        return this.containsObjectInIdentityMap(this.getSession().keyFromObject(object), object.getClass());
    }

    public boolean containsObjectInIdentityMap(Vector primaryKey, Class theClass) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        return this.containsObjectInIdentityMap(primaryKey, theClass, descriptor);
    }

    public boolean containsObjectInIdentityMap(Vector primaryKey, Class theClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().containsKey(primaryKey, theClass, descriptor);
    }

    public boolean containsObjectInIdentityMap(Record rowContainingPrimaryKey, Class theClass) {
        return this.containsObjectInIdentityMap(this.extractPrimaryKeyFromRow(rowContainingPrimaryKey, theClass), theClass);
    }

    protected Vector extractPrimaryKeyFromRow(Record rowContainingPrimaryKey, Class theClass) {
        return this.session.getDescriptor(theClass).getObjectBuilder().extractPrimaryKeyFromRow((AbstractRecord)rowContainingPrimaryKey, this.session);
    }

    public CacheKey getCacheKeyForObject(Object object, ClassDescriptor descriptor) {
        return this.getCacheKeyForObject(this.getSession().keyFromObject(object, descriptor), object.getClass(), descriptor);
    }

    public Vector getClassesRegistered() {
        return this.getIdentityMapManager().getClassesRegistered();
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow) throws QueryException {
        return this.getAllFromIdentityMap(selectionCriteria, theClass, translationRow, 0, true);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy) throws QueryException {
        return this.getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, true);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy) throws QueryException {
        return this.getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, true);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean shouldReturnInvalidatedObjects) throws QueryException {
        int policy = 0;
        if (valueHolderPolicy != null) {
            policy = valueHolderPolicy.getPolicy();
        }
        return this.getAllFromIdentityMap(selectionCriteria, theClass, translationRow, policy, shouldReturnInvalidatedObjects);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean shouldReturnInvalidatedObjects) throws QueryException {
        return this.getIdentityMapManager().getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, shouldReturnInvalidatedObjects);
    }

    public Object getFromIdentityMap(Object object) {
        return this.getFromIdentityMap(this.getSession().keyFromObject(object), object.getClass());
    }

    public CacheKey getCacheKeyForObject(Object object) {
        return this.getCacheKeyForObject(this.getSession().keyFromObject(object), object.getClass(), this.getSession().getDescriptor(object.getClass()));
    }

    public CacheKey getCacheKeyForObject(Vector primaryKey, Class myClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getCacheKeyForObject(primaryKey, myClass, descriptor);
    }

    public Object getFromIdentityMap(Vector primaryKey, Class theClass) {
        return this.getFromIdentityMap(primaryKey, theClass, true);
    }

    public Object getFromIdentityMap(Vector primaryKey, Class theClass, ClassDescriptor descriptor) {
        return this.getFromIdentityMap(primaryKey, theClass, true, descriptor);
    }

    public Object getFromIdentityMap(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects) {
        return this.getFromIdentityMap(primaryKey, theClass, shouldReturnInvalidatedObjects, this.getSession().getDescriptor(theClass));
    }

    public Object getFromIdentityMap(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getFromIdentityMap(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    public Object getFromIdentityMap(Record rowContainingPrimaryKey, Class theClass) {
        return this.getFromIdentityMap(this.extractPrimaryKeyFromRow(rowContainingPrimaryKey, theClass), theClass);
    }

    public Object getFromIdentityMap(Record rowContainingPrimaryKey, Class theClass, boolean shouldReturnInvalidatedObjects) {
        return this.getFromIdentityMap(this.extractPrimaryKeyFromRow(rowContainingPrimaryKey, theClass), theClass, shouldReturnInvalidatedObjects);
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow) throws QueryException {
        return this.getFromIdentityMap(selectionCriteria, theClass, translationRow, 0);
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy) throws QueryException {
        int policy = 0;
        if (valueHolderPolicy != null) {
            policy = valueHolderPolicy.getPolicy();
        }
        return this.getFromIdentityMap(selectionCriteria, theClass, translationRow, policy, false);
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy) throws QueryException {
        return this.getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, false);
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean conforming) {
        return this.getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, conforming, true, this.getSession().getDescriptor(theClass));
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean conforming, boolean shouldReturnInvalidatedObjects) {
        return this.getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, conforming, shouldReturnInvalidatedObjects, this.getSession().getDescriptor(theClass));
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean conforming, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, conforming, shouldReturnInvalidatedObjects, descriptor);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector primaryKey, Class theClass, ClassDescriptor descriptor) {
        return this.getFromIdentityMapWithDeferredLock(primaryKey, theClass, true, descriptor);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getFromIdentityMapWithDeferredLock(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    public IdentityMapManager getIdentityMapManager() {
        if (this.session.hasBroker()) {
            return this.getSession().getBroker().getIdentityMapAccessorInstance().getIdentityMapManager();
        }
        return this.identityMapManager;
    }

    public IdentityMap getIdentityMap(Class theClass) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(theClass.toString());
        }
        return this.getIdentityMap(descriptor);
    }

    public IdentityMap getIdentityMap(ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getIdentityMap(descriptor);
    }

    public Object getQueryResult(ReadQuery query, Vector parameters, boolean checkExpiry) {
        return this.getIdentityMapManager().getQueryResult(query, parameters, checkExpiry);
    }

    public long getRemainingValidTime(Object object) {
        Vector primaryKey = this.getSession().keyFromObject(object);
        ClassDescriptor descriptor = this.getSession().getDescriptor(object);
        CacheKey key = this.getCacheKeyForObject(primaryKey, object.getClass(), descriptor);
        if (key == null) {
            throw QueryException.objectDoesNotExistInCache(object);
        }
        return descriptor.getCacheInvalidationPolicy().getRemainingValidTime(key);
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Object getWrapper(Vector primaryKey, Class theClass) {
        return this.getIdentityMapManager().getWrapper(primaryKey, theClass);
    }

    public WriteLockManager getWriteLockManager() {
        return this.getIdentityMapManager().getWriteLockManager();
    }

    public Object getWriteLockValue(Object object) {
        return this.getWriteLockValue(this.getSession().keyFromObject(object), object.getClass());
    }

    public Object getWriteLockValue(Vector primaryKey, Class theClass) {
        return this.getWriteLockValue(primaryKey, theClass, this.getSession().getDescriptor(theClass));
    }

    public Object getWriteLockValue(Vector primaryKey, Class theClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getWriteLockValue(primaryKey, theClass, descriptor);
    }

    public void initializeAllIdentityMaps() {
        this.getSession().log(2, "cache", "initialize_all_identitymaps");
        this.getIdentityMapManager().initializeIdentityMaps();
    }

    public void initializeIdentityMap(Class theClass) {
        this.getSession().log(2, "cache", "initialize_identitymap", theClass);
        this.getIdentityMapManager().initializeIdentityMap(theClass);
    }

    public void initializeIdentityMaps() {
        this.getSession().log(2, "cache", "initialize_identitymaps");
        this.getIdentityMapManager().initializeIdentityMaps();
        if (this.getSession().hasCommitManager()) {
            this.getSession().getCommitManager().reinitialize();
        }
    }

    public void invalidateObject(Object object) {
        this.invalidateObject(this.getSession().keyFromObject(object), object.getClass());
    }

    public void invalidateObject(Vector primaryKey, Class theClass) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        CacheKey key = this.getCacheKeyForObject(primaryKey, theClass, descriptor);
        if (key != null) {
            key.setInvalidationState(-1);
        }
    }

    public void invalidateObject(Record rowContainingPrimaryKey, Class theClass) {
        this.invalidateObject(this.extractPrimaryKeyFromRow(rowContainingPrimaryKey, theClass), theClass);
    }

    public void invalidateObjects(Expression selectionCriteria) {
        this.invalidateObjects(this.getAllFromIdentityMap(selectionCriteria, selectionCriteria.getBuilder().getQueryClass(), new DatabaseRecord(0)));
    }

    public void invalidateObjects(Vector collection) {
        Enumeration enumtr = collection.elements();
        while (enumtr.hasMoreElements()) {
            this.invalidateObject(enumtr.nextElement());
        }
    }

    public void invalidateClass(Class myClass) {
        this.invalidateClass(myClass, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateClass(Class myClass, boolean recurse) {
        IdentityMap identityMap;
        IdentityMap identityMap2 = identityMap = this.getIdentityMap(myClass);
        synchronized (identityMap2) {
            Enumeration keys = identityMap.keys();
            while (keys.hasMoreElements()) {
                CacheKey key = (CacheKey)keys.nextElement();
                Object obj = key.getObject();
                if (!recurse && (obj == null || !obj.getClass().equals(myClass))) continue;
                key.setInvalidationState(-1);
            }
        }
    }

    public void invalidateAll() {
        Iterator identiyMapClasses = this.getIdentityMapManager().getIdentityMapClasses();
        while (identiyMapClasses.hasNext()) {
            this.invalidateClass((Class)identiyMapClasses.next());
        }
    }

    public boolean isValid(Object object) {
        return this.isValid(this.getSession().keyFromObject(object), object.getClass());
    }

    public boolean isValid(Vector primaryKey, Class theClass) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        CacheKey key = this.getCacheKeyForObject(primaryKey, theClass, descriptor);
        if (key == null) {
            throw QueryException.classPkDoesNotExistInCache(theClass, primaryKey);
        }
        return !descriptor.getCacheInvalidationPolicy().isInvalidated(key);
    }

    public boolean isValid(Record rowContainingPrimaryKey, Class theClass) {
        return this.isValid(this.extractPrimaryKeyFromRow(rowContainingPrimaryKey, theClass), theClass);
    }

    public void printIdentityMap(Class businessClass) {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printIdentityMap(businessClass);
        }
    }

    public void printIdentityMaps() {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printIdentityMaps();
        }
    }

    public void printIdentityMapLocks() {
        if (this.getSession().shouldLog(1, "cache")) {
            this.getIdentityMapManager().printLocks();
        }
    }

    public Object putInIdentityMap(Object object) {
        return this.putInIdentityMap(object, this.getSession().keyFromObject(object));
    }

    public Object putInIdentityMap(Object object, Vector key) {
        return this.putInIdentityMap(object, key, null);
    }

    public Object putInIdentityMap(Object object, Vector key, Object writeLockValue) {
        return this.putInIdentityMap(object, key, writeLockValue, 0L);
    }

    public Object putInIdentityMap(Object object, Vector key, Object writeLockValue, long readTime) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(object);
        return this.putInIdentityMap(object, key, writeLockValue, readTime, descriptor);
    }

    public Object putInIdentityMap(Object object, Vector key, Object writeLockValue, long readTime, ClassDescriptor descriptor) {
        CacheKey cacheKey = this.internalPutInIdentityMap(object, key, writeLockValue, readTime, descriptor);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getObject();
    }

    public void putQueryResult(ReadQuery query, Vector parameters, Object results) {
        this.getIdentityMapManager().putQueryResult(query, parameters, results);
    }

    public CacheKey internalPutInIdentityMap(Object object, Vector key, Object writeLockValue, long readTime, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().putInIdentityMap(object, key, writeLockValue, readTime, descriptor);
    }

    public void releaseWriteLock() {
        this.getIdentityMapManager().releaseWriteLock();
    }

    public Object removeFromIdentityMap(Object object) {
        return this.removeFromIdentityMap(this.getSession().keyFromObject(object), object.getClass());
    }

    public Object removeFromIdentityMap(Vector key, Class theClass) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        return this.removeFromIdentityMap(key, theClass, descriptor);
    }

    public Object removeFromIdentityMap(Vector key, Class theClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().removeFromIdentityMap(key, theClass, descriptor);
    }

    public void setIdentityMapManager(IdentityMapManager identityMapManager) {
        this.identityMapManager = identityMapManager;
    }

    public void setWrapper(Vector primaryKey, Class theClass, Object wrapper) {
        this.getIdentityMapManager().setWrapper(primaryKey, theClass, wrapper);
    }

    public void updateWriteLockValue(Object object, Object writeLockValue) {
        this.updateWriteLockValue(this.getSession().keyFromObject(object), object.getClass(), writeLockValue);
    }

    public void updateWriteLockValue(Vector primaryKey, Class theClass, Object writeLockValue) {
        this.getIdentityMapManager().setWriteLockValue(primaryKey, theClass, writeLockValue);
    }

    public void validateCache() {
        this.getSession().log(2, "cache", "validate_cache");
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                if (!IdentityMapAccessor.this.containsObjectInIdentityMap(IdentityMapAccessor.this.session.getDescriptor(object.getClass()).getObjectBuilder().extractPrimaryKeyFromObject(object, IdentityMapAccessor.this.getSession()), object.getClass())) {
                    IdentityMapAccessor.this.session.log(1, "cache", "stack_of_visited_objects_that_refer_to_the_corrupt_object", this.getVisitedStack());
                    IdentityMapAccessor.this.session.log(2, "cache", "corrupt_object_referenced_through_mapping", this.getCurrentMapping());
                    IdentityMapAccessor.this.session.log(2, "cache", "corrupt_object", object);
                }
            }
        };
        iterator.setSession(this.getSession());
        for (ClassDescriptor descriptor : this.getSession().getDescriptors().values()) {
            Enumeration mapEnum = this.getIdentityMap(descriptor).elements();
            while (mapEnum.hasMoreElements()) {
                iterator.startIterationOn(mapEnum.nextElement());
            }
        }
    }
}

