/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class XPathFragment {
    public static final XPathFragment TEXT_FRAGMENT = new XPathFragment("text()");
    public static final XPathFragment SELF_FRAGMENT = new XPathFragment(".");
    public static final XPathFragment ANY_FRAGMENT = null;
    private XPathFragment nextFragment;
    private String xpath;
    private boolean hasAttribute = false;
    private boolean hasText = false;
    private boolean hasNamespace = false;
    private boolean containsIndex = false;
    private int indexValue = -1;
    private boolean shouldExecuteSelectNodes = false;
    private String shortName;
    private String prefix;
    private String localName;
    private String namespaceURI;
    private QName qname;
    protected boolean nameIsText = false;
    protected boolean isSelfFragment = false;
    private QName leafElementType;
    private boolean generatedPrefix = false;

    public XPathFragment(String xpathString) {
        this.setXPath(xpathString);
    }

    public XPathFragment() {
    }

    public XPathFragment getNextFragment() {
        return this.nextFragment;
    }

    public void setNextFragment(XPathFragment nextFragment) {
        this.nextFragment = nextFragment;
    }

    public void setXPath(String xpathString) {
        this.xpath = xpathString;
        if (this.xpath.indexOf("[") != -1 && this.xpath.indexOf("]") == -1) {
            this.setShouldExecuteSelectNodes(true);
            return;
        }
        if (this.xpath.indexOf("::") != -1) {
            this.setShouldExecuteSelectNodes(true);
            return;
        }
        this.shortName = xpathString;
        int attrindex = xpathString.indexOf(64);
        if (attrindex == 0) {
            this.hasAttribute = true;
            this.shortName = xpathString.substring(attrindex + 1);
            this.indexValue = this.hasIndex(xpathString);
            this.setupNamespaceInformation(this.shortName);
            return;
        }
        if (xpathString.startsWith("/")) {
            this.setShouldExecuteSelectNodes(true);
            this.shortName = xpathString;
            this.indexValue = this.hasIndex(xpathString);
            this.setupNamespaceInformation(this.shortName);
            return;
        }
        if (xpathString.equals("text()")) {
            this.nameIsText = true;
            this.shortName = xpathString;
            return;
        }
        if (xpathString.equals(".")) {
            this.isSelfFragment = true;
            this.shortName = xpathString;
            return;
        }
        this.indexValue = this.hasIndex(xpathString);
        this.setupNamespaceInformation(this.shortName);
    }

    private void setupNamespaceInformation(String xpathString) {
        int nsindex = xpathString.indexOf(58);
        if (nsindex != -1) {
            this.hasNamespace = true;
            this.localName = xpathString.substring(nsindex + 1);
            this.prefix = xpathString.substring(0, nsindex);
        } else {
            this.localName = xpathString;
        }
    }

    public boolean isAttribute() {
        return this.hasAttribute;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = "".equals(namespaceURI) ? null : namespaceURI;
    }

    public QName getQName() {
        return this.qname;
    }

    public void setQName(QName q) {
        this.qname = q;
    }

    private int hasIndex(String xpathString) {
        int index;
        int startindex = xpathString.lastIndexOf(91);
        if (startindex != -1 && xpathString.lastIndexOf(93) != -1) {
            this.setContainsIndex(true);
            StringTokenizer st = new StringTokenizer(xpathString, "[]");
            String element = st.nextToken();
            String indexString = st.nextToken();
            try {
                index = Integer.valueOf(indexString);
            }
            catch (NumberFormatException e) {
                this.setShouldExecuteSelectNodes(true);
                index = -1;
            }
            this.shortName = element;
        } else {
            index = -1;
        }
        return index;
    }

    public int getIndexValue() {
        return this.indexValue;
    }

    public void setIndexValue(int indexValue) {
        this.indexValue = indexValue;
    }

    public String getXPath() {
        return this.xpath;
    }

    public boolean hasNamespace() {
        return this.hasNamespace;
    }

    public boolean isSelfFragment() {
        return this.isSelfFragment;
    }

    public boolean nameIsText() {
        return this.nameIsText;
    }

    public void setHasText(boolean hasText) {
        this.hasText = hasText;
    }

    public boolean getHasText() {
        return this.hasText;
    }

    public void setContainsIndex(boolean containsIndex) {
        this.containsIndex = containsIndex;
    }

    public boolean containsIndex() {
        return this.containsIndex;
    }

    public void setShouldExecuteSelectNodes(boolean newShouldExecuteSelectNodes) {
        this.shouldExecuteSelectNodes = newShouldExecuteSelectNodes;
    }

    public boolean shouldExecuteSelectNodes() {
        return this.shouldExecuteSelectNodes;
    }

    public boolean equals(Object object) {
        try {
            if (this == object) {
                return true;
            }
            XPathFragment xPathFragment = (XPathFragment)object;
            return (this.localName == xPathFragment.getLocalName() || this.localName != null && this.localName.equals(xPathFragment.getLocalName())) && (this.namespaceURI == xPathFragment.getNamespaceURI() || this.namespaceURI != null && this.namespaceURI.equals(xPathFragment.getNamespaceURI())) && this.indexValue == xPathFragment.getIndexValue() && this.nameIsText == xPathFragment.nameIsText();
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean qNameEquals(Object object) {
        try {
            if (this == object) {
                return true;
            }
            XPathFragment xPathFragment = (XPathFragment)object;
            return (this.localName == xPathFragment.getLocalName() || this.localName != null && this.localName.equals(xPathFragment.getLocalName())) && (this.namespaceURI == xPathFragment.getNamespaceURI() || this.namespaceURI != null && this.namespaceURI.equals(xPathFragment.getNamespaceURI())) && this.nameIsText == xPathFragment.nameIsText();
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.localName ? 0 : this.localName.hashCode());
        hash = 31 * hash + (null == this.namespaceURI ? 0 : this.namespaceURI.hashCode());
        return hash;
    }

    public QName getLeafElementType() {
        return this.leafElementType;
    }

    public boolean hasLeafElementType() {
        return this.getLeafElementType() != null;
    }

    public void setLeafElementType(QName type) {
        this.leafElementType = type;
    }

    public void setGeneratedPrefix(boolean isGenerated) {
        this.generatedPrefix = isGenerated;
    }

    public boolean isGeneratedPrefix() {
        return this.generatedPrefix;
    }
}

