/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.xml;

import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXCodeAdapter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXClassAdapter
implements ClassVisitor {
    private ContentHandler h;
    private boolean singleDocument;

    public SAXClassAdapter(ContentHandler contentHandler, boolean bl) {
        this.h = contentHandler;
        this.singleDocument = bl;
        if (!bl) {
            try {
                contentHandler.startDocument();
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException.getException());
            }
        }
    }

    public final void visit(int n, int n2, String string, String string2, String[] stringArray, String string3) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if ((n2 & 1) != 0) {
                stringBuffer.append("public ");
            }
            if ((n2 & 2) != 0) {
                stringBuffer.append("private ");
            }
            if ((n2 & 4) != 0) {
                stringBuffer.append("protected ");
            }
            if ((n2 & 0x10) != 0) {
                stringBuffer.append("final ");
            }
            if ((n2 & 0x20) != 0) {
                stringBuffer.append("super ");
            }
            if ((n2 & 0x200) != 0) {
                stringBuffer.append("interface ");
            }
            if ((n2 & 0x400) != 0) {
                stringBuffer.append("abstract ");
            }
            if ((n2 & 0x1000) != 0) {
                stringBuffer.append("synthetic ");
            }
            if ((n2 & 0x2000) != 0) {
                stringBuffer.append("annotation ");
            }
            if ((n2 & 0x4000) != 0) {
                stringBuffer.append("enum ");
            }
            if ((n2 & 0x20000) != 0) {
                stringBuffer.append("deprecated ");
            }
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "access", "access", "", stringBuffer.toString());
            if (string != null) {
                attributesImpl.addAttribute("", "name", "name", "", string);
            }
            if (string2 != null) {
                attributesImpl.addAttribute("", "parent", "parent", "", string2);
            }
            if (string3 != null) {
                attributesImpl.addAttribute("", "source", "source", "", string3);
            }
            attributesImpl.addAttribute("", "major", "major", "", new Integer(n & 0xFFFF).toString());
            attributesImpl.addAttribute("", "minor", "minor", "", new Integer(n >>> 16).toString());
            this.h.startElement("", "class", "class", attributesImpl);
            this.h.startElement("", "interfaces", "interfaces", new AttributesImpl());
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    AttributesImpl attributesImpl2 = new AttributesImpl();
                    attributesImpl2.addAttribute("", "name", "name", "", stringArray[i]);
                    this.h.startElement("", "interface", "interface", attributesImpl2);
                    this.h.endElement("", "interface", "interface");
                }
            }
            this.h.endElement("", "interfaces", "interfaces");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.getException());
        }
    }

    public final void visitField(int n, String string, String string2, Object object, Attribute attribute) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append("public ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("private ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("protected ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("static ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("final ");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append("volatile ");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("transient ");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("synthetic ");
        }
        if ((n & 0x4000) != 0) {
            stringBuffer.append("enum ");
        }
        if ((n & 0x20000) != 0) {
            stringBuffer.append("deprecated ");
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "access", "access", "", stringBuffer.toString());
        attributesImpl.addAttribute("", "name", "name", "", string);
        attributesImpl.addAttribute("", "desc", "desc", "", string2);
        if (object != null) {
            attributesImpl.addAttribute("", "value", "value", "", SAXClassAdapter.encode(object.toString()));
        }
        try {
            this.h.startElement("", "field", "field", attributesImpl);
            this.h.endElement("", "field", "field");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
    }

    public final CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray, Attribute attribute) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append("public ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("private ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("protected ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("static ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("final ");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("synchronized ");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append("bridge ");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("varargs ");
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("native ");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append("abstract ");
        }
        if ((n & 0x800) != 0) {
            stringBuffer.append("strict ");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("synthetic ");
        }
        if ((n & 0x20000) != 0) {
            stringBuffer.append("deprecated ");
        }
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "access", "access", "", stringBuffer.toString());
            attributesImpl.addAttribute("", "name", "name", "", string);
            attributesImpl.addAttribute("", "desc", "desc", "", string2);
            this.h.startElement("", "method", "method", attributesImpl);
            this.h.startElement("", "exceptions", "exceptions", new AttributesImpl());
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    AttributesImpl attributesImpl2 = new AttributesImpl();
                    attributesImpl2.addAttribute("", "name", "name", "", stringArray[i]);
                    this.h.startElement("", "exception", "exception", attributesImpl2);
                    this.h.endElement("", "exception", "exception");
                }
            }
            this.h.endElement("", "exceptions", "exceptions");
            if ((n & 0x700) > 0) {
                this.h.endElement("", "method", "method");
            } else {
                this.h.startElement("", "code", "code", new AttributesImpl());
            }
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
        return new SAXCodeAdapter(this.h);
    }

    public final void visitInnerClass(String string, String string2, String string3, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append("public ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("private ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("protected ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("static ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("final ");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("super ");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append("interface ");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append("abstract ");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("synthetic ");
        }
        if ((n & 0x2000) != 0) {
            stringBuffer.append("annotation ");
        }
        if ((n & 0x4000) != 0) {
            stringBuffer.append("enum ");
        }
        if ((n & 0x20000) != 0) {
            stringBuffer.append("deprecated ");
        }
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "access", "access", "", stringBuffer.toString());
            if (string != null) {
                attributesImpl.addAttribute("", "name", "name", "", string);
            }
            if (string2 != null) {
                attributesImpl.addAttribute("", "outerName", "outerName", "", string2);
            }
            if (string3 != null) {
                attributesImpl.addAttribute("", "innerName", "innerName", "", string3);
            }
            this.h.startElement("", "innerclass", "innerclass", attributesImpl);
            this.h.endElement("", "innerclass", "innerclass");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
    }

    public final void visitAttribute(Attribute attribute) {
    }

    public final void visitEnd() {
        try {
            this.h.endElement("", "class", "class");
            if (!this.singleDocument) {
                this.h.endDocument();
            }
        }
        catch (SAXException sAXException) {
            sAXException.getException().printStackTrace();
            sAXException.printStackTrace();
            throw new RuntimeException(sAXException.toString());
        }
    }

    static final String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                stringBuffer.append("\\u");
                if (c < '\u0010') {
                    stringBuffer.append("000");
                } else if (c < '\u0100') {
                    stringBuffer.append("00");
                } else if (c < '\u1000') {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toString(c, 16));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

