/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.xml;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.xml.ASMContentHandler;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXClassAdapter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Processor {
    public static final int BYTECODE = 1;
    public static final int MULTI_XML = 2;
    public static final int SINGLE_XML = 3;
    private static final String SINGLE_XML_NAME = "classes.xml";
    private int inRepresentation;
    private int outRepresentation;
    private InputStream input = null;
    private OutputStream output = null;
    private Source xslt = null;
    private boolean computeMax;
    private int n = 0;

    public Processor(int n, int n2, InputStream inputStream, OutputStream outputStream, Source source) {
        this.inRepresentation = n;
        this.outRepresentation = n2;
        this.input = inputStream;
        this.output = outputStream;
        this.xslt = source;
        this.computeMax = true;
    }

    public int process() throws TransformerException, IOException, SAXException {
        Object object;
        ZipInputStream zipInputStream = new ZipInputStream(this.input);
        ZipOutputStream zipOutputStream = new ZipOutputStream(this.output);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(zipOutputStream);
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") || !transformerFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            return 0;
        }
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
        Templates templates = null;
        if (this.xslt != null) {
            templates = sAXTransformerFactory.newTemplates(this.xslt);
        }
        EntryElement entryElement = this.getEntryElement(zipOutputStream);
        DefaultHandler defaultHandler = null;
        switch (this.outRepresentation) {
            case 1: {
                defaultHandler = new OutputSlicingHandler(new ASMContentHandlerFactory(zipOutputStream, this.computeMax), entryElement, false);
                break;
            }
            case 2: {
                defaultHandler = new OutputSlicingHandler(new SAXWriterFactory(outputStreamWriter, true), entryElement, true);
                break;
            }
            case 3: {
                object = new ZipEntry(SINGLE_XML_NAME);
                zipOutputStream.putNextEntry((ZipEntry)object);
                defaultHandler = new SAXWriter(outputStreamWriter, false);
            }
        }
        object = null;
        object = templates == null ? defaultHandler : new InputSlicingHandler("class", defaultHandler, new TransformerHandlerFactory(sAXTransformerFactory, templates, defaultHandler));
        SubdocumentHandlerFactory subdocumentHandlerFactory = new SubdocumentHandlerFactory((ContentHandler)object);
        if (object != null && this.inRepresentation != 3) {
            object.startDocument();
            object.startElement("", "classes", "classes", new AttributesImpl());
        }
        int n = 0;
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (this.isClassEntry(zipEntry)) {
                this.processEntry(zipInputStream, zipEntry, subdocumentHandlerFactory);
            } else {
                OutputStream outputStream = entryElement.openEntry(this.getName(zipEntry));
                this.copyEntry(zipInputStream, outputStream);
                entryElement.closeEntry();
            }
            ++n;
            this.update(zipEntry.getName());
        }
        if (object != null && this.inRepresentation != 3) {
            object.endElement("", "classes", "classes");
            object.endDocument();
        }
        if (this.outRepresentation == 3) {
            zipOutputStream.closeEntry();
        }
        zipOutputStream.flush();
        zipOutputStream.close();
        return n;
    }

    private void copyEntry(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        if (this.outRepresentation == 3) {
            return;
        }
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    private boolean isClassEntry(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        return this.inRepresentation == 3 && string.equals(SINGLE_XML_NAME) || string.endsWith(".class") || string.endsWith(".class.xml");
    }

    private void processEntry(ZipInputStream zipInputStream, ZipEntry zipEntry, ContentHandlerFactory contentHandlerFactory) {
        ContentHandler contentHandler = contentHandlerFactory.createContentHandler();
        try {
            boolean bl;
            boolean bl2 = bl = this.inRepresentation == 3;
            if (this.inRepresentation == 1) {
                ClassReader classReader = new ClassReader(this.readEntry(zipInputStream, zipEntry));
                classReader.accept(new SAXClassAdapter(contentHandler, bl), false);
            } else {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                xMLReader.setContentHandler(contentHandler);
                xMLReader.parse(new InputSource(bl ? new ProtectedInputStream(zipInputStream) : new ByteArrayInputStream(this.readEntry(zipInputStream, zipEntry))));
            }
        }
        catch (Exception exception) {
            this.update(zipEntry.getName());
            this.update(exception);
        }
    }

    private EntryElement getEntryElement(ZipOutputStream zipOutputStream) {
        if (this.outRepresentation == 3) {
            return new SingleDocElement(zipOutputStream);
        }
        return new ZipEntryElement(zipOutputStream);
    }

    private String getName(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        if (this.isClassEntry(zipEntry)) {
            if (this.inRepresentation != 1 && this.outRepresentation == 1) {
                string = string.substring(0, string.length() - 4);
            } else if (this.inRepresentation == 1 && this.outRepresentation != 1) {
                string = string.concat(".xml");
            }
        }
        return string;
    }

    private byte[] readEntry(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        int n;
        long l = zipEntry.getSize();
        if (l > -1L) {
            byte[] byArray = new byte[(int)l];
            zipInputStream.read(byArray);
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = zipInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void update(Object object) {
        if (object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        } else if (this.n % 100 == 0) {
            System.err.println(this.n + " " + object);
        }
        ++this.n;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            Processor.showUsage();
            return;
        }
        int n = Processor.getRepresentation(stringArray[0]);
        int n2 = Processor.getRepresentation(stringArray[1]);
        FileInputStream fileInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        StreamSource streamSource = null;
        for (int i = 2; i < stringArray.length; ++i) {
            if ("-in".equals(stringArray[i])) {
                fileInputStream = new FileInputStream(stringArray[++i]);
                continue;
            }
            if ("-out".equals(stringArray[i])) {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(stringArray[++i]));
                continue;
            }
            if ("-xslt".equals(stringArray[i])) {
                streamSource = new StreamSource(new FileInputStream(stringArray[++i]));
                continue;
            }
            Processor.showUsage();
            return;
        }
        if (fileInputStream == null || bufferedOutputStream == null || n == 0 || n2 == 0) {
            Processor.showUsage();
            return;
        }
        Processor processor = new Processor(n, n2, fileInputStream, bufferedOutputStream, streamSource);
        long l = System.currentTimeMillis();
        int n3 = processor.process();
        long l2 = System.currentTimeMillis();
        System.err.println(n3);
        System.err.println("" + (l2 - l) + "ms  " + 1000.0f * (float)n3 / (float)(l2 - l) + " files/sec");
    }

    private static int getRepresentation(String string) {
        if ("code".equals(string)) {
            return 1;
        }
        if ("xml".equals(string)) {
            return 2;
        }
        if ("singlexml".equals(string)) {
            return 3;
        }
        return 0;
    }

    private static void showUsage() {
        System.err.println("Usage: Main <in format> <out format> -in <input jar> -out <output jar> [-xslt <xslt fiel>]");
        System.err.println("  <in format> and <out format> - code | xml | singlexml");
    }

    private static final class ZipEntryElement
    implements EntryElement {
        private ZipOutputStream zos;

        public ZipEntryElement(ZipOutputStream zipOutputStream) {
            this.zos = zipOutputStream;
        }

        public OutputStream openEntry(String string) throws IOException {
            ZipEntry zipEntry = new ZipEntry(string);
            this.zos.putNextEntry(zipEntry);
            return this.zos;
        }

        public void closeEntry() throws IOException {
            this.zos.flush();
            this.zos.closeEntry();
        }
    }

    private static final class SingleDocElement
    implements EntryElement {
        private OutputStream os;

        public SingleDocElement(OutputStream outputStream) {
            this.os = outputStream;
        }

        public OutputStream openEntry(String string) throws IOException {
            return this.os;
        }

        public void closeEntry() throws IOException {
            this.os.flush();
        }
    }

    private static interface EntryElement {
        public OutputStream openEntry(String var1) throws IOException;

        public void closeEntry() throws IOException;
    }

    private static final class OutputSlicingHandler
    extends DefaultHandler {
        private String subdocumentRoot = "class";
        private ContentHandlerFactory subdocumentHandlerFactory;
        private EntryElement entryElement;
        private boolean isXml;
        private boolean subdocument = false;
        private ContentHandler subdocumentHandler;

        public OutputSlicingHandler(ContentHandlerFactory contentHandlerFactory, EntryElement entryElement, boolean bl) {
            this.subdocumentHandlerFactory = contentHandlerFactory;
            this.entryElement = entryElement;
            this.isXml = bl;
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.startElement(string, string2, string3, attributes);
            } else if (string2.equals(this.subdocumentRoot)) {
                String string4 = attributes.getValue("name");
                if (string4 == null || string4.length() == 0) {
                    throw new SAXException("Class element without name attribute.");
                }
                try {
                    this.entryElement.openEntry(this.isXml ? string4.concat(".class.xml") : string4.concat(".class"));
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException.toString(), iOException);
                }
                this.subdocumentHandler = this.subdocumentHandlerFactory.createContentHandler();
                this.subdocumentHandler.startDocument();
                this.subdocumentHandler.startElement(string, string2, string3, attributes);
                this.subdocument = true;
            }
        }

        public final void endElement(String string, String string2, String string3) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.endElement(string, string2, string3);
                if (string2.equals(this.subdocumentRoot)) {
                    this.subdocumentHandler.endDocument();
                    this.subdocument = false;
                    try {
                        this.entryElement.closeEntry();
                    }
                    catch (IOException iOException) {
                        throw new SAXException(iOException.toString(), iOException);
                    }
                }
            }
        }

        public final void startDocument() throws SAXException {
        }

        public final void endDocument() throws SAXException {
        }

        public final void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.characters(cArray, n, n2);
            }
        }
    }

    private static final class InputSlicingHandler
    extends DefaultHandler {
        private String subdocumentRoot;
        private ContentHandler rootHandler;
        private ContentHandlerFactory subdocumentHandlerFactory;
        private boolean subdocument = false;
        private ContentHandler subdocumentHandler;

        public InputSlicingHandler(String string, ContentHandler contentHandler, ContentHandlerFactory contentHandlerFactory) {
            this.subdocumentRoot = string;
            this.rootHandler = contentHandler;
            this.subdocumentHandlerFactory = contentHandlerFactory;
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.startElement(string, string2, string3, attributes);
            } else if (string2.equals(this.subdocumentRoot)) {
                this.subdocumentHandler = this.subdocumentHandlerFactory.createContentHandler();
                this.subdocumentHandler.startDocument();
                this.subdocumentHandler.startElement(string, string2, string3, attributes);
                this.subdocument = true;
            } else if (this.rootHandler != null) {
                this.rootHandler.startElement(string, string2, string3, attributes);
            }
        }

        public final void endElement(String string, String string2, String string3) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.endElement(string, string2, string3);
                if (string2.equals(this.subdocumentRoot)) {
                    this.subdocumentHandler.endDocument();
                    this.subdocument = false;
                }
            } else if (this.rootHandler != null) {
                this.rootHandler.endElement(string, string2, string3);
            }
        }

        public final void startDocument() throws SAXException {
            if (this.rootHandler != null) {
                this.rootHandler.startDocument();
            }
        }

        public final void endDocument() throws SAXException {
            if (this.rootHandler != null) {
                this.rootHandler.endDocument();
            }
        }

        public final void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.characters(cArray, n, n2);
            } else if (this.rootHandler != null) {
                this.rootHandler.characters(cArray, n, n2);
            }
        }
    }

    private static final class SAXWriter
    extends DefaultHandler
    implements LexicalHandler {
        private static final char[] OFF = "                                                                                                        ".toCharArray();
        private Writer w;
        private boolean optimizeEmptyElements;
        private boolean openElement = false;
        private int ident = 0;

        public SAXWriter(Writer writer, boolean bl) {
            this.w = writer;
            this.optimizeEmptyElements = bl;
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                this.closeElement();
                this.writeIdent();
                this.w.write("<".concat(string3));
                if (attributes != null && attributes.getLength() > 0) {
                    this.writeAttributes(attributes);
                }
                if (!this.optimizeEmptyElements) {
                    this.w.write(">\n");
                } else {
                    this.openElement = true;
                }
                this.ident += 2;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void endElement(String string, String string2, String string3) throws SAXException {
            this.ident -= 2;
            try {
                if (this.openElement) {
                    this.w.write("/>\n");
                    this.openElement = false;
                } else {
                    this.writeIdent();
                    this.w.write("</" + string3 + ">\n");
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void endDocument() throws SAXException {
            try {
                this.w.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void comment(char[] cArray, int n, int n2) throws SAXException {
            try {
                this.closeElement();
                this.writeIdent();
                this.w.write("<!-- ");
                this.w.write(cArray, n, n2);
                this.w.write(" -->\n");
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void startDTD(String string, String string2, String string3) throws SAXException {
        }

        public final void endDTD() throws SAXException {
        }

        public final void startEntity(String string) throws SAXException {
        }

        public final void endEntity(String string) throws SAXException {
        }

        public final void startCDATA() throws SAXException {
        }

        public final void endCDATA() throws SAXException {
        }

        private final void writeAttributes(Attributes attributes) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(" ").append(attributes.getLocalName(i)).append("=\"").append(this.esc(attributes.getValue(i))).append("\"");
            }
            this.w.write(stringBuffer.toString());
        }

        private final String esc(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            block6: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        continue block6;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block6;
                    }
                    default: {
                        if (c > '\u007f') {
                            stringBuffer.append("&#").append(Integer.toString(c)).append(';');
                            continue block6;
                        }
                        stringBuffer.append(c);
                    }
                }
            }
            return stringBuffer.toString();
        }

        private final void writeIdent() throws IOException {
            int n = this.ident;
            while (n > 0) {
                if (n > OFF.length) {
                    this.w.write(OFF);
                    n -= OFF.length;
                    continue;
                }
                this.w.write(OFF, 0, n);
                n = 0;
            }
        }

        private final void closeElement() throws IOException {
            if (this.openElement) {
                this.w.write(">\n");
            }
            this.openElement = false;
        }
    }

    private static final class SubdocumentHandlerFactory
    implements ContentHandlerFactory {
        private ContentHandler subdocumentHandler;

        public SubdocumentHandlerFactory(ContentHandler contentHandler) {
            this.subdocumentHandler = contentHandler;
        }

        public final ContentHandler createContentHandler() {
            return this.subdocumentHandler;
        }
    }

    private static final class TransformerHandlerFactory
    implements ContentHandlerFactory {
        private SAXTransformerFactory saxtf;
        private Templates templates;
        private ContentHandler outputHandler;

        public TransformerHandlerFactory(SAXTransformerFactory sAXTransformerFactory, Templates templates, ContentHandler contentHandler) {
            this.saxtf = sAXTransformerFactory;
            this.templates = templates;
            this.outputHandler = contentHandler;
        }

        public final ContentHandler createContentHandler() {
            try {
                TransformerHandler transformerHandler = this.saxtf.newTransformerHandler(this.templates);
                transformerHandler.setResult(new SAXResult(this.outputHandler));
                return transformerHandler;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new RuntimeException(transformerConfigurationException.toString());
            }
        }
    }

    private static final class ASMContentHandlerFactory
    implements ContentHandlerFactory {
        private OutputStream os;
        private boolean computeMax;

        public ASMContentHandlerFactory(OutputStream outputStream, boolean bl) {
            this.os = outputStream;
            this.computeMax = bl;
        }

        public final ContentHandler createContentHandler() {
            return new ASMContentHandler(this.os, this.computeMax);
        }
    }

    private static final class SAXWriterFactory
    implements ContentHandlerFactory {
        private Writer w;
        private boolean optimizeEmptyElements;

        public SAXWriterFactory(Writer writer, boolean bl) {
            this.w = writer;
            this.optimizeEmptyElements = bl;
        }

        public final ContentHandler createContentHandler() {
            return new SAXWriter(this.w, this.optimizeEmptyElements);
        }
    }

    private static interface ContentHandlerFactory {
        public ContentHandler createContentHandler();
    }

    private static final class ProtectedInputStream
    extends InputStream {
        private final InputStream is;

        private ProtectedInputStream(InputStream inputStream) {
            this.is = inputStream;
        }

        public final void close() throws IOException {
        }

        public final int read() throws IOException {
            return this.is.read();
        }

        public final int read(byte[] byArray, int n, int n2) throws IOException {
            return this.is.read(byArray, n, n2);
        }

        public final int available() throws IOException {
            return this.is.available();
        }
    }
}

