/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util.attrs;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.attrs.StackMapAttribute;
import org.eclipse.persistence.internal.libraries.asm.attrs.StackMapFrame;
import org.eclipse.persistence.internal.libraries.asm.attrs.StackMapType;
import org.eclipse.persistence.internal.libraries.asm.util.attrs.ASMifiable;

public class ASMStackMapAttribute
extends StackMapAttribute
implements ASMifiable {
    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        StackMapAttribute stackMapAttribute = (StackMapAttribute)super.read(classReader, n, n2, cArray, n3, labelArray);
        ASMStackMapAttribute aSMStackMapAttribute = new ASMStackMapAttribute();
        aSMStackMapAttribute.frames = stackMapAttribute.frames;
        return aSMStackMapAttribute;
    }

    public void asmify(StringBuffer stringBuffer, String string, Map map) {
        stringBuffer.append("{\n");
        stringBuffer.append("StackMapAttribute ").append(string).append("Attr");
        stringBuffer.append(" = new StackMapAttribute();\n");
        if (this.frames.size() > 0) {
            for (int i = 0; i < this.frames.size(); ++i) {
                this.asmify((StackMapFrame)this.frames.get(i), stringBuffer, string + "frame" + i, map);
            }
        }
        stringBuffer.append(string).append(".visitAttribute(").append(string);
        stringBuffer.append("Attr);\n}\n");
    }

    void asmify(StackMapFrame stackMapFrame, StringBuffer stringBuffer, String string, Map map) {
        ASMStackMapAttribute.declareLabel(stringBuffer, map, stackMapFrame.label);
        stringBuffer.append("{\n");
        stringBuffer.append("StackMapFrame ").append(string).append(" = new StackMapFrame();\n");
        stringBuffer.append(string).append(".label = ").append(map.get(stackMapFrame.label)).append(";\n");
        this.asmifyTypeInfo(stringBuffer, string, map, stackMapFrame.locals, "locals");
        this.asmifyTypeInfo(stringBuffer, string, map, stackMapFrame.stack, "stack");
        stringBuffer.append("cvAttr.frames.add(").append(string).append(");\n");
        stringBuffer.append("}\n");
    }

    void asmifyTypeInfo(StringBuffer stringBuffer, String string, Map map, List list, String string2) {
        if (list.size() > 0) {
            stringBuffer.append("{\n");
            for (int i = 0; i < list.size(); ++i) {
                StackMapType stackMapType = (StackMapType)list.get(i);
                String string3 = string + "Info" + i;
                int n = stackMapType.getType();
                stringBuffer.append("StackMapType ").append(string3).append(" = StackMapType.getTypeInfo( StackMapType.ITEM_").append(StackMapType.ITEM_NAMES[n]).append(");\n");
                switch (n) {
                    case 7: {
                        stringBuffer.append(string3).append(".setObject(\"").append(stackMapType.getObject()).append("\");\n");
                        break;
                    }
                    case 8: {
                        ASMStackMapAttribute.declareLabel(stringBuffer, map, stackMapType.getLabel());
                        stringBuffer.append(string3).append(".setLabel(").append(map.get(stackMapType.getLabel())).append(");\n");
                    }
                }
                stringBuffer.append(string).append(".").append(string2).append(".add(").append(string3).append(");\n");
            }
            stringBuffer.append("}\n");
        }
    }

    static void declareLabel(StringBuffer stringBuffer, Map map, Label label) {
        String string = (String)map.get(label);
        if (string == null) {
            string = "l" + map.size();
            map.put(label, string);
            stringBuffer.append("Label ").append(string).append(" = new Label();\n");
        }
    }
}

