/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.util.ASMifierCodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.util.PrintClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.util.attrs.ASMifiable;

public class ASMifierClassVisitor
extends PrintClassVisitor {
    private static final int ACCESS_CLASS = 262144;
    private static final int ACCESS_FIELD = 524288;
    private static final int ACCESS_INNER = 0x100000;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1 || stringArray.length > 2) {
            ASMifierClassVisitor.printUsage();
        }
        int n = 0;
        boolean bl = true;
        if (stringArray[0].equals("-debug")) {
            n = 1;
            bl = false;
            if (stringArray.length != 2) {
                ASMifierClassVisitor.printUsage();
            }
        }
        ClassReader classReader = stringArray[n].endsWith(".class") ? new ClassReader(new FileInputStream(stringArray[n])) : new ClassReader(stringArray[n]);
        classReader.accept(new ASMifierClassVisitor(new PrintWriter(System.out)), ASMifierClassVisitor.getDefaultAttributes(), bl);
    }

    private static void printUsage() {
        System.err.println("Prints the ASM code to generate the given class.");
        System.err.println("Usage: ASMifierClassVisitor [-debug] <fully qualified class name or class file name>");
        System.exit(-1);
    }

    public ASMifierClassVisitor(PrintWriter printWriter) {
        super(printWriter);
    }

    public void visit(int n, int n2, String string, String string2, String[] stringArray, String string3) {
        int n3 = string.lastIndexOf("/");
        if (n3 > -1) {
            this.text.add("package asm." + string.substring(0, n3).replace('/', '.') + ";\n");
        }
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.*;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.attrs.*;\n");
        this.text.add("import java.util.*;\n\n");
        this.text.add("public class " + (n3 == -1 ? string : string.substring(n3 + 1)) + "Dump implements Constants {\n\n");
        this.text.add("public static byte[] dump () throws Exception {\n\n");
        this.text.add("ClassWriter cw = new ClassWriter(false);\n");
        this.text.add("CodeVisitor cv;\n\n");
        this.buf.setLength(0);
        this.buf.append("cw.visit(");
        switch (n) {
            case 196653: {
                this.buf.append("V1_1");
                break;
            }
            case 46: {
                this.buf.append("V1_2");
                break;
            }
            case 47: {
                this.buf.append("V1_3");
                break;
            }
            case 48: {
                this.buf.append("V1_4");
                break;
            }
            case 49: {
                this.buf.append("V1_5");
                break;
            }
            default: {
                this.buf.append(n);
            }
        }
        this.buf.append(", ");
        this.appendAccess(n2 | 0x40000);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append("new String[] {");
            for (int i = 0; i < stringArray.length; ++i) {
                this.buf.append(i == 0 ? " " : ", ");
                ASMifierClassVisitor.appendConstant(this.buf, stringArray[i]);
            }
            this.buf.append(" }");
        } else {
            this.buf.append("null");
        }
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string3);
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.buf.setLength(0);
        this.buf.append("cw.visitInnerClass(");
        ASMifierClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string3);
        this.buf.append(", ");
        this.appendAccess(n | 0x100000);
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitField(int n, String string, String string2, Object object, Attribute attribute) {
        this.buf.setLength(0);
        int n2 = 1;
        if (attribute != null) {
            this.buf.append("{\n");
            this.buf.append("// FIELD ATTRIBUTES\n");
            Attribute attribute2 = attribute;
            while (attribute2 != null) {
                if (attribute2 instanceof ASMifiable) {
                    ((ASMifiable)((Object)attribute2)).asmify(this.buf, "fieldAttrs" + n2, null);
                    if (n2 > 1) {
                        this.buf.append("fieldAttrs" + (n2 - 1) + " = fieldAttrs" + n2 + ";\n");
                    }
                    ++n2;
                } else {
                    this.buf.append("// WARNING! skipped non standard field attribute of type ");
                    this.buf.append(attribute2.type).append("\n");
                }
                attribute2 = attribute2.next;
            }
        }
        this.buf.append("cw.visitField(");
        this.appendAccess(n | 0x80000);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, object);
        if (n2 == 1) {
            this.buf.append(", null);\n\n");
        } else {
            this.buf.append(", fieldAttrs1);\n");
            this.buf.append("}\n\n");
        }
        this.text.add(this.buf.toString());
    }

    public CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray, Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append("{\n");
        int n2 = 1;
        if (attribute != null) {
            this.buf.append("// METHOD ATTRIBUTES\n");
            Attribute attribute2 = attribute;
            while (attribute2 != null) {
                if (attribute2 instanceof ASMifiable) {
                    ((ASMifiable)((Object)attribute2)).asmify(this.buf, "methodAttrs" + n2, null);
                    if (n2 > 1) {
                        this.buf.append("methodAttrs" + (n2 - 1) + ".next = methodAttrs" + n2 + ";\n");
                    }
                    ++n2;
                } else {
                    this.buf.append("// WARNING! skipped non standard method attribute of type ");
                    this.buf.append(attribute2.type).append("\n");
                }
                attribute2 = attribute2.next;
            }
        }
        this.buf.append("cv = cw.visitMethod(");
        this.appendAccess(n);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append("new String[] {");
            for (int i = 0; i < stringArray.length; ++i) {
                this.buf.append(i == 0 ? " " : ", ");
                ASMifierClassVisitor.appendConstant(this.buf, stringArray[i]);
            }
            this.buf.append(" }");
        } else {
            this.buf.append("null");
        }
        if (n2 == 1) {
            this.buf.append(", null);\n");
        } else {
            this.buf.append(", methodAttrs1);\n");
        }
        this.text.add(this.buf.toString());
        ASMifierCodeVisitor aSMifierCodeVisitor = new ASMifierCodeVisitor();
        this.text.add(aSMifierCodeVisitor.getText());
        this.text.add("}\n");
        return aSMifierCodeVisitor;
    }

    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        if (attribute instanceof ASMifiable) {
            this.buf.append("{\n");
            this.buf.append("// CLASS ATRIBUTE\n");
            ((ASMifiable)((Object)attribute)).asmify(this.buf, "attr", null);
            this.buf.append("cw.visitAttribute(attr);\n");
            this.buf.append("}\n");
        } else {
            this.buf.append("// WARNING! skipped a non standard class attribute of type \"");
            this.buf.append(attribute.type).append("\"\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitEnd() {
        this.text.add("cw.visitEnd();\n\n");
        this.text.add("return cw.toByteArray();\n");
        this.text.add("}\n");
        this.text.add("}\n");
        super.visitEnd();
    }

    void appendAccess(int n) {
        boolean bl = true;
        if ((n & 1) != 0) {
            this.buf.append("ACC_PUBLIC");
            bl = false;
        }
        if ((n & 2) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_PRIVATE");
            bl = false;
        }
        if ((n & 4) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_PROTECTED");
            bl = false;
        }
        if ((n & 0x10) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_FINAL");
            bl = false;
        }
        if ((n & 8) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_STATIC");
            bl = false;
        }
        if ((n & 0x20) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            if ((n & 0x40000) != 0) {
                this.buf.append("ACC_SUPER");
            } else {
                this.buf.append("ACC_SYNCHRONIZED");
            }
            bl = false;
        }
        if ((n & 0x40) != 0 && (n & 0x80000) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_VOLATILE");
            bl = false;
        }
        if ((n & 0x40) != 0 && (n & 0x40000) == 0 && (n & 0x80000) == 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_BRIDGE");
            bl = false;
        }
        if ((n & 0x80) != 0 && (n & 0x40000) == 0 && (n & 0x80000) == 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_VARARGS");
            bl = false;
        }
        if ((n & 0x80) != 0 && (n & 0x80000) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_TRANSIENT");
            bl = false;
        }
        if ((n & 0x100) != 0 && (n & 0x40000) == 0 && (n & 0x80000) == 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_NATIVE");
            bl = false;
        }
        if ((n & 0x4000) != 0 && ((n & 0x40000) != 0 || (n & 0x80000) != 0 || (n & 0x100000) != 0)) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ENUM");
            bl = false;
        }
        if ((n & 0x2000) != 0 && (n & 0x40000) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ANNOTATION");
            bl = false;
        }
        if ((n & 0x400) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ABSTRACT");
            bl = false;
        }
        if ((n & 0x200) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_INTERFACE");
            bl = false;
        }
        if ((n & 0x800) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_STRICT");
            bl = false;
        }
        if ((n & 0x1000) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_SYNTHETIC");
            bl = false;
        }
        if ((n & 0x20000) != 0) {
            if (!bl) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_DEPRECATED");
            bl = false;
        }
        if (bl) {
            this.buf.append("0");
        }
    }

    static void appendConstant(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            stringBuffer.append("null");
        } else if (object instanceof String) {
            String string = (String)object;
            stringBuffer.append("\"");
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    stringBuffer.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    stringBuffer.append("\\r");
                    continue;
                }
                if (c == '\\') {
                    stringBuffer.append("\\\\");
                    continue;
                }
                if (c == '\"') {
                    stringBuffer.append("\\\"");
                    continue;
                }
                if (c < ' ' || c > '\u007f') {
                    stringBuffer.append("\\u");
                    if (c < '\u0010') {
                        stringBuffer.append("000");
                    } else if (c < '\u0100') {
                        stringBuffer.append("00");
                    } else if (c < '\u1000') {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(Integer.toString(c, 16));
                    continue;
                }
                stringBuffer.append(c);
            }
            stringBuffer.append("\"");
        } else if (object instanceof Type) {
            stringBuffer.append("Type.getType(\"");
            stringBuffer.append(((Type)object).getDescriptor());
            stringBuffer.append("\")");
        } else if (object instanceof Integer) {
            stringBuffer.append("new Integer(").append(object).append(")");
        } else if (object instanceof Float) {
            stringBuffer.append("new Float(\"").append(object).append("\")");
        } else if (object instanceof Long) {
            stringBuffer.append("new Long(").append(object).append("L)");
        } else if (object instanceof Double) {
            stringBuffer.append("new Double(\"").append(object).append("\")");
        }
    }
}

